/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.veraid.Periods;
import tech.relaycorp.veraid.SignatureException;
import tech.relaycorp.veraid.utils.asn1.ASN1Exception;
import tech.relaycorp.veraid.utils.asn1.ASN1Utils;
import tech.relaycorp.veraid.utils.asn1.ASN1UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\f\u0012\u0004\u0012\u00020\u00060\u0005j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Ltech/relaycorp/veraid/SignatureMetadata;", "", "service", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "validityPeriod", "Lkotlin/ranges/ClosedRange;", "Ljava/time/ZonedDateTime;", "Ltech/relaycorp/veraid/DatePeriod;", "(Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;Lkotlin/ranges/ClosedRange;)V", "getService", "()Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "getValidityPeriod", "()Lkotlin/ranges/ClosedRange;", "encode", "Lorg/bouncycastle/asn1/DERSequence;", "Companion", "veraid"})
public final class SignatureMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ASN1ObjectIdentifier service;
    @NotNull
    private final ClosedRange<ZonedDateTime> validityPeriod;

    public SignatureMetadata(@NotNull ASN1ObjectIdentifier service, @NotNull ClosedRange<ZonedDateTime> validityPeriod2) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(validityPeriod2, (String)"validityPeriod");
        this.service = service;
        this.validityPeriod = validityPeriod2;
        if (((ZonedDateTime)this.validityPeriod.getEndInclusive()).compareTo((ChronoZonedDateTime)this.validityPeriod.getStart()) < 0) {
            throw new SignatureException("End date should not be before start date (start=" + this.validityPeriod.getStart() + ", end=" + this.validityPeriod.getEndInclusive() + ")", null, 2, null);
        }
    }

    @NotNull
    public final ASN1ObjectIdentifier getService() {
        return this.service;
    }

    @NotNull
    public final ClosedRange<ZonedDateTime> getValidityPeriod() {
        return this.validityPeriod;
    }

    @NotNull
    public final DERSequence encode() {
        Object[] objectArray = new ASN1Primitive[]{this.service, Periods.encode(this.validityPeriod)};
        return ASN1Utils.INSTANCE.makeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/veraid/SignatureMetadata$Companion;", "", "()V", "decode", "Ltech/relaycorp/veraid/SignatureMetadata;", "attributeValueTagged", "Lorg/bouncycastle/asn1/ASN1Encodable;", "veraid"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SignatureMetadata decode(@NotNull ASN1Encodable attributeValueTagged) throws SignatureException {
            ZonedDateTime zonedDateTime;
            Object startDateRaw;
            ASN1Sequence aSN1Sequence;
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            ASN1Sequence aSN1Sequence2;
            Intrinsics.checkNotNullParameter((Object)attributeValueTagged, (String)"attributeValueTagged");
            try {
                aSN1Sequence2 = DERSequence.getInstance((Object)attributeValueTagged);
            }
            catch (IllegalArgumentException exc) {
                throw new SignatureException("Encoding isn't a SEQUENCE", exc);
            }
            ASN1Sequence attributeValue = aSN1Sequence2;
            if (attributeValue.size() < 2) {
                throw new SignatureException("Metadata SEQUENCE should have at least 2 items (got " + attributeValue.size() + ")", null, 2, null);
            }
            ASN1Encodable serviceRaw = attributeValue.getObjectAt(0);
            try {
                Intrinsics.checkNotNull((Object)serviceRaw, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                aSN1ObjectIdentifier = ASN1Utils.INSTANCE.getOID((ASN1TaggedObject)serviceRaw);
            }
            catch (ASN1Exception exc) {
                throw new SignatureException("Service in metadata isn't an OID", exc);
            }
            ASN1ObjectIdentifier service = aSN1ObjectIdentifier;
            ASN1Encodable validityPeriodRaw = attributeValue.getObjectAt(1);
            try {
                Intrinsics.checkNotNull((Object)validityPeriodRaw, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                aSN1Sequence = DERSequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)validityPeriodRaw), (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new SignatureException("Validity period in metadata isn't a SEQUENCE", exc);
            }
            ASN1Sequence validityPeriod2 = aSN1Sequence;
            if (validityPeriod2.size() < 2) {
                throw new SignatureException("Validity period in metadata should have at least 2 items (got " + validityPeriod2.size() + ")", null, 2, null);
            }
            try {
                startDateRaw = validityPeriod2.getObjectAt(0);
                Intrinsics.checkNotNull((Object)startDateRaw, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                startDateRaw = ASN1UtilsKt.toZonedDateTime((ASN1TaggedObject)startDateRaw);
            }
            catch (ASN1Exception exc) {
                throw new SignatureException("Start date in metadata is invalid", exc);
            }
            Object startDate = startDateRaw;
            try {
                ASN1Encodable endDateRaw = validityPeriod2.getObjectAt(1);
                Intrinsics.checkNotNull((Object)endDateRaw, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1TaggedObject");
                zonedDateTime = ASN1UtilsKt.toZonedDateTime((ASN1TaggedObject)endDateRaw);
            }
            catch (ASN1Exception exc) {
                throw new SignatureException("End date in metadata is invalid", exc);
            }
            ZonedDateTime endDate = zonedDateTime;
            return new SignatureMetadata(service, (ClosedRange<ZonedDateTime>)RangesKt.rangeTo((Comparable)((Comparable)startDate), (Comparable)endDate));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

