/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.dns;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.Type;
import org.xbill.DNS.dnssec.ValidatingResolver;
import tech.relaycorp.veraid.dns.BaseDnssecChain;
import tech.relaycorp.veraid.dns.DnsException;
import tech.relaycorp.veraid.dns.MessageUtils;
import tech.relaycorp.veraid.dns.resolvers.OfflineResolver;
import tech.relaycorp.veraid.dns.resolvers.PersistingResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Ltech/relaycorp/veraid/dns/BaseDnssecChain;", "", "domainName", "", "recordType", "responses", "", "Lorg/xbill/DNS/Message;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getDomainName$veraid", "()Ljava/lang/String;", "getRecordType$veraid", "getResponses$veraid", "()Ljava/util/List;", "verify", "", "instant", "Ljava/time/Instant;", "verify$veraid", "(Ljava/time/Instant;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "veraid"})
public class BaseDnssecChain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String domainName;
    @NotNull
    private final String recordType;
    @NotNull
    private final List<Message> responses;
    @NotNull
    private static final byte[] DNSSEC_ROOT_DS;
    @NotNull
    private static Function1<? super String, PersistingResolver> persistingResolverInitialiser;
    @NotNull
    private static Function1<? super Resolver, ValidatingResolver> onlineResolverInitialiser;
    @NotNull
    private static Function2<? super OfflineResolver, ? super Clock, ValidatingResolver> offlineResolverInitialiser;

    public BaseDnssecChain(@NotNull String domainName, @NotNull String recordType, @NotNull List<? extends Message> responses) {
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        Intrinsics.checkNotNullParameter((Object)recordType, (String)"recordType");
        Intrinsics.checkNotNullParameter(responses, (String)"responses");
        this.domainName = domainName;
        this.recordType = recordType;
        this.responses = responses;
    }

    @NotNull
    public final String getDomainName$veraid() {
        return this.domainName;
    }

    @NotNull
    public final String getRecordType$veraid() {
        return this.recordType;
    }

    @NotNull
    public final List<Message> getResponses$veraid() {
        return this.responses;
    }

    @Nullable
    public final Object verify$veraid(@NotNull Instant instant, @NotNull Continuation<? super Unit> $completion) throws DnsException {
        OfflineResolver offlineResolver = new OfflineResolver(this.responses);
        Clock clock = Clock.fixed(instant, ZoneOffset.UTC);
        Intrinsics.checkNotNull((Object)clock);
        ValidatingResolver validatingResolver = (ValidatingResolver)offlineResolverInitialiser.invoke((Object)offlineResolver, (Object)clock);
        Object object = BaseDnssecChain.Companion.resolve(validatingResolver, this.domainName, this.recordType, (Continuation<? super Unit>)$completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @Nullable
    public static final Object retrieve(@NotNull String domainName, @NotNull String recordType, @NotNull String resolverHostName, @NotNull Continuation<? super BaseDnssecChain> $completion) throws DnsException {
        return Companion.retrieve(domainName, recordType, resolverHostName, $completion);
    }

    public static final /* synthetic */ byte[] access$getDNSSEC_ROOT_DS$cp() {
        return DNSSEC_ROOT_DS;
    }

    static {
        String string = ". IN DS 20326 8 2 E06D44B80B8F1D39A95C0B0D7C65D08458E880409BBC683457104237C7F8EC8D";
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        DNSSEC_ROOT_DS = byArray;
        persistingResolverInitialiser = Companion.persistingResolverInitialiser.1.INSTANCE;
        onlineResolverInitialiser = Companion.onlineResolverInitialiser.1.INSTANCE;
        offlineResolverInitialiser = Companion.offlineResolverInitialiser.1.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J%\u0010'\u001a\u00020(*\u00020\r2\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001cH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0005\u001a6\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u0006j\u0002`\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R9\u0010\u0013\u001a!\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\r0\u0014j\u0002`\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR9\u0010\u001b\u001a!\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u0014j\u0002`\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0018\"\u0004\b!\u0010\u001a\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006*"}, d2={"Ltech/relaycorp/veraid/dns/BaseDnssecChain$Companion;", "", "()V", "DNSSEC_ROOT_DS", "", "offlineResolverInitialiser", "Lkotlin/Function2;", "Ltech/relaycorp/veraid/dns/resolvers/OfflineResolver;", "Lkotlin/ParameterName;", "name", "headResolver", "Ljava/time/Clock;", "clock", "Lorg/xbill/DNS/dnssec/ValidatingResolver;", "Ltech/relaycorp/veraid/dns/OfflineResolverInitialiser;", "getOfflineResolverInitialiser", "()Lkotlin/jvm/functions/Function2;", "setOfflineResolverInitialiser", "(Lkotlin/jvm/functions/Function2;)V", "onlineResolverInitialiser", "Lkotlin/Function1;", "Lorg/xbill/DNS/Resolver;", "Ltech/relaycorp/veraid/dns/OnlineResolverInitialiser;", "getOnlineResolverInitialiser", "()Lkotlin/jvm/functions/Function1;", "setOnlineResolverInitialiser", "(Lkotlin/jvm/functions/Function1;)V", "persistingResolverInitialiser", "", "resolverHostName", "Ltech/relaycorp/veraid/dns/resolvers/PersistingResolver;", "Ltech/relaycorp/veraid/dns/PersistingResolverInitialiser;", "getPersistingResolverInitialiser", "setPersistingResolverInitialiser", "retrieve", "Ltech/relaycorp/veraid/dns/BaseDnssecChain;", "domainName", "recordType", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve", "", "(Lorg/xbill/DNS/dnssec/ValidatingResolver;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "veraid"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<String, PersistingResolver> getPersistingResolverInitialiser() {
            return persistingResolverInitialiser;
        }

        public final void setPersistingResolverInitialiser(@NotNull Function1<? super String, PersistingResolver> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            persistingResolverInitialiser = function1;
        }

        @NotNull
        public final Function1<Resolver, ValidatingResolver> getOnlineResolverInitialiser() {
            return onlineResolverInitialiser;
        }

        public final void setOnlineResolverInitialiser(@NotNull Function1<? super Resolver, ValidatingResolver> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            onlineResolverInitialiser = function1;
        }

        @NotNull
        public final Function2<OfflineResolver, Clock, ValidatingResolver> getOfflineResolverInitialiser() {
            return offlineResolverInitialiser;
        }

        public final void setOfflineResolverInitialiser(@NotNull Function2<? super OfflineResolver, ? super Clock, ValidatingResolver> function2) {
            Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
            offlineResolverInitialiser = function2;
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final Object retrieve(@NotNull String var1_1, @NotNull String var2_2, @NotNull String var3_3, @NotNull Continuation<? super BaseDnssecChain> var4_4) throws DnsException {
            if (!(var4_4 instanceof retrieve.1)) ** GOTO lbl-1000
            var8_5 = var4_4;
            if ((var8_5.label & -2147483648) != 0) {
                var8_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.retrieve(null, null, null, (Continuation<? super BaseDnssecChain>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    persistingResolver = (PersistingResolver)this.getPersistingResolverInitialiser().invoke((Object)resolverHostName);
                    validatingResolver = (ValidatingResolver)this.getOnlineResolverInitialiser().invoke((Object)persistingResolver);
                    $continuation.L$0 = domainName;
                    $continuation.L$1 = recordType;
                    $continuation.L$2 = persistingResolver;
                    $continuation.label = 1;
                    v0 = this.resolve(validatingResolver, domainName, recordType, (Continuation<? super Unit>)$continuation);
                    if (v0 == var9_7) {
                        return var9_7;
                    }
                    ** GOTO lbl28
                }
                case 1: {
                    persistingResolver = (PersistingResolver)$continuation.L$2;
                    recordType = (String)$continuation.L$1;
                    domainName = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    return new BaseDnssecChain(domainName, recordType, persistingResolver.getResponses());
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object resolve(ValidatingResolver var1_1, String var2_2, String var3_3, Continuation<? super Unit> var4_4) throws DnsException {
            if (!(var4_4 instanceof resolve.1)) ** GOTO lbl-1000
            var10_5 = var4_4;
            if ((var10_5.label & -2147483648) != 0) {
                var10_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var4_4){
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return tech.relaycorp.veraid.dns.BaseDnssecChain$Companion.access$resolve(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$resolve.loadTrustAnchors((InputStream)new ByteArrayInputStream(BaseDnssecChain.access$getDNSSEC_ROOT_DS$cp()));
                    queryRecord = Record.newRecord((Name)Name.fromString((String)domainName), (int)Type.value((String)recordType), (int)1);
                    queryMessage = Message.newQuery((Record)queryRecord);
                    var8_10 = $this$resolve.sendAsync(queryMessage);
                    Intrinsics.checkNotNullExpressionValue((Object)var8_10, (String)"sendAsync(...)");
                    $continuation.label = 1;
                    v0 = FutureKt.await((CompletionStage)var8_10, (Continuation)$continuation);
                    if (v0 == var11_7) {
                        return var11_7;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    if (!(response = (Message)v0).getHeader().getFlag(10)) {
                        Intrinsics.checkNotNull((Object)response);
                        throw new DnsException("DNSSEC verification failed: " + MessageUtils.getDnssecFailureDescription(response));
                    }
                    if (response.getHeader().getRcode() != 0) {
                        rcodeName = Rcode.string((int)response.getHeader().getRcode());
                        throw new DnsException("DNS lookup failed (" + rcodeName + ")");
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

