/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.dns;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.Type;
import org.xbill.DNS.WireParseException;
import tech.relaycorp.veraid.OrganisationKeySpec;
import tech.relaycorp.veraid.Periods;
import tech.relaycorp.veraid.dns.BaseDnssecChain;
import tech.relaycorp.veraid.dns.DnsException;
import tech.relaycorp.veraid.dns.DnssecChain;
import tech.relaycorp.veraid.dns.InvalidChainException;
import tech.relaycorp.veraid.dns.InvalidRdataException;
import tech.relaycorp.veraid.dns.MessageUtils;
import tech.relaycorp.veraid.dns.RdataFieldSet;
import tech.relaycorp.veraid.utils.Range;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J4\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\r\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0012\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ5\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\u001f0\u000bj\u0002` H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Ltech/relaycorp/veraid/dns/DnssecChain;", "Ltech/relaycorp/veraid/dns/BaseDnssecChain;", "orgName", "", "responses", "", "Lorg/xbill/DNS/Message;", "(Ljava/lang/String;Ljava/util/List;)V", "getOrgName$veraid", "()Ljava/lang/String;", "calculateVerificationPeriod", "Lkotlin/ranges/ClosedRange;", "Ljava/time/Instant;", "Ltech/relaycorp/veraid/InstantPeriod;", "period", "orgKeySpec", "Ltech/relaycorp/veraid/OrganisationKeySpec;", "serviceOid", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "encode", "Lorg/bouncycastle/asn1/ASN1Set;", "encode$veraid", "getChainValidityPeriod", "getRdataFields", "Ltech/relaycorp/veraid/dns/RdataFieldSet;", "getVeraTxtAnswers", "Lorg/xbill/DNS/TXTRecord;", "serialise", "", "verify", "", "Ljava/time/ZonedDateTime;", "Ltech/relaycorp/veraid/DatePeriod;", "verify$veraid", "(Ltech/relaycorp/veraid/OrganisationKeySpec;Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;Lkotlin/ranges/ClosedRange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "veraid"})
@SourceDebugExtension(value={"SMAP\nDnssecChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnssecChain.kt\ntech/relaycorp/veraid/dns/DnssecChain\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1549#2:203\n1620#2,3:204\n1603#2,9:209\n1855#2:218\n1856#2:220\n1612#2:221\n2661#2,7:222\n1549#2:229\n1620#2,3:230\n766#2:233\n857#2,2:234\n766#2:236\n857#2,2:237\n766#2:239\n857#2,2:240\n766#2:242\n857#2,2:243\n37#3,2:207\n1#4:219\n*S KotlinDebug\n*F\n+ 1 DnssecChain.kt\ntech/relaycorp/veraid/dns/DnssecChain\n*L\n35#1:203\n35#1:204,3\n67#1:209,9\n67#1:218\n67#1:220\n67#1:221\n70#1:222,7\n95#1:229\n95#1:230,3\n105#1:233\n105#1:234,2\n110#1:236\n110#1:237,2\n116#1:239\n116#1:240,2\n128#1:242\n128#1:243,2\n37#1:207,2\n67#1:219\n*E\n"})
public final class DnssecChain
extends BaseDnssecChain {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String orgName;
    @NotNull
    private static final String VERA_RECORD_TYPE = "TXT";
    @NotNull
    private static final String CLOUDFLARE_RESOLVER = "1.1.1.1";
    @NotNull
    private static Function4<? super String, ? super String, ? super String, ? super Continuation<? super BaseDnssecChain>, ? extends Object> chainRetriever = (Function4)new Function4<String, String, String, Continuation<? super BaseDnssecChain>, Object>((Object)BaseDnssecChain.Companion){

        @Nullable
        public final Object invoke(@NotNull String p0, @NotNull String p1, @NotNull String p2, @NotNull Continuation<? super BaseDnssecChain> $completion) {
            return ((BaseDnssecChain.Companion)this.receiver).retrieve(p0, p1, p2, $completion);
        }
    };

    public DnssecChain(@NotNull String orgName, @NotNull List<? extends Message> responses) {
        Intrinsics.checkNotNullParameter((Object)orgName, (String)"orgName");
        Intrinsics.checkNotNullParameter(responses, (String)"responses");
        super("_veraid." + orgName + ".", VERA_RECORD_TYPE, responses);
        this.orgName = orgName;
    }

    @NotNull
    public final String getOrgName$veraid() {
        return this.orgName;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ASN1Set encode$veraid() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getResponses$veraid();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Message message = (Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DEROctetString(it.toWire()));
        }
        List responsesWrapped = (List)destination$iv$iv;
        ASN1EncodableVector vector = new ASN1EncodableVector(responsesWrapped.size());
        Collection $this$toTypedArray$iv = responsesWrapped;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        vector.addAll((ASN1Encodable[])thisCollection$iv.toArray(new DEROctetString[0]));
        return (ASN1Set)new DERSet(vector);
    }

    @NotNull
    public final byte[] serialise() {
        byte[] byArray = this.encode$veraid().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return byArray;
    }

    @Nullable
    public final Object verify$veraid(@NotNull OrganisationKeySpec orgKeySpec, @NotNull ASN1ObjectIdentifier serviceOid, @NotNull ClosedRange<ZonedDateTime> period, @NotNull Continuation<? super Unit> $completion) throws DnsException, InvalidChainException {
        ClosedRange<Instant> verificationPeriod = this.calculateVerificationPeriod(Periods.toInstantPeriod(period), orgKeySpec, serviceOid);
        ClosedRange<Instant> chainValidityPeriod = this.getChainValidityPeriod();
        ClosedRange<Instant> closedRange = Range.intersect(verificationPeriod, chainValidityPeriod);
        if (closedRange == null) {
            throw new InvalidChainException("Chain validity period does not overlap with required period", null, 2, null);
        }
        ClosedRange<Instant> intersectingPeriod = closedRange;
        Object object = super.verify$veraid((Instant)intersectingPeriod.getStart(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final ClosedRange<Instant> getChainValidityPeriod() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getResponses$veraid();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ClosedRange<Instant> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Message it = (Message)element$iv$iv;
            boolean bl2 = false;
            if (MessageUtils.getSignatureValidityPeriod(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        if ($this$mapNotNull$iv.isEmpty()) {
            boolean bl = false;
            throw new InvalidChainException("Chain does not contain RRSig records", null, 2, null);
        }
        Iterable $this$reduce$iv = $this$mapNotNull$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void period;
            ClosedRange $i$f$mapNotNullTo2 = (ClosedRange)iterator$iv.next();
            ClosedRange acc = (ClosedRange)accumulator$iv;
            boolean bl = false;
            if (Range.intersect(acc, period) != null) continue;
            throw new InvalidChainException("Chain contains RRSigs whose validity periods do not overlap", null, 2, null);
        }
        ClosedRange chainValidityPeriod = (ClosedRange)accumulator$iv;
        return chainValidityPeriod;
    }

    private final ClosedRange<Instant> calculateVerificationPeriod(ClosedRange<Instant> period, OrganisationKeySpec orgKeySpec, ASN1ObjectIdentifier serviceOid) {
        RdataFieldSet matchingFields = this.getRdataFields(orgKeySpec, serviceOid);
        long ttlOverride = matchingFields.getTtlOverride-UwyO8pc();
        Instant instant = (Instant)period.getEndInclusive();
        long l = ttlOverride;
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toJavaDuration-LRDsOJo");
        Instant truncatedStart = instant.minus(duration);
        Instant start = (Instant)ComparisonsKt.maxOf((Comparable)period.getStart(), (Comparable)truncatedStart);
        return RangesKt.rangeTo((Comparable)start, (Comparable)period.getEndInclusive());
    }

    /*
     * WARNING - void declaration
     */
    private final RdataFieldSet getRdataFields(OrganisationKeySpec orgKeySpec, ASN1ObjectIdentifier serviceOid) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$filterTo$iv$iv3;
        void $this$mapTo$iv$iv;
        List<TXTRecord> answers = this.getVeraTxtAnswers();
        Iterable $this$map$iv = answers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RdataFieldSet rdataFieldSet;
            void it;
            TXTRecord tXTRecord = (TXTRecord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = it.getStrings();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
            if ((String)CollectionsKt.singleOrNull((List)list) == null) {
                throw new InvalidChainException("VeraId TXT answer rdata must contain one string (got " + it.getStrings().size() + ")", null, 2, null);
            }
            try {
                String rdata;
                rdataFieldSet = RdataFieldSet.Companion.parse(rdata);
            }
            catch (InvalidRdataException exc) {
                throw new InvalidChainException("VeraId TXT response contains invalid RDATA", exc);
            }
            collection.add(rdataFieldSet);
        }
        List fieldSet = (List)destination$iv$iv;
        Iterable $this$filter$iv = fieldSet;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            RdataFieldSet it = (RdataFieldSet)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getOrgKeySpec(), (Object)orgKeySpec) && (it.getService() == null || Intrinsics.areEqual((Object)it.getService(), (Object)serviceOid)))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        if ($this$filter$iv.isEmpty()) {
            boolean bl = false;
            throw new InvalidChainException("Could not find VeraId record for specified key or service", null, 2, null);
        }
        List matchingSet = (List)$this$filter$iv;
        Iterable $this$filter$iv2 = matchingSet;
        boolean $i$f$filter2 = false;
        destination$iv$iv2 = $this$filter$iv2;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            RdataFieldSet it = (RdataFieldSet)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getService(), (Object)serviceOid)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List concreteFields = (List)destination$iv$iv3;
        if (1 < concreteFields.size()) {
            throw new InvalidChainException("Found multiple VeraId records for the same key and service", null, 2, null);
        }
        Iterable $this$filter$iv3 = matchingSet;
        boolean $i$f$filter3 = false;
        destination$iv$iv3 = $this$filter$iv3;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RdataFieldSet it = (RdataFieldSet)element$iv$iv;
            boolean bl = false;
            if (!(it.getService() == null)) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        List wildcardFields = (List)destination$iv$iv4;
        if (1 < wildcardFields.size()) {
            throw new InvalidChainException("Found multiple VeraId records for the same key and no service", null, 2, null);
        }
        RdataFieldSet rdataFieldSet = (RdataFieldSet)CollectionsKt.singleOrNull((List)concreteFields);
        if (rdataFieldSet == null) {
            rdataFieldSet = (RdataFieldSet)CollectionsKt.single((List)wildcardFields);
        }
        return rdataFieldSet;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TXTRecord> getVeraTxtAnswers() {
        void $this$filterTo$iv$iv;
        Record veraRecordQuery = Record.newRecord((Name)Name.fromString((String)this.getDomainName$veraid()), (int)Type.value((String)this.getRecordType$veraid()), (int)1);
        Iterable $this$filter$iv = this.getResponses$veraid();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Message it = (Message)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getQuestion(), (Object)veraRecordQuery)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List veraTxtResponses = (List)destination$iv$iv;
        if (veraTxtResponses.isEmpty()) {
            throw new InvalidChainException("Chain is missing VeraId TXT response", null, 2, null);
        }
        if (1 < veraTxtResponses.size()) {
            throw new InvalidChainException("Chain contains multiple VeraId TXT responses", null, 2, null);
        }
        Message veraTxtResponse = (Message)CollectionsKt.single((List)veraTxtResponses);
        Intrinsics.checkNotNull((Object)veraRecordQuery);
        RRset rRset = MessageUtils.getRrset(veraTxtResponse, veraRecordQuery, 1);
        if (rRset == null) {
            throw new InvalidChainException("VeraId TXT response does not contain an answer", null, 2, null);
        }
        RRset rrset = rRset;
        List list = rrset.rrs();
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<org.xbill.DNS.TXTRecord>");
        return list;
    }

    @JvmStatic
    @Nullable
    public static final Object retrieve(@NotNull String organisationName, @NotNull String resolverHost, @NotNull Continuation<? super DnssecChain> $completion) throws DnsException {
        return Companion.retrieve(organisationName, resolverHost, $completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u0019J#\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u0004H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000Rt\u0010\u0006\u001aW\b\u0001\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007X\u0080\u000e\u00f8\u0001\u0000\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Ltech/relaycorp/veraid/dns/DnssecChain$Companion;", "", "()V", "CLOUDFLARE_RESOLVER", "", "VERA_RECORD_TYPE", "chainRetriever", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "domainName", "recordType", "resolverHostName", "Lkotlin/coroutines/Continuation;", "Ltech/relaycorp/veraid/dns/BaseDnssecChain;", "getChainRetriever$veraid", "()Lkotlin/jvm/functions/Function4;", "setChainRetriever$veraid", "(Lkotlin/jvm/functions/Function4;)V", "Lkotlin/jvm/functions/Function4;", "decode", "Ltech/relaycorp/veraid/dns/DnssecChain;", "organisationName", "set", "Lorg/bouncycastle/asn1/ASN1Set;", "decode$veraid", "setTagged", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "retrieve", "resolverHost", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "veraid"})
    @SourceDebugExtension(value={"SMAP\nDnssecChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnssecChain.kt\ntech/relaycorp/veraid/dns/DnssecChain$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1549#2:203\n1620#2,3:204\n*S KotlinDebug\n*F\n+ 1 DnssecChain.kt\ntech/relaycorp/veraid/dns/DnssecChain$Companion\n*L\n186#1:203\n186#1:204,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function4<String, String, String, Continuation<? super BaseDnssecChain>, Object> getChainRetriever$veraid() {
            return chainRetriever;
        }

        public final void setChainRetriever$veraid(@NotNull Function4<? super String, ? super String, ? super String, ? super Continuation<? super BaseDnssecChain>, ? extends Object> function4) {
            Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
            chainRetriever = function4;
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        @Nullable
        public final Object retrieve(@NotNull String var1_1, @NotNull String var2_2, @NotNull Continuation<? super DnssecChain> var3_3) throws DnsException {
            if (!(var3_3 instanceof retrieve.1)) ** GOTO lbl-1000
            var8_4 = var3_3;
            if ((var8_4.label & -2147483648) != 0) {
                var8_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var3_3){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.retrieve(null, null, (Continuation<? super DnssecChain>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var5_7 = new char[]{'.'};
                    organisationNameNormalised = StringsKt.trimEnd((String)organisationName, (char[])var5_7);
                    domainName = "_veraid." + organisationNameNormalised + ".";
                    $continuation.L$0 = organisationName;
                    $continuation.label = 1;
                    v0 = this.getChainRetriever$veraid().invoke((Object)domainName, (Object)"TXT", (Object)resolverHost, (Object)$continuation);
                    if (v0 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl25
                }
                case 1: {
                    organisationName = (String)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl25:
                    // 2 sources

                    dnssecChain = (BaseDnssecChain)v0;
                    return new DnssecChain(organisationName, dnssecChain.getResponses$veraid());
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static /* synthetic */ Object retrieve$default(Companion companion, String string, String string2, Continuation continuation, int n, Object object) throws DnsException {
            if ((n & 2) != 0) {
                string2 = DnssecChain.CLOUDFLARE_RESOLVER;
            }
            return companion.retrieve(string, string2, (Continuation<? super DnssecChain>)continuation);
        }

        @NotNull
        public final DnssecChain decode$veraid(@NotNull String organisationName, @NotNull ASN1TaggedObject setTagged) throws InvalidChainException {
            ASN1Set aSN1Set;
            Intrinsics.checkNotNullParameter((Object)organisationName, (String)"organisationName");
            Intrinsics.checkNotNullParameter((Object)setTagged, (String)"setTagged");
            try {
                aSN1Set = ASN1Set.getInstance((ASN1TaggedObject)setTagged, (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new InvalidChainException("Chain is not an implicitly-tagged SET", exc);
            }
            ASN1Set set = aSN1Set;
            Intrinsics.checkNotNull((Object)set);
            return this.decode$veraid(organisationName, set);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DnssecChain decode$veraid(@NotNull String organisationName, @NotNull ASN1Set set) throws InvalidChainException {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)organisationName, (String)"organisationName");
            Intrinsics.checkNotNullParameter((Object)set, (String)"set");
            Iterable $this$map$iv = (Iterable)set;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Message message;
                void it;
                ASN1Encodable aSN1Encodable = (ASN1Encodable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!(it instanceof DEROctetString)) {
                    throw new InvalidChainException("Chain SET contains non-OCTET STRING item (" + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName() + ")", null, 2, null);
                }
                try {
                    message = new Message(((DEROctetString)it).getOctets());
                }
                catch (WireParseException exc) {
                    throw new InvalidChainException("Chain contains a malformed DNS message", exc);
                }
                collection.add(message);
            }
            List responses = (List)destination$iv$iv;
            return new DnssecChain(organisationName, responses);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

