/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.dns;

import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import tech.relaycorp.veraid.dns.RrSetUtils;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u001e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"&\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006j\u0004\u0018\u0001`\b*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"dnssecFailureDescription", "", "Lorg/xbill/DNS/Message;", "getDnssecFailureDescription", "(Lorg/xbill/DNS/Message;)Ljava/lang/String;", "signatureValidityPeriod", "Lkotlin/ranges/ClosedRange;", "Ljava/time/Instant;", "Ltech/relaycorp/veraid/InstantPeriod;", "getSignatureValidityPeriod", "(Lorg/xbill/DNS/Message;)Lkotlin/ranges/ClosedRange;", "getRrset", "Lorg/xbill/DNS/RRset;", "question", "Lorg/xbill/DNS/Record;", "section", "", "veraid"})
@JvmName(name="MessageUtils")
@SourceDebugExtension(value={"SMAP\nMessageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageUtils.kt\ntech/relaycorp/veraid/dns/MessageUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n288#2,2:35\n*S KotlinDebug\n*F\n+ 1 MessageUtils.kt\ntech/relaycorp/veraid/dns/MessageUtils\n*L\n17#1:35,2\n*E\n"})
public final class MessageUtils {
    @Nullable
    public static final RRset getRrset(@NotNull Message $this$getRrset, @NotNull Record question, int section) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getRrset, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)question, (String)"question");
            List sectionRrsets = $this$getRrset.getSectionRRsets(section);
            Intrinsics.checkNotNull((Object)sectionRrsets);
            Iterable $this$firstOrNull$iv = sectionRrsets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RRset it = (RRset)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)RrSetUtils.getQuestion(it), (Object)question)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final String getDnssecFailureDescription(@NotNull Message $this$dnssecFailureDescription) {
        Intrinsics.checkNotNullParameter((Object)$this$dnssecFailureDescription, (String)"<this>");
        Record question = Record.newRecord((Name)Name.root, (int)16, (int)65280);
        Intrinsics.checkNotNull((Object)question);
        RRset rRset = MessageUtils.getRrset($this$dnssecFailureDescription, question, 3);
        if (rRset == null) {
            return null;
        }
        RRset rrset = rRset;
        Record record = rrset.first();
        Intrinsics.checkNotNull((Object)record, (String)"null cannot be cast to non-null type org.xbill.DNS.TXTRecord");
        List list = ((TXTRecord)record).getStrings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStrings(...)");
        return (String)CollectionsKt.first((List)list);
    }

    @Nullable
    public static final ClosedRange<Instant> getSignatureValidityPeriod(@NotNull Message $this$signatureValidityPeriod) {
        Intrinsics.checkNotNullParameter((Object)$this$signatureValidityPeriod, (String)"<this>");
        Record record = $this$signatureValidityPeriod.getQuestion();
        if (record == null) {
            return null;
        }
        Record question = record;
        RRset rRset = MessageUtils.getRrset($this$signatureValidityPeriod, question, 1);
        if (rRset == null) {
            return null;
        }
        RRset rrset = rRset;
        return RrSetUtils.getSignatureValidityPeriod(rrset);
    }
}

