/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.dns;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.veraid.KeyAlgorithm;
import tech.relaycorp.veraid.OrganisationKeySpec;
import tech.relaycorp.veraid.dns.InvalidRdataException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0019\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J6\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0004\u001a\u00020\u0005\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Ltech/relaycorp/veraid/dns/RdataFieldSet;", "", "orgKeySpec", "Ltech/relaycorp/veraid/OrganisationKeySpec;", "ttlOverride", "Lkotlin/time/Duration;", "service", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "(Ltech/relaycorp/veraid/OrganisationKeySpec;JLorg/bouncycastle/asn1/ASN1ObjectIdentifier;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getOrgKeySpec", "()Ltech/relaycorp/veraid/OrganisationKeySpec;", "getService", "()Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "getTtlOverride-UwyO8pc", "()J", "J", "component1", "component2", "component2-UwyO8pc", "component3", "copy", "copy-8Mi8wO0", "(Ltech/relaycorp/veraid/OrganisationKeySpec;JLorg/bouncycastle/asn1/ASN1ObjectIdentifier;)Ltech/relaycorp/veraid/dns/RdataFieldSet;", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "veraid"})
public final class RdataFieldSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OrganisationKeySpec orgKeySpec;
    private final long ttlOverride;
    @Nullable
    private final ASN1ObjectIdentifier service;
    private static final long MAX_TTL = DurationKt.toDuration((int)90, (DurationUnit)DurationUnit.DAYS);

    private RdataFieldSet(OrganisationKeySpec orgKeySpec, long ttlOverride, ASN1ObjectIdentifier service) {
        Intrinsics.checkNotNullParameter((Object)orgKeySpec, (String)"orgKeySpec");
        this.orgKeySpec = orgKeySpec;
        this.ttlOverride = ttlOverride;
        this.service = service;
    }

    public /* synthetic */ RdataFieldSet(OrganisationKeySpec organisationKeySpec, long l, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            aSN1ObjectIdentifier = null;
        }
        this(organisationKeySpec, l, aSN1ObjectIdentifier, null);
    }

    @NotNull
    public final OrganisationKeySpec getOrgKeySpec() {
        return this.orgKeySpec;
    }

    public final long getTtlOverride-UwyO8pc() {
        return this.ttlOverride;
    }

    @Nullable
    public final ASN1ObjectIdentifier getService() {
        return this.service;
    }

    @NotNull
    public String toString() {
        Object[] objectArray = new String[]{String.valueOf(this.orgKeySpec.getAlgorithm().getTypeId()), this.orgKeySpec.getId(), String.valueOf(Duration.getInWholeSeconds-impl((long)this.ttlOverride))};
        List fieldsOrdered = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)(this.service != null ? CollectionsKt.listOf((Object)this.service.getId()) : CollectionsKt.emptyList()));
        return CollectionsKt.joinToString$default((Iterable)fieldsOrdered, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final OrganisationKeySpec component1() {
        return this.orgKeySpec;
    }

    public final long component2-UwyO8pc() {
        return this.ttlOverride;
    }

    @Nullable
    public final ASN1ObjectIdentifier component3() {
        return this.service;
    }

    @NotNull
    public final RdataFieldSet copy-8Mi8wO0(@NotNull OrganisationKeySpec orgKeySpec, long ttlOverride, @Nullable ASN1ObjectIdentifier service) {
        Intrinsics.checkNotNullParameter((Object)orgKeySpec, (String)"orgKeySpec");
        return new RdataFieldSet(orgKeySpec, ttlOverride, service, null);
    }

    public static /* synthetic */ RdataFieldSet copy-8Mi8wO0$default(RdataFieldSet rdataFieldSet, OrganisationKeySpec organisationKeySpec, long l, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n, Object object) {
        if ((n & 1) != 0) {
            organisationKeySpec = rdataFieldSet.orgKeySpec;
        }
        if ((n & 2) != 0) {
            l = rdataFieldSet.ttlOverride;
        }
        if ((n & 4) != 0) {
            aSN1ObjectIdentifier = rdataFieldSet.service;
        }
        return rdataFieldSet.copy-8Mi8wO0(organisationKeySpec, l, aSN1ObjectIdentifier);
    }

    public int hashCode() {
        int result = this.orgKeySpec.hashCode();
        result = result * 31 + Duration.hashCode-impl((long)this.ttlOverride);
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RdataFieldSet)) {
            return false;
        }
        RdataFieldSet rdataFieldSet = (RdataFieldSet)other;
        if (!Intrinsics.areEqual((Object)this.orgKeySpec, (Object)rdataFieldSet.orgKeySpec)) {
            return false;
        }
        if (!Duration.equals-impl0((long)this.ttlOverride, (long)rdataFieldSet.ttlOverride)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.service, (Object)rdataFieldSet.service);
    }

    public /* synthetic */ RdataFieldSet(OrganisationKeySpec orgKeySpec, long ttlOverride, ASN1ObjectIdentifier service, DefaultConstructorMarker $constructor_marker) {
        this(orgKeySpec, ttlOverride, service);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0019\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\n"}, d2={"Ltech/relaycorp/veraid/dns/RdataFieldSet$Companion;", "", "()V", "MAX_TTL", "Lkotlin/time/Duration;", "J", "parse", "Ltech/relaycorp/veraid/dns/RdataFieldSet;", "rdata", "", "veraid"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RdataFieldSet parse(@NotNull String rdata) throws InvalidRdataException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            Intrinsics.checkNotNullParameter((Object)rdata, (String)"rdata");
            CharSequence charSequence = ((Object)StringsKt.trim((CharSequence)rdata)).toString();
            Regex regex = new Regex("\\s+");
            int n = 0;
            List fieldsOrdered = regex.split(charSequence, n);
            if (fieldsOrdered.size() < 3) {
                throw new InvalidRdataException("RDATA should have at least 3 space-separated fields (got " + fieldsOrdered.size() + ")");
            }
            String keyAlgorithmIdRaw = (String)fieldsOrdered.get(0);
            String keyId = (String)fieldsOrdered.get(1);
            String ttlOverrideRaw = (String)fieldsOrdered.get(2);
            Integer n2 = StringsKt.toIntOrNull((String)keyAlgorithmIdRaw);
            if (n2 == null) {
                throw new InvalidRdataException("Malformed algorithm id (" + keyAlgorithmIdRaw + ")");
            }
            int keyAlgorithmId = n2;
            KeyAlgorithm keyAlgorithm = KeyAlgorithm.Companion.get(keyAlgorithmId);
            if (keyAlgorithm == null) {
                throw new InvalidRdataException("Unknown algorithm id (" + keyAlgorithmId + ")");
            }
            KeyAlgorithm keyAlgorithm2 = keyAlgorithm;
            OrganisationKeySpec keySpec = new OrganisationKeySpec(keyAlgorithm2, keyId);
            UInt uInt = UStringsKt.toUIntOrNull((String)ttlOverrideRaw);
            if (uInt == null) {
                throw new InvalidRdataException("Malformed TTL override (" + ttlOverrideRaw + ")");
            }
            int ttlOverrideSeconds = uInt.unbox-impl();
            long ttlOverride = ((Duration)RangesKt.coerceAtMost((Comparable)Duration.box-impl((long)DurationKt.toDuration((int)ttlOverrideSeconds, (DurationUnit)DurationUnit.SECONDS)), (Comparable)Duration.box-impl((long)MAX_TTL))).unbox-impl();
            String serviceOidRaw = (String)CollectionsKt.getOrNull((List)fieldsOrdered, (int)3);
            if (serviceOidRaw != null) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier2;
                try {
                    aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier(serviceOidRaw);
                }
                catch (IllegalArgumentException exc) {
                    throw new InvalidRdataException("Malformed service OID (" + serviceOidRaw + ")");
                }
                aSN1ObjectIdentifier = aSN1ObjectIdentifier2;
            } else {
                aSN1ObjectIdentifier = null;
            }
            ASN1ObjectIdentifier serviceOid = aSN1ObjectIdentifier;
            return new RdataFieldSet(keySpec, ttlOverride, serviceOid, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

