/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.pki;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.veraid.KeyAlgorithm;
import tech.relaycorp.veraid.OrganisationKeySpec;
import tech.relaycorp.veraid.pki.PkiException;
import tech.relaycorp.veraid.pki.RsaModulus;
import tech.relaycorp.veraid.utils.Crypto;
import tech.relaycorp.veraid.utils.Hash;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0013\u001a\u00020\b*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\n\u0010\u0014\u001a\u00020\f*\u00020\u0010\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0010\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"rsaModulusHashMap", "", "Ltech/relaycorp/veraid/pki/RsaModulus;", "Ltech/relaycorp/veraid/utils/Hash;", "rsaModulusKeyAlgorithmMap", "Ltech/relaycorp/veraid/KeyAlgorithm;", "orgKeySpec", "Ltech/relaycorp/veraid/OrganisationKeySpec;", "Ljava/security/PublicKey;", "getOrgKeySpec", "(Ljava/security/PublicKey;)Ltech/relaycorp/veraid/OrganisationKeySpec;", "generateRSAKeyPair", "Ljava/security/KeyPair;", "modulus", "deserialisePrivateKey", "Ljava/security/PrivateKey;", "", "algorithm", "", "deserialisePublicKey", "deserialiseRSAKeyPair", "deserialiseRSAPublicKey", "Ljava/security/interfaces/RSAPublicKey;", "veraid"})
@JvmName(name="Keys")
public final class Keys {
    @NotNull
    private static final Map<RsaModulus, KeyAlgorithm> rsaModulusKeyAlgorithmMap;
    @NotNull
    private static final Map<RsaModulus, Hash> rsaModulusHashMap;

    @NotNull
    public static final KeyPair generateRSAKeyPair(@NotNull RsaModulus modulus) {
        Intrinsics.checkNotNullParameter((Object)((Object)modulus), (String)"modulus");
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", (Provider)Crypto.getBC_PROVIDER());
        keyGen.initialize(modulus.getModulus$veraid());
        KeyPair keyPair = keyGen.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }

    public static /* synthetic */ KeyPair generateRSAKeyPair$default(RsaModulus rsaModulus, int n, Object object) {
        if ((n & 1) != 0) {
            rsaModulus = RsaModulus.RSA_2048;
        }
        return Keys.generateRSAKeyPair(rsaModulus);
    }

    @NotNull
    public static final OrganisationKeySpec getOrgKeySpec(@NotNull PublicKey $this$orgKeySpec) {
        Intrinsics.checkNotNullParameter((Object)$this$orgKeySpec, (String)"<this>");
        if (!($this$orgKeySpec instanceof RSAPublicKey)) {
            throw new PkiException("Key type (" + $this$orgKeySpec.getAlgorithm() + ") is unsupported", null, 2, null);
        }
        int modulusRaw = ((RSAPublicKey)$this$orgKeySpec).getModulus().bitLength();
        RsaModulus rsaModulus = RsaModulus.Companion.get(modulusRaw);
        if (rsaModulus == null) {
            throw new PkiException("RSA modulus " + modulusRaw + " is unsupported", null, 2, null);
        }
        RsaModulus modulusSanitised = rsaModulus;
        KeyAlgorithm keyAlgorithm = rsaModulusKeyAlgorithmMap.get((Object)modulusSanitised);
        Intrinsics.checkNotNull((Object)((Object)keyAlgorithm));
        KeyAlgorithm keyAlgorithm2 = keyAlgorithm;
        Hash hash = rsaModulusHashMap.get((Object)modulusSanitised);
        Intrinsics.checkNotNull((Object)((Object)hash));
        Hash hash2 = hash;
        byte[] byArray = ((RSAPublicKey)$this$orgKeySpec).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        byte[] digest = Crypto.hash(byArray, hash2);
        String digestHex = Base64.getEncoder().encodeToString(digest);
        Intrinsics.checkNotNull((Object)digestHex);
        return new OrganisationKeySpec(keyAlgorithm2, digestHex);
    }

    @NotNull
    public static final KeyPair deserialiseRSAKeyPair(@NotNull byte[] $this$deserialiseRSAKeyPair) throws PkiException {
        Intrinsics.checkNotNullParameter((Object)$this$deserialiseRSAKeyPair, (String)"<this>");
        PrivateKey privateKey = Keys.deserialisePrivateKey($this$deserialiseRSAKeyPair, "RSA");
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateCrtKey");
        RSAPrivateCrtKey privateKey2 = (RSAPrivateCrtKey)privateKey;
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)Crypto.getBC_PROVIDER());
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privateKey2.getModulus(), privateKey2.getPublicExponent());
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        return new KeyPair(publicKey, privateKey2);
    }

    private static final PrivateKey deserialisePrivateKey(byte[] $this$deserialisePrivateKey, String algorithm) {
        PrivateKey privateKey;
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec($this$deserialisePrivateKey);
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm, (Provider)Crypto.getBC_PROVIDER());
        try {
            privateKey = keyFactory.generatePrivate(privateKeySpec);
            Intrinsics.checkNotNull((Object)privateKey);
        }
        catch (InvalidKeySpecException exc) {
            throw new PkiException("Value is not a valid " + algorithm + " private key", exc);
        }
        return privateKey;
    }

    @NotNull
    public static final RSAPublicKey deserialiseRSAPublicKey(@NotNull byte[] $this$deserialiseRSAPublicKey) {
        Intrinsics.checkNotNullParameter((Object)$this$deserialiseRSAPublicKey, (String)"<this>");
        PublicKey publicKey = Keys.deserialisePublicKey($this$deserialiseRSAPublicKey, "RSA");
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        return (RSAPublicKey)publicKey;
    }

    private static final PublicKey deserialisePublicKey(byte[] $this$deserialisePublicKey, String algorithm) {
        PublicKey publicKey;
        X509EncodedKeySpec spec = new X509EncodedKeySpec($this$deserialisePublicKey);
        KeyFactory factory = KeyFactory.getInstance(algorithm, (Provider)Crypto.getBC_PROVIDER());
        try {
            publicKey = factory.generatePublic(spec);
            Intrinsics.checkNotNull((Object)publicKey);
        }
        catch (InvalidKeySpecException exc) {
            throw new PkiException("Value is not a valid " + algorithm + " public key", exc);
        }
        return publicKey;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)RsaModulus.RSA_2048), (Object)((Object)KeyAlgorithm.RSA_2048)), TuplesKt.to((Object)((Object)RsaModulus.RSA_3072), (Object)((Object)KeyAlgorithm.RSA_3072)), TuplesKt.to((Object)((Object)RsaModulus.RSA_4096), (Object)((Object)KeyAlgorithm.RSA_4096))};
        rsaModulusKeyAlgorithmMap = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)RsaModulus.RSA_2048), (Object)((Object)Hash.SHA_256)), TuplesKt.to((Object)((Object)RsaModulus.RSA_3072), (Object)((Object)Hash.SHA_384)), TuplesKt.to((Object)((Object)RsaModulus.RSA_4096), (Object)((Object)Hash.SHA_512))};
        rsaModulusHashMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

