/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.pki;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.ZonedDateTime;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.cert.X509CertificateHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.veraid.pki.OrgCertificate;
import tech.relaycorp.veraid.pki.PkiException;
import tech.relaycorp.veraid.utils.x509.Certificate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001d\u0010\u0005\u001a\u0004\u0018\u00010\u00068@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Ltech/relaycorp/veraid/pki/MemberCertificate;", "Ltech/relaycorp/veraid/utils/x509/Certificate;", "certificateHolder", "Lorg/bouncycastle/cert/X509CertificateHolder;", "(Lorg/bouncycastle/cert/X509CertificateHolder;)V", "userName", "", "getUserName$veraid", "()Ljava/lang/String;", "userName$delegate", "Lkotlin/Lazy;", "Companion", "veraid"})
public final class MemberCertificate
extends Certificate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy userName$delegate;
    @NotNull
    private static final Regex FORBIDDEN_USER_NAME_CHARS_REGEX = new Regex("[@\t\r\n]");
    @NotNull
    private static final String BOT_NAME = "@";

    public MemberCertificate(@NotNull X509CertificateHolder certificateHolder) {
        Intrinsics.checkNotNullParameter((Object)certificateHolder, (String)"certificateHolder");
        super(certificateHolder);
        this.userName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ MemberCertificate this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return Intrinsics.areEqual((Object)this.this$0.getCommonName$veraid(), (Object)"@") ? null : this.this$0.getCommonName$veraid();
            }
        }));
    }

    @Nullable
    public final String getUserName$veraid() {
        Lazy lazy = this.userName$delegate;
        return (String)lazy.getValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ:\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0015J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ltech/relaycorp/veraid/pki/MemberCertificate$Companion;", "", "()V", "BOT_NAME", "", "FORBIDDEN_USER_NAME_CHARS_REGEX", "Lkotlin/text/Regex;", "decode", "Ltech/relaycorp/veraid/pki/MemberCertificate;", "encoding", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "decode$veraid", "issue", "userName", "memberPublicKey", "Ljava/security/PublicKey;", "orgCertificate", "Ltech/relaycorp/veraid/pki/OrgCertificate;", "orgPrivateKey", "Ljava/security/PrivateKey;", "expiryDate", "Ljava/time/ZonedDateTime;", "startDate", "validateUserName", "", "validateUserName$veraid", "veraid"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MemberCertificate issue(@Nullable String userName2, @NotNull PublicKey memberPublicKey, @NotNull OrgCertificate orgCertificate, @NotNull PrivateKey orgPrivateKey, @NotNull ZonedDateTime expiryDate, @NotNull ZonedDateTime startDate) {
            String string;
            Intrinsics.checkNotNullParameter((Object)memberPublicKey, (String)"memberPublicKey");
            Intrinsics.checkNotNullParameter((Object)orgCertificate, (String)"orgCertificate");
            Intrinsics.checkNotNullParameter((Object)orgPrivateKey, (String)"orgPrivateKey");
            Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
            Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
            if (userName2 != null) {
                this.validateUserName$veraid(userName2);
            }
            if ((string = userName2) == null) {
                string = MemberCertificate.BOT_NAME;
            }
            return new MemberCertificate(Certificate.Companion.issue$default(Certificate.Companion, string, memberPublicKey, orgPrivateKey, expiryDate, orgCertificate, false, 0, startDate, 96, null).getCertificateHolder$veraid());
        }

        public static /* synthetic */ MemberCertificate issue$default(Companion companion, String string, PublicKey publicKey, OrgCertificate orgCertificate, PrivateKey privateKey, ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, int n, Object object) {
            if ((n & 0x20) != 0) {
                ZonedDateTime zonedDateTime3 = ZonedDateTime.now();
                Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"now(...)");
                zonedDateTime2 = zonedDateTime3;
            }
            return companion.issue(string, publicKey, orgCertificate, privateKey, zonedDateTime, zonedDateTime2);
        }

        @NotNull
        public final MemberCertificate decode$veraid(@NotNull ASN1TaggedObject encoding) {
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            return new MemberCertificate(Certificate.Companion.decode(encoding).getCertificateHolder$veraid());
        }

        public final void validateUserName$veraid(@NotNull String userName2) {
            Intrinsics.checkNotNullParameter((Object)userName2, (String)"userName");
            if (FORBIDDEN_USER_NAME_CHARS_REGEX.containsMatchIn((CharSequence)userName2)) {
                throw new PkiException("User name should not contain at signs or whitespace other than simple spaces", null, 2, null);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

