/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.pki;

import java.time.ZonedDateTime;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.veraid.Member;
import tech.relaycorp.veraid.dns.DnsException;
import tech.relaycorp.veraid.dns.DnssecChain;
import tech.relaycorp.veraid.dns.InvalidChainException;
import tech.relaycorp.veraid.pki.Keys;
import tech.relaycorp.veraid.pki.MemberCertificate;
import tech.relaycorp.veraid.pki.MemberIdBundle;
import tech.relaycorp.veraid.pki.OrgCertificate;
import tech.relaycorp.veraid.pki.PkiException;
import tech.relaycorp.veraid.utils.Range;
import tech.relaycorp.veraid.utils.asn1.ASN1Exception;
import tech.relaycorp.veraid.utils.asn1.ASN1Utils;
import tech.relaycorp.veraid.utils.x509.CertificateException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J-\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020\u00170\u0016j\u0002`\u0018H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Ltech/relaycorp/veraid/pki/MemberIdBundle;", "", "dnssecChain", "Ltech/relaycorp/veraid/dns/DnssecChain;", "orgCertificate", "Ltech/relaycorp/veraid/pki/OrgCertificate;", "memberCertificate", "Ltech/relaycorp/veraid/pki/MemberCertificate;", "(Ltech/relaycorp/veraid/dns/DnssecChain;Ltech/relaycorp/veraid/pki/OrgCertificate;Ltech/relaycorp/veraid/pki/MemberCertificate;)V", "getDnssecChain$veraid", "()Ltech/relaycorp/veraid/dns/DnssecChain;", "getMemberCertificate$veraid", "()Ltech/relaycorp/veraid/pki/MemberCertificate;", "getOrgCertificate$veraid", "()Ltech/relaycorp/veraid/pki/OrgCertificate;", "serialise", "", "verify", "Ltech/relaycorp/veraid/Member;", "service", "Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;", "datePeriod", "Lkotlin/ranges/ClosedRange;", "Ljava/time/ZonedDateTime;", "Ltech/relaycorp/veraid/DatePeriod;", "verify$veraid", "(Lorg/bouncycastle/asn1/ASN1ObjectIdentifier;Lkotlin/ranges/ClosedRange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "veraid"})
public final class MemberIdBundle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DnssecChain dnssecChain;
    @NotNull
    private final OrgCertificate orgCertificate;
    @NotNull
    private final MemberCertificate memberCertificate;

    public MemberIdBundle(@NotNull DnssecChain dnssecChain, @NotNull OrgCertificate orgCertificate, @NotNull MemberCertificate memberCertificate) {
        Intrinsics.checkNotNullParameter((Object)dnssecChain, (String)"dnssecChain");
        Intrinsics.checkNotNullParameter((Object)orgCertificate, (String)"orgCertificate");
        Intrinsics.checkNotNullParameter((Object)memberCertificate, (String)"memberCertificate");
        this.dnssecChain = dnssecChain;
        this.orgCertificate = orgCertificate;
        this.memberCertificate = memberCertificate;
    }

    @NotNull
    public final DnssecChain getDnssecChain$veraid() {
        return this.dnssecChain;
    }

    @NotNull
    public final OrgCertificate getOrgCertificate$veraid() {
        return this.orgCertificate;
    }

    @NotNull
    public final MemberCertificate getMemberCertificate$veraid() {
        return this.memberCertificate;
    }

    @NotNull
    public final byte[] serialise() {
        Object[] objectArray = new ASN1Object[]{new ASN1Integer(0L), this.dnssecChain.encode$veraid(), this.orgCertificate.encode$veraid(), this.memberCertificate.encode$veraid()};
        return ASN1Utils.INSTANCE.serializeSequence(CollectionsKt.listOf((Object[])objectArray), false);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object verify$veraid(@NotNull ASN1ObjectIdentifier var1_1, @NotNull ClosedRange<ZonedDateTime> var2_2, @NotNull Continuation<? super Member> var3_3) throws PkiException {
        if (!(var3_3 instanceof verify.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ MemberIdBundle this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.verify$veraid(null, null, (Continuation<? super Member>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    this.memberCertificate.getCertificationPath$veraid(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)this.orgCertificate));
                }
                catch (CertificateException exc) {
                    throw new PkiException("Member certificate was not issued by organisation", exc);
                }
                v0 = Range.intersect(this.memberCertificate.getValidityPeriod$veraid(), this.orgCertificate.getValidityPeriod$veraid());
                Intrinsics.checkNotNull(v0);
                certsPeriod = v0;
                v1 = Range.intersect(datePeriod, certsPeriod);
                if (v1 == null) {
                    throw new PkiException("Validity period of certificate chain does not overlap with required period", null, 2, null);
                }
                verificationPeriod = v1;
                userName = this.memberCertificate.getUserName$veraid();
                if (userName != null) {
                    MemberCertificate.Companion.validateUserName$veraid(userName);
                }
                if (!Intrinsics.areEqual((Object)this.orgCertificate.getCommonName$veraid(), (Object)this.dnssecChain.getOrgName$veraid())) {
                    throw new PkiException("Organisation certificate does not correspond to DNSSEC chain", null, 2, null);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = userName;
                $continuation.label = 1;
                v2 = this.dnssecChain.verify$veraid(Keys.getOrgKeySpec(this.orgCertificate.getSubjectPublicKey$veraid()), var1_1, verificationPeriod, (Continuation<? super Unit>)$continuation);
                ** if (v2 != var10_6) goto lbl39
lbl38:
                // 1 sources

                return var10_6;
lbl39:
                // 1 sources

                ** GOTO lbl52
            }
            case 1: {
                userName = (String)$continuation.L$1;
                this = (MemberIdBundle)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                }
                catch (DnsException exc) {
                    throw new PkiException("DNS/DNSSEC resolution failed", exc);
                }
                catch (InvalidChainException exc) {
                    throw new PkiException("VeraId DNSSEC chain verification failed", exc);
                }
lbl52:
                // 2 sources

                return new Member(this.orgCertificate.getCommonName$veraid(), userName);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ltech/relaycorp/veraid/pki/MemberIdBundle$Companion;", "", "()V", "deserialise", "Ltech/relaycorp/veraid/pki/MemberIdBundle;", "serialisation", "", "veraid"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MemberIdBundle deserialise(@NotNull byte[] serialisation) throws PkiException {
            MemberCertificate memberCertificate;
            DnssecChain exc3;
            OrgCertificate exc22;
            ASN1TaggedObject[] aSN1TaggedObjectArray;
            Intrinsics.checkNotNullParameter((Object)serialisation, (String)"serialisation");
            try {
                aSN1TaggedObjectArray = ASN1Utils.INSTANCE.deserializeHeterogeneousSequence(serialisation);
            }
            catch (ASN1Exception exc22) {
                throw new PkiException("Member Id Bundle should be a SEQUENCE", exc22);
            }
            ASN1TaggedObject[] sequence = aSN1TaggedObjectArray;
            if (sequence.length < 4) {
                throw new PkiException("Member Id Bundle should have at least 4 items", null, 2, null);
            }
            try {
                exc22 = OrgCertificate.Companion.decode$veraid(sequence[2]);
            }
            catch (CertificateException exc3) {
                throw new PkiException("Organisation certificate is malformed", exc3);
            }
            OrgCertificate orgCertificate = exc22;
            try {
                exc3 = DnssecChain.Companion.decode$veraid(orgCertificate.getCommonName$veraid(), sequence[1]);
            }
            catch (InvalidChainException exc4) {
                throw new PkiException("DNSSEC chain is malformed", exc4);
            }
            DnssecChain dnssecChain = exc3;
            try {
                memberCertificate = MemberCertificate.Companion.decode$veraid(sequence[3]);
            }
            catch (CertificateException exc5) {
                throw new PkiException("Member certificate is malformed", exc5);
            }
            MemberCertificate memberCertificate2 = memberCertificate;
            return new MemberIdBundle(dnssecChain, orgCertificate, memberCertificate2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

