/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.utils.asn1;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.jetbrains.annotations.NotNull;
import tech.relaycorp.veraid.utils.asn1.ASN1Exception;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0002*\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"toGeneralizedTime", "Lorg/bouncycastle/asn1/DERGeneralizedTime;", "Ljava/time/ZonedDateTime;", "toZonedDateTime", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "veraid"})
public final class ASN1UtilsKt {
    @NotNull
    public static final DERGeneralizedTime toGeneralizedTime(@NotNull ZonedDateTime $this$toGeneralizedTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toGeneralizedTime, (String)"<this>");
        ZonedDateTime dateUTC = $this$toGeneralizedTime.withZoneSameInstant(ZoneOffset.UTC);
        return new DERGeneralizedTime(Date.from(dateUTC.toInstant()));
    }

    @NotNull
    public static final ZonedDateTime toZonedDateTime(@NotNull ASN1TaggedObject $this$toZonedDateTime) {
        ASN1GeneralizedTime aSN1GeneralizedTime;
        Intrinsics.checkNotNullParameter((Object)$this$toZonedDateTime, (String)"<this>");
        try {
            aSN1GeneralizedTime = DERGeneralizedTime.getInstance((ASN1TaggedObject)$this$toZonedDateTime, (boolean)false);
        }
        catch (IllegalStateException exc) {
            throw new ASN1Exception("Value is not a GeneralizedTime", exc);
        }
        ASN1GeneralizedTime generalizedTime = aSN1GeneralizedTime;
        ZonedDateTime zonedDateTime = generalizedTime.getDate().toInstant().atZone(ZoneOffset.UTC);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atZone(...)");
        return zonedDateTime;
    }
}

