/*
 * Decompiled with CFR 0.152.
 */
package tech.relaycorp.veraid.utils.cms;

import java.security.PrivateKey;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.relaycorp.veraid.utils.Crypto;
import tech.relaycorp.veraid.utils.Hash;
import tech.relaycorp.veraid.utils.cms.SignedDataException;
import tech.relaycorp.veraid.utils.x509.Certificate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010 \u001a\u00020!J\u0012\u0010\"\u001a\u00020#2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\r\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\r\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Ltech/relaycorp/veraid/utils/cms/SignedData;", "", "bcSignedData", "Lorg/bouncycastle/cms/CMSSignedData;", "(Lorg/bouncycastle/cms/CMSSignedData;)V", "getBcSignedData", "()Lorg/bouncycastle/cms/CMSSignedData;", "certificates", "", "Ltech/relaycorp/veraid/utils/x509/Certificate;", "getCertificates", "()Ljava/util/Set;", "certificates$delegate", "Lkotlin/Lazy;", "plaintext", "", "getPlaintext", "()[B", "plaintext$delegate", "signedAttrs", "Lorg/bouncycastle/asn1/cms/AttributeTable;", "getSignedAttrs", "()Lorg/bouncycastle/asn1/cms/AttributeTable;", "signerCertificate", "getSignerCertificate", "()Ltech/relaycorp/veraid/utils/x509/Certificate;", "signerCertificate$delegate", "signerInfo", "Lorg/bouncycastle/cms/SignerInformation;", "getSignerInfo", "()Lorg/bouncycastle/cms/SignerInformation;", "signerInfo$delegate", "encode", "Lorg/bouncycastle/asn1/cms/ContentInfo;", "verify", "", "expectedPlaintext", "Companion", "veraid"})
public final class SignedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMSSignedData bcSignedData;
    @NotNull
    private final Lazy plaintext$delegate;
    @NotNull
    private final Lazy signerInfo$delegate;
    @NotNull
    private final Lazy signerCertificate$delegate;
    @Nullable
    private final AttributeTable signedAttrs;
    @NotNull
    private final Lazy certificates$delegate;
    @NotNull
    private static final Map<Hash, String> signatureAlgorithmMap;

    public SignedData(@NotNull CMSSignedData bcSignedData) {
        Intrinsics.checkNotNullParameter((Object)bcSignedData, (String)"bcSignedData");
        this.bcSignedData = bcSignedData;
        this.plaintext$delegate = LazyKt.lazy((Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ SignedData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final byte[] invoke() {
                CMSTypedData cMSTypedData = this.this$0.getBcSignedData().getSignedContent();
                return (byte[])(cMSTypedData != null ? cMSTypedData.getContent() : null);
            }
        }));
        this.signerInfo$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SignerInformation>(this){
            final /* synthetic */ SignedData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final SignerInformation invoke() {
                SignerInformationStore signerInformationStore = this.this$0.getBcSignedData().getSignerInfos();
                Intrinsics.checkNotNullExpressionValue((Object)signerInformationStore, (String)"getSignerInfos(...)");
                return (SignerInformation)CollectionsKt.singleOrNull((Iterable)((Iterable)signerInformationStore));
            }
        }));
        this.signerCertificate$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Certificate>(this){
            final /* synthetic */ SignedData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Certificate invoke() {
                Certificate certificate;
                SignerInformation signerInformation = SignedData.access$getSignerInfo(this.this$0);
                if (signerInformation == null) {
                    throw new SignedDataException("SignedData should contain exactly one SignerInfo", null, 2, null);
                }
                SignerInformation signerInfo2 = signerInformation;
                Selector signerCertSelector = (Selector)new X509CertificateHolderSelector(signerInfo2.getSID().getIssuer(), signerInfo2.getSID().getSerialNumber());
                Collection signerCertMatches = this.this$0.getBcSignedData().getCertificates().getMatches(signerCertSelector);
                try {
                    Intrinsics.checkNotNull((Object)signerCertMatches);
                    Object object = CollectionsKt.first((Iterable)signerCertMatches);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                    certificate = new Certificate((X509CertificateHolder)object);
                }
                catch (NoSuchElementException noSuchElementException) {
                    certificate = null;
                }
                return certificate;
            }
        }));
        SignerInformation signerInformation = this.getSignerInfo();
        this.signedAttrs = signerInformation != null ? signerInformation.getSignedAttributes() : null;
        this.certificates$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends Certificate>>(this){
            final /* synthetic */ SignedData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<Certificate> invoke() {
                void $this$mapTo$iv$iv;
                Store store = this.this$0.getBcSignedData().getCertificates();
                Intrinsics.checkNotNull((Object)store, (String)"null cannot be cast to non-null type org.bouncycastle.util.CollectionStore<@[FlexibleNullability] org.bouncycastle.cert.X509CertificateHolder?>");
                Iterable $this$map$iv = (Iterable)((CollectionStore)store);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(new Certificate((X509CertificateHolder)it));
                }
                return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            }
        }));
    }

    @NotNull
    public final CMSSignedData getBcSignedData() {
        return this.bcSignedData;
    }

    @Nullable
    public final byte[] getPlaintext() {
        Lazy lazy = this.plaintext$delegate;
        return (byte[])lazy.getValue();
    }

    private final SignerInformation getSignerInfo() {
        Lazy lazy = this.signerInfo$delegate;
        return (SignerInformation)lazy.getValue();
    }

    @Nullable
    public final Certificate getSignerCertificate() {
        Lazy lazy = this.signerCertificate$delegate;
        return (Certificate)lazy.getValue();
    }

    @Nullable
    public final AttributeTable getSignedAttrs() {
        return this.signedAttrs;
    }

    @NotNull
    public final Set<Certificate> getCertificates() {
        Lazy lazy = this.certificates$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final ContentInfo encode() {
        ContentInfo contentInfo = this.bcSignedData.toASN1Structure();
        Intrinsics.checkNotNullExpressionValue((Object)contentInfo, (String)"toASN1Structure(...)");
        return contentInfo;
    }

    public final void verify(@Nullable byte[] expectedPlaintext) throws SignedDataException {
        boolean bl;
        if (this.getPlaintext() != null && expectedPlaintext != null) {
            throw new SignedDataException("No specific plaintext should be expected because one is already encapsulated", null, 2, null);
        }
        byte[] byArray = this.getPlaintext();
        if (byArray == null) {
            byArray = expectedPlaintext;
            if (expectedPlaintext == null) {
                throw new SignedDataException("Plaintext should be encapsulated or explicitly set", null, 2, null);
            }
        }
        byte[] signedPlaintext = byArray;
        if (this.getSignerCertificate() == null) {
            throw new SignedDataException("Signer certificate should be encapsulated", null, 2, null);
        }
        CMSSignedData signedData = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(signedPlaintext), this.bcSignedData.toASN1Structure());
        SignerInformationStore signerInformationStore = signedData.getSignerInfos();
        Intrinsics.checkNotNullExpressionValue((Object)signerInformationStore, (String)"getSignerInfos(...)");
        SignerInformation signerInfo2 = (SignerInformation)CollectionsKt.single((Iterable)((Iterable)signerInformationStore));
        JcaSimpleSignerInfoVerifierBuilder verifierBuilder = new JcaSimpleSignerInfoVerifierBuilder().setProvider((Provider)Crypto.getBC_PROVIDER());
        Certificate certificate = this.getSignerCertificate();
        Intrinsics.checkNotNull((Object)certificate);
        SignerInformationVerifier verifier = verifierBuilder.build(certificate.getCertificateHolder$veraid());
        try {
            bl = signerInfo2.verify(verifier);
        }
        catch (CMSException exc) {
            throw new SignedDataException("Could not verify signature", exc);
        }
        boolean isValid = bl;
        if (!isValid) {
            throw new SignedDataException("Invalid signature", null, 2, null);
        }
    }

    public static /* synthetic */ void verify$default(SignedData signedData, byte[] byArray, int n, Object object) throws SignedDataException {
        if ((n & 1) != 0) {
            byArray = null;
        }
        signedData.verify(byArray);
    }

    @JvmStatic
    @NotNull
    public static final SignedData sign(@NotNull byte[] plaintext2, @NotNull PrivateKey signerPrivateKey, @NotNull Certificate signerCertificate2, @NotNull Set<? extends Certificate> encapsulatedCertificates, @Nullable Hash hashingAlgorithm, boolean encapsulatePlaintext, @NotNull Collection<? extends Attribute> extraSignedAttrs) {
        return Companion.sign(plaintext2, signerPrivateKey, signerCertificate2, encapsulatedCertificates, hashingAlgorithm, encapsulatePlaintext, extraSignedAttrs);
    }

    @JvmStatic
    @NotNull
    public static final SignedData decode(@NotNull ASN1TaggedObject contentInfoTagged) {
        return Companion.decode(contentInfoTagged);
    }

    public static final /* synthetic */ SignerInformation access$getSignerInfo(SignedData $this) {
        return $this.getSignerInfo();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)Hash.SHA_256), (Object)"SHA256WITHRSAANDMGF1"), TuplesKt.to((Object)((Object)Hash.SHA_384), (Object)"SHA384WITHRSAANDMGF1"), TuplesKt.to((Object)((Object)Hash.SHA_512), (Object)"SHA512WITHRSAANDMGF1")};
        signatureAlgorithmMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0002J2\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JV\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ltech/relaycorp/veraid/utils/cms/SignedData$Companion;", "", "()V", "signatureAlgorithmMap", "", "Ltech/relaycorp/veraid/utils/Hash;", "", "decode", "Ltech/relaycorp/veraid/utils/cms/SignedData;", "contentInfoTagged", "Lorg/bouncycastle/asn1/ASN1TaggedObject;", "makeContentSigner", "Lorg/bouncycastle/operator/ContentSigner;", "signerPrivateKey", "Ljava/security/PrivateKey;", "hashingAlgorithm", "makeSignerInfoGenerator", "Lorg/bouncycastle/cms/SignerInfoGenerator;", "extraSignedAttrs", "", "Lorg/bouncycastle/asn1/cms/Attribute;", "signerCertificate", "Ltech/relaycorp/veraid/utils/x509/Certificate;", "sign", "plaintext", "", "encapsulatedCertificates", "", "encapsulatePlaintext", "", "veraid"})
    @SourceDebugExtension(value={"SMAP\nSignedData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignedData.kt\ntech/relaycorp/veraid/utils/cms/SignedData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,209:1\n1549#2:210\n1620#2,3:211\n37#3,2:214\n*S KotlinDebug\n*F\n+ 1 SignedData.kt\ntech/relaycorp/veraid/utils/cms/SignedData$Companion\n*L\n140#1:210\n140#1:211,3\n170#1:214,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SignedData sign(@NotNull byte[] plaintext2, @NotNull PrivateKey signerPrivateKey, @NotNull Certificate signerCertificate2, @NotNull Set<? extends Certificate> encapsulatedCertificates, @Nullable Hash hashingAlgorithm, boolean encapsulatePlaintext, @NotNull Collection<? extends Attribute> extraSignedAttrs) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)plaintext2, (String)"plaintext");
            Intrinsics.checkNotNullParameter((Object)signerPrivateKey, (String)"signerPrivateKey");
            Intrinsics.checkNotNullParameter((Object)signerCertificate2, (String)"signerCertificate");
            Intrinsics.checkNotNullParameter(encapsulatedCertificates, (String)"encapsulatedCertificates");
            Intrinsics.checkNotNullParameter(extraSignedAttrs, (String)"extraSignedAttrs");
            SignerInfoGenerator signerInfoGenerator = this.makeSignerInfoGenerator(signerPrivateKey, hashingAlgorithm, extraSignedAttrs, signerCertificate2);
            CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
            signedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
            Iterable $this$map$iv = encapsulatedCertificates;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Certificate certificate = (Certificate)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCertificateHolder$veraid());
            }
            Collection collection = (List)destination$iv$iv;
            JcaCertStore certs = new JcaCertStore(collection);
            signedDataGenerator.addCertificates((Store)certs);
            CMSTypedData plaintextCms = (CMSTypedData)new CMSProcessableByteArray(plaintext2);
            CMSSignedData bcSignedData = signedDataGenerator.generate(plaintextCms, encapsulatePlaintext);
            iterable = encapsulatePlaintext ? bcSignedData : new CMSSignedData(bcSignedData.toASN1Structure());
            Intrinsics.checkNotNull((Object)iterable);
            return new SignedData((CMSSignedData)iterable);
        }

        public static /* synthetic */ SignedData sign$default(Companion companion, byte[] byArray, PrivateKey privateKey, Certificate certificate, Set set, Hash hash, boolean bl, Collection collection, int n, Object object) {
            if ((n & 8) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 0x10) != 0) {
                hash = null;
            }
            if ((n & 0x20) != 0) {
                bl = true;
            }
            if ((n & 0x40) != 0) {
                collection = CollectionsKt.emptyList();
            }
            return companion.sign(byArray, privateKey, certificate, set, hash, bl, collection);
        }

        private final SignerInfoGenerator makeSignerInfoGenerator(PrivateKey signerPrivateKey, Hash hashingAlgorithm, Collection<? extends Attribute> extraSignedAttrs, Certificate signerCertificate2) {
            ContentSigner contentSigner = this.makeContentSigner(signerPrivateKey, hashingAlgorithm);
            JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build());
            ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
            Collection<? extends Attribute> $this$toTypedArray$iv = extraSignedAttrs;
            boolean $i$f$toTypedArray = false;
            Collection<? extends Attribute> thisCollection$iv = $this$toTypedArray$iv;
            signedAttrs.addAll((ASN1Encodable[])thisCollection$iv.toArray(new Attribute[0]));
            signerInfoGeneratorBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(new AttributeTable(signedAttrs)));
            return signerInfoGeneratorBuilder.build(contentSigner, signerCertificate2.getCertificateHolder$veraid());
        }

        private final ContentSigner makeContentSigner(PrivateKey signerPrivateKey, Hash hashingAlgorithm) {
            Hash hash = hashingAlgorithm;
            if (hash == null) {
                hash = Hash.SHA_256;
            }
            Hash algorithm = hash;
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder((String)signatureAlgorithmMap.get((Object)algorithm)).setProvider((Provider)Crypto.getBC_PROVIDER());
            ContentSigner contentSigner = signerBuilder.build(signerPrivateKey);
            Intrinsics.checkNotNullExpressionValue((Object)contentSigner, (String)"build(...)");
            return contentSigner;
        }

        @JvmStatic
        @NotNull
        public final SignedData decode(@NotNull ASN1TaggedObject contentInfoTagged) {
            CMSSignedData cMSSignedData;
            ContentInfo contentInfo;
            Intrinsics.checkNotNullParameter((Object)contentInfoTagged, (String)"contentInfoTagged");
            try {
                contentInfo = ContentInfo.getInstance((ASN1TaggedObject)contentInfoTagged, (boolean)false);
            }
            catch (IllegalStateException exc) {
                throw new SignedDataException("Encoding is not an implicitly-tagged ContentInfo", exc);
            }
            ContentInfo contentInfo2 = contentInfo;
            try {
                cMSSignedData = new CMSSignedData(contentInfo2);
            }
            catch (CMSException cMSException) {
                throw new SignedDataException("ContentInfo wraps invalid SignedData value", null, 2, null);
            }
            CMSSignedData bcSignedData = cMSSignedData;
            return new SignedData(bcSignedData);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

