/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.web.filters;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHttpHeadersFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(LogHttpHeadersFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        log.debug("LogHttpHeadersFilter - RequstedURI is: " + req.getRequestURL());
        Enumeration en = req.getHeaderNames();
        while (en.hasMoreElements()) {
            String n = (String)en.nextElement();
            String v = req.getHeader(n);
            log.info(n + " = " + v);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

