/*
 * Decompiled with CFR 0.152.
 */
package tech.simter.operation.impl.dao.mongo;

import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import tech.simter.operation.core.Operation;
import tech.simter.operation.core.OperationDao;
import tech.simter.operation.impl.dao.mongo.OperationDaoImpl;
import tech.simter.operation.impl.dao.mongo.OperationReactiveRepository;
import tech.simter.operation.impl.dao.mongo.po.OperationPo;

@Repository
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00062\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ltech/simter/operation/impl/dao/mongo/OperationDaoImpl;", "Ltech/simter/operation/core/OperationDao;", "repository", "Ltech/simter/operation/impl/dao/mongo/OperationReactiveRepository;", "(Ltech/simter/operation/impl/dao/mongo/OperationReactiveRepository;)V", "create", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "operation", "Ltech/simter/operation/core/Operation;", "findByBatch", "Lreactor/core/publisher/Flux;", "batch", "", "findByTarget", "targetType", "targetId", "get", "id", "simter-operation-dao-mongo"})
public class OperationDaoImpl
implements OperationDao {
    private final OperationReactiveRepository repository;

    @NotNull
    public Mono<Void> create(@NotNull Operation operation) {
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Mono mono = this.repository.save(OperationPo.Companion.from(operation)).then(Mono.empty());
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"repository.save(Operatio\u2026tion)).then(Mono.empty())");
        return mono;
    }

    @NotNull
    public Mono<Operation> get(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Mono mono = this.repository.findById(id).map((Function)get.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"repository.findById(id).map { it as Operation }");
        return mono;
    }

    @NotNull
    public Flux<Operation> findByBatch(@NotNull String batch) {
        Intrinsics.checkParameterIsNotNull((Object)batch, (String)"batch");
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"ts"});
        Intrinsics.checkExpressionValueIsNotNull((Object)sort, (String)"Sort.by(Sort.Direction.DESC, \"ts\")");
        Flux flux = this.repository.findByBatch(batch, sort).map((Function)findByBatch.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"repository.findByBatch(b\u2026 .map { it as Operation }");
        return flux;
    }

    @NotNull
    public Flux<Operation> findByTarget(@NotNull String targetType, @NotNull String targetId) {
        Intrinsics.checkParameterIsNotNull((Object)targetType, (String)"targetType");
        Intrinsics.checkParameterIsNotNull((Object)targetId, (String)"targetId");
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"ts"});
        Intrinsics.checkExpressionValueIsNotNull((Object)sort, (String)"Sort.by(Sort.Direction.DESC, \"ts\")");
        Flux flux = this.repository.findByTargetTypeAndTargetId(targetType, targetId, sort).map((Function)findByTarget.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flux, (String)"repository.findByTargetT\u2026 .map { it as Operation }");
        return flux;
    }

    @Autowired
    public OperationDaoImpl(@NotNull OperationReactiveRepository repository) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        this.repository = repository;
    }
}

