/*
 * Decompiled with CFR 0.152.
 */
package tech.sourced.gitbase.spark.rule;

import java.util.NoSuchElementException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeEquals;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.types.Metadata;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import tech.sourced.gitbase.spark.DefaultReader;
import tech.sourced.gitbase.spark.GitbaseServer;
import tech.sourced.gitbase.spark.Join;
import tech.sourced.gitbase.spark.Node;
import tech.sourced.gitbase.spark.Sources$;
import tech.sourced.gitbase.spark.Table;
import tech.sourced.gitbase.spark.rule.JoinData;
import tech.sourced.gitbase.spark.rule.JoinData$;

public final class JoinOptimizer$
implements Logging {
    public static final JoinOptimizer$ MODULE$;
    private final Seq<JoinType> supportedJoinTypes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new JoinOptimizer$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public boolean hasSource(Attribute attr) {
        String string = this.getSource((NamedExpression)attr);
        String string2 = "";
        return string != null ? !string.equals(string2) : string2 != null;
    }

    public String getSource(NamedExpression attr) {
        return this.getSource(attr.metadata());
    }

    public String getSource(Metadata metadata) {
        String string;
        try {
            string = metadata.getString(Sources$.MODULE$.SourceKey());
        }
        catch (NoSuchElementException noSuchElementException) {
            string = "";
        }
        return string;
    }

    public JoinData getJoinData(org.apache.spark.sql.catalyst.plans.logical.Join j) {
        block4: {
            Option option;
            block8: {
                block7: {
                    block5: {
                        block6: {
                            Seq<String> tables;
                            Option<DataSourceV2Relation> leftRel = this.getGitbaseRelation(j.left());
                            Option<DataSourceV2Relation> rightRel = this.getGitbaseRelation(j.right());
                            if (leftRel.isEmpty() || rightRel.isEmpty() || !this.isJoinSupported(j)) break block4;
                            Set<Attribute> unsupportedConditions = this.getUnsupportedConditions(j, (DataSourceV2Relation)leftRel.get(), (DataSourceV2Relation)rightRel.get());
                            if (unsupportedConditions.nonEmpty()) {
                                this.tech$sourced$gitbase$spark$rule$JoinOptimizer$$logUnableToOptimize(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Obtained unsupported conditions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unsupportedConditions})));
                                return new JoinData(JoinData$.MODULE$.apply$default$1(), JoinData$.MODULE$.apply$default$2(), JoinData$.MODULE$.apply$default$3(), JoinData$.MODULE$.apply$default$4(), JoinData$.MODULE$.apply$default$5(), JoinData$.MODULE$.apply$default$6(), JoinData$.MODULE$.apply$default$7());
                            }
                            option = j.condition();
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            Expression cond = (Expression)some.x();
                            if (!this.tech$sourced$gitbase$spark$rule$JoinOptimizer$$conditionsAllowPushdown(cond, tables = this.getRelationTables((DataSourceV2Relation)leftRel.get(), (DataSourceV2Relation)rightRel.get()))) break block6;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        this.tech$sourced$gitbase$spark$rule$JoinOptimizer$$logUnableToOptimize("Join conditions are not restricted by repository_id");
                        return new JoinData(JoinData$.MODULE$.apply$default$1(), JoinData$.MODULE$.apply$default$2(), JoinData$.MODULE$.apply$default$3(), JoinData$.MODULE$.apply$default$4(), JoinData$.MODULE$.apply$default$5(), JoinData$.MODULE$.apply$default$6(), JoinData$.MODULE$.apply$default$7());
                    }
                    if (!None$.MODULE$.equals(option)) break block8;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                JoinData left = this.getLeafJoinData(j.left());
                JoinData right = this.getLeafJoinData(j.right());
                JoinData[] joinDataArray = new JoinData[3];
                boolean x$12 = true;
                Option x$13 = j.condition();
                Option<Node> x$14 = JoinData$.MODULE$.apply$default$1();
                Option<Expression> x$15 = JoinData$.MODULE$.apply$default$3();
                Seq<NamedExpression> x$16 = JoinData$.MODULE$.apply$default$4();
                Seq<AttributeReference> x$17 = JoinData$.MODULE$.apply$default$5();
                Seq<GitbaseServer> x$18 = JoinData$.MODULE$.apply$default$6();
                joinDataArray[0] = new JoinData(x$14, (Option<Expression>)x$13, x$15, x$16, x$17, x$18, x$12);
                joinDataArray[1] = left;
                joinDataArray[2] = right;
                return this.mergeJoinData((Seq<JoinData>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])joinDataArray))));
            }
            throw new MatchError((Object)option);
        }
        this.tech$sourced$gitbase$spark$rule$JoinOptimizer$$logUnableToOptimize("It doesn't have gitbase relations in both sides, or the Join type is not supported.");
        return new JoinData(JoinData$.MODULE$.apply$default$1(), JoinData$.MODULE$.apply$default$2(), JoinData$.MODULE$.apply$default$3(), JoinData$.MODULE$.apply$default$4(), JoinData$.MODULE$.apply$default$5(), JoinData$.MODULE$.apply$default$6(), JoinData$.MODULE$.apply$default$7());
    }

    private JoinData getLeafJoinData(LogicalPlan p) {
        ObjectRef filter = ObjectRef.create((Object)None$.MODULE$);
        BooleanRef valid = BooleanRef.create((boolean)true);
        ObjectRef project = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ObjectRef source = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef attributes = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ObjectRef servers = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        p.map((Function1)new Serializable(filter, valid, project, source, attributes, servers){
            public static final long serialVersionUID = 0L;
            private final ObjectRef filter$1;
            private final BooleanRef valid$1;
            private final ObjectRef project$1;
            private final ObjectRef source$1;
            private final ObjectRef attributes$1;
            private final ObjectRef servers$1;

            /*
             * Enabled aggressive block sorting
             */
            public final void apply(LogicalPlan x0$1) {
                LogicalPlan logicalPlan = x0$1;
                if (logicalPlan instanceof org.apache.spark.sql.catalyst.plans.logical.Join) {
                    org.apache.spark.sql.catalyst.plans.logical.Join join = (org.apache.spark.sql.catalyst.plans.logical.Join)logicalPlan;
                    JoinOptimizer$.MODULE$.tech$sourced$gitbase$spark$rule$JoinOptimizer$$logUnableToOptimize(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid node: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{join})));
                    this.valid$1.elem = false;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (logicalPlan instanceof Filter) {
                    Filter filter = (Filter)logicalPlan;
                    Expression cond = filter.condition();
                    this.filter$1.elem = new Some((Object)cond);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (logicalPlan instanceof Project) {
                    Project project = (Project)logicalPlan;
                    Seq namedExpressions = project.projectList();
                    this.project$1.elem = namedExpressions;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (logicalPlan instanceof DataSourceV2Relation) {
                    DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)logicalPlan;
                    Seq out = dataSourceV2Relation.output();
                    DataSourceReader dataSourceReader = dataSourceV2Relation.reader();
                    if (dataSourceReader instanceof DefaultReader) {
                        DefaultReader defaultReader = (DefaultReader)dataSourceReader;
                        Seq<GitbaseServer> srvs = defaultReader.servers();
                        Node src = defaultReader.node();
                        this.source$1.elem = new Some((Object)src);
                        if (((Seq)this.project$1.elem).isEmpty()) {
                            this.project$1.elem = out;
                        }
                        this.attributes$1.elem = out;
                        this.servers$1.elem = srvs;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                JoinOptimizer$.MODULE$.tech$sourced$gitbase$spark$rule$JoinOptimizer$$logUnableToOptimize(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid node: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logicalPlan})));
                this.valid$1.elem = false;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.filter$1 = filter$1;
                this.valid$1 = valid$1;
                this.project$1 = project$1;
                this.source$1 = source$1;
                this.attributes$1 = attributes$1;
                this.servers$1 = servers$1;
            }
        });
        return new JoinData((Option<Node>)((Option)source.elem), (Option<Expression>)None$.MODULE$, (Option<Expression>)((Option)filter.elem), (Seq<NamedExpression>)((Seq)project.elem), (Seq<AttributeReference>)((Seq)attributes.elem), (Seq<GitbaseServer>)((Seq)servers.elem), valid.elem);
    }

    private Seq<String> getRelationTables(DataSourceV2Relation left, DataSourceV2Relation right) {
        Node leftSource = ((DefaultReader)left.reader()).node();
        Node rightSource = ((DefaultReader)right.reader()).node();
        return (Seq)((SeqLike)this.getSourceTables(leftSource).$plus$plus(this.getSourceTables(rightSource), Seq$.MODULE$.canBuildFrom())).distinct();
    }

    private Seq<String> getSourceTables(Node s) {
        Seq seq;
        Node node = s;
        if (node instanceof Table) {
            Table table = (Table)node;
            String t = table.name();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}));
        } else if (node instanceof Join) {
            Join join = (Join)node;
            Node left = join.left();
            Node right = join.right();
            seq = (Seq)((SeqLike)this.getSourceTables(left).$plus$plus(this.getSourceTables(right), Seq$.MODULE$.canBuildFrom())).distinct();
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        return seq;
    }

    public boolean tech$sourced$gitbase$spark$rule$JoinOptimizer$$conditionsAllowPushdown(Expression expression, Seq<String> tables) {
        return expression.find((Function1)new Serializable(tables){
            public static final long serialVersionUID = 0L;
            private final Seq tables$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Expression x0$2) {
                Expression expression = x0$2;
                if (expression instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)expression;
                    Expression left = equalTo.left();
                    Expression right = equalTo.right();
                    if (left instanceof Attribute) {
                        Attribute attribute = (Attribute)left;
                        if (right instanceof Attribute) {
                            Attribute attribute2 = (Attribute)right;
                            String leftSource = attribute.metadata().getString(Sources$.MODULE$.SourceKey());
                            String rightSource = attribute2.metadata().getString(Sources$.MODULE$.SourceKey());
                            String string = attribute.name();
                            String string2 = "repository_id";
                            if (string == null) {
                                if (string2 != null) {
                                    return false;
                                }
                            } else if (!string.equals(string2)) return false;
                            String string3 = attribute2.name();
                            String string4 = "repository_id";
                            if (string3 == null) {
                                if (string4 != null) {
                                    return false;
                                }
                            } else if (!string3.equals(string4)) return false;
                            if (!this.tables$1.contains((Object)leftSource)) return false;
                            if (!this.tables$1.contains((Object)rightSource)) return false;
                            String string5 = leftSource;
                            String string6 = rightSource;
                            if (string5 == null) {
                                if (string6 == null) return false;
                                return true;
                            } else if (string5.equals(string6)) return false;
                            return true;
                        }
                    }
                }
                if (!(expression instanceof And)) return false;
                And and = (And)expression;
                Expression left = and.left();
                Expression right = and.right();
                if (JoinOptimizer$.MODULE$.tech$sourced$gitbase$spark$rule$JoinOptimizer$$conditionsAllowPushdown(left, (Seq<String>)this.tables$1)) return true;
                if (!JoinOptimizer$.MODULE$.tech$sourced$gitbase$spark$rule$JoinOptimizer$$conditionsAllowPushdown(right, (Seq<String>)this.tables$1)) return false;
                return true;
            }
            {
                this.tables$1 = tables$1;
            }
        }).isDefined();
    }

    private JoinData mergeJoinData(Seq<JoinData> data) {
        JoinData d = (JoinData)data.reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Unable to fully structure code
             */
            public final JoinData apply(JoinData jd1, JoinData jd2) {
                block3: {
                    block4: {
                        block2: {
                            filters = JoinOptimizer$.MODULE$.mixExpressions(jd1.filter(), jd2.filter(), (Function2<Expression, Expression, Expression>)And$.MODULE$);
                            conditions = JoinOptimizer$.MODULE$.mixExpressions(jd1.conditions(), jd2.conditions(), (Function2<Expression, Expression, Expression>)And$.MODULE$);
                            var6_5 = new Tuple2(jd1.source(), jd2.source());
                            if (var6_5 == null) break block2;
                            var7_6 = (Option)var6_5._1();
                            var8_7 = (Option)var6_5._2();
                            if (!(var7_6 instanceof Some)) break block2;
                            var9_8 = (Some)var7_6;
                            s1 = (Node)var9_8.x();
                            if (!(var8_7 instanceof Some)) break block2;
                            var11_10 = (Some)var8_7;
                            s2 = (Node)var11_10.x();
                            var13_12 = new Some((Object)new Join(s1, s2, conditions));
                            break block3;
                        }
                        if (var6_5 == null) break block4;
                        var14_13 = (Option)var6_5._1();
                        var15_14 = (Option)var6_5._2();
                        if (!(var14_13 instanceof Some)) break block4;
                        var16_15 = (Some)var14_13;
                        s1 = (Node)var16_15.x();
                        if (!None$.MODULE$.equals(var15_14)) break block4;
                        var13_12 = new Some((Object)s1);
                        break block3;
                    }
                    if (var6_5 == null) ** GOTO lbl-1000
                    var18_17 = (Option)var6_5._1();
                    var19_18 = (Option)var6_5._2();
                    if (None$.MODULE$.equals(var18_17) && var19_18 instanceof Some) {
                        var20_19 = (Some)var19_18;
                        s1 = (Node)var20_19.x();
                        var13_12 = new Some((Object)s1);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var13_12 = None$.MODULE$;
                    }
                }
                source = var13_12;
                return new JoinData((Option<Node>)source, conditions, filters, (Seq<NamedExpression>)((Seq)jd1.project().$plus$plus(jd2.project(), Seq$.MODULE$.canBuildFrom())), (Seq<AttributeReference>)((Seq)jd1.attributes().$plus$plus(jd2.attributes(), Seq$.MODULE$.canBuildFrom())), (Seq<GitbaseServer>)((Seq)((SeqLike)jd1.servers().$plus$plus(jd2.servers(), Seq$.MODULE$.canBuildFrom())).distinct()), jd1.valid() != false && jd2.valid() != false);
            }
        });
        return d.source().isEmpty() ? new JoinData(JoinData$.MODULE$.apply$default$1(), JoinData$.MODULE$.apply$default$2(), JoinData$.MODULE$.apply$default$3(), JoinData$.MODULE$.apply$default$4(), JoinData$.MODULE$.apply$default$5(), JoinData$.MODULE$.apply$default$6(), JoinData$.MODULE$.apply$default$7()) : d;
    }

    private Seq<JoinType> supportedJoinTypes() {
        return this.supportedJoinTypes;
    }

    public boolean isJoinSupported(org.apache.spark.sql.catalyst.plans.logical.Join j) {
        return this.supportedJoinTypes().contains((Object)j.joinType());
    }

    public Set<Attribute> getUnsupportedConditions(org.apache.spark.sql.catalyst.plans.logical.Join join, DataSourceV2Relation left, DataSourceV2Relation right) {
        Set leftReferences = left.references().baseSet();
        Set rightReferences = right.references().baseSet();
        Set joinReferences = join.references().baseSet();
        return (Set)((SetLike)joinReferences.$minus$minus((GenTraversableOnce)leftReferences).$minus$minus((GenTraversableOnce)rightReferences)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Attribute apply(AttributeEquals x$3) {
                return x$3.a();
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    public Option<Expression> mixExpressions(Option<Expression> l, Option<Expression> r, Function2<Expression, Expression, Expression> joinFunction) {
        Tuple2 tuple2;
        block6: {
            Option option;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            tuple2 = new Tuple2(l, r);
                            if (tuple2 == null) break block2;
                            Option option2 = (Option)tuple2._1();
                            Option option3 = (Option)tuple2._2();
                            if (!(option2 instanceof Some)) break block2;
                            Some some = (Some)option2;
                            Expression expr1 = (Expression)some.x();
                            if (!(option3 instanceof Some)) break block2;
                            Some some2 = (Some)option3;
                            Expression expr2 = (Expression)some2.x();
                            option = new Some(joinFunction.apply((Object)expr1, (Object)expr2));
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        Option option4 = (Option)tuple2._1();
                        Option option5 = (Option)tuple2._2();
                        if (!None$.MODULE$.equals(option4) || !None$.MODULE$.equals(option5)) break block4;
                        option = None$.MODULE$;
                        break block3;
                    }
                    if (tuple2 == null) break block5;
                    Option le = (Option)tuple2._1();
                    Option option6 = (Option)tuple2._2();
                    if (!None$.MODULE$.equals(option6)) break block5;
                    option = le;
                    break block3;
                }
                if (tuple2 == null) break block6;
                Option option7 = (Option)tuple2._1();
                Option re = (Option)tuple2._2();
                if (!None$.MODULE$.equals(option7)) break block6;
                option = re;
            }
            return option;
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<DataSourceV2Relation> getGitbaseRelation(LogicalPlan lp) {
        return lp.find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogicalPlan x0$3) {
                DataSourceV2Relation dataSourceV2Relation;
                LogicalPlan logicalPlan = x0$3;
                boolean bl = logicalPlan instanceof DataSourceV2Relation && (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan).reader() instanceof DefaultReader;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataSourceV2Relation apply(LogicalPlan x$4) {
                return (DataSourceV2Relation)x$4;
            }
        });
    }

    public void tech$sourced$gitbase$spark$rule$JoinOptimizer$$logUnableToOptimize(String msg) {
        this.logError((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("*")).$times(80);
            }
        });
        this.logError((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "* This Join could not be optimized. This might severely impact the performance *";
            }
        });
        this.logError((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "* of your query. This happened because there is an unexpected node between the *";
            }
        });
        this.logError((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "* two relations of a Join, such as Limit or another kind of unknown relation.  *";
            }
        });
        this.logError((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "* Note that this will not stop your query or make it fail, only make it slow.  *";
            }
        });
        this.logError((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("*")).$times(80);
            }
        });
        if (new StringOps(Predef$.MODULE$.augmentString(msg)).nonEmpty()) {
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"* Reason:", "*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(" ")).$times(70)}));
                }
            });
            new StringOps(Predef$.MODULE$.augmentString(msg)).lines().flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<String> apply(String str) {
                    return JoinOptimizer$.MODULE$.tech$sourced$gitbase$spark$rule$JoinOptimizer$$split$1(str);
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String line) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"* ", "", " *"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line, new StringOps(Predef$.MODULE$.augmentString(" ")).$times(76 - line.length())}));
                }
            }).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(String x$5) {
                    JoinOptimizer$.MODULE$.logError((Function0<String>)new Serializable(this, x$5){
                        public static final long serialVersionUID = 0L;
                        private final String x$5$1;

                        public final String apply() {
                            return this.x$5$1;
                        }
                        {
                            this.x$5$1 = x$5$1;
                        }
                    });
                }
            });
            this.logError((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("*")).$times(80);
                }
            });
        }
    }

    private String logUnableToOptimize$default$1() {
        return "";
    }

    public final Seq tech$sourced$gitbase$spark$rule$JoinOptimizer$$split$1(String str) {
        return str.length() > 76 ? (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{str.substring(0, 76)}))).$plus$plus((GenTraversableOnce)this.tech$sourced$gitbase$spark$rule$JoinOptimizer$$split$1(str.substring(76)), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{str}));
    }

    private JoinOptimizer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        Inner$ inner$ = Inner$.MODULE$;
        this.supportedJoinTypes = Nil$.MODULE$.$colon$colon((Object)inner$);
    }
}

