/*
 * Decompiled with CFR 0.152.
 */
package tech.sourced.gitbase.spark.udf;

import gopkg.in.bblfsh.sdk.v1.protocol.generated.DriverManifest;
import gopkg.in.bblfsh.sdk.v1.uast.generated.Node;
import gopkg.in.bblfsh.sdk.v1.uast.generated.Node$;
import java.nio.ByteBuffer;
import org.apache.spark.internal.Logging;
import org.bblfsh.client.BblfshClient;
import org.bblfsh.client.BblfshClient$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import tech.sourced.gitbase.spark.udf.package$;

public final class BblfshUtils$
implements Logging {
    public static final BblfshUtils$ MODULE$;
    private final String hostKey;
    private final String portKey;
    private final String defaultHost;
    private final int defaultPort;
    private BblfshClient client;
    private Seq<String> supportedLanguages;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new BblfshUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public String hostKey() {
        return this.hostKey;
    }

    public String portKey() {
        return this.portKey;
    }

    public String defaultHost() {
        return this.defaultHost;
    }

    public int defaultPort() {
        return this.defaultPort;
    }

    private BblfshClient client() {
        return this.client;
    }

    private void client_$eq(BblfshClient x$1) {
        this.client = x$1;
    }

    private Seq<String> supportedLanguages() {
        return this.supportedLanguages;
    }

    private void supportedLanguages_$eq(Seq<String> x$1) {
        this.supportedLanguages = x$1;
    }

    public synchronized BblfshClient getClient() {
        block4: {
            int n;
            if (this.client() != null) break block4;
            String host = package$.MODULE$.spark().conf().get(this.hostKey(), this.defaultHost());
            Try try_ = Try$.MODULE$.apply((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return new StringOps(Predef$.MODULE$.augmentString(package$.MODULE$.spark().conf().get(BblfshUtils$.MODULE$.portKey(), ((Object)BoxesRunTime.boxToInteger((int)BblfshUtils$.MODULE$.defaultPort())).toString()))).toInt();
                }
            });
            if (try_ instanceof Success) {
                int p;
                Success success = (Success)try_;
                n = p = BoxesRunTime.unboxToInt((Object)success.value());
            } else {
                if (!(try_ instanceof Failure)) {
                    throw new MatchError((Object)try_);
                }
                this.log().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"couldn't get value for config key ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.portKey()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default value ", " will be used"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.defaultPort())}))).toString());
                n = this.defaultPort();
            }
            int port = n;
            this.client_$eq(BblfshClient$.MODULE$.apply(host, port, BblfshClient$.MODULE$.apply$default$3()));
        }
        return this.client();
    }

    public boolean isSupportedLanguage(String lang) {
        if (this.supportedLanguages() == null) {
            this.supportedLanguages_$eq((Seq<String>)((Seq)this.getClient().supportedLanguages().languages().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(DriverManifest x$1) {
                    return x$1.language().toLowerCase();
                }
            }, Seq$.MODULE$.canBuildFrom())));
        }
        return this.supportedLanguages().contains((Object)lang.toLowerCase());
    }

    public Option<byte[]> marshalNodes(Seq<Node> nodes) {
        None$ none$;
        if (nodes == null || nodes.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            Seq serialized = (Seq)((TraversableLike)nodes.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Node x$2) {
                    return x$2 != null;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(Node x$3) {
                    return x$3.toByteArray();
                }
            }, Seq$.MODULE$.canBuildFrom());
            int size = BoxesRunTime.unboxToInt((Object)serialized.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(int sum, byte[] sn) {
                    return sum + sn.length;
                }
            })) + 4 * serialized.length();
            byte[] result = new byte[size];
            ByteBuffer buffer = ByteBuffer.wrap(result);
            serialized.foreach((Function1)new Serializable(buffer){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buffer$1;

                public final ByteBuffer apply(byte[] sn) {
                    return this.buffer$1.putInt(sn.length).put(sn);
                }
                {
                    this.buffer$1 = buffer$1;
                }
            });
            none$ = new Some((Object)result);
        }
        return none$;
    }

    public Option<Seq<Node>> unmarshalNodes(byte[] blob) {
        None$ none$;
        if (blob == null || Predef$.MODULE$.byteArrayOps(blob).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ArrayBuffer nodes = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ByteBuffer buffer = ByteBuffer.wrap(blob);
            while (buffer.hasRemaining()) {
                int size = buffer.getInt();
                byte[] sn = new byte[size];
                buffer.get(sn);
                Node node = (Node)Node$.MODULE$.parseFrom(sn);
                nodes.$plus$eq((Object)node);
            }
            none$ = new Some((Object)nodes.toList());
        }
        return none$;
    }

    private BblfshUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.hostKey = "spark.tech.sourced.bblfsh.grpc.host";
        this.portKey = "spark.tech.sourced.bblfsh.grpc.port";
        this.defaultHost = "0.0.0.0";
        this.defaultPort = 9432;
    }
}

