/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.text.NumberFormat;
import java.time.ZoneOffset;
import java.util.function.DoublePredicate;
import org.apache.commons.math3.stat.correlation.KendallsCorrelation;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import tech.tablesaw.aggregate.AggregateFunctions;
import tech.tablesaw.aggregate.NumericAggregateFunction;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.numbers.DoubleIterable;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.columns.numbers.NumberFillers;
import tech.tablesaw.columns.numbers.NumberFilters;
import tech.tablesaw.columns.numbers.NumberMapFunctions;
import tech.tablesaw.columns.numbers.NumberPredicates;
import tech.tablesaw.columns.numbers.Stats;
import tech.tablesaw.filtering.predicates.DoubleBiPredicate;
import tech.tablesaw.filtering.predicates.DoubleRangePredicate;
import tech.tablesaw.selection.Selection;

public interface NumberColumn
extends NumberMapFunctions,
DoubleIterable,
NumberFilters,
NumberFillers<NumberColumn>,
CategoricalColumn<Double> {
    public static final double MISSING_VALUE = (Double)ColumnType.DOUBLE.getMissingValue();

    public static boolean valueIsMissing(double value) {
        return Double.isNaN(value);
    }

    @Override
    public boolean isMissing(int var1);

    public void setPrintFormatter(NumberFormat var1, String var2);

    public void setPrintFormatter(NumberColumnFormatter var1);

    @Override
    public int size();

    @Override
    public Table summary();

    public Stats stats();

    public DoubleArrayList top(int var1);

    public DoubleArrayList bottom(int var1);

    public NumberColumn unique();

    public double firstElement();

    public NumberColumn append(float var1);

    public NumberColumn append(double var1);

    public NumberColumn append(int var1);

    @Override
    public String getString(int var1);

    @Override
    public double getDouble(int var1);

    @Override
    public String getUnformattedString(int var1);

    public NumberColumn emptyCopy();

    public NumberColumn emptyCopy(int var1);

    public NumberColumn copy();

    @Override
    public void clear();

    @Override
    public void sortAscending();

    @Override
    public void sortDescending();

    @Override
    public boolean isEmpty();

    public NumberColumn appendCell(String var1);

    public Integer roundInt(int var1);

    public long getLong(int var1);

    default public Double summarizeIf(Selection selection, NumericAggregateFunction function) {
        NumberColumn column = this.where(selection);
        return (Double)function.summarize(column);
    }

    @Override
    public IntComparator rowComparator();

    public NumberColumn set(int var1, double var2);

    public NumberColumn set(Selection var1, double var2);

    @Override
    public double[] asDoubleArray();

    public NumberColumn where(Selection var1);

    @Override
    public Selection eval(DoublePredicate var1);

    @Override
    public Selection eval(DoubleBiPredicate var1, NumberColumn var2);

    @Override
    public Selection eval(DoubleBiPredicate var1, Number var2);

    @Override
    public Selection eval(DoubleRangePredicate var1, Number var2, Number var3);

    @Override
    public Selection isIn(Number ... var1);

    @Override
    public Selection isNotIn(Number ... var1);

    public DoubleSet asSet();

    public boolean contains(double var1);

    @Override
    public int byteSize();

    @Override
    public byte[] asBytes(int var1);

    @Override
    public int[] asIntArray();

    @Override
    public DoubleList dataInternal();

    public NumberColumn appendMissing();

    @Override
    default public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!NumberColumn.valueIsMissing(this.getDouble(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    default public double sum() {
        return (Double)AggregateFunctions.sum.summarize(this);
    }

    default public double product() {
        return (Double)AggregateFunctions.product.summarize(this);
    }

    default public double mean() {
        return (Double)AggregateFunctions.mean.summarize(this);
    }

    default public double median() {
        return (Double)AggregateFunctions.median.summarize(this);
    }

    default public double quartile1() {
        return (Double)AggregateFunctions.quartile1.summarize(this);
    }

    default public double quartile3() {
        return (Double)AggregateFunctions.quartile3.summarize(this);
    }

    default public double percentile(double percentile) {
        return AggregateFunctions.percentile(this, percentile);
    }

    default public double range() {
        return (Double)AggregateFunctions.range.summarize(this);
    }

    default public double max() {
        return (Double)AggregateFunctions.max.summarize(this);
    }

    default public double min() {
        return (Double)AggregateFunctions.min.summarize(this);
    }

    default public double variance() {
        return (Double)AggregateFunctions.variance.summarize(this);
    }

    default public double populationVariance() {
        return (Double)AggregateFunctions.populationVariance.summarize(this);
    }

    default public double standardDeviation() {
        return (Double)AggregateFunctions.stdDev.summarize(this);
    }

    default public double sumOfLogs() {
        return (Double)AggregateFunctions.sumOfLogs.summarize(this);
    }

    default public double sumOfSquares() {
        return (Double)AggregateFunctions.sumOfSquares.summarize(this);
    }

    default public double geometricMean() {
        return (Double)AggregateFunctions.geometricMean.summarize(this);
    }

    default public double quadraticMean() {
        return (Double)AggregateFunctions.quadraticMean.summarize(this);
    }

    default public double kurtosis() {
        return (Double)AggregateFunctions.kurtosis.summarize(this);
    }

    default public double skewness() {
        return (Double)AggregateFunctions.skewness.summarize(this);
    }

    public DateTimeColumn asDateTimes(ZoneOffset var1);

    default public double pearsons(NumberColumn otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new PearsonsCorrelation().correlation(x, y);
    }

    default public double spearmans(NumberColumn otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new SpearmansCorrelation().correlation(x, y);
    }

    default public double kendalls(NumberColumn otherColumn) {
        double[] x = this.asDoubleArray();
        double[] y = otherColumn.asDoubleArray();
        return new KendallsCorrelation().correlation(x, y);
    }

    @Override
    default public int countUnique() {
        DoubleOpenHashSet doubles = new DoubleOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (NumberColumn.valueIsMissing(this.getDouble(i))) continue;
            doubles.add(this.getDouble(i));
        }
        return doubles.size();
    }

    @Override
    default public Selection isMissing() {
        return this.eval(NumberPredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(NumberPredicates.isNotMissing);
    }
}

