/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.html;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.TableBuildingUtils;

public class HtmlTableReader {
    public Table read(String url) throws IOException {
        Document doc = Jsoup.connect(url).get();
        Elements tables = doc.select("table");
        if (tables.size() != 1) {
            throw new IllegalStateException("Reading html to table currently works if there is exactly 1 html table on the page.  The URL you passed has " + tables.size() + ". You may file a feature request with the URL if you'd like your pagae to be supported");
        }
        Element htmlTable = (Element)tables.get(0);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (Element row : htmlTable.select("tr")) {
            Elements headerCells = row.getElementsByTag("th");
            Elements cells = row.getElementsByTag("td");
            String[] nextLine = (String[])Stream.concat(headerCells.stream(), cells.stream()).map(Element::text).toArray(String[]::new);
            rows.add(nextLine);
        }
        Table table = Table.create((String)url);
        if (rows.size() == 0) {
            return table;
        }
        ReadOptions options = ReadOptions.builder((Reader)new StringReader(""), (String)url).build();
        String[] headerRow = (String[])rows.get(0);
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < headerRow.length; ++i) {
            columnNames.add(headerRow[i]);
        }
        return TableBuildingUtils.build(columnNames, rows, (ReadOptions)options);
    }
}

