/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.change;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import liquibase.change.ColumnConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.core.InsertDataChange;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

@DatabaseChange(name="insert", description="Inserts data into an existing table", priority=5, appliesTo={"table"})
public class InsertDataChangeYdb
extends InsertDataChange {
    public SqlStatement[] generateStatements(Database database) {
        HashMap<String, LiquibaseDataType> columnToLiquibaseDataType = new HashMap<String, LiquibaseDataType>();
        try {
            JdbcConnection jdbcConnection = (JdbcConnection)database.getConnection();
            ResultSet resultSet = jdbcConnection.getMetaData().getColumns(null, null, this.getTableName(), null);
            while (resultSet.next()) {
                columnToLiquibaseDataType.put(resultSet.getString("COLUMN_NAME").toLowerCase(), DataTypeFactory.getInstance().fromDescription(resultSet.getString("TYPE_NAME"), database));
            }
            StringBuilder yqlInsert = new StringBuilder().append("INSERT INTO ").append(database.escapeTableName(this.getCatalogName(), this.getSchemaName(), this.getTableName())).append(" (");
            Iterator columnConfigIterator = this.getColumns().iterator();
            ArrayList<String> sqlValues = new ArrayList<String>();
            while (columnConfigIterator.hasNext()) {
                ColumnConfig columnConfig = (ColumnConfig)columnConfigIterator.next();
                yqlInsert.append(columnConfig.getName());
                if (columnConfigIterator.hasNext()) {
                    yqlInsert.append(", ");
                }
                sqlValues.add(columnToLiquibaseDataType.getOrDefault(columnConfig.getName(), DataTypeFactory.getInstance().fromDescription("text", database)).objectToSql(columnConfig.getValueObject(), database));
            }
            yqlInsert.append(") VALUES (");
            Iterator sqlValueIterator = sqlValues.iterator();
            while (sqlValueIterator.hasNext()) {
                yqlInsert.append((String)sqlValueIterator.next());
                if (!sqlValueIterator.hasNext()) continue;
                yqlInsert.append(", ");
            }
            yqlInsert.append(")");
            return new SqlStatement[]{new RawSqlStatement(yqlInsert.toString())};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

