/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.database;

import java.sql.Date;
import java.sql.Timestamp;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;

public class YdbDatabase
extends AbstractJdbcDatabase {
    private static final String DATABASE_PRODUCT_NAME = "YDB";
    private static final String DATABASE_QUOTING_CHARACTER = "`";
    private static final int DATABASE_DEFAULT_PORT = 2136;
    private static final String DRIVER_NAME = "tech.ydb.jdbc.YdbDriver";

    public YdbDatabase() {
        super.setCurrentDateTimeFunction("CurrentUtcDatetime()");
    }

    protected String getDefaultDatabaseProductName() {
        return DATABASE_PRODUCT_NAME;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection databaseConnection) throws DatabaseException {
        return DATABASE_PRODUCT_NAME.equalsIgnoreCase(databaseConnection.getDatabaseProductName());
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:ydb")) {
            return DRIVER_NAME;
        }
        return null;
    }

    public String getShortName() {
        return DATABASE_PRODUCT_NAME.toLowerCase();
    }

    public Integer getDefaultPort() {
        return 2136;
    }

    public int getPriority() {
        return 5;
    }

    public String escapeStringForDatabase(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("\\", "\\\\").replace("'", "\\'");
    }

    public boolean requiresUsername() {
        return false;
    }

    public String getDateLiteral(Date date) {
        return "DATE(" + super.getDateLiteral(date) + ")";
    }

    public String getDateTimeLiteral(Timestamp date) {
        return "CAST(" + date.toInstant().getEpochSecond() + " AS DATETIME)";
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public boolean requiresPassword() {
        return false;
    }

    protected String getQuotingStartCharacter() {
        return DATABASE_QUOTING_CHARACTER;
    }

    protected String getQuotingEndCharacter() {
        return DATABASE_QUOTING_CHARACTER;
    }

    public boolean supportsCatalogs() {
        return false;
    }

    public boolean supportsSchemas() {
        return false;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsForeignKeyDisable() {
        return true;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsAutoIncrement() {
        return false;
    }

    public boolean supportsDDLInTransaction() {
        return false;
    }

    public boolean supportsPrimaryKeyNames() {
        return false;
    }
}

