/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.lockservice;

import java.util.concurrent.ThreadLocalRandom;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.exception.LockException;
import liquibase.lockservice.StandardLockService;

public class StandardLockServiceYdb
extends StandardLockService {
    private static final int RELEASE_MAX_ATTEMPT = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquireLock() throws LockException {
        boolean bl;
        boolean originalAutoCommit = this.database.getConnection().getAutoCommit();
        try {
            this.database.getConnection().setAutoCommit(false);
            bl = super.acquireLock();
        }
        catch (LockException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    this.database.getConnection().setAutoCommit(originalAutoCommit);
                    throw throwable;
                }
                catch (DatabaseException e2) {
                    throw new LockException((Throwable)e2);
                }
            }
            this.database.getConnection().setAutoCommit(originalAutoCommit);
            return bl2;
        }
        this.database.getConnection().setAutoCommit(originalAutoCommit);
        return bl;
    }

    public void releaseLock() throws LockException {
        for (int i = 0; i < 10; ++i) {
            try {
                super.releaseLock();
                return;
            }
            catch (LockException e) {
                if (i == 9) {
                    throw e;
                }
                Scope.getCurrentScope().getLog(StandardLockServiceYdb.class).info("Retry release lock!");
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextLong(1000L));
                    continue;
                }
                catch (InterruptedException exception) {
                    throw new LockException((Throwable)exception);
                }
            }
        }
    }
}

