/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.sqlgenerator;

import java.util.Iterator;
import java.util.Map;
import liquibase.database.Database;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.PrimaryKeyConstraint;
import liquibase.statement.core.CreateTableStatement;
import liquibase.structure.DatabaseObject;
import tech.ydb.liquibase.database.YdbDatabase;
import tech.ydb.liquibase.exception.YdbMessageException;

public class CreateTableGeneratorYdb
extends CreateTableGenerator {
    public boolean supports(CreateTableStatement statement, Database database) {
        return database instanceof YdbDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public Sql[] generateSql(CreateTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder yqlCreateTable = new StringBuilder();
        yqlCreateTable.append("CREATE TABLE ").append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName())).append(" (");
        Map nullConstraintMap = statement.getNotNullColumns();
        for (String columnName : statement.getColumns()) {
            DatabaseDataType columnType = ((LiquibaseDataType)statement.getColumnTypes().get(columnName)).toDatabaseDataType(database);
            yqlCreateTable.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), columnName)).append(" ").append(columnType);
            if (nullConstraintMap.containsKey(columnName)) {
                yqlCreateTable.append(" NOT NULL");
            }
            yqlCreateTable.append(", ");
        }
        yqlCreateTable.append("PRIMARY KEY (");
        PrimaryKeyConstraint primaryKeyConstraint = statement.getPrimaryKeyConstraint();
        Iterator columnNamesOfPrimaryKeyIterator = primaryKeyConstraint.getColumns().iterator();
        while (columnNamesOfPrimaryKeyIterator.hasNext()) {
            String columnName = (String)columnNamesOfPrimaryKeyIterator.next();
            yqlCreateTable.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), columnName));
            if (!columnNamesOfPrimaryKeyIterator.hasNext()) continue;
            yqlCreateTable.append(", ");
        }
        yqlCreateTable.append(") )");
        return new Sql[]{new UnparsedSql(yqlCreateTable.toString(), new DatabaseObject[]{this.getAffectedTable(statement)})};
    }

    public ValidationErrors validate(CreateTableStatement createTableStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors errors = super.validate(createTableStatement, database, sqlGeneratorChain);
        if (createTableStatement.getPrimaryKeyConstraint() == null) {
            errors.addError("Table YDB needs to have a PRIMARY KEY. " + YdbMessageException.badTableStrPointer(() -> ((CreateTableStatement)createTableStatement).getTableName()));
        } else if (createTableStatement.getPrimaryKeyConstraint().getConstraintName() != null) {
            errors.addWarning("YDB doesn't use PRIMARY KEY constraint name! " + YdbMessageException.badTableStrPointer(() -> ((CreateTableStatement)createTableStatement).getTableName()));
        }
        if (createTableStatement.getUniqueConstraints() != null && !createTableStatement.getUniqueConstraints().isEmpty()) {
            errors.addError("YDB doesn't support UNIQUE CONSTRAINT! " + YdbMessageException.badTableStrPointer(() -> ((CreateTableStatement)createTableStatement).getTableName()));
        }
        if (createTableStatement.getAutoIncrementConstraints() != null && !createTableStatement.getAutoIncrementConstraints().isEmpty()) {
            errors.addError("YDB doesn't support AUTO INCREMENT CONSTRAINT! " + YdbMessageException.badTableStrPointer(() -> ((CreateTableStatement)createTableStatement).getTableName()));
        }
        if (createTableStatement.getDefaultValues() != null && !createTableStatement.getDefaultValues().isEmpty()) {
            errors.addError("YDB doesn't support DEFAULT VALUE CONSTRAINT! " + YdbMessageException.badTableStrPointer(() -> ((CreateTableStatement)createTableStatement).getTableName()));
        }
        if (createTableStatement.getForeignKeyConstraints() != null && !createTableStatement.getForeignKeyConstraints().isEmpty()) {
            errors.addError("YDB doesn't support FOREIGN KEY CONSTRAINT! " + YdbMessageException.badTableStrPointer(() -> ((CreateTableStatement)createTableStatement).getTableName()));
        }
        return errors;
    }
}

