/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.liquibase.type;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import liquibase.database.Database;
import liquibase.datatype.DataTypeInfo;
import tech.ydb.liquibase.type.BaseTypeYdb;

@DataTypeInfo(name="Datetime", aliases={"time", "java.sql.Types.TIME", "java.sql.Time"}, minParameters=0, maxParameters=0, priority=5)
public class TimeTypeYdb
extends BaseTypeYdb {
    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || "null".equalsIgnoreCase(value.toString())) {
            return "NULL";
        }
        if (value instanceof Timestamp) {
            return database.getDateTimeLiteral((Timestamp)value);
        }
        return "DATETIME('" + LocalDateTime.parse(value.toString()).atZone(ZoneId.of("UTC")).format(DateTimeFormatter.ISO_INSTANT) + "')";
    }

    @Override
    protected String objectToSql(Object value) {
        return "";
    }
}

