// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: yandex/cloud/storage/v1/bucket.proto

package yandex.cloud.api.storage.v1;

public final class BucketOuterClass {
  private BucketOuterClass() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * Protobuf enum {@code yandex.cloud.storage.v1.Versioning}
   */
  public enum Versioning
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>VERSIONING_UNSPECIFIED = 0;</code>
     */
    VERSIONING_UNSPECIFIED(0),
    /**
     * <pre>
     * The bucket is unversioned, i.e. versioning has never been enabled for the bucket, including at its creation.
     * Objects that are stored in the bucket have a version ID of `null`.
     * To enable versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request. Note that this
     * action is irreversible, and a bucket with versioning enabled can never return to `VERSIONING_DISABLED` state.
     * </pre>
     *
     * <code>VERSIONING_DISABLED = 1;</code>
     */
    VERSIONING_DISABLED(1),
    /**
     * <pre>
     * Bucket versioning is enabled, i.e. all new objects are versioned and given a unique version ID, and objects that
     * already existed at the time versioning was enabled will be versioned and given a unique version ID when modified
     * by future requests.
     * To suspend versioning, change status to `VERSIONING_SUSPENDED` via a [BucketService.Update] request. You cannot
     * disable versioning altogether for a bucket that already had it enabled; objects that had version IDs will keep
     * them.
     * </pre>
     *
     * <code>VERSIONING_ENABLED = 2;</code>
     */
    VERSIONING_ENABLED(2),
    /**
     * <pre>
     * Bucket versioning is suspended, i.e. new objects are not versioned, but objects that already existed at the time
     * versioning was suspended are still versioned and keep their version IDs.
     * To resume versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request.
     * </pre>
     *
     * <code>VERSIONING_SUSPENDED = 3;</code>
     */
    VERSIONING_SUSPENDED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>VERSIONING_UNSPECIFIED = 0;</code>
     */
    public static final int VERSIONING_UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * The bucket is unversioned, i.e. versioning has never been enabled for the bucket, including at its creation.
     * Objects that are stored in the bucket have a version ID of `null`.
     * To enable versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request. Note that this
     * action is irreversible, and a bucket with versioning enabled can never return to `VERSIONING_DISABLED` state.
     * </pre>
     *
     * <code>VERSIONING_DISABLED = 1;</code>
     */
    public static final int VERSIONING_DISABLED_VALUE = 1;
    /**
     * <pre>
     * Bucket versioning is enabled, i.e. all new objects are versioned and given a unique version ID, and objects that
     * already existed at the time versioning was enabled will be versioned and given a unique version ID when modified
     * by future requests.
     * To suspend versioning, change status to `VERSIONING_SUSPENDED` via a [BucketService.Update] request. You cannot
     * disable versioning altogether for a bucket that already had it enabled; objects that had version IDs will keep
     * them.
     * </pre>
     *
     * <code>VERSIONING_ENABLED = 2;</code>
     */
    public static final int VERSIONING_ENABLED_VALUE = 2;
    /**
     * <pre>
     * Bucket versioning is suspended, i.e. new objects are not versioned, but objects that already existed at the time
     * versioning was suspended are still versioned and keep their version IDs.
     * To resume versioning, change status to `VERSIONING_ENABLED` via a [BucketService.Update] request.
     * </pre>
     *
     * <code>VERSIONING_SUSPENDED = 3;</code>
     */
    public static final int VERSIONING_SUSPENDED_VALUE = 3;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Versioning valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Versioning forNumber(int value) {
      switch (value) {
        case 0: return VERSIONING_UNSPECIFIED;
        case 1: return VERSIONING_DISABLED;
        case 2: return VERSIONING_ENABLED;
        case 3: return VERSIONING_SUSPENDED;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Versioning>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Versioning> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Versioning>() {
            public Versioning findValueByNumber(int number) {
              return Versioning.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.getDescriptor().getEnumTypes().get(0);
    }

    private static final Versioning[] VALUES = values();

    public static Versioning valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Versioning(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:yandex.cloud.storage.v1.Versioning)
  }

  public interface BucketOrBuilder extends
      // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.Bucket)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID of the bucket. Always equal to [name], which has priority.
     * </pre>
     *
     * <code>string id = 1;</code>
     * @return The id.
     */
    java.lang.String getId();
    /**
     * <pre>
     * ID of the bucket. Always equal to [name], which has priority.
     * </pre>
     *
     * <code>string id = 1;</code>
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Name of the bucket.
     * The name is unique within the platform. For naming limitations and rules, see
     * [documentation](/docs/storage/concepts/bucket#naming).
     * </pre>
     *
     * <code>string name = 2;</code>
     * @return The name.
     */
    java.lang.String getName();
    /**
     * <pre>
     * Name of the bucket.
     * The name is unique within the platform. For naming limitations and rules, see
     * [documentation](/docs/storage/concepts/bucket#naming).
     * </pre>
     *
     * <code>string name = 2;</code>
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * ID of the folder that the bucket belongs to.
     * </pre>
     *
     * <code>string folder_id = 3;</code>
     * @return The folderId.
     */
    java.lang.String getFolderId();
    /**
     * <pre>
     * ID of the folder that the bucket belongs to.
     * </pre>
     *
     * <code>string folder_id = 3;</code>
     * @return The bytes for folderId.
     */
    com.google.protobuf.ByteString
        getFolderIdBytes();

    /**
     * <pre>
     * Flags for configuring public (anonymous) access to the bucket's content and settings.
     * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
     * @return Whether the anonymousAccessFlags field is set.
     */
    boolean hasAnonymousAccessFlags();
    /**
     * <pre>
     * Flags for configuring public (anonymous) access to the bucket's content and settings.
     * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
     * @return The anonymousAccessFlags.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags getAnonymousAccessFlags();
    /**
     * <pre>
     * Flags for configuring public (anonymous) access to the bucket's content and settings.
     * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlagsOrBuilder getAnonymousAccessFlagsOrBuilder();

    /**
     * <pre>
     * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
     * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
     * For details, see [documentation](/docs/storage/concepts/storage-class).
     * </pre>
     *
     * <code>string default_storage_class = 5;</code>
     * @return The defaultStorageClass.
     */
    java.lang.String getDefaultStorageClass();
    /**
     * <pre>
     * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
     * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
     * For details, see [documentation](/docs/storage/concepts/storage-class).
     * </pre>
     *
     * <code>string default_storage_class = 5;</code>
     * @return The bytes for defaultStorageClass.
     */
    com.google.protobuf.ByteString
        getDefaultStorageClassBytes();

    /**
     * <pre>
     * Bucket versioning status.
     * For details, see [documentation](/docs/storage/concepts/versioning).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
     * @return The enum numeric value on the wire for versioning.
     */
    int getVersioningValue();
    /**
     * <pre>
     * Bucket versioning status.
     * For details, see [documentation](/docs/storage/concepts/versioning).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
     * @return The versioning.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.Versioning getVersioning();

    /**
     * <pre>
     * Maximum size of the bucket, in bytes.
     * For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
     * </pre>
     *
     * <code>int64 max_size = 7;</code>
     * @return The maxSize.
     */
    long getMaxSize();

    /**
     * <pre>
     * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
     * For details, see [documentation](/docs/storage/concepts/policy).
     * </pre>
     *
     * <code>.google.protobuf.Struct policy = 8;</code>
     * @return Whether the policy field is set.
     */
    boolean hasPolicy();
    /**
     * <pre>
     * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
     * For details, see [documentation](/docs/storage/concepts/policy).
     * </pre>
     *
     * <code>.google.protobuf.Struct policy = 8;</code>
     * @return The policy.
     */
    com.google.protobuf.Struct getPolicy();
    /**
     * <pre>
     * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
     * For details, see [documentation](/docs/storage/concepts/policy).
     * </pre>
     *
     * <code>.google.protobuf.Struct policy = 8;</code>
     */
    com.google.protobuf.StructOrBuilder getPolicyOrBuilder();

    /**
     * <pre>
     * Access control list (ACL) of the bucket.
     * For details, see [documentation](/docs/storage/concepts/acl).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
     * @return Whether the acl field is set.
     */
    boolean hasAcl();
    /**
     * <pre>
     * Access control list (ACL) of the bucket.
     * For details, see [documentation](/docs/storage/concepts/acl).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
     * @return The acl.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.ACL getAcl();
    /**
     * <pre>
     * Access control list (ACL) of the bucket.
     * For details, see [documentation](/docs/storage/concepts/acl).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.ACLOrBuilder getAclOrBuilder();

    /**
     * <pre>
     * Creation timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 10;</code>
     * @return Whether the createdAt field is set.
     */
    boolean hasCreatedAt();
    /**
     * <pre>
     * Creation timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 10;</code>
     * @return The createdAt.
     */
    com.google.protobuf.Timestamp getCreatedAt();
    /**
     * <pre>
     * Creation timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 10;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCreatedAtOrBuilder();

    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule> 
        getCorsList();
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule getCors(int index);
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    int getCorsCount();
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder> 
        getCorsOrBuilderList();
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder getCorsOrBuilder(
        int index);

    /**
     * <pre>
     * Configuration for hosting a static website in the bucket.
     * For details, see [documentation](/docs/storage/concepts/hosting).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
     * @return Whether the websiteSettings field is set.
     */
    boolean hasWebsiteSettings();
    /**
     * <pre>
     * Configuration for hosting a static website in the bucket.
     * For details, see [documentation](/docs/storage/concepts/hosting).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
     * @return The websiteSettings.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings getWebsiteSettings();
    /**
     * <pre>
     * Configuration for hosting a static website in the bucket.
     * For details, see [documentation](/docs/storage/concepts/hosting).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettingsOrBuilder getWebsiteSettingsOrBuilder();

    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule> 
        getLifecycleRulesList();
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule getLifecycleRules(int index);
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    int getLifecycleRulesCount();
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder> 
        getLifecycleRulesOrBuilderList();
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder getLifecycleRulesOrBuilder(
        int index);

    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.Tag> 
        getTagsList();
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.Tag getTags(int index);
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    int getTagsCount();
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder> 
        getTagsOrBuilderList();
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder getTagsOrBuilder(
        int index);

    /**
     * <pre>
     * Configuration for object lock on the bucket.
     * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
     * @return Whether the objectLock field is set.
     */
    boolean hasObjectLock();
    /**
     * <pre>
     * Configuration for object lock on the bucket.
     * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
     * @return The objectLock.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock getObjectLock();
    /**
     * <pre>
     * Configuration for object lock on the bucket.
     * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLockOrBuilder getObjectLockOrBuilder();

    /**
     * <pre>
     * Configuration for bucket's encryption
     * For detauls, see [documentation](/docs/storage/concepts/encryption)
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
     * @return Whether the encryption field is set.
     */
    boolean hasEncryption();
    /**
     * <pre>
     * Configuration for bucket's encryption
     * For detauls, see [documentation](/docs/storage/concepts/encryption)
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
     * @return The encryption.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.Encryption getEncryption();
    /**
     * <pre>
     * Configuration for bucket's encryption
     * For detauls, see [documentation](/docs/storage/concepts/encryption)
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.EncryptionOrBuilder getEncryptionOrBuilder();
  }
  /**
   * <pre>
   * A bucket resource.
   * For details about the concept, see [documentation](/docs/storage/concepts/bucket).
   * </pre>
   *
   * Protobuf type {@code yandex.cloud.storage.v1.Bucket}
   */
  public static final class Bucket extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.Bucket)
      BucketOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Bucket.newBuilder() to construct.
    private Bucket(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Bucket() {
      id_ = "";
      name_ = "";
      folderId_ = "";
      defaultStorageClass_ = "";
      versioning_ = 0;
      cors_ = java.util.Collections.emptyList();
      lifecycleRules_ = java.util.Collections.emptyList();
      tags_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Bucket();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Bucket(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              folderId_ = s;
              break;
            }
            case 34: {
              yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.Builder subBuilder = null;
              if (anonymousAccessFlags_ != null) {
                subBuilder = anonymousAccessFlags_.toBuilder();
              }
              anonymousAccessFlags_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(anonymousAccessFlags_);
                anonymousAccessFlags_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              defaultStorageClass_ = s;
              break;
            }
            case 48: {
              int rawValue = input.readEnum();

              versioning_ = rawValue;
              break;
            }
            case 56: {

              maxSize_ = input.readInt64();
              break;
            }
            case 66: {
              com.google.protobuf.Struct.Builder subBuilder = null;
              if (policy_ != null) {
                subBuilder = policy_.toBuilder();
              }
              policy_ = input.readMessage(com.google.protobuf.Struct.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(policy_);
                policy_ = subBuilder.buildPartial();
              }

              break;
            }
            case 74: {
              yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Builder subBuilder = null;
              if (acl_ != null) {
                subBuilder = acl_.toBuilder();
              }
              acl_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.ACL.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(acl_);
                acl_ = subBuilder.buildPartial();
              }

              break;
            }
            case 82: {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createdAt_ != null) {
                subBuilder = createdAt_.toBuilder();
              }
              createdAt_ = input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createdAt_);
                createdAt_ = subBuilder.buildPartial();
              }

              break;
            }
            case 90: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                cors_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule>();
                mutable_bitField0_ |= 0x00000001;
              }
              cors_.add(
                  input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.parser(), extensionRegistry));
              break;
            }
            case 98: {
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Builder subBuilder = null;
              if (websiteSettings_ != null) {
                subBuilder = websiteSettings_.toBuilder();
              }
              websiteSettings_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(websiteSettings_);
                websiteSettings_ = subBuilder.buildPartial();
              }

              break;
            }
            case 106: {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                lifecycleRules_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule>();
                mutable_bitField0_ |= 0x00000002;
              }
              lifecycleRules_.add(
                  input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.parser(), extensionRegistry));
              break;
            }
            case 114: {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                tags_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.Tag>();
                mutable_bitField0_ |= 0x00000004;
              }
              tags_.add(
                  input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.Tag.parser(), extensionRegistry));
              break;
            }
            case 122: {
              yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.Builder subBuilder = null;
              if (objectLock_ != null) {
                subBuilder = objectLock_.toBuilder();
              }
              objectLock_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(objectLock_);
                objectLock_ = subBuilder.buildPartial();
              }

              break;
            }
            case 130: {
              yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.Builder subBuilder = null;
              if (encryption_ != null) {
                subBuilder = encryption_.toBuilder();
              }
              encryption_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(encryption_);
                encryption_ = subBuilder.buildPartial();
              }

              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          cors_ = java.util.Collections.unmodifiableList(cors_);
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          lifecycleRules_ = java.util.Collections.unmodifiableList(lifecycleRules_);
        }
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          tags_ = java.util.Collections.unmodifiableList(tags_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Bucket_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Bucket_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              yandex.cloud.api.storage.v1.BucketOuterClass.Bucket.class, yandex.cloud.api.storage.v1.BucketOuterClass.Bucket.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * ID of the bucket. Always equal to [name], which has priority.
     * </pre>
     *
     * <code>string id = 1;</code>
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID of the bucket. Always equal to [name], which has priority.
     * </pre>
     *
     * <code>string id = 1;</code>
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     * Name of the bucket.
     * The name is unique within the platform. For naming limitations and rules, see
     * [documentation](/docs/storage/concepts/bucket#naming).
     * </pre>
     *
     * <code>string name = 2;</code>
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Name of the bucket.
     * The name is unique within the platform. For naming limitations and rules, see
     * [documentation](/docs/storage/concepts/bucket#naming).
     * </pre>
     *
     * <code>string name = 2;</code>
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FOLDER_ID_FIELD_NUMBER = 3;
    private volatile java.lang.Object folderId_;
    /**
     * <pre>
     * ID of the folder that the bucket belongs to.
     * </pre>
     *
     * <code>string folder_id = 3;</code>
     * @return The folderId.
     */
    @java.lang.Override
    public java.lang.String getFolderId() {
      java.lang.Object ref = folderId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        folderId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID of the folder that the bucket belongs to.
     * </pre>
     *
     * <code>string folder_id = 3;</code>
     * @return The bytes for folderId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getFolderIdBytes() {
      java.lang.Object ref = folderId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        folderId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANONYMOUS_ACCESS_FLAGS_FIELD_NUMBER = 4;
    private yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags anonymousAccessFlags_;
    /**
     * <pre>
     * Flags for configuring public (anonymous) access to the bucket's content and settings.
     * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
     * @return Whether the anonymousAccessFlags field is set.
     */
    @java.lang.Override
    public boolean hasAnonymousAccessFlags() {
      return anonymousAccessFlags_ != null;
    }
    /**
     * <pre>
     * Flags for configuring public (anonymous) access to the bucket's content and settings.
     * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
     * @return The anonymousAccessFlags.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags getAnonymousAccessFlags() {
      return anonymousAccessFlags_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.getDefaultInstance() : anonymousAccessFlags_;
    }
    /**
     * <pre>
     * Flags for configuring public (anonymous) access to the bucket's content and settings.
     * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlagsOrBuilder getAnonymousAccessFlagsOrBuilder() {
      return getAnonymousAccessFlags();
    }

    public static final int DEFAULT_STORAGE_CLASS_FIELD_NUMBER = 5;
    private volatile java.lang.Object defaultStorageClass_;
    /**
     * <pre>
     * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
     * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
     * For details, see [documentation](/docs/storage/concepts/storage-class).
     * </pre>
     *
     * <code>string default_storage_class = 5;</code>
     * @return The defaultStorageClass.
     */
    @java.lang.Override
    public java.lang.String getDefaultStorageClass() {
      java.lang.Object ref = defaultStorageClass_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultStorageClass_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
     * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
     * For details, see [documentation](/docs/storage/concepts/storage-class).
     * </pre>
     *
     * <code>string default_storage_class = 5;</code>
     * @return The bytes for defaultStorageClass.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getDefaultStorageClassBytes() {
      java.lang.Object ref = defaultStorageClass_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        defaultStorageClass_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSIONING_FIELD_NUMBER = 6;
    private int versioning_;
    /**
     * <pre>
     * Bucket versioning status.
     * For details, see [documentation](/docs/storage/concepts/versioning).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
     * @return The enum numeric value on the wire for versioning.
     */
    @java.lang.Override public int getVersioningValue() {
      return versioning_;
    }
    /**
     * <pre>
     * Bucket versioning status.
     * For details, see [documentation](/docs/storage/concepts/versioning).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
     * @return The versioning.
     */
    @java.lang.Override public yandex.cloud.api.storage.v1.BucketOuterClass.Versioning getVersioning() {
      @SuppressWarnings("deprecation")
      yandex.cloud.api.storage.v1.BucketOuterClass.Versioning result = yandex.cloud.api.storage.v1.BucketOuterClass.Versioning.valueOf(versioning_);
      return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.Versioning.UNRECOGNIZED : result;
    }

    public static final int MAX_SIZE_FIELD_NUMBER = 7;
    private long maxSize_;
    /**
     * <pre>
     * Maximum size of the bucket, in bytes.
     * For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
     * </pre>
     *
     * <code>int64 max_size = 7;</code>
     * @return The maxSize.
     */
    @java.lang.Override
    public long getMaxSize() {
      return maxSize_;
    }

    public static final int POLICY_FIELD_NUMBER = 8;
    private com.google.protobuf.Struct policy_;
    /**
     * <pre>
     * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
     * For details, see [documentation](/docs/storage/concepts/policy).
     * </pre>
     *
     * <code>.google.protobuf.Struct policy = 8;</code>
     * @return Whether the policy field is set.
     */
    @java.lang.Override
    public boolean hasPolicy() {
      return policy_ != null;
    }
    /**
     * <pre>
     * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
     * For details, see [documentation](/docs/storage/concepts/policy).
     * </pre>
     *
     * <code>.google.protobuf.Struct policy = 8;</code>
     * @return The policy.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getPolicy() {
      return policy_ == null ? com.google.protobuf.Struct.getDefaultInstance() : policy_;
    }
    /**
     * <pre>
     * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
     * For details, see [documentation](/docs/storage/concepts/policy).
     * </pre>
     *
     * <code>.google.protobuf.Struct policy = 8;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getPolicyOrBuilder() {
      return getPolicy();
    }

    public static final int ACL_FIELD_NUMBER = 9;
    private yandex.cloud.api.storage.v1.BucketOuterClass.ACL acl_;
    /**
     * <pre>
     * Access control list (ACL) of the bucket.
     * For details, see [documentation](/docs/storage/concepts/acl).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
     * @return Whether the acl field is set.
     */
    @java.lang.Override
    public boolean hasAcl() {
      return acl_ != null;
    }
    /**
     * <pre>
     * Access control list (ACL) of the bucket.
     * For details, see [documentation](/docs/storage/concepts/acl).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
     * @return The acl.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.ACL getAcl() {
      return acl_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.ACL.getDefaultInstance() : acl_;
    }
    /**
     * <pre>
     * Access control list (ACL) of the bucket.
     * For details, see [documentation](/docs/storage/concepts/acl).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.ACLOrBuilder getAclOrBuilder() {
      return getAcl();
    }

    public static final int CREATED_AT_FIELD_NUMBER = 10;
    private com.google.protobuf.Timestamp createdAt_;
    /**
     * <pre>
     * Creation timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 10;</code>
     * @return Whether the createdAt field is set.
     */
    @java.lang.Override
    public boolean hasCreatedAt() {
      return createdAt_ != null;
    }
    /**
     * <pre>
     * Creation timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 10;</code>
     * @return The createdAt.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCreatedAt() {
      return createdAt_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createdAt_;
    }
    /**
     * <pre>
     * Creation timestamp.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp created_at = 10;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCreatedAtOrBuilder() {
      return getCreatedAt();
    }

    public static final int CORS_FIELD_NUMBER = 11;
    private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule> cors_;
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    @java.lang.Override
    public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule> getCorsList() {
      return cors_;
    }
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    @java.lang.Override
    public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder> 
        getCorsOrBuilderList() {
      return cors_;
    }
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    @java.lang.Override
    public int getCorsCount() {
      return cors_.size();
    }
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule getCors(int index) {
      return cors_.get(index);
    }
    /**
     * <pre>
     * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
     * For details, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder getCorsOrBuilder(
        int index) {
      return cors_.get(index);
    }

    public static final int WEBSITE_SETTINGS_FIELD_NUMBER = 12;
    private yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings websiteSettings_;
    /**
     * <pre>
     * Configuration for hosting a static website in the bucket.
     * For details, see [documentation](/docs/storage/concepts/hosting).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
     * @return Whether the websiteSettings field is set.
     */
    @java.lang.Override
    public boolean hasWebsiteSettings() {
      return websiteSettings_ != null;
    }
    /**
     * <pre>
     * Configuration for hosting a static website in the bucket.
     * For details, see [documentation](/docs/storage/concepts/hosting).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
     * @return The websiteSettings.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings getWebsiteSettings() {
      return websiteSettings_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.getDefaultInstance() : websiteSettings_;
    }
    /**
     * <pre>
     * Configuration for hosting a static website in the bucket.
     * For details, see [documentation](/docs/storage/concepts/hosting).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettingsOrBuilder getWebsiteSettingsOrBuilder() {
      return getWebsiteSettings();
    }

    public static final int LIFECYCLE_RULES_FIELD_NUMBER = 13;
    private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule> lifecycleRules_;
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    @java.lang.Override
    public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule> getLifecycleRulesList() {
      return lifecycleRules_;
    }
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    @java.lang.Override
    public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder> 
        getLifecycleRulesOrBuilderList() {
      return lifecycleRules_;
    }
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    @java.lang.Override
    public int getLifecycleRulesCount() {
      return lifecycleRules_.size();
    }
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule getLifecycleRules(int index) {
      return lifecycleRules_.get(index);
    }
    /**
     * <pre>
     * List of object lifecycle rules for the bucket.
     * For details, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder getLifecycleRulesOrBuilder(
        int index) {
      return lifecycleRules_.get(index);
    }

    public static final int TAGS_FIELD_NUMBER = 14;
    private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.Tag> tags_;
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    @java.lang.Override
    public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.Tag> getTagsList() {
      return tags_;
    }
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    @java.lang.Override
    public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder> 
        getTagsOrBuilderList() {
      return tags_;
    }
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    @java.lang.Override
    public int getTagsCount() {
      return tags_.size();
    }
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.Tag getTags(int index) {
      return tags_.get(index);
    }
    /**
     * <pre>
     * List of tags for the bucket.
     * For details, see [documentation](/docs/resource-manager/concepts/labels).
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder getTagsOrBuilder(
        int index) {
      return tags_.get(index);
    }

    public static final int OBJECT_LOCK_FIELD_NUMBER = 15;
    private yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock objectLock_;
    /**
     * <pre>
     * Configuration for object lock on the bucket.
     * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
     * @return Whether the objectLock field is set.
     */
    @java.lang.Override
    public boolean hasObjectLock() {
      return objectLock_ != null;
    }
    /**
     * <pre>
     * Configuration for object lock on the bucket.
     * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
     * @return The objectLock.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock getObjectLock() {
      return objectLock_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.getDefaultInstance() : objectLock_;
    }
    /**
     * <pre>
     * Configuration for object lock on the bucket.
     * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLockOrBuilder getObjectLockOrBuilder() {
      return getObjectLock();
    }

    public static final int ENCRYPTION_FIELD_NUMBER = 16;
    private yandex.cloud.api.storage.v1.BucketOuterClass.Encryption encryption_;
    /**
     * <pre>
     * Configuration for bucket's encryption
     * For detauls, see [documentation](/docs/storage/concepts/encryption)
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
     * @return Whether the encryption field is set.
     */
    @java.lang.Override
    public boolean hasEncryption() {
      return encryption_ != null;
    }
    /**
     * <pre>
     * Configuration for bucket's encryption
     * For detauls, see [documentation](/docs/storage/concepts/encryption)
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
     * @return The encryption.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.Encryption getEncryption() {
      return encryption_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.getDefaultInstance() : encryption_;
    }
    /**
     * <pre>
     * Configuration for bucket's encryption
     * For detauls, see [documentation](/docs/storage/concepts/encryption)
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.EncryptionOrBuilder getEncryptionOrBuilder() {
      return getEncryption();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(folderId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, folderId_);
      }
      if (anonymousAccessFlags_ != null) {
        output.writeMessage(4, getAnonymousAccessFlags());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultStorageClass_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, defaultStorageClass_);
      }
      if (versioning_ != yandex.cloud.api.storage.v1.BucketOuterClass.Versioning.VERSIONING_UNSPECIFIED.getNumber()) {
        output.writeEnum(6, versioning_);
      }
      if (maxSize_ != 0L) {
        output.writeInt64(7, maxSize_);
      }
      if (policy_ != null) {
        output.writeMessage(8, getPolicy());
      }
      if (acl_ != null) {
        output.writeMessage(9, getAcl());
      }
      if (createdAt_ != null) {
        output.writeMessage(10, getCreatedAt());
      }
      for (int i = 0; i < cors_.size(); i++) {
        output.writeMessage(11, cors_.get(i));
      }
      if (websiteSettings_ != null) {
        output.writeMessage(12, getWebsiteSettings());
      }
      for (int i = 0; i < lifecycleRules_.size(); i++) {
        output.writeMessage(13, lifecycleRules_.get(i));
      }
      for (int i = 0; i < tags_.size(); i++) {
        output.writeMessage(14, tags_.get(i));
      }
      if (objectLock_ != null) {
        output.writeMessage(15, getObjectLock());
      }
      if (encryption_ != null) {
        output.writeMessage(16, getEncryption());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(folderId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, folderId_);
      }
      if (anonymousAccessFlags_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getAnonymousAccessFlags());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultStorageClass_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, defaultStorageClass_);
      }
      if (versioning_ != yandex.cloud.api.storage.v1.BucketOuterClass.Versioning.VERSIONING_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(6, versioning_);
      }
      if (maxSize_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(7, maxSize_);
      }
      if (policy_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getPolicy());
      }
      if (acl_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, getAcl());
      }
      if (createdAt_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, getCreatedAt());
      }
      for (int i = 0; i < cors_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, cors_.get(i));
      }
      if (websiteSettings_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(12, getWebsiteSettings());
      }
      for (int i = 0; i < lifecycleRules_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(13, lifecycleRules_.get(i));
      }
      for (int i = 0; i < tags_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(14, tags_.get(i));
      }
      if (objectLock_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(15, getObjectLock());
      }
      if (encryption_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(16, getEncryption());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.Bucket)) {
        return super.equals(obj);
      }
      yandex.cloud.api.storage.v1.BucketOuterClass.Bucket other = (yandex.cloud.api.storage.v1.BucketOuterClass.Bucket) obj;

      if (!getId()
          .equals(other.getId())) return false;
      if (!getName()
          .equals(other.getName())) return false;
      if (!getFolderId()
          .equals(other.getFolderId())) return false;
      if (hasAnonymousAccessFlags() != other.hasAnonymousAccessFlags()) return false;
      if (hasAnonymousAccessFlags()) {
        if (!getAnonymousAccessFlags()
            .equals(other.getAnonymousAccessFlags())) return false;
      }
      if (!getDefaultStorageClass()
          .equals(other.getDefaultStorageClass())) return false;
      if (versioning_ != other.versioning_) return false;
      if (getMaxSize()
          != other.getMaxSize()) return false;
      if (hasPolicy() != other.hasPolicy()) return false;
      if (hasPolicy()) {
        if (!getPolicy()
            .equals(other.getPolicy())) return false;
      }
      if (hasAcl() != other.hasAcl()) return false;
      if (hasAcl()) {
        if (!getAcl()
            .equals(other.getAcl())) return false;
      }
      if (hasCreatedAt() != other.hasCreatedAt()) return false;
      if (hasCreatedAt()) {
        if (!getCreatedAt()
            .equals(other.getCreatedAt())) return false;
      }
      if (!getCorsList()
          .equals(other.getCorsList())) return false;
      if (hasWebsiteSettings() != other.hasWebsiteSettings()) return false;
      if (hasWebsiteSettings()) {
        if (!getWebsiteSettings()
            .equals(other.getWebsiteSettings())) return false;
      }
      if (!getLifecycleRulesList()
          .equals(other.getLifecycleRulesList())) return false;
      if (!getTagsList()
          .equals(other.getTagsList())) return false;
      if (hasObjectLock() != other.hasObjectLock()) return false;
      if (hasObjectLock()) {
        if (!getObjectLock()
            .equals(other.getObjectLock())) return false;
      }
      if (hasEncryption() != other.hasEncryption()) return false;
      if (hasEncryption()) {
        if (!getEncryption()
            .equals(other.getEncryption())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + FOLDER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getFolderId().hashCode();
      if (hasAnonymousAccessFlags()) {
        hash = (37 * hash) + ANONYMOUS_ACCESS_FLAGS_FIELD_NUMBER;
        hash = (53 * hash) + getAnonymousAccessFlags().hashCode();
      }
      hash = (37 * hash) + DEFAULT_STORAGE_CLASS_FIELD_NUMBER;
      hash = (53 * hash) + getDefaultStorageClass().hashCode();
      hash = (37 * hash) + VERSIONING_FIELD_NUMBER;
      hash = (53 * hash) + versioning_;
      hash = (37 * hash) + MAX_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getMaxSize());
      if (hasPolicy()) {
        hash = (37 * hash) + POLICY_FIELD_NUMBER;
        hash = (53 * hash) + getPolicy().hashCode();
      }
      if (hasAcl()) {
        hash = (37 * hash) + ACL_FIELD_NUMBER;
        hash = (53 * hash) + getAcl().hashCode();
      }
      if (hasCreatedAt()) {
        hash = (37 * hash) + CREATED_AT_FIELD_NUMBER;
        hash = (53 * hash) + getCreatedAt().hashCode();
      }
      if (getCorsCount() > 0) {
        hash = (37 * hash) + CORS_FIELD_NUMBER;
        hash = (53 * hash) + getCorsList().hashCode();
      }
      if (hasWebsiteSettings()) {
        hash = (37 * hash) + WEBSITE_SETTINGS_FIELD_NUMBER;
        hash = (53 * hash) + getWebsiteSettings().hashCode();
      }
      if (getLifecycleRulesCount() > 0) {
        hash = (37 * hash) + LIFECYCLE_RULES_FIELD_NUMBER;
        hash = (53 * hash) + getLifecycleRulesList().hashCode();
      }
      if (getTagsCount() > 0) {
        hash = (37 * hash) + TAGS_FIELD_NUMBER;
        hash = (53 * hash) + getTagsList().hashCode();
      }
      if (hasObjectLock()) {
        hash = (37 * hash) + OBJECT_LOCK_FIELD_NUMBER;
        hash = (53 * hash) + getObjectLock().hashCode();
      }
      if (hasEncryption()) {
        hash = (37 * hash) + ENCRYPTION_FIELD_NUMBER;
        hash = (53 * hash) + getEncryption().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.Bucket prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A bucket resource.
     * For details about the concept, see [documentation](/docs/storage/concepts/bucket).
     * </pre>
     *
     * Protobuf type {@code yandex.cloud.storage.v1.Bucket}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.Bucket)
        yandex.cloud.api.storage.v1.BucketOuterClass.BucketOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Bucket_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Bucket_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.Bucket.class, yandex.cloud.api.storage.v1.BucketOuterClass.Bucket.Builder.class);
      }

      // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.Bucket.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCorsFieldBuilder();
          getLifecycleRulesFieldBuilder();
          getTagsFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        id_ = "";

        name_ = "";

        folderId_ = "";

        if (anonymousAccessFlagsBuilder_ == null) {
          anonymousAccessFlags_ = null;
        } else {
          anonymousAccessFlags_ = null;
          anonymousAccessFlagsBuilder_ = null;
        }
        defaultStorageClass_ = "";

        versioning_ = 0;

        maxSize_ = 0L;

        if (policyBuilder_ == null) {
          policy_ = null;
        } else {
          policy_ = null;
          policyBuilder_ = null;
        }
        if (aclBuilder_ == null) {
          acl_ = null;
        } else {
          acl_ = null;
          aclBuilder_ = null;
        }
        if (createdAtBuilder_ == null) {
          createdAt_ = null;
        } else {
          createdAt_ = null;
          createdAtBuilder_ = null;
        }
        if (corsBuilder_ == null) {
          cors_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          corsBuilder_.clear();
        }
        if (websiteSettingsBuilder_ == null) {
          websiteSettings_ = null;
        } else {
          websiteSettings_ = null;
          websiteSettingsBuilder_ = null;
        }
        if (lifecycleRulesBuilder_ == null) {
          lifecycleRules_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          lifecycleRulesBuilder_.clear();
        }
        if (tagsBuilder_ == null) {
          tags_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          tagsBuilder_.clear();
        }
        if (objectLockBuilder_ == null) {
          objectLock_ = null;
        } else {
          objectLock_ = null;
          objectLockBuilder_ = null;
        }
        if (encryptionBuilder_ == null) {
          encryption_ = null;
        } else {
          encryption_ = null;
          encryptionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Bucket_descriptor;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.Bucket getDefaultInstanceForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.Bucket.getDefaultInstance();
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.Bucket build() {
        yandex.cloud.api.storage.v1.BucketOuterClass.Bucket result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.Bucket buildPartial() {
        yandex.cloud.api.storage.v1.BucketOuterClass.Bucket result = new yandex.cloud.api.storage.v1.BucketOuterClass.Bucket(this);
        int from_bitField0_ = bitField0_;
        result.id_ = id_;
        result.name_ = name_;
        result.folderId_ = folderId_;
        if (anonymousAccessFlagsBuilder_ == null) {
          result.anonymousAccessFlags_ = anonymousAccessFlags_;
        } else {
          result.anonymousAccessFlags_ = anonymousAccessFlagsBuilder_.build();
        }
        result.defaultStorageClass_ = defaultStorageClass_;
        result.versioning_ = versioning_;
        result.maxSize_ = maxSize_;
        if (policyBuilder_ == null) {
          result.policy_ = policy_;
        } else {
          result.policy_ = policyBuilder_.build();
        }
        if (aclBuilder_ == null) {
          result.acl_ = acl_;
        } else {
          result.acl_ = aclBuilder_.build();
        }
        if (createdAtBuilder_ == null) {
          result.createdAt_ = createdAt_;
        } else {
          result.createdAt_ = createdAtBuilder_.build();
        }
        if (corsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            cors_ = java.util.Collections.unmodifiableList(cors_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.cors_ = cors_;
        } else {
          result.cors_ = corsBuilder_.build();
        }
        if (websiteSettingsBuilder_ == null) {
          result.websiteSettings_ = websiteSettings_;
        } else {
          result.websiteSettings_ = websiteSettingsBuilder_.build();
        }
        if (lifecycleRulesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            lifecycleRules_ = java.util.Collections.unmodifiableList(lifecycleRules_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.lifecycleRules_ = lifecycleRules_;
        } else {
          result.lifecycleRules_ = lifecycleRulesBuilder_.build();
        }
        if (tagsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            tags_ = java.util.Collections.unmodifiableList(tags_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.tags_ = tags_;
        } else {
          result.tags_ = tagsBuilder_.build();
        }
        if (objectLockBuilder_ == null) {
          result.objectLock_ = objectLock_;
        } else {
          result.objectLock_ = objectLockBuilder_.build();
        }
        if (encryptionBuilder_ == null) {
          result.encryption_ = encryption_;
        } else {
          result.encryption_ = encryptionBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.Bucket) {
          return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.Bucket)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.Bucket other) {
        if (other == yandex.cloud.api.storage.v1.BucketOuterClass.Bucket.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getFolderId().isEmpty()) {
          folderId_ = other.folderId_;
          onChanged();
        }
        if (other.hasAnonymousAccessFlags()) {
          mergeAnonymousAccessFlags(other.getAnonymousAccessFlags());
        }
        if (!other.getDefaultStorageClass().isEmpty()) {
          defaultStorageClass_ = other.defaultStorageClass_;
          onChanged();
        }
        if (other.versioning_ != 0) {
          setVersioningValue(other.getVersioningValue());
        }
        if (other.getMaxSize() != 0L) {
          setMaxSize(other.getMaxSize());
        }
        if (other.hasPolicy()) {
          mergePolicy(other.getPolicy());
        }
        if (other.hasAcl()) {
          mergeAcl(other.getAcl());
        }
        if (other.hasCreatedAt()) {
          mergeCreatedAt(other.getCreatedAt());
        }
        if (corsBuilder_ == null) {
          if (!other.cors_.isEmpty()) {
            if (cors_.isEmpty()) {
              cors_ = other.cors_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureCorsIsMutable();
              cors_.addAll(other.cors_);
            }
            onChanged();
          }
        } else {
          if (!other.cors_.isEmpty()) {
            if (corsBuilder_.isEmpty()) {
              corsBuilder_.dispose();
              corsBuilder_ = null;
              cors_ = other.cors_;
              bitField0_ = (bitField0_ & ~0x00000001);
              corsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getCorsFieldBuilder() : null;
            } else {
              corsBuilder_.addAllMessages(other.cors_);
            }
          }
        }
        if (other.hasWebsiteSettings()) {
          mergeWebsiteSettings(other.getWebsiteSettings());
        }
        if (lifecycleRulesBuilder_ == null) {
          if (!other.lifecycleRules_.isEmpty()) {
            if (lifecycleRules_.isEmpty()) {
              lifecycleRules_ = other.lifecycleRules_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureLifecycleRulesIsMutable();
              lifecycleRules_.addAll(other.lifecycleRules_);
            }
            onChanged();
          }
        } else {
          if (!other.lifecycleRules_.isEmpty()) {
            if (lifecycleRulesBuilder_.isEmpty()) {
              lifecycleRulesBuilder_.dispose();
              lifecycleRulesBuilder_ = null;
              lifecycleRules_ = other.lifecycleRules_;
              bitField0_ = (bitField0_ & ~0x00000002);
              lifecycleRulesBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getLifecycleRulesFieldBuilder() : null;
            } else {
              lifecycleRulesBuilder_.addAllMessages(other.lifecycleRules_);
            }
          }
        }
        if (tagsBuilder_ == null) {
          if (!other.tags_.isEmpty()) {
            if (tags_.isEmpty()) {
              tags_ = other.tags_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureTagsIsMutable();
              tags_.addAll(other.tags_);
            }
            onChanged();
          }
        } else {
          if (!other.tags_.isEmpty()) {
            if (tagsBuilder_.isEmpty()) {
              tagsBuilder_.dispose();
              tagsBuilder_ = null;
              tags_ = other.tags_;
              bitField0_ = (bitField0_ & ~0x00000004);
              tagsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getTagsFieldBuilder() : null;
            } else {
              tagsBuilder_.addAllMessages(other.tags_);
            }
          }
        }
        if (other.hasObjectLock()) {
          mergeObjectLock(other.getObjectLock());
        }
        if (other.hasEncryption()) {
          mergeEncryption(other.getEncryption());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        yandex.cloud.api.storage.v1.BucketOuterClass.Bucket parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.Bucket) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * ID of the bucket. Always equal to [name], which has priority.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID of the bucket. Always equal to [name], which has priority.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID of the bucket. Always equal to [name], which has priority.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the bucket. Always equal to [name], which has priority.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the bucket. Always equal to [name], which has priority.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * Name of the bucket.
       * The name is unique within the platform. For naming limitations and rules, see
       * [documentation](/docs/storage/concepts/bucket#naming).
       * </pre>
       *
       * <code>string name = 2;</code>
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Name of the bucket.
       * The name is unique within the platform. For naming limitations and rules, see
       * [documentation](/docs/storage/concepts/bucket#naming).
       * </pre>
       *
       * <code>string name = 2;</code>
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Name of the bucket.
       * The name is unique within the platform. For naming limitations and rules, see
       * [documentation](/docs/storage/concepts/bucket#naming).
       * </pre>
       *
       * <code>string name = 2;</code>
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name of the bucket.
       * The name is unique within the platform. For naming limitations and rules, see
       * [documentation](/docs/storage/concepts/bucket#naming).
       * </pre>
       *
       * <code>string name = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name of the bucket.
       * The name is unique within the platform. For naming limitations and rules, see
       * [documentation](/docs/storage/concepts/bucket#naming).
       * </pre>
       *
       * <code>string name = 2;</code>
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object folderId_ = "";
      /**
       * <pre>
       * ID of the folder that the bucket belongs to.
       * </pre>
       *
       * <code>string folder_id = 3;</code>
       * @return The folderId.
       */
      public java.lang.String getFolderId() {
        java.lang.Object ref = folderId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          folderId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID of the folder that the bucket belongs to.
       * </pre>
       *
       * <code>string folder_id = 3;</code>
       * @return The bytes for folderId.
       */
      public com.google.protobuf.ByteString
          getFolderIdBytes() {
        java.lang.Object ref = folderId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          folderId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID of the folder that the bucket belongs to.
       * </pre>
       *
       * <code>string folder_id = 3;</code>
       * @param value The folderId to set.
       * @return This builder for chaining.
       */
      public Builder setFolderId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        folderId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the folder that the bucket belongs to.
       * </pre>
       *
       * <code>string folder_id = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearFolderId() {
        
        folderId_ = getDefaultInstance().getFolderId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the folder that the bucket belongs to.
       * </pre>
       *
       * <code>string folder_id = 3;</code>
       * @param value The bytes for folderId to set.
       * @return This builder for chaining.
       */
      public Builder setFolderIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        folderId_ = value;
        onChanged();
        return this;
      }

      private yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags anonymousAccessFlags_;
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags, yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlagsOrBuilder> anonymousAccessFlagsBuilder_;
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       * @return Whether the anonymousAccessFlags field is set.
       */
      public boolean hasAnonymousAccessFlags() {
        return anonymousAccessFlagsBuilder_ != null || anonymousAccessFlags_ != null;
      }
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       * @return The anonymousAccessFlags.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags getAnonymousAccessFlags() {
        if (anonymousAccessFlagsBuilder_ == null) {
          return anonymousAccessFlags_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.getDefaultInstance() : anonymousAccessFlags_;
        } else {
          return anonymousAccessFlagsBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       */
      public Builder setAnonymousAccessFlags(yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags value) {
        if (anonymousAccessFlagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          anonymousAccessFlags_ = value;
          onChanged();
        } else {
          anonymousAccessFlagsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       */
      public Builder setAnonymousAccessFlags(
          yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.Builder builderForValue) {
        if (anonymousAccessFlagsBuilder_ == null) {
          anonymousAccessFlags_ = builderForValue.build();
          onChanged();
        } else {
          anonymousAccessFlagsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       */
      public Builder mergeAnonymousAccessFlags(yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags value) {
        if (anonymousAccessFlagsBuilder_ == null) {
          if (anonymousAccessFlags_ != null) {
            anonymousAccessFlags_ =
              yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.newBuilder(anonymousAccessFlags_).mergeFrom(value).buildPartial();
          } else {
            anonymousAccessFlags_ = value;
          }
          onChanged();
        } else {
          anonymousAccessFlagsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       */
      public Builder clearAnonymousAccessFlags() {
        if (anonymousAccessFlagsBuilder_ == null) {
          anonymousAccessFlags_ = null;
          onChanged();
        } else {
          anonymousAccessFlags_ = null;
          anonymousAccessFlagsBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.Builder getAnonymousAccessFlagsBuilder() {
        
        onChanged();
        return getAnonymousAccessFlagsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlagsOrBuilder getAnonymousAccessFlagsOrBuilder() {
        if (anonymousAccessFlagsBuilder_ != null) {
          return anonymousAccessFlagsBuilder_.getMessageOrBuilder();
        } else {
          return anonymousAccessFlags_ == null ?
              yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.getDefaultInstance() : anonymousAccessFlags_;
        }
      }
      /**
       * <pre>
       * Flags for configuring public (anonymous) access to the bucket's content and settings.
       * For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.AnonymousAccessFlags anonymous_access_flags = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags, yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlagsOrBuilder> 
          getAnonymousAccessFlagsFieldBuilder() {
        if (anonymousAccessFlagsBuilder_ == null) {
          anonymousAccessFlagsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags, yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlagsOrBuilder>(
                  getAnonymousAccessFlags(),
                  getParentForChildren(),
                  isClean());
          anonymousAccessFlags_ = null;
        }
        return anonymousAccessFlagsBuilder_;
      }

      private java.lang.Object defaultStorageClass_ = "";
      /**
       * <pre>
       * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
       * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
       * For details, see [documentation](/docs/storage/concepts/storage-class).
       * </pre>
       *
       * <code>string default_storage_class = 5;</code>
       * @return The defaultStorageClass.
       */
      public java.lang.String getDefaultStorageClass() {
        java.lang.Object ref = defaultStorageClass_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultStorageClass_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
       * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
       * For details, see [documentation](/docs/storage/concepts/storage-class).
       * </pre>
       *
       * <code>string default_storage_class = 5;</code>
       * @return The bytes for defaultStorageClass.
       */
      public com.google.protobuf.ByteString
          getDefaultStorageClassBytes() {
        java.lang.Object ref = defaultStorageClass_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          defaultStorageClass_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
       * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
       * For details, see [documentation](/docs/storage/concepts/storage-class).
       * </pre>
       *
       * <code>string default_storage_class = 5;</code>
       * @param value The defaultStorageClass to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultStorageClass(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        defaultStorageClass_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
       * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
       * For details, see [documentation](/docs/storage/concepts/storage-class).
       * </pre>
       *
       * <code>string default_storage_class = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearDefaultStorageClass() {
        
        defaultStorageClass_ = getDefaultInstance().getDefaultStorageClass();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
       * (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
       * For details, see [documentation](/docs/storage/concepts/storage-class).
       * </pre>
       *
       * <code>string default_storage_class = 5;</code>
       * @param value The bytes for defaultStorageClass to set.
       * @return This builder for chaining.
       */
      public Builder setDefaultStorageClassBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        defaultStorageClass_ = value;
        onChanged();
        return this;
      }

      private int versioning_ = 0;
      /**
       * <pre>
       * Bucket versioning status.
       * For details, see [documentation](/docs/storage/concepts/versioning).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
       * @return The enum numeric value on the wire for versioning.
       */
      @java.lang.Override public int getVersioningValue() {
        return versioning_;
      }
      /**
       * <pre>
       * Bucket versioning status.
       * For details, see [documentation](/docs/storage/concepts/versioning).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
       * @param value The enum numeric value on the wire for versioning to set.
       * @return This builder for chaining.
       */
      public Builder setVersioningValue(int value) {
        
        versioning_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Bucket versioning status.
       * For details, see [documentation](/docs/storage/concepts/versioning).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
       * @return The versioning.
       */
      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.Versioning getVersioning() {
        @SuppressWarnings("deprecation")
        yandex.cloud.api.storage.v1.BucketOuterClass.Versioning result = yandex.cloud.api.storage.v1.BucketOuterClass.Versioning.valueOf(versioning_);
        return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.Versioning.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Bucket versioning status.
       * For details, see [documentation](/docs/storage/concepts/versioning).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
       * @param value The versioning to set.
       * @return This builder for chaining.
       */
      public Builder setVersioning(yandex.cloud.api.storage.v1.BucketOuterClass.Versioning value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        versioning_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Bucket versioning status.
       * For details, see [documentation](/docs/storage/concepts/versioning).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Versioning versioning = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearVersioning() {
        
        versioning_ = 0;
        onChanged();
        return this;
      }

      private long maxSize_ ;
      /**
       * <pre>
       * Maximum size of the bucket, in bytes.
       * For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
       * </pre>
       *
       * <code>int64 max_size = 7;</code>
       * @return The maxSize.
       */
      @java.lang.Override
      public long getMaxSize() {
        return maxSize_;
      }
      /**
       * <pre>
       * Maximum size of the bucket, in bytes.
       * For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
       * </pre>
       *
       * <code>int64 max_size = 7;</code>
       * @param value The maxSize to set.
       * @return This builder for chaining.
       */
      public Builder setMaxSize(long value) {
        
        maxSize_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Maximum size of the bucket, in bytes.
       * For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
       * </pre>
       *
       * <code>int64 max_size = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearMaxSize() {
        
        maxSize_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.Struct policy_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Struct, com.google.protobuf.Struct.Builder, com.google.protobuf.StructOrBuilder> policyBuilder_;
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       * @return Whether the policy field is set.
       */
      public boolean hasPolicy() {
        return policyBuilder_ != null || policy_ != null;
      }
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       * @return The policy.
       */
      public com.google.protobuf.Struct getPolicy() {
        if (policyBuilder_ == null) {
          return policy_ == null ? com.google.protobuf.Struct.getDefaultInstance() : policy_;
        } else {
          return policyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       */
      public Builder setPolicy(com.google.protobuf.Struct value) {
        if (policyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          policy_ = value;
          onChanged();
        } else {
          policyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       */
      public Builder setPolicy(
          com.google.protobuf.Struct.Builder builderForValue) {
        if (policyBuilder_ == null) {
          policy_ = builderForValue.build();
          onChanged();
        } else {
          policyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       */
      public Builder mergePolicy(com.google.protobuf.Struct value) {
        if (policyBuilder_ == null) {
          if (policy_ != null) {
            policy_ =
              com.google.protobuf.Struct.newBuilder(policy_).mergeFrom(value).buildPartial();
          } else {
            policy_ = value;
          }
          onChanged();
        } else {
          policyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       */
      public Builder clearPolicy() {
        if (policyBuilder_ == null) {
          policy_ = null;
          onChanged();
        } else {
          policy_ = null;
          policyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       */
      public com.google.protobuf.Struct.Builder getPolicyBuilder() {
        
        onChanged();
        return getPolicyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       */
      public com.google.protobuf.StructOrBuilder getPolicyOrBuilder() {
        if (policyBuilder_ != null) {
          return policyBuilder_.getMessageOrBuilder();
        } else {
          return policy_ == null ?
              com.google.protobuf.Struct.getDefaultInstance() : policy_;
        }
      }
      /**
       * <pre>
       * Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
       * For details, see [documentation](/docs/storage/concepts/policy).
       * </pre>
       *
       * <code>.google.protobuf.Struct policy = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Struct, com.google.protobuf.Struct.Builder, com.google.protobuf.StructOrBuilder> 
          getPolicyFieldBuilder() {
        if (policyBuilder_ == null) {
          policyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct, com.google.protobuf.Struct.Builder, com.google.protobuf.StructOrBuilder>(
                  getPolicy(),
                  getParentForChildren(),
                  isClean());
          policy_ = null;
        }
        return policyBuilder_;
      }

      private yandex.cloud.api.storage.v1.BucketOuterClass.ACL acl_;
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ACLOrBuilder> aclBuilder_;
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       * @return Whether the acl field is set.
       */
      public boolean hasAcl() {
        return aclBuilder_ != null || acl_ != null;
      }
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       * @return The acl.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL getAcl() {
        if (aclBuilder_ == null) {
          return acl_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.ACL.getDefaultInstance() : acl_;
        } else {
          return aclBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       */
      public Builder setAcl(yandex.cloud.api.storage.v1.BucketOuterClass.ACL value) {
        if (aclBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          acl_ = value;
          onChanged();
        } else {
          aclBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       */
      public Builder setAcl(
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Builder builderForValue) {
        if (aclBuilder_ == null) {
          acl_ = builderForValue.build();
          onChanged();
        } else {
          aclBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       */
      public Builder mergeAcl(yandex.cloud.api.storage.v1.BucketOuterClass.ACL value) {
        if (aclBuilder_ == null) {
          if (acl_ != null) {
            acl_ =
              yandex.cloud.api.storage.v1.BucketOuterClass.ACL.newBuilder(acl_).mergeFrom(value).buildPartial();
          } else {
            acl_ = value;
          }
          onChanged();
        } else {
          aclBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       */
      public Builder clearAcl() {
        if (aclBuilder_ == null) {
          acl_ = null;
          onChanged();
        } else {
          acl_ = null;
          aclBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Builder getAclBuilder() {
        
        onChanged();
        return getAclFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACLOrBuilder getAclOrBuilder() {
        if (aclBuilder_ != null) {
          return aclBuilder_.getMessageOrBuilder();
        } else {
          return acl_ == null ?
              yandex.cloud.api.storage.v1.BucketOuterClass.ACL.getDefaultInstance() : acl_;
        }
      }
      /**
       * <pre>
       * Access control list (ACL) of the bucket.
       * For details, see [documentation](/docs/storage/concepts/acl).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL acl = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ACLOrBuilder> 
          getAclFieldBuilder() {
        if (aclBuilder_ == null) {
          aclBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.ACL, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ACLOrBuilder>(
                  getAcl(),
                  getParentForChildren(),
                  isClean());
          acl_ = null;
        }
        return aclBuilder_;
      }

      private com.google.protobuf.Timestamp createdAt_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> createdAtBuilder_;
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       * @return Whether the createdAt field is set.
       */
      public boolean hasCreatedAt() {
        return createdAtBuilder_ != null || createdAt_ != null;
      }
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       * @return The createdAt.
       */
      public com.google.protobuf.Timestamp getCreatedAt() {
        if (createdAtBuilder_ == null) {
          return createdAt_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createdAt_;
        } else {
          return createdAtBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       */
      public Builder setCreatedAt(com.google.protobuf.Timestamp value) {
        if (createdAtBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createdAt_ = value;
          onChanged();
        } else {
          createdAtBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       */
      public Builder setCreatedAt(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (createdAtBuilder_ == null) {
          createdAt_ = builderForValue.build();
          onChanged();
        } else {
          createdAtBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       */
      public Builder mergeCreatedAt(com.google.protobuf.Timestamp value) {
        if (createdAtBuilder_ == null) {
          if (createdAt_ != null) {
            createdAt_ =
              com.google.protobuf.Timestamp.newBuilder(createdAt_).mergeFrom(value).buildPartial();
          } else {
            createdAt_ = value;
          }
          onChanged();
        } else {
          createdAtBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       */
      public Builder clearCreatedAt() {
        if (createdAtBuilder_ == null) {
          createdAt_ = null;
          onChanged();
        } else {
          createdAt_ = null;
          createdAtBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCreatedAtBuilder() {
        
        onChanged();
        return getCreatedAtFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCreatedAtOrBuilder() {
        if (createdAtBuilder_ != null) {
          return createdAtBuilder_.getMessageOrBuilder();
        } else {
          return createdAt_ == null ?
              com.google.protobuf.Timestamp.getDefaultInstance() : createdAt_;
        }
      }
      /**
       * <pre>
       * Creation timestamp.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp created_at = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> 
          getCreatedAtFieldBuilder() {
        if (createdAtBuilder_ == null) {
          createdAtBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                  getCreatedAt(),
                  getParentForChildren(),
                  isClean());
          createdAt_ = null;
        }
        return createdAtBuilder_;
      }

      private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule> cors_ =
        java.util.Collections.emptyList();
      private void ensureCorsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          cors_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule>(cors_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder> corsBuilder_;

      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule> getCorsList() {
        if (corsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(cors_);
        } else {
          return corsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public int getCorsCount() {
        if (corsBuilder_ == null) {
          return cors_.size();
        } else {
          return corsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule getCors(int index) {
        if (corsBuilder_ == null) {
          return cors_.get(index);
        } else {
          return corsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder setCors(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule value) {
        if (corsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCorsIsMutable();
          cors_.set(index, value);
          onChanged();
        } else {
          corsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder setCors(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder builderForValue) {
        if (corsBuilder_ == null) {
          ensureCorsIsMutable();
          cors_.set(index, builderForValue.build());
          onChanged();
        } else {
          corsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder addCors(yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule value) {
        if (corsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCorsIsMutable();
          cors_.add(value);
          onChanged();
        } else {
          corsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder addCors(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule value) {
        if (corsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCorsIsMutable();
          cors_.add(index, value);
          onChanged();
        } else {
          corsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder addCors(
          yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder builderForValue) {
        if (corsBuilder_ == null) {
          ensureCorsIsMutable();
          cors_.add(builderForValue.build());
          onChanged();
        } else {
          corsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder addCors(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder builderForValue) {
        if (corsBuilder_ == null) {
          ensureCorsIsMutable();
          cors_.add(index, builderForValue.build());
          onChanged();
        } else {
          corsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder addAllCors(
          java.lang.Iterable<? extends yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule> values) {
        if (corsBuilder_ == null) {
          ensureCorsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, cors_);
          onChanged();
        } else {
          corsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder clearCors() {
        if (corsBuilder_ == null) {
          cors_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          corsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public Builder removeCors(int index) {
        if (corsBuilder_ == null) {
          ensureCorsIsMutable();
          cors_.remove(index);
          onChanged();
        } else {
          corsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder getCorsBuilder(
          int index) {
        return getCorsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder getCorsOrBuilder(
          int index) {
        if (corsBuilder_ == null) {
          return cors_.get(index);  } else {
          return corsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder> 
           getCorsOrBuilderList() {
        if (corsBuilder_ != null) {
          return corsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(cors_);
        }
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder addCorsBuilder() {
        return getCorsFieldBuilder().addBuilder(
            yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.getDefaultInstance());
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder addCorsBuilder(
          int index) {
        return getCorsFieldBuilder().addBuilder(
            index, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.getDefaultInstance());
      }
      /**
       * <pre>
       * List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
       * For details, see [documentation](/docs/storage/concepts/cors).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule cors = 11;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder> 
           getCorsBuilderList() {
        return getCorsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder> 
          getCorsFieldBuilder() {
        if (corsBuilder_ == null) {
          corsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder>(
                  cors_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          cors_ = null;
        }
        return corsBuilder_;
      }

      private yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings websiteSettings_;
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettingsOrBuilder> websiteSettingsBuilder_;
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       * @return Whether the websiteSettings field is set.
       */
      public boolean hasWebsiteSettings() {
        return websiteSettingsBuilder_ != null || websiteSettings_ != null;
      }
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       * @return The websiteSettings.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings getWebsiteSettings() {
        if (websiteSettingsBuilder_ == null) {
          return websiteSettings_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.getDefaultInstance() : websiteSettings_;
        } else {
          return websiteSettingsBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       */
      public Builder setWebsiteSettings(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings value) {
        if (websiteSettingsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          websiteSettings_ = value;
          onChanged();
        } else {
          websiteSettingsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       */
      public Builder setWebsiteSettings(
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Builder builderForValue) {
        if (websiteSettingsBuilder_ == null) {
          websiteSettings_ = builderForValue.build();
          onChanged();
        } else {
          websiteSettingsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       */
      public Builder mergeWebsiteSettings(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings value) {
        if (websiteSettingsBuilder_ == null) {
          if (websiteSettings_ != null) {
            websiteSettings_ =
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.newBuilder(websiteSettings_).mergeFrom(value).buildPartial();
          } else {
            websiteSettings_ = value;
          }
          onChanged();
        } else {
          websiteSettingsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       */
      public Builder clearWebsiteSettings() {
        if (websiteSettingsBuilder_ == null) {
          websiteSettings_ = null;
          onChanged();
        } else {
          websiteSettings_ = null;
          websiteSettingsBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Builder getWebsiteSettingsBuilder() {
        
        onChanged();
        return getWebsiteSettingsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettingsOrBuilder getWebsiteSettingsOrBuilder() {
        if (websiteSettingsBuilder_ != null) {
          return websiteSettingsBuilder_.getMessageOrBuilder();
        } else {
          return websiteSettings_ == null ?
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.getDefaultInstance() : websiteSettings_;
        }
      }
      /**
       * <pre>
       * Configuration for hosting a static website in the bucket.
       * For details, see [documentation](/docs/storage/concepts/hosting).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings website_settings = 12;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettingsOrBuilder> 
          getWebsiteSettingsFieldBuilder() {
        if (websiteSettingsBuilder_ == null) {
          websiteSettingsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettingsOrBuilder>(
                  getWebsiteSettings(),
                  getParentForChildren(),
                  isClean());
          websiteSettings_ = null;
        }
        return websiteSettingsBuilder_;
      }

      private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule> lifecycleRules_ =
        java.util.Collections.emptyList();
      private void ensureLifecycleRulesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          lifecycleRules_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule>(lifecycleRules_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder> lifecycleRulesBuilder_;

      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule> getLifecycleRulesList() {
        if (lifecycleRulesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(lifecycleRules_);
        } else {
          return lifecycleRulesBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public int getLifecycleRulesCount() {
        if (lifecycleRulesBuilder_ == null) {
          return lifecycleRules_.size();
        } else {
          return lifecycleRulesBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule getLifecycleRules(int index) {
        if (lifecycleRulesBuilder_ == null) {
          return lifecycleRules_.get(index);
        } else {
          return lifecycleRulesBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder setLifecycleRules(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule value) {
        if (lifecycleRulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLifecycleRulesIsMutable();
          lifecycleRules_.set(index, value);
          onChanged();
        } else {
          lifecycleRulesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder setLifecycleRules(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder builderForValue) {
        if (lifecycleRulesBuilder_ == null) {
          ensureLifecycleRulesIsMutable();
          lifecycleRules_.set(index, builderForValue.build());
          onChanged();
        } else {
          lifecycleRulesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder addLifecycleRules(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule value) {
        if (lifecycleRulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLifecycleRulesIsMutable();
          lifecycleRules_.add(value);
          onChanged();
        } else {
          lifecycleRulesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder addLifecycleRules(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule value) {
        if (lifecycleRulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLifecycleRulesIsMutable();
          lifecycleRules_.add(index, value);
          onChanged();
        } else {
          lifecycleRulesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder addLifecycleRules(
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder builderForValue) {
        if (lifecycleRulesBuilder_ == null) {
          ensureLifecycleRulesIsMutable();
          lifecycleRules_.add(builderForValue.build());
          onChanged();
        } else {
          lifecycleRulesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder addLifecycleRules(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder builderForValue) {
        if (lifecycleRulesBuilder_ == null) {
          ensureLifecycleRulesIsMutable();
          lifecycleRules_.add(index, builderForValue.build());
          onChanged();
        } else {
          lifecycleRulesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder addAllLifecycleRules(
          java.lang.Iterable<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule> values) {
        if (lifecycleRulesBuilder_ == null) {
          ensureLifecycleRulesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, lifecycleRules_);
          onChanged();
        } else {
          lifecycleRulesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder clearLifecycleRules() {
        if (lifecycleRulesBuilder_ == null) {
          lifecycleRules_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          lifecycleRulesBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public Builder removeLifecycleRules(int index) {
        if (lifecycleRulesBuilder_ == null) {
          ensureLifecycleRulesIsMutable();
          lifecycleRules_.remove(index);
          onChanged();
        } else {
          lifecycleRulesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder getLifecycleRulesBuilder(
          int index) {
        return getLifecycleRulesFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder getLifecycleRulesOrBuilder(
          int index) {
        if (lifecycleRulesBuilder_ == null) {
          return lifecycleRules_.get(index);  } else {
          return lifecycleRulesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder> 
           getLifecycleRulesOrBuilderList() {
        if (lifecycleRulesBuilder_ != null) {
          return lifecycleRulesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(lifecycleRules_);
        }
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder addLifecycleRulesBuilder() {
        return getLifecycleRulesFieldBuilder().addBuilder(
            yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.getDefaultInstance());
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder addLifecycleRulesBuilder(
          int index) {
        return getLifecycleRulesFieldBuilder().addBuilder(
            index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.getDefaultInstance());
      }
      /**
       * <pre>
       * List of object lifecycle rules for the bucket.
       * For details, see [documentation](/docs/storage/concepts/lifecycles).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule lifecycle_rules = 13;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder> 
           getLifecycleRulesBuilderList() {
        return getLifecycleRulesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder> 
          getLifecycleRulesFieldBuilder() {
        if (lifecycleRulesBuilder_ == null) {
          lifecycleRulesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder>(
                  lifecycleRules_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          lifecycleRules_ = null;
        }
        return lifecycleRulesBuilder_;
      }

      private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.Tag> tags_ =
        java.util.Collections.emptyList();
      private void ensureTagsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          tags_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.Tag>(tags_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.Tag, yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder> tagsBuilder_;

      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.Tag> getTagsList() {
        if (tagsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tags_);
        } else {
          return tagsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public int getTagsCount() {
        if (tagsBuilder_ == null) {
          return tags_.size();
        } else {
          return tagsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.Tag getTags(int index) {
        if (tagsBuilder_ == null) {
          return tags_.get(index);
        } else {
          return tagsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder setTags(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.Tag value) {
        if (tagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagsIsMutable();
          tags_.set(index, value);
          onChanged();
        } else {
          tagsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder setTags(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder builderForValue) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          tags_.set(index, builderForValue.build());
          onChanged();
        } else {
          tagsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder addTags(yandex.cloud.api.storage.v1.BucketOuterClass.Tag value) {
        if (tagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagsIsMutable();
          tags_.add(value);
          onChanged();
        } else {
          tagsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder addTags(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.Tag value) {
        if (tagsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTagsIsMutable();
          tags_.add(index, value);
          onChanged();
        } else {
          tagsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder addTags(
          yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder builderForValue) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          tags_.add(builderForValue.build());
          onChanged();
        } else {
          tagsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder addTags(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder builderForValue) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          tags_.add(index, builderForValue.build());
          onChanged();
        } else {
          tagsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder addAllTags(
          java.lang.Iterable<? extends yandex.cloud.api.storage.v1.BucketOuterClass.Tag> values) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, tags_);
          onChanged();
        } else {
          tagsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder clearTags() {
        if (tagsBuilder_ == null) {
          tags_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          tagsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public Builder removeTags(int index) {
        if (tagsBuilder_ == null) {
          ensureTagsIsMutable();
          tags_.remove(index);
          onChanged();
        } else {
          tagsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder getTagsBuilder(
          int index) {
        return getTagsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder getTagsOrBuilder(
          int index) {
        if (tagsBuilder_ == null) {
          return tags_.get(index);  } else {
          return tagsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder> 
           getTagsOrBuilderList() {
        if (tagsBuilder_ != null) {
          return tagsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tags_);
        }
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder addTagsBuilder() {
        return getTagsFieldBuilder().addBuilder(
            yandex.cloud.api.storage.v1.BucketOuterClass.Tag.getDefaultInstance());
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder addTagsBuilder(
          int index) {
        return getTagsFieldBuilder().addBuilder(
            index, yandex.cloud.api.storage.v1.BucketOuterClass.Tag.getDefaultInstance());
      }
      /**
       * <pre>
       * List of tags for the bucket.
       * For details, see [documentation](/docs/resource-manager/concepts/labels).
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.Tag tags = 14;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder> 
           getTagsBuilderList() {
        return getTagsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.Tag, yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder> 
          getTagsFieldBuilder() {
        if (tagsBuilder_ == null) {
          tagsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.Tag, yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder>(
                  tags_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          tags_ = null;
        }
        return tagsBuilder_;
      }

      private yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock objectLock_;
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock, yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLockOrBuilder> objectLockBuilder_;
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       * @return Whether the objectLock field is set.
       */
      public boolean hasObjectLock() {
        return objectLockBuilder_ != null || objectLock_ != null;
      }
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       * @return The objectLock.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock getObjectLock() {
        if (objectLockBuilder_ == null) {
          return objectLock_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.getDefaultInstance() : objectLock_;
        } else {
          return objectLockBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       */
      public Builder setObjectLock(yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock value) {
        if (objectLockBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          objectLock_ = value;
          onChanged();
        } else {
          objectLockBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       */
      public Builder setObjectLock(
          yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.Builder builderForValue) {
        if (objectLockBuilder_ == null) {
          objectLock_ = builderForValue.build();
          onChanged();
        } else {
          objectLockBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       */
      public Builder mergeObjectLock(yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock value) {
        if (objectLockBuilder_ == null) {
          if (objectLock_ != null) {
            objectLock_ =
              yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.newBuilder(objectLock_).mergeFrom(value).buildPartial();
          } else {
            objectLock_ = value;
          }
          onChanged();
        } else {
          objectLockBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       */
      public Builder clearObjectLock() {
        if (objectLockBuilder_ == null) {
          objectLock_ = null;
          onChanged();
        } else {
          objectLock_ = null;
          objectLockBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.Builder getObjectLockBuilder() {
        
        onChanged();
        return getObjectLockFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLockOrBuilder getObjectLockOrBuilder() {
        if (objectLockBuilder_ != null) {
          return objectLockBuilder_.getMessageOrBuilder();
        } else {
          return objectLock_ == null ?
              yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.getDefaultInstance() : objectLock_;
        }
      }
      /**
       * <pre>
       * Configuration for object lock on the bucket.
       * For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ObjectLock object_lock = 15;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock, yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLockOrBuilder> 
          getObjectLockFieldBuilder() {
        if (objectLockBuilder_ == null) {
          objectLockBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock, yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLock.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ObjectLockOrBuilder>(
                  getObjectLock(),
                  getParentForChildren(),
                  isClean());
          objectLock_ = null;
        }
        return objectLockBuilder_;
      }

      private yandex.cloud.api.storage.v1.BucketOuterClass.Encryption encryption_;
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.Encryption, yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.EncryptionOrBuilder> encryptionBuilder_;
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       * @return Whether the encryption field is set.
       */
      public boolean hasEncryption() {
        return encryptionBuilder_ != null || encryption_ != null;
      }
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       * @return The encryption.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.Encryption getEncryption() {
        if (encryptionBuilder_ == null) {
          return encryption_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.getDefaultInstance() : encryption_;
        } else {
          return encryptionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       */
      public Builder setEncryption(yandex.cloud.api.storage.v1.BucketOuterClass.Encryption value) {
        if (encryptionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          encryption_ = value;
          onChanged();
        } else {
          encryptionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       */
      public Builder setEncryption(
          yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.Builder builderForValue) {
        if (encryptionBuilder_ == null) {
          encryption_ = builderForValue.build();
          onChanged();
        } else {
          encryptionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       */
      public Builder mergeEncryption(yandex.cloud.api.storage.v1.BucketOuterClass.Encryption value) {
        if (encryptionBuilder_ == null) {
          if (encryption_ != null) {
            encryption_ =
              yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.newBuilder(encryption_).mergeFrom(value).buildPartial();
          } else {
            encryption_ = value;
          }
          onChanged();
        } else {
          encryptionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       */
      public Builder clearEncryption() {
        if (encryptionBuilder_ == null) {
          encryption_ = null;
          onChanged();
        } else {
          encryption_ = null;
          encryptionBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.Builder getEncryptionBuilder() {
        
        onChanged();
        return getEncryptionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.EncryptionOrBuilder getEncryptionOrBuilder() {
        if (encryptionBuilder_ != null) {
          return encryptionBuilder_.getMessageOrBuilder();
        } else {
          return encryption_ == null ?
              yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.getDefaultInstance() : encryption_;
        }
      }
      /**
       * <pre>
       * Configuration for bucket's encryption
       * For detauls, see [documentation](/docs/storage/concepts/encryption)
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.Encryption encryption = 16;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.Encryption, yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.EncryptionOrBuilder> 
          getEncryptionFieldBuilder() {
        if (encryptionBuilder_ == null) {
          encryptionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.Encryption, yandex.cloud.api.storage.v1.BucketOuterClass.Encryption.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.EncryptionOrBuilder>(
                  getEncryption(),
                  getParentForChildren(),
                  isClean());
          encryption_ = null;
        }
        return encryptionBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.Bucket)
    }

    // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.Bucket)
    private static final yandex.cloud.api.storage.v1.BucketOuterClass.Bucket DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.Bucket();
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.Bucket getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Bucket>
        PARSER = new com.google.protobuf.AbstractParser<Bucket>() {
      @java.lang.Override
      public Bucket parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Bucket(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Bucket> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Bucket> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.Bucket getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TagOrBuilder extends
      // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.Tag)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Key of the bucket tag.
     * </pre>
     *
     * <code>string key = 1;</code>
     * @return The key.
     */
    java.lang.String getKey();
    /**
     * <pre>
     * Key of the bucket tag.
     * </pre>
     *
     * <code>string key = 1;</code>
     * @return The bytes for key.
     */
    com.google.protobuf.ByteString
        getKeyBytes();

    /**
     * <pre>
     * Value of the bucket tag.
     * </pre>
     *
     * <code>string value = 2;</code>
     * @return The value.
     */
    java.lang.String getValue();
    /**
     * <pre>
     * Value of the bucket tag.
     * </pre>
     *
     * <code>string value = 2;</code>
     * @return The bytes for value.
     */
    com.google.protobuf.ByteString
        getValueBytes();
  }
  /**
   * Protobuf type {@code yandex.cloud.storage.v1.Tag}
   */
  public static final class Tag extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.Tag)
      TagOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Tag.newBuilder() to construct.
    private Tag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Tag() {
      key_ = "";
      value_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new Tag();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Tag(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              key_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              value_ = s;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Tag_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Tag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              yandex.cloud.api.storage.v1.BucketOuterClass.Tag.class, yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private volatile java.lang.Object key_;
    /**
     * <pre>
     * Key of the bucket tag.
     * </pre>
     *
     * <code>string key = 1;</code>
     * @return The key.
     */
    @java.lang.Override
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Key of the bucket tag.
     * </pre>
     *
     * <code>string key = 1;</code>
     * @return The bytes for key.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private volatile java.lang.Object value_;
    /**
     * <pre>
     * Value of the bucket tag.
     * </pre>
     *
     * <code>string value = 2;</code>
     * @return The value.
     */
    @java.lang.Override
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Value of the bucket tag.
     * </pre>
     *
     * <code>string value = 2;</code>
     * @return The bytes for value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, key_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(key_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, key_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(value_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.Tag)) {
        return super.equals(obj);
      }
      yandex.cloud.api.storage.v1.BucketOuterClass.Tag other = (yandex.cloud.api.storage.v1.BucketOuterClass.Tag) obj;

      if (!getKey()
          .equals(other.getKey())) return false;
      if (!getValue()
          .equals(other.getValue())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.Tag prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.Tag}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.Tag)
        yandex.cloud.api.storage.v1.BucketOuterClass.TagOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Tag_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Tag_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.Tag.class, yandex.cloud.api.storage.v1.BucketOuterClass.Tag.Builder.class);
      }

      // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.Tag.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        key_ = "";

        value_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_Tag_descriptor;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.Tag getDefaultInstanceForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.Tag.getDefaultInstance();
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.Tag build() {
        yandex.cloud.api.storage.v1.BucketOuterClass.Tag result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.Tag buildPartial() {
        yandex.cloud.api.storage.v1.BucketOuterClass.Tag result = new yandex.cloud.api.storage.v1.BucketOuterClass.Tag(this);
        result.key_ = key_;
        result.value_ = value_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.Tag) {
          return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.Tag)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.Tag other) {
        if (other == yandex.cloud.api.storage.v1.BucketOuterClass.Tag.getDefaultInstance()) return this;
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          onChanged();
        }
        if (!other.getValue().isEmpty()) {
          value_ = other.value_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        yandex.cloud.api.storage.v1.BucketOuterClass.Tag parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.Tag) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object key_ = "";
      /**
       * <pre>
       * Key of the bucket tag.
       * </pre>
       *
       * <code>string key = 1;</code>
       * @return The key.
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Key of the bucket tag.
       * </pre>
       *
       * <code>string key = 1;</code>
       * @return The bytes for key.
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Key of the bucket tag.
       * </pre>
       *
       * <code>string key = 1;</code>
       * @param value The key to set.
       * @return This builder for chaining.
       */
      public Builder setKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Key of the bucket tag.
       * </pre>
       *
       * <code>string key = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearKey() {
        
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Key of the bucket tag.
       * </pre>
       *
       * <code>string key = 1;</code>
       * @param value The bytes for key to set.
       * @return This builder for chaining.
       */
      public Builder setKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        key_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object value_ = "";
      /**
       * <pre>
       * Value of the bucket tag.
       * </pre>
       *
       * <code>string value = 2;</code>
       * @return The value.
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          value_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Value of the bucket tag.
       * </pre>
       *
       * <code>string value = 2;</code>
       * @return The bytes for value.
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Value of the bucket tag.
       * </pre>
       *
       * <code>string value = 2;</code>
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        value_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Value of the bucket tag.
       * </pre>
       *
       * <code>string value = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Value of the bucket tag.
       * </pre>
       *
       * <code>string value = 2;</code>
       * @param value The bytes for value to set.
       * @return This builder for chaining.
       */
      public Builder setValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        value_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.Tag)
    }

    // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.Tag)
    private static final yandex.cloud.api.storage.v1.BucketOuterClass.Tag DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.Tag();
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.Tag getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Tag>
        PARSER = new com.google.protobuf.AbstractParser<Tag>() {
      @java.lang.Override
      public Tag parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Tag(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Tag> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Tag> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.Tag getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ACLOrBuilder extends
      // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.ACL)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant> 
        getGrantsList();
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant getGrants(int index);
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    int getGrantsCount();
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder> 
        getGrantsOrBuilderList();
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder getGrantsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code yandex.cloud.storage.v1.ACL}
   */
  public static final class ACL extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.ACL)
      ACLOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ACL.newBuilder() to construct.
    private ACL(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ACL() {
      grants_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new ACL();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ACL(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                grants_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant>();
                mutable_bitField0_ |= 0x00000001;
              }
              grants_.add(
                  input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.parser(), extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          grants_ = java.util.Collections.unmodifiableList(grants_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              yandex.cloud.api.storage.v1.BucketOuterClass.ACL.class, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Builder.class);
    }

    public interface GrantOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.ACL.Grant)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Permission granted by the grant.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
       * @return The enum numeric value on the wire for permission.
       */
      int getPermissionValue();
      /**
       * <pre>
       * Permission granted by the grant.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
       * @return The permission.
       */
      yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission getPermission();

      /**
       * <pre>
       * The grantee type for the grant.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
       * @return The enum numeric value on the wire for grantType.
       */
      int getGrantTypeValue();
      /**
       * <pre>
       * The grantee type for the grant.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
       * @return The grantType.
       */
      yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType getGrantType();

      /**
       * <pre>
       * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
       * </pre>
       *
       * <code>string grantee_id = 3;</code>
       * @return The granteeId.
       */
      java.lang.String getGranteeId();
      /**
       * <pre>
       * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
       * </pre>
       *
       * <code>string grantee_id = 3;</code>
       * @return The bytes for granteeId.
       */
      com.google.protobuf.ByteString
          getGranteeIdBytes();
    }
    /**
     * <pre>
     * A grant resource, used to specify the permission granted and the grantee.
     * </pre>
     *
     * Protobuf type {@code yandex.cloud.storage.v1.ACL.Grant}
     */
    public static final class Grant extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.ACL.Grant)
        GrantOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Grant.newBuilder() to construct.
      private Grant(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Grant() {
        permission_ = 0;
        grantType_ = 0;
        granteeId_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Grant();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Grant(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int rawValue = input.readEnum();

                permission_ = rawValue;
                break;
              }
              case 16: {
                int rawValue = input.readEnum();

                grantType_ = rawValue;
                break;
              }
              case 26: {
                java.lang.String s = input.readStringRequireUtf8();

                granteeId_ = s;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_Grant_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_Grant_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.class, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder.class);
      }

      /**
       * Protobuf enum {@code yandex.cloud.storage.v1.ACL.Grant.Permission}
       */
      public enum Permission
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>PERMISSION_UNSPECIFIED = 0;</code>
         */
        PERMISSION_UNSPECIFIED(0),
        /**
         * <pre>
         * Allows grantee the `PERMISSION_WRITE`, `PERMISSION_WRITE_ACP`, `PERMISSION_READ`, and `PERMISSION_READ_ACP`
         * on the bucket.
         * Maps to `x-amz-grant-full-control` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
         * Amazon S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_FULL_CONTROL = 1;</code>
         */
        PERMISSION_FULL_CONTROL(1),
        /**
         * <pre>
         * Allows grantee to create new objects in the bucket. For the bucket and object owners of existing objects, also
         * allows deletions and overwrites of those objects.
         * Maps to `x-amz-grant-write` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
         * S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_WRITE = 2;</code>
         */
        PERMISSION_WRITE(2),
        /**
         * <pre>
         * Allows grantee to write the ACL for the bucket.
         * Maps to `x-amz-grant-write-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
         * Amazon S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_WRITE_ACP = 3;</code>
         */
        PERMISSION_WRITE_ACP(3),
        /**
         * <pre>
         * Allows grantee to list the objects in the bucket.
         * Maps to `x-amz-grant-read` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
         * S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_READ = 4;</code>
         */
        PERMISSION_READ(4),
        /**
         * <pre>
         * Allows grantee to read the bucket ACL
         * Maps to `x-amz-grant-read-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
         * Amazon S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_READ_ACP = 5;</code>
         */
        PERMISSION_READ_ACP(5),
        UNRECOGNIZED(-1),
        ;

        /**
         * <code>PERMISSION_UNSPECIFIED = 0;</code>
         */
        public static final int PERMISSION_UNSPECIFIED_VALUE = 0;
        /**
         * <pre>
         * Allows grantee the `PERMISSION_WRITE`, `PERMISSION_WRITE_ACP`, `PERMISSION_READ`, and `PERMISSION_READ_ACP`
         * on the bucket.
         * Maps to `x-amz-grant-full-control` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
         * Amazon S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_FULL_CONTROL = 1;</code>
         */
        public static final int PERMISSION_FULL_CONTROL_VALUE = 1;
        /**
         * <pre>
         * Allows grantee to create new objects in the bucket. For the bucket and object owners of existing objects, also
         * allows deletions and overwrites of those objects.
         * Maps to `x-amz-grant-write` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
         * S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_WRITE = 2;</code>
         */
        public static final int PERMISSION_WRITE_VALUE = 2;
        /**
         * <pre>
         * Allows grantee to write the ACL for the bucket.
         * Maps to `x-amz-grant-write-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
         * Amazon S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_WRITE_ACP = 3;</code>
         */
        public static final int PERMISSION_WRITE_ACP_VALUE = 3;
        /**
         * <pre>
         * Allows grantee to list the objects in the bucket.
         * Maps to `x-amz-grant-read` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon
         * S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_READ = 4;</code>
         */
        public static final int PERMISSION_READ_VALUE = 4;
        /**
         * <pre>
         * Allows grantee to read the bucket ACL
         * Maps to `x-amz-grant-read-acp` header for [bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of
         * Amazon S3-compatible HTTP API.
         * </pre>
         *
         * <code>PERMISSION_READ_ACP = 5;</code>
         */
        public static final int PERMISSION_READ_ACP_VALUE = 5;


        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Permission valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Permission forNumber(int value) {
          switch (value) {
            case 0: return PERMISSION_UNSPECIFIED;
            case 1: return PERMISSION_FULL_CONTROL;
            case 2: return PERMISSION_WRITE;
            case 3: return PERMISSION_WRITE_ACP;
            case 4: return PERMISSION_READ;
            case 5: return PERMISSION_READ_ACP;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Permission>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            Permission> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Permission>() {
                public Permission findValueByNumber(int number) {
                  return Permission.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.getDescriptor().getEnumTypes().get(0);
        }

        private static final Permission[] VALUES = values();

        public static Permission valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Permission(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:yandex.cloud.storage.v1.ACL.Grant.Permission)
      }

      /**
       * Protobuf enum {@code yandex.cloud.storage.v1.ACL.Grant.GrantType}
       */
      public enum GrantType
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>GRANT_TYPE_UNSPECIFIED = 0;</code>
         */
        GRANT_TYPE_UNSPECIFIED(0),
        /**
         * <pre>
         * A grantee is an [account on the platform](/docs/iam/concepts/#accounts).
         * For this grantee type, you need to specify the user ID in [Bucket.acl.grants.grantee_id] field. To get user ID, see
         * [instruction](/docs/iam/operations/users/get).
         * Maps to using `id="*"` value for `x-amz-grant-*` header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput)
         * method of Amazon S3-compatible HTTP API).
         * </pre>
         *
         * <code>GRANT_TYPE_ACCOUNT = 1;</code>
         */
        GRANT_TYPE_ACCOUNT(1),
        /**
         * <pre>
         * Grantees are all authenticated users, both from your clouds and other users' clouds. Access
         * permission to this group allows any account on the platform to access the resource via a signed (authenticated)
         * request.
         * Maps to using `uri="http://acs.amazonaws.com/groups/global/AuthenticatedUsers"` value for `x-amz-grant-*`
         * header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
         * </pre>
         *
         * <code>GRANT_TYPE_ALL_AUTHENTICATED_USERS = 2;</code>
         */
        GRANT_TYPE_ALL_AUTHENTICATED_USERS(2),
        /**
         * <pre>
         * Grantees are all internet users. Access permission to this group allows anyone in the world access to the
         * resource via signed (authenticated) or unsigned (anonymous) requests.
         * Maps to using `uri="http://acs.amazonaws.com/groups/global/AllUsers"` value for `x-amz-grant-*` header
         * ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
         * </pre>
         *
         * <code>GRANT_TYPE_ALL_USERS = 3;</code>
         */
        GRANT_TYPE_ALL_USERS(3),
        UNRECOGNIZED(-1),
        ;

        /**
         * <code>GRANT_TYPE_UNSPECIFIED = 0;</code>
         */
        public static final int GRANT_TYPE_UNSPECIFIED_VALUE = 0;
        /**
         * <pre>
         * A grantee is an [account on the platform](/docs/iam/concepts/#accounts).
         * For this grantee type, you need to specify the user ID in [Bucket.acl.grants.grantee_id] field. To get user ID, see
         * [instruction](/docs/iam/operations/users/get).
         * Maps to using `id="*"` value for `x-amz-grant-*` header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput)
         * method of Amazon S3-compatible HTTP API).
         * </pre>
         *
         * <code>GRANT_TYPE_ACCOUNT = 1;</code>
         */
        public static final int GRANT_TYPE_ACCOUNT_VALUE = 1;
        /**
         * <pre>
         * Grantees are all authenticated users, both from your clouds and other users' clouds. Access
         * permission to this group allows any account on the platform to access the resource via a signed (authenticated)
         * request.
         * Maps to using `uri="http://acs.amazonaws.com/groups/global/AuthenticatedUsers"` value for `x-amz-grant-*`
         * header ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
         * </pre>
         *
         * <code>GRANT_TYPE_ALL_AUTHENTICATED_USERS = 2;</code>
         */
        public static final int GRANT_TYPE_ALL_AUTHENTICATED_USERS_VALUE = 2;
        /**
         * <pre>
         * Grantees are all internet users. Access permission to this group allows anyone in the world access to the
         * resource via signed (authenticated) or unsigned (anonymous) requests.
         * Maps to using `uri="http://acs.amazonaws.com/groups/global/AllUsers"` value for `x-amz-grant-*` header
         * ([bucketPutAcl](/docs/storage/s3/api-ref/acl/bucketput) method of Amazon S3-compatible HTTP API).
         * </pre>
         *
         * <code>GRANT_TYPE_ALL_USERS = 3;</code>
         */
        public static final int GRANT_TYPE_ALL_USERS_VALUE = 3;


        public final int getNumber() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalArgumentException(
                "Can't get the number of an unknown enum value.");
          }
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static GrantType valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static GrantType forNumber(int value) {
          switch (value) {
            case 0: return GRANT_TYPE_UNSPECIFIED;
            case 1: return GRANT_TYPE_ACCOUNT;
            case 2: return GRANT_TYPE_ALL_AUTHENTICATED_USERS;
            case 3: return GRANT_TYPE_ALL_USERS;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<GrantType>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            GrantType> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<GrantType>() {
                public GrantType findValueByNumber(int number) {
                  return GrantType.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          if (this == UNRECOGNIZED) {
            throw new java.lang.IllegalStateException(
                "Can't get the descriptor of an unrecognized enum value.");
          }
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.getDescriptor().getEnumTypes().get(1);
        }

        private static final GrantType[] VALUES = values();

        public static GrantType valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          if (desc.getIndex() == -1) {
            return UNRECOGNIZED;
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private GrantType(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:yandex.cloud.storage.v1.ACL.Grant.GrantType)
      }

      public static final int PERMISSION_FIELD_NUMBER = 1;
      private int permission_;
      /**
       * <pre>
       * Permission granted by the grant.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
       * @return The enum numeric value on the wire for permission.
       */
      @java.lang.Override public int getPermissionValue() {
        return permission_;
      }
      /**
       * <pre>
       * Permission granted by the grant.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
       * @return The permission.
       */
      @java.lang.Override public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission getPermission() {
        @SuppressWarnings("deprecation")
        yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission result = yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission.valueOf(permission_);
        return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission.UNRECOGNIZED : result;
      }

      public static final int GRANT_TYPE_FIELD_NUMBER = 2;
      private int grantType_;
      /**
       * <pre>
       * The grantee type for the grant.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
       * @return The enum numeric value on the wire for grantType.
       */
      @java.lang.Override public int getGrantTypeValue() {
        return grantType_;
      }
      /**
       * <pre>
       * The grantee type for the grant.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
       * @return The grantType.
       */
      @java.lang.Override public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType getGrantType() {
        @SuppressWarnings("deprecation")
        yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType result = yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType.valueOf(grantType_);
        return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType.UNRECOGNIZED : result;
      }

      public static final int GRANTEE_ID_FIELD_NUMBER = 3;
      private volatile java.lang.Object granteeId_;
      /**
       * <pre>
       * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
       * </pre>
       *
       * <code>string grantee_id = 3;</code>
       * @return The granteeId.
       */
      @java.lang.Override
      public java.lang.String getGranteeId() {
        java.lang.Object ref = granteeId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          granteeId_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
       * </pre>
       *
       * <code>string grantee_id = 3;</code>
       * @return The bytes for granteeId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getGranteeIdBytes() {
        java.lang.Object ref = granteeId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          granteeId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (permission_ != yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission.PERMISSION_UNSPECIFIED.getNumber()) {
          output.writeEnum(1, permission_);
        }
        if (grantType_ != yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType.GRANT_TYPE_UNSPECIFIED.getNumber()) {
          output.writeEnum(2, grantType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(granteeId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, granteeId_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (permission_ != yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission.PERMISSION_UNSPECIFIED.getNumber()) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(1, permission_);
        }
        if (grantType_ != yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType.GRANT_TYPE_UNSPECIFIED.getNumber()) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(2, grantType_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(granteeId_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, granteeId_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant other = (yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant) obj;

        if (permission_ != other.permission_) return false;
        if (grantType_ != other.grantType_) return false;
        if (!getGranteeId()
            .equals(other.getGranteeId())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PERMISSION_FIELD_NUMBER;
        hash = (53 * hash) + permission_;
        hash = (37 * hash) + GRANT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + grantType_;
        hash = (37 * hash) + GRANTEE_ID_FIELD_NUMBER;
        hash = (53 * hash) + getGranteeId().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * A grant resource, used to specify the permission granted and the grantee.
       * </pre>
       *
       * Protobuf type {@code yandex.cloud.storage.v1.ACL.Grant}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.ACL.Grant)
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_Grant_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_Grant_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.class, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          permission_ = 0;

          grantType_ = 0;

          granteeId_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_Grant_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant result = new yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant(this);
          result.permission_ = permission_;
          result.grantType_ = grantType_;
          result.granteeId_ = granteeId_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.getDefaultInstance()) return this;
          if (other.permission_ != 0) {
            setPermissionValue(other.getPermissionValue());
          }
          if (other.grantType_ != 0) {
            setGrantTypeValue(other.getGrantTypeValue());
          }
          if (!other.getGranteeId().isEmpty()) {
            granteeId_ = other.granteeId_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int permission_ = 0;
        /**
         * <pre>
         * Permission granted by the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
         * @return The enum numeric value on the wire for permission.
         */
        @java.lang.Override public int getPermissionValue() {
          return permission_;
        }
        /**
         * <pre>
         * Permission granted by the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
         * @param value The enum numeric value on the wire for permission to set.
         * @return This builder for chaining.
         */
        public Builder setPermissionValue(int value) {
          
          permission_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Permission granted by the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
         * @return The permission.
         */
        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission getPermission() {
          @SuppressWarnings("deprecation")
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission result = yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission.valueOf(permission_);
          return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission.UNRECOGNIZED : result;
        }
        /**
         * <pre>
         * Permission granted by the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
         * @param value The permission to set.
         * @return This builder for chaining.
         */
        public Builder setPermission(yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Permission value) {
          if (value == null) {
            throw new NullPointerException();
          }
          
          permission_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Permission granted by the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.Permission permission = 1 [(.yandex.cloud.required) = true];</code>
         * @return This builder for chaining.
         */
        public Builder clearPermission() {
          
          permission_ = 0;
          onChanged();
          return this;
        }

        private int grantType_ = 0;
        /**
         * <pre>
         * The grantee type for the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
         * @return The enum numeric value on the wire for grantType.
         */
        @java.lang.Override public int getGrantTypeValue() {
          return grantType_;
        }
        /**
         * <pre>
         * The grantee type for the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
         * @param value The enum numeric value on the wire for grantType to set.
         * @return This builder for chaining.
         */
        public Builder setGrantTypeValue(int value) {
          
          grantType_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The grantee type for the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
         * @return The grantType.
         */
        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType getGrantType() {
          @SuppressWarnings("deprecation")
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType result = yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType.valueOf(grantType_);
          return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType.UNRECOGNIZED : result;
        }
        /**
         * <pre>
         * The grantee type for the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
         * @param value The grantType to set.
         * @return This builder for chaining.
         */
        public Builder setGrantType(yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.GrantType value) {
          if (value == null) {
            throw new NullPointerException();
          }
          
          grantType_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The grantee type for the grant.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.ACL.Grant.GrantType grant_type = 2 [(.yandex.cloud.required) = true];</code>
         * @return This builder for chaining.
         */
        public Builder clearGrantType() {
          
          grantType_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object granteeId_ = "";
        /**
         * <pre>
         * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
         * </pre>
         *
         * <code>string grantee_id = 3;</code>
         * @return The granteeId.
         */
        public java.lang.String getGranteeId() {
          java.lang.Object ref = granteeId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            granteeId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
         * </pre>
         *
         * <code>string grantee_id = 3;</code>
         * @return The bytes for granteeId.
         */
        public com.google.protobuf.ByteString
            getGranteeIdBytes() {
          java.lang.Object ref = granteeId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            granteeId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
         * </pre>
         *
         * <code>string grantee_id = 3;</code>
         * @param value The granteeId to set.
         * @return This builder for chaining.
         */
        public Builder setGranteeId(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          granteeId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
         * </pre>
         *
         * <code>string grantee_id = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearGranteeId() {
          
          granteeId_ = getDefaultInstance().getGranteeId();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * ID of the account who is a grantee. Required when the [grant_type] is `GRANT_TYPE_ACCOUNT`.
         * </pre>
         *
         * <code>string grantee_id = 3;</code>
         * @param value The bytes for granteeId to set.
         * @return This builder for chaining.
         */
        public Builder setGranteeIdBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          granteeId_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.ACL.Grant)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.ACL.Grant)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Grant>
          PARSER = new com.google.protobuf.AbstractParser<Grant>() {
        @java.lang.Override
        public Grant parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Grant(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Grant> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Grant> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int GRANTS_FIELD_NUMBER = 1;
    private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant> grants_;
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    @java.lang.Override
    public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant> getGrantsList() {
      return grants_;
    }
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder> 
        getGrantsOrBuilderList() {
      return grants_;
    }
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    @java.lang.Override
    public int getGrantsCount() {
      return grants_.size();
    }
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant getGrants(int index) {
      return grants_.get(index);
    }
    /**
     * <pre>
     * List of permissions granted and the grantees.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder getGrantsOrBuilder(
        int index) {
      return grants_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < grants_.size(); i++) {
        output.writeMessage(1, grants_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < grants_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, grants_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.ACL)) {
        return super.equals(obj);
      }
      yandex.cloud.api.storage.v1.BucketOuterClass.ACL other = (yandex.cloud.api.storage.v1.BucketOuterClass.ACL) obj;

      if (!getGrantsList()
          .equals(other.getGrantsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getGrantsCount() > 0) {
        hash = (37 * hash) + GRANTS_FIELD_NUMBER;
        hash = (53 * hash) + getGrantsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.ACL prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.ACL}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.ACL)
        yandex.cloud.api.storage.v1.BucketOuterClass.ACLOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.ACL.class, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Builder.class);
      }

      // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.ACL.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getGrantsFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (grantsBuilder_ == null) {
          grants_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          grantsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_ACL_descriptor;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL getDefaultInstanceForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.ACL.getDefaultInstance();
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL build() {
        yandex.cloud.api.storage.v1.BucketOuterClass.ACL result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL buildPartial() {
        yandex.cloud.api.storage.v1.BucketOuterClass.ACL result = new yandex.cloud.api.storage.v1.BucketOuterClass.ACL(this);
        int from_bitField0_ = bitField0_;
        if (grantsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            grants_ = java.util.Collections.unmodifiableList(grants_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.grants_ = grants_;
        } else {
          result.grants_ = grantsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.ACL) {
          return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.ACL)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.ACL other) {
        if (other == yandex.cloud.api.storage.v1.BucketOuterClass.ACL.getDefaultInstance()) return this;
        if (grantsBuilder_ == null) {
          if (!other.grants_.isEmpty()) {
            if (grants_.isEmpty()) {
              grants_ = other.grants_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureGrantsIsMutable();
              grants_.addAll(other.grants_);
            }
            onChanged();
          }
        } else {
          if (!other.grants_.isEmpty()) {
            if (grantsBuilder_.isEmpty()) {
              grantsBuilder_.dispose();
              grantsBuilder_ = null;
              grants_ = other.grants_;
              bitField0_ = (bitField0_ & ~0x00000001);
              grantsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getGrantsFieldBuilder() : null;
            } else {
              grantsBuilder_.addAllMessages(other.grants_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        yandex.cloud.api.storage.v1.BucketOuterClass.ACL parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.ACL) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant> grants_ =
        java.util.Collections.emptyList();
      private void ensureGrantsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          grants_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant>(grants_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder> grantsBuilder_;

      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant> getGrantsList() {
        if (grantsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(grants_);
        } else {
          return grantsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public int getGrantsCount() {
        if (grantsBuilder_ == null) {
          return grants_.size();
        } else {
          return grantsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant getGrants(int index) {
        if (grantsBuilder_ == null) {
          return grants_.get(index);
        } else {
          return grantsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder setGrants(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant value) {
        if (grantsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGrantsIsMutable();
          grants_.set(index, value);
          onChanged();
        } else {
          grantsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder setGrants(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder builderForValue) {
        if (grantsBuilder_ == null) {
          ensureGrantsIsMutable();
          grants_.set(index, builderForValue.build());
          onChanged();
        } else {
          grantsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder addGrants(yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant value) {
        if (grantsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGrantsIsMutable();
          grants_.add(value);
          onChanged();
        } else {
          grantsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder addGrants(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant value) {
        if (grantsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureGrantsIsMutable();
          grants_.add(index, value);
          onChanged();
        } else {
          grantsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder addGrants(
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder builderForValue) {
        if (grantsBuilder_ == null) {
          ensureGrantsIsMutable();
          grants_.add(builderForValue.build());
          onChanged();
        } else {
          grantsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder addGrants(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder builderForValue) {
        if (grantsBuilder_ == null) {
          ensureGrantsIsMutable();
          grants_.add(index, builderForValue.build());
          onChanged();
        } else {
          grantsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder addAllGrants(
          java.lang.Iterable<? extends yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant> values) {
        if (grantsBuilder_ == null) {
          ensureGrantsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, grants_);
          onChanged();
        } else {
          grantsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder clearGrants() {
        if (grantsBuilder_ == null) {
          grants_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          grantsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public Builder removeGrants(int index) {
        if (grantsBuilder_ == null) {
          ensureGrantsIsMutable();
          grants_.remove(index);
          onChanged();
        } else {
          grantsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder getGrantsBuilder(
          int index) {
        return getGrantsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder getGrantsOrBuilder(
          int index) {
        if (grantsBuilder_ == null) {
          return grants_.get(index);  } else {
          return grantsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder> 
           getGrantsOrBuilderList() {
        if (grantsBuilder_ != null) {
          return grantsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(grants_);
        }
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder addGrantsBuilder() {
        return getGrantsFieldBuilder().addBuilder(
            yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.getDefaultInstance());
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder addGrantsBuilder(
          int index) {
        return getGrantsFieldBuilder().addBuilder(
            index, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.getDefaultInstance());
      }
      /**
       * <pre>
       * List of permissions granted and the grantees.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.ACL.Grant grants = 1;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder> 
           getGrantsBuilderList() {
        return getGrantsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder> 
          getGrantsFieldBuilder() {
        if (grantsBuilder_ == null) {
          grantsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.Grant.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.ACL.GrantOrBuilder>(
                  grants_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          grants_ = null;
        }
        return grantsBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.ACL)
    }

    // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.ACL)
    private static final yandex.cloud.api.storage.v1.BucketOuterClass.ACL DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.ACL();
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.ACL getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ACL>
        PARSER = new com.google.protobuf.AbstractParser<ACL>() {
      @java.lang.Override
      public ACL parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ACL(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ACL> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ACL> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.ACL getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AnonymousAccessFlagsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.AnonymousAccessFlags)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue read = 1;</code>
     * @return Whether the read field is set.
     */
    boolean hasRead();
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue read = 1;</code>
     * @return The read.
     */
    com.google.protobuf.BoolValue getRead();
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue read = 1;</code>
     */
    com.google.protobuf.BoolValueOrBuilder getReadOrBuilder();

    /**
     * <pre>
     * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue list = 2;</code>
     * @return Whether the list field is set.
     */
    boolean hasList();
    /**
     * <pre>
     * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue list = 2;</code>
     * @return The list.
     */
    com.google.protobuf.BoolValue getList();
    /**
     * <pre>
     * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue list = 2;</code>
     */
    com.google.protobuf.BoolValueOrBuilder getListOrBuilder();

    /**
     * <pre>
     * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
     * [static website hosting](/docs/storage/concepts/hosting), and
     * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue config_read = 3;</code>
     * @return Whether the configRead field is set.
     */
    boolean hasConfigRead();
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
     * [static website hosting](/docs/storage/concepts/hosting), and
     * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue config_read = 3;</code>
     * @return The configRead.
     */
    com.google.protobuf.BoolValue getConfigRead();
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
     * [static website hosting](/docs/storage/concepts/hosting), and
     * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue config_read = 3;</code>
     */
    com.google.protobuf.BoolValueOrBuilder getConfigReadOrBuilder();
  }
  /**
   * Protobuf type {@code yandex.cloud.storage.v1.AnonymousAccessFlags}
   */
  public static final class AnonymousAccessFlags extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.AnonymousAccessFlags)
      AnonymousAccessFlagsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AnonymousAccessFlags.newBuilder() to construct.
    private AnonymousAccessFlags(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AnonymousAccessFlags() {
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new AnonymousAccessFlags();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private AnonymousAccessFlags(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.BoolValue.Builder subBuilder = null;
              if (read_ != null) {
                subBuilder = read_.toBuilder();
              }
              read_ = input.readMessage(com.google.protobuf.BoolValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(read_);
                read_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              com.google.protobuf.BoolValue.Builder subBuilder = null;
              if (list_ != null) {
                subBuilder = list_.toBuilder();
              }
              list_ = input.readMessage(com.google.protobuf.BoolValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(list_);
                list_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              com.google.protobuf.BoolValue.Builder subBuilder = null;
              if (configRead_ != null) {
                subBuilder = configRead_.toBuilder();
              }
              configRead_ = input.readMessage(com.google.protobuf.BoolValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(configRead_);
                configRead_ = subBuilder.buildPartial();
              }

              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_AnonymousAccessFlags_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_AnonymousAccessFlags_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.class, yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.Builder.class);
    }

    public static final int READ_FIELD_NUMBER = 1;
    private com.google.protobuf.BoolValue read_;
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue read = 1;</code>
     * @return Whether the read field is set.
     */
    @java.lang.Override
    public boolean hasRead() {
      return read_ != null;
    }
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue read = 1;</code>
     * @return The read.
     */
    @java.lang.Override
    public com.google.protobuf.BoolValue getRead() {
      return read_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : read_;
    }
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue read = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.BoolValueOrBuilder getReadOrBuilder() {
      return getRead();
    }

    public static final int LIST_FIELD_NUMBER = 2;
    private com.google.protobuf.BoolValue list_;
    /**
     * <pre>
     * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue list = 2;</code>
     * @return Whether the list field is set.
     */
    @java.lang.Override
    public boolean hasList() {
      return list_ != null;
    }
    /**
     * <pre>
     * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue list = 2;</code>
     * @return The list.
     */
    @java.lang.Override
    public com.google.protobuf.BoolValue getList() {
      return list_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : list_;
    }
    /**
     * <pre>
     * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue list = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.BoolValueOrBuilder getListOrBuilder() {
      return getList();
    }

    public static final int CONFIG_READ_FIELD_NUMBER = 3;
    private com.google.protobuf.BoolValue configRead_;
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
     * [static website hosting](/docs/storage/concepts/hosting), and
     * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue config_read = 3;</code>
     * @return Whether the configRead field is set.
     */
    @java.lang.Override
    public boolean hasConfigRead() {
      return configRead_ != null;
    }
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
     * [static website hosting](/docs/storage/concepts/hosting), and
     * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue config_read = 3;</code>
     * @return The configRead.
     */
    @java.lang.Override
    public com.google.protobuf.BoolValue getConfigRead() {
      return configRead_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : configRead_;
    }
    /**
     * <pre>
     * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
     * [static website hosting](/docs/storage/concepts/hosting), and
     * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
     * </pre>
     *
     * <code>.google.protobuf.BoolValue config_read = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.BoolValueOrBuilder getConfigReadOrBuilder() {
      return getConfigRead();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (read_ != null) {
        output.writeMessage(1, getRead());
      }
      if (list_ != null) {
        output.writeMessage(2, getList());
      }
      if (configRead_ != null) {
        output.writeMessage(3, getConfigRead());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (read_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getRead());
      }
      if (list_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getList());
      }
      if (configRead_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getConfigRead());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags)) {
        return super.equals(obj);
      }
      yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags other = (yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags) obj;

      if (hasRead() != other.hasRead()) return false;
      if (hasRead()) {
        if (!getRead()
            .equals(other.getRead())) return false;
      }
      if (hasList() != other.hasList()) return false;
      if (hasList()) {
        if (!getList()
            .equals(other.getList())) return false;
      }
      if (hasConfigRead() != other.hasConfigRead()) return false;
      if (hasConfigRead()) {
        if (!getConfigRead()
            .equals(other.getConfigRead())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRead()) {
        hash = (37 * hash) + READ_FIELD_NUMBER;
        hash = (53 * hash) + getRead().hashCode();
      }
      if (hasList()) {
        hash = (37 * hash) + LIST_FIELD_NUMBER;
        hash = (53 * hash) + getList().hashCode();
      }
      if (hasConfigRead()) {
        hash = (37 * hash) + CONFIG_READ_FIELD_NUMBER;
        hash = (53 * hash) + getConfigRead().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.AnonymousAccessFlags}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.AnonymousAccessFlags)
        yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlagsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_AnonymousAccessFlags_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_AnonymousAccessFlags_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.class, yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.Builder.class);
      }

      // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (readBuilder_ == null) {
          read_ = null;
        } else {
          read_ = null;
          readBuilder_ = null;
        }
        if (listBuilder_ == null) {
          list_ = null;
        } else {
          list_ = null;
          listBuilder_ = null;
        }
        if (configReadBuilder_ == null) {
          configRead_ = null;
        } else {
          configRead_ = null;
          configReadBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_AnonymousAccessFlags_descriptor;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags getDefaultInstanceForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.getDefaultInstance();
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags build() {
        yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags buildPartial() {
        yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags result = new yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags(this);
        if (readBuilder_ == null) {
          result.read_ = read_;
        } else {
          result.read_ = readBuilder_.build();
        }
        if (listBuilder_ == null) {
          result.list_ = list_;
        } else {
          result.list_ = listBuilder_.build();
        }
        if (configReadBuilder_ == null) {
          result.configRead_ = configRead_;
        } else {
          result.configRead_ = configReadBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags) {
          return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags other) {
        if (other == yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags.getDefaultInstance()) return this;
        if (other.hasRead()) {
          mergeRead(other.getRead());
        }
        if (other.hasList()) {
          mergeList(other.getList());
        }
        if (other.hasConfigRead()) {
          mergeConfigRead(other.getConfigRead());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.protobuf.BoolValue read_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder> readBuilder_;
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       * @return Whether the read field is set.
       */
      public boolean hasRead() {
        return readBuilder_ != null || read_ != null;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       * @return The read.
       */
      public com.google.protobuf.BoolValue getRead() {
        if (readBuilder_ == null) {
          return read_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : read_;
        } else {
          return readBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       */
      public Builder setRead(com.google.protobuf.BoolValue value) {
        if (readBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          read_ = value;
          onChanged();
        } else {
          readBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       */
      public Builder setRead(
          com.google.protobuf.BoolValue.Builder builderForValue) {
        if (readBuilder_ == null) {
          read_ = builderForValue.build();
          onChanged();
        } else {
          readBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       */
      public Builder mergeRead(com.google.protobuf.BoolValue value) {
        if (readBuilder_ == null) {
          if (read_ != null) {
            read_ =
              com.google.protobuf.BoolValue.newBuilder(read_).mergeFrom(value).buildPartial();
          } else {
            read_ = value;
          }
          onChanged();
        } else {
          readBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       */
      public Builder clearRead() {
        if (readBuilder_ == null) {
          read_ = null;
          onChanged();
        } else {
          read_ = null;
          readBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       */
      public com.google.protobuf.BoolValue.Builder getReadBuilder() {
        
        onChanged();
        return getReadFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       */
      public com.google.protobuf.BoolValueOrBuilder getReadOrBuilder() {
        if (readBuilder_ != null) {
          return readBuilder_.getMessageOrBuilder();
        } else {
          return read_ == null ?
              com.google.protobuf.BoolValue.getDefaultInstance() : read_;
        }
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue read = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder> 
          getReadFieldBuilder() {
        if (readBuilder_ == null) {
          readBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder>(
                  getRead(),
                  getParentForChildren(),
                  isClean());
          read_ = null;
        }
        return readBuilder_;
      }

      private com.google.protobuf.BoolValue list_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder> listBuilder_;
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       * @return Whether the list field is set.
       */
      public boolean hasList() {
        return listBuilder_ != null || list_ != null;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       * @return The list.
       */
      public com.google.protobuf.BoolValue getList() {
        if (listBuilder_ == null) {
          return list_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : list_;
        } else {
          return listBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       */
      public Builder setList(com.google.protobuf.BoolValue value) {
        if (listBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          list_ = value;
          onChanged();
        } else {
          listBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       */
      public Builder setList(
          com.google.protobuf.BoolValue.Builder builderForValue) {
        if (listBuilder_ == null) {
          list_ = builderForValue.build();
          onChanged();
        } else {
          listBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       */
      public Builder mergeList(com.google.protobuf.BoolValue value) {
        if (listBuilder_ == null) {
          if (list_ != null) {
            list_ =
              com.google.protobuf.BoolValue.newBuilder(list_).mergeFrom(value).buildPartial();
          } else {
            list_ = value;
          }
          onChanged();
        } else {
          listBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       */
      public Builder clearList() {
        if (listBuilder_ == null) {
          list_ = null;
          onChanged();
        } else {
          list_ = null;
          listBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       */
      public com.google.protobuf.BoolValue.Builder getListBuilder() {
        
        onChanged();
        return getListFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       */
      public com.google.protobuf.BoolValueOrBuilder getListOrBuilder() {
        if (listBuilder_ != null) {
          return listBuilder_.getMessageOrBuilder();
        } else {
          return list_ == null ?
              com.google.protobuf.BoolValue.getDefaultInstance() : list_;
        }
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to the list of objects in the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue list = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder> 
          getListFieldBuilder() {
        if (listBuilder_ == null) {
          listBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder>(
                  getList(),
                  getParentForChildren(),
                  isClean());
          list_ = null;
        }
        return listBuilder_;
      }

      private com.google.protobuf.BoolValue configRead_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder> configReadBuilder_;
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       * @return Whether the configRead field is set.
       */
      public boolean hasConfigRead() {
        return configReadBuilder_ != null || configRead_ != null;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       * @return The configRead.
       */
      public com.google.protobuf.BoolValue getConfigRead() {
        if (configReadBuilder_ == null) {
          return configRead_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : configRead_;
        } else {
          return configReadBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       */
      public Builder setConfigRead(com.google.protobuf.BoolValue value) {
        if (configReadBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          configRead_ = value;
          onChanged();
        } else {
          configReadBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       */
      public Builder setConfigRead(
          com.google.protobuf.BoolValue.Builder builderForValue) {
        if (configReadBuilder_ == null) {
          configRead_ = builderForValue.build();
          onChanged();
        } else {
          configReadBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       */
      public Builder mergeConfigRead(com.google.protobuf.BoolValue value) {
        if (configReadBuilder_ == null) {
          if (configRead_ != null) {
            configRead_ =
              com.google.protobuf.BoolValue.newBuilder(configRead_).mergeFrom(value).buildPartial();
          } else {
            configRead_ = value;
          }
          onChanged();
        } else {
          configReadBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       */
      public Builder clearConfigRead() {
        if (configReadBuilder_ == null) {
          configRead_ = null;
          onChanged();
        } else {
          configRead_ = null;
          configReadBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       */
      public com.google.protobuf.BoolValue.Builder getConfigReadBuilder() {
        
        onChanged();
        return getConfigReadFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       */
      public com.google.protobuf.BoolValueOrBuilder getConfigReadOrBuilder() {
        if (configReadBuilder_ != null) {
          return configReadBuilder_.getMessageOrBuilder();
        } else {
          return configRead_ == null ?
              com.google.protobuf.BoolValue.getDefaultInstance() : configRead_;
        }
      }
      /**
       * <pre>
       * Specifies whether public (anonymous) access to read [CORS](/docs/storage/concepts/cors),
       * [static website hosting](/docs/storage/concepts/hosting), and
       * [object lifecycles](/docs/storage/concepts/lifecycles) settings of the bucket is enabled.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue config_read = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder> 
          getConfigReadFieldBuilder() {
        if (configReadBuilder_ == null) {
          configReadBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder>(
                  getConfigRead(),
                  getParentForChildren(),
                  isClean());
          configRead_ = null;
        }
        return configReadBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.AnonymousAccessFlags)
    }

    // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.AnonymousAccessFlags)
    private static final yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags();
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnonymousAccessFlags>
        PARSER = new com.google.protobuf.AbstractParser<AnonymousAccessFlags>() {
      @java.lang.Override
      public AnonymousAccessFlags parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new AnonymousAccessFlags(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<AnonymousAccessFlags> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnonymousAccessFlags> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.AnonymousAccessFlags getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CorsRuleOrBuilder extends
      // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.CorsRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID of the CORS rule.
     * </pre>
     *
     * <code>string id = 1;</code>
     * @return The id.
     */
    java.lang.String getId();
    /**
     * <pre>
     * ID of the CORS rule.
     * </pre>
     *
     * <code>string id = 1;</code>
     * @return The bytes for id.
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @return A list containing the allowedMethods.
     */
    java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method> getAllowedMethodsList();
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @return The count of allowedMethods.
     */
    int getAllowedMethodsCount();
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @param index The index of the element to return.
     * @return The allowedMethods at the given index.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method getAllowedMethods(int index);
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @return A list containing the enum numeric values on the wire for allowedMethods.
     */
    java.util.List<java.lang.Integer>
    getAllowedMethodsValueList();
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of allowedMethods at the given index.
     */
    int getAllowedMethodsValue(int index);

    /**
     * <pre>
     * List of HTTP headers allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
     * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
     * `Access-Control-Allow-Headers` header of the response.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
     * </pre>
     *
     * <code>repeated string allowed_headers = 3;</code>
     * @return A list containing the allowedHeaders.
     */
    java.util.List<java.lang.String>
        getAllowedHeadersList();
    /**
     * <pre>
     * List of HTTP headers allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
     * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
     * `Access-Control-Allow-Headers` header of the response.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
     * </pre>
     *
     * <code>repeated string allowed_headers = 3;</code>
     * @return The count of allowedHeaders.
     */
    int getAllowedHeadersCount();
    /**
     * <pre>
     * List of HTTP headers allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
     * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
     * `Access-Control-Allow-Headers` header of the response.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
     * </pre>
     *
     * <code>repeated string allowed_headers = 3;</code>
     * @param index The index of the element to return.
     * @return The allowedHeaders at the given index.
     */
    java.lang.String getAllowedHeaders(int index);
    /**
     * <pre>
     * List of HTTP headers allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
     * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
     * `Access-Control-Allow-Headers` header of the response.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
     * </pre>
     *
     * <code>repeated string allowed_headers = 3;</code>
     * @param index The index of the value to return.
     * @return The bytes of the allowedHeaders at the given index.
     */
    com.google.protobuf.ByteString
        getAllowedHeadersBytes(int index);

    /**
     * <pre>
     * List of request origins allowed by the CORS rule.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
     * </pre>
     *
     * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
     * @return A list containing the allowedOrigins.
     */
    java.util.List<java.lang.String>
        getAllowedOriginsList();
    /**
     * <pre>
     * List of request origins allowed by the CORS rule.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
     * </pre>
     *
     * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
     * @return The count of allowedOrigins.
     */
    int getAllowedOriginsCount();
    /**
     * <pre>
     * List of request origins allowed by the CORS rule.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
     * </pre>
     *
     * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
     * @param index The index of the element to return.
     * @return The allowedOrigins at the given index.
     */
    java.lang.String getAllowedOrigins(int index);
    /**
     * <pre>
     * List of request origins allowed by the CORS rule.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
     * </pre>
     *
     * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
     * @param index The index of the value to return.
     * @return The bytes of the allowedOrigins at the given index.
     */
    com.google.protobuf.ByteString
        getAllowedOriginsBytes(int index);

    /**
     * <pre>
     * List of headers contained in responses to CORS requests that can be accessed by applications.
     * </pre>
     *
     * <code>repeated string expose_headers = 5;</code>
     * @return A list containing the exposeHeaders.
     */
    java.util.List<java.lang.String>
        getExposeHeadersList();
    /**
     * <pre>
     * List of headers contained in responses to CORS requests that can be accessed by applications.
     * </pre>
     *
     * <code>repeated string expose_headers = 5;</code>
     * @return The count of exposeHeaders.
     */
    int getExposeHeadersCount();
    /**
     * <pre>
     * List of headers contained in responses to CORS requests that can be accessed by applications.
     * </pre>
     *
     * <code>repeated string expose_headers = 5;</code>
     * @param index The index of the element to return.
     * @return The exposeHeaders at the given index.
     */
    java.lang.String getExposeHeaders(int index);
    /**
     * <pre>
     * List of headers contained in responses to CORS requests that can be accessed by applications.
     * </pre>
     *
     * <code>repeated string expose_headers = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the exposeHeaders at the given index.
     */
    com.google.protobuf.ByteString
        getExposeHeadersBytes(int index);

    /**
     * <pre>
     * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
     * object requested, the HTTP method, and the origin.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
     * @return Whether the maxAgeSeconds field is set.
     */
    boolean hasMaxAgeSeconds();
    /**
     * <pre>
     * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
     * object requested, the HTTP method, and the origin.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
     * @return The maxAgeSeconds.
     */
    com.google.protobuf.Int64Value getMaxAgeSeconds();
    /**
     * <pre>
     * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
     * object requested, the HTTP method, and the origin.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
     */
    com.google.protobuf.Int64ValueOrBuilder getMaxAgeSecondsOrBuilder();
  }
  /**
   * <pre>
   * A CORS rule resource.
   * For details about the concept, see [documentation](/docs/storage/concepts/cors).
   * </pre>
   *
   * Protobuf type {@code yandex.cloud.storage.v1.CorsRule}
   */
  public static final class CorsRule extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.CorsRule)
      CorsRuleOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use CorsRule.newBuilder() to construct.
    private CorsRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private CorsRule() {
      id_ = "";
      allowedMethods_ = java.util.Collections.emptyList();
      allowedHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      allowedOrigins_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      exposeHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new CorsRule();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private CorsRule(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                allowedMethods_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000001;
              }
              allowedMethods_.add(rawValue);
              break;
            }
            case 18: {
              int length = input.readRawVarint32();
              int oldLimit = input.pushLimit(length);
              while(input.getBytesUntilLimit() > 0) {
                int rawValue = input.readEnum();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  allowedMethods_ = new java.util.ArrayList<java.lang.Integer>();
                  mutable_bitField0_ |= 0x00000001;
                }
                allowedMethods_.add(rawValue);
              }
              input.popLimit(oldLimit);
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                allowedHeaders_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              allowedHeaders_.add(s);
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                allowedOrigins_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              allowedOrigins_.add(s);
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                exposeHeaders_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              exposeHeaders_.add(s);
              break;
            }
            case 50: {
              com.google.protobuf.Int64Value.Builder subBuilder = null;
              if (maxAgeSeconds_ != null) {
                subBuilder = maxAgeSeconds_.toBuilder();
              }
              maxAgeSeconds_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(maxAgeSeconds_);
                maxAgeSeconds_ = subBuilder.buildPartial();
              }

              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          allowedMethods_ = java.util.Collections.unmodifiableList(allowedMethods_);
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          allowedHeaders_ = allowedHeaders_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          allowedOrigins_ = allowedOrigins_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000008) != 0)) {
          exposeHeaders_ = exposeHeaders_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_CorsRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_CorsRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.class, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder.class);
    }

    /**
     * <pre>
     * List of HTTP methods that are allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against the
     * list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * Protobuf enum {@code yandex.cloud.storage.v1.CorsRule.Method}
     */
    public enum Method
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>METHOD_UNSPECIFIED = 0;</code>
       */
      METHOD_UNSPECIFIED(0),
      /**
       * <pre>
       * HTTP `GET` method.
       * </pre>
       *
       * <code>METHOD_GET = 1;</code>
       */
      METHOD_GET(1),
      /**
       * <pre>
       * HTTP `HEAD` method.
       * </pre>
       *
       * <code>METHOD_HEAD = 2;</code>
       */
      METHOD_HEAD(2),
      /**
       * <pre>
       * HTTP `POST` method.
       * </pre>
       *
       * <code>METHOD_POST = 3;</code>
       */
      METHOD_POST(3),
      /**
       * <pre>
       * HTTP `PUT` method.
       * </pre>
       *
       * <code>METHOD_PUT = 4;</code>
       */
      METHOD_PUT(4),
      /**
       * <pre>
       * HTTP `DELETE` method.
       * </pre>
       *
       * <code>METHOD_DELETE = 5;</code>
       */
      METHOD_DELETE(5),
      UNRECOGNIZED(-1),
      ;

      /**
       * <code>METHOD_UNSPECIFIED = 0;</code>
       */
      public static final int METHOD_UNSPECIFIED_VALUE = 0;
      /**
       * <pre>
       * HTTP `GET` method.
       * </pre>
       *
       * <code>METHOD_GET = 1;</code>
       */
      public static final int METHOD_GET_VALUE = 1;
      /**
       * <pre>
       * HTTP `HEAD` method.
       * </pre>
       *
       * <code>METHOD_HEAD = 2;</code>
       */
      public static final int METHOD_HEAD_VALUE = 2;
      /**
       * <pre>
       * HTTP `POST` method.
       * </pre>
       *
       * <code>METHOD_POST = 3;</code>
       */
      public static final int METHOD_POST_VALUE = 3;
      /**
       * <pre>
       * HTTP `PUT` method.
       * </pre>
       *
       * <code>METHOD_PUT = 4;</code>
       */
      public static final int METHOD_PUT_VALUE = 4;
      /**
       * <pre>
       * HTTP `DELETE` method.
       * </pre>
       *
       * <code>METHOD_DELETE = 5;</code>
       */
      public static final int METHOD_DELETE_VALUE = 5;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Method valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Method forNumber(int value) {
        switch (value) {
          case 0: return METHOD_UNSPECIFIED;
          case 1: return METHOD_GET;
          case 2: return METHOD_HEAD;
          case 3: return METHOD_POST;
          case 4: return METHOD_PUT;
          case 5: return METHOD_DELETE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Method>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Method> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Method>() {
              public Method findValueByNumber(int number) {
                return Method.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.getDescriptor().getEnumTypes().get(0);
      }

      private static final Method[] VALUES = values();

      public static Method valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Method(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:yandex.cloud.storage.v1.CorsRule.Method)
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * ID of the CORS rule.
     * </pre>
     *
     * <code>string id = 1;</code>
     * @return The id.
     */
    @java.lang.Override
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID of the CORS rule.
     * </pre>
     *
     * <code>string id = 1;</code>
     * @return The bytes for id.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOWED_METHODS_FIELD_NUMBER = 2;
    private java.util.List<java.lang.Integer> allowedMethods_;
    private static final com.google.protobuf.Internal.ListAdapter.Converter<
        java.lang.Integer, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method> allowedMethods_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method>() {
              public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method convert(java.lang.Integer from) {
                @SuppressWarnings("deprecation")
                yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method result = yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method.valueOf(from);
                return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method.UNRECOGNIZED : result;
              }
            };
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @return A list containing the allowedMethods.
     */
    @java.lang.Override
    public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method> getAllowedMethodsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method>(allowedMethods_, allowedMethods_converter_);
    }
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @return The count of allowedMethods.
     */
    @java.lang.Override
    public int getAllowedMethodsCount() {
      return allowedMethods_.size();
    }
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @param index The index of the element to return.
     * @return The allowedMethods at the given index.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method getAllowedMethods(int index) {
      return allowedMethods_converter_.convert(allowedMethods_.get(index));
    }
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @return A list containing the enum numeric values on the wire for allowedMethods.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer>
    getAllowedMethodsValueList() {
      return allowedMethods_;
    }
    /**
     * <pre>
     * List of HTTP methods allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
     * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
     * `Access-Control-Allow-Methods` header of the response.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of allowedMethods at the given index.
     */
    @java.lang.Override
    public int getAllowedMethodsValue(int index) {
      return allowedMethods_.get(index);
    }
    private int allowedMethodsMemoizedSerializedSize;

    public static final int ALLOWED_HEADERS_FIELD_NUMBER = 3;
    private com.google.protobuf.LazyStringList allowedHeaders_;
    /**
     * <pre>
     * List of HTTP headers allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
     * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
     * `Access-Control-Allow-Headers` header of the response.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
     * </pre>
     *
     * <code>repeated string allowed_headers = 3;</code>
     * @return A list containing the allowedHeaders.
     */
    public com.google.protobuf.ProtocolStringList
        getAllowedHeadersList() {
      return allowedHeaders_;
    }
    /**
     * <pre>
     * List of HTTP headers allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
     * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
     * `Access-Control-Allow-Headers` header of the response.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
     * </pre>
     *
     * <code>repeated string allowed_headers = 3;</code>
     * @return The count of allowedHeaders.
     */
    public int getAllowedHeadersCount() {
      return allowedHeaders_.size();
    }
    /**
     * <pre>
     * List of HTTP headers allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
     * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
     * `Access-Control-Allow-Headers` header of the response.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
     * </pre>
     *
     * <code>repeated string allowed_headers = 3;</code>
     * @param index The index of the element to return.
     * @return The allowedHeaders at the given index.
     */
    public java.lang.String getAllowedHeaders(int index) {
      return allowedHeaders_.get(index);
    }
    /**
     * <pre>
     * List of HTTP headers allowed by the CORS rule.
     * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
     * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
     * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
     * `Access-Control-Allow-Headers` header of the response.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
     * </pre>
     *
     * <code>repeated string allowed_headers = 3;</code>
     * @param index The index of the value to return.
     * @return The bytes of the allowedHeaders at the given index.
     */
    public com.google.protobuf.ByteString
        getAllowedHeadersBytes(int index) {
      return allowedHeaders_.getByteString(index);
    }

    public static final int ALLOWED_ORIGINS_FIELD_NUMBER = 4;
    private com.google.protobuf.LazyStringList allowedOrigins_;
    /**
     * <pre>
     * List of request origins allowed by the CORS rule.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
     * </pre>
     *
     * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
     * @return A list containing the allowedOrigins.
     */
    public com.google.protobuf.ProtocolStringList
        getAllowedOriginsList() {
      return allowedOrigins_;
    }
    /**
     * <pre>
     * List of request origins allowed by the CORS rule.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
     * </pre>
     *
     * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
     * @return The count of allowedOrigins.
     */
    public int getAllowedOriginsCount() {
      return allowedOrigins_.size();
    }
    /**
     * <pre>
     * List of request origins allowed by the CORS rule.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
     * </pre>
     *
     * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
     * @param index The index of the element to return.
     * @return The allowedOrigins at the given index.
     */
    public java.lang.String getAllowedOrigins(int index) {
      return allowedOrigins_.get(index);
    }
    /**
     * <pre>
     * List of request origins allowed by the CORS rule.
     * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
     * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
     * </pre>
     *
     * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
     * @param index The index of the value to return.
     * @return The bytes of the allowedOrigins at the given index.
     */
    public com.google.protobuf.ByteString
        getAllowedOriginsBytes(int index) {
      return allowedOrigins_.getByteString(index);
    }

    public static final int EXPOSE_HEADERS_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList exposeHeaders_;
    /**
     * <pre>
     * List of headers contained in responses to CORS requests that can be accessed by applications.
     * </pre>
     *
     * <code>repeated string expose_headers = 5;</code>
     * @return A list containing the exposeHeaders.
     */
    public com.google.protobuf.ProtocolStringList
        getExposeHeadersList() {
      return exposeHeaders_;
    }
    /**
     * <pre>
     * List of headers contained in responses to CORS requests that can be accessed by applications.
     * </pre>
     *
     * <code>repeated string expose_headers = 5;</code>
     * @return The count of exposeHeaders.
     */
    public int getExposeHeadersCount() {
      return exposeHeaders_.size();
    }
    /**
     * <pre>
     * List of headers contained in responses to CORS requests that can be accessed by applications.
     * </pre>
     *
     * <code>repeated string expose_headers = 5;</code>
     * @param index The index of the element to return.
     * @return The exposeHeaders at the given index.
     */
    public java.lang.String getExposeHeaders(int index) {
      return exposeHeaders_.get(index);
    }
    /**
     * <pre>
     * List of headers contained in responses to CORS requests that can be accessed by applications.
     * </pre>
     *
     * <code>repeated string expose_headers = 5;</code>
     * @param index The index of the value to return.
     * @return The bytes of the exposeHeaders at the given index.
     */
    public com.google.protobuf.ByteString
        getExposeHeadersBytes(int index) {
      return exposeHeaders_.getByteString(index);
    }

    public static final int MAX_AGE_SECONDS_FIELD_NUMBER = 6;
    private com.google.protobuf.Int64Value maxAgeSeconds_;
    /**
     * <pre>
     * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
     * object requested, the HTTP method, and the origin.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
     * @return Whether the maxAgeSeconds field is set.
     */
    @java.lang.Override
    public boolean hasMaxAgeSeconds() {
      return maxAgeSeconds_ != null;
    }
    /**
     * <pre>
     * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
     * object requested, the HTTP method, and the origin.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
     * @return The maxAgeSeconds.
     */
    @java.lang.Override
    public com.google.protobuf.Int64Value getMaxAgeSeconds() {
      return maxAgeSeconds_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : maxAgeSeconds_;
    }
    /**
     * <pre>
     * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
     * object requested, the HTTP method, and the origin.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int64ValueOrBuilder getMaxAgeSecondsOrBuilder() {
      return getMaxAgeSeconds();
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (getAllowedMethodsList().size() > 0) {
        output.writeUInt32NoTag(18);
        output.writeUInt32NoTag(allowedMethodsMemoizedSerializedSize);
      }
      for (int i = 0; i < allowedMethods_.size(); i++) {
        output.writeEnumNoTag(allowedMethods_.get(i));
      }
      for (int i = 0; i < allowedHeaders_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, allowedHeaders_.getRaw(i));
      }
      for (int i = 0; i < allowedOrigins_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, allowedOrigins_.getRaw(i));
      }
      for (int i = 0; i < exposeHeaders_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, exposeHeaders_.getRaw(i));
      }
      if (maxAgeSeconds_ != null) {
        output.writeMessage(6, getMaxAgeSeconds());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowedMethods_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeEnumSizeNoTag(allowedMethods_.get(i));
        }
        size += dataSize;
        if (!getAllowedMethodsList().isEmpty()) {  size += 1;
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32SizeNoTag(dataSize);
        }allowedMethodsMemoizedSerializedSize = dataSize;
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowedHeaders_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowedHeaders_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowedHeadersList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowedOrigins_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowedOrigins_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowedOriginsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < exposeHeaders_.size(); i++) {
          dataSize += computeStringSizeNoTag(exposeHeaders_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExposeHeadersList().size();
      }
      if (maxAgeSeconds_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getMaxAgeSeconds());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule)) {
        return super.equals(obj);
      }
      yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule other = (yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule) obj;

      if (!getId()
          .equals(other.getId())) return false;
      if (!allowedMethods_.equals(other.allowedMethods_)) return false;
      if (!getAllowedHeadersList()
          .equals(other.getAllowedHeadersList())) return false;
      if (!getAllowedOriginsList()
          .equals(other.getAllowedOriginsList())) return false;
      if (!getExposeHeadersList()
          .equals(other.getExposeHeadersList())) return false;
      if (hasMaxAgeSeconds() != other.hasMaxAgeSeconds()) return false;
      if (hasMaxAgeSeconds()) {
        if (!getMaxAgeSeconds()
            .equals(other.getMaxAgeSeconds())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (getAllowedMethodsCount() > 0) {
        hash = (37 * hash) + ALLOWED_METHODS_FIELD_NUMBER;
        hash = (53 * hash) + allowedMethods_.hashCode();
      }
      if (getAllowedHeadersCount() > 0) {
        hash = (37 * hash) + ALLOWED_HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedHeadersList().hashCode();
      }
      if (getAllowedOriginsCount() > 0) {
        hash = (37 * hash) + ALLOWED_ORIGINS_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedOriginsList().hashCode();
      }
      if (getExposeHeadersCount() > 0) {
        hash = (37 * hash) + EXPOSE_HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + getExposeHeadersList().hashCode();
      }
      if (hasMaxAgeSeconds()) {
        hash = (37 * hash) + MAX_AGE_SECONDS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxAgeSeconds().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A CORS rule resource.
     * For details about the concept, see [documentation](/docs/storage/concepts/cors).
     * </pre>
     *
     * Protobuf type {@code yandex.cloud.storage.v1.CorsRule}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.CorsRule)
        yandex.cloud.api.storage.v1.BucketOuterClass.CorsRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_CorsRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_CorsRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.class, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Builder.class);
      }

      // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        id_ = "";

        allowedMethods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        allowedHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        allowedOrigins_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        exposeHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        if (maxAgeSecondsBuilder_ == null) {
          maxAgeSeconds_ = null;
        } else {
          maxAgeSeconds_ = null;
          maxAgeSecondsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_CorsRule_descriptor;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule getDefaultInstanceForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.getDefaultInstance();
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule build() {
        yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule buildPartial() {
        yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule result = new yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule(this);
        int from_bitField0_ = bitField0_;
        result.id_ = id_;
        if (((bitField0_ & 0x00000001) != 0)) {
          allowedMethods_ = java.util.Collections.unmodifiableList(allowedMethods_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.allowedMethods_ = allowedMethods_;
        if (((bitField0_ & 0x00000002) != 0)) {
          allowedHeaders_ = allowedHeaders_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.allowedHeaders_ = allowedHeaders_;
        if (((bitField0_ & 0x00000004) != 0)) {
          allowedOrigins_ = allowedOrigins_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.allowedOrigins_ = allowedOrigins_;
        if (((bitField0_ & 0x00000008) != 0)) {
          exposeHeaders_ = exposeHeaders_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.exposeHeaders_ = exposeHeaders_;
        if (maxAgeSecondsBuilder_ == null) {
          result.maxAgeSeconds_ = maxAgeSeconds_;
        } else {
          result.maxAgeSeconds_ = maxAgeSecondsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule) {
          return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule other) {
        if (other == yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (!other.allowedMethods_.isEmpty()) {
          if (allowedMethods_.isEmpty()) {
            allowedMethods_ = other.allowedMethods_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAllowedMethodsIsMutable();
            allowedMethods_.addAll(other.allowedMethods_);
          }
          onChanged();
        }
        if (!other.allowedHeaders_.isEmpty()) {
          if (allowedHeaders_.isEmpty()) {
            allowedHeaders_ = other.allowedHeaders_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAllowedHeadersIsMutable();
            allowedHeaders_.addAll(other.allowedHeaders_);
          }
          onChanged();
        }
        if (!other.allowedOrigins_.isEmpty()) {
          if (allowedOrigins_.isEmpty()) {
            allowedOrigins_ = other.allowedOrigins_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAllowedOriginsIsMutable();
            allowedOrigins_.addAll(other.allowedOrigins_);
          }
          onChanged();
        }
        if (!other.exposeHeaders_.isEmpty()) {
          if (exposeHeaders_.isEmpty()) {
            exposeHeaders_ = other.exposeHeaders_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureExposeHeadersIsMutable();
            exposeHeaders_.addAll(other.exposeHeaders_);
          }
          onChanged();
        }
        if (other.hasMaxAgeSeconds()) {
          mergeMaxAgeSeconds(other.getMaxAgeSeconds());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * ID of the CORS rule.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @return The id.
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID of the CORS rule.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @return The bytes for id.
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID of the CORS rule.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the CORS rule.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the CORS rule.
       * </pre>
       *
       * <code>string id = 1;</code>
       * @param value The bytes for id to set.
       * @return This builder for chaining.
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> allowedMethods_ =
        java.util.Collections.emptyList();
      private void ensureAllowedMethodsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          allowedMethods_ = new java.util.ArrayList<java.lang.Integer>(allowedMethods_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @return A list containing the allowedMethods.
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method> getAllowedMethodsList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method>(allowedMethods_, allowedMethods_converter_);
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @return The count of allowedMethods.
       */
      public int getAllowedMethodsCount() {
        return allowedMethods_.size();
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @param index The index of the element to return.
       * @return The allowedMethods at the given index.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method getAllowedMethods(int index) {
        return allowedMethods_converter_.convert(allowedMethods_.get(index));
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @param index The index to set the value at.
       * @param value The allowedMethods to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedMethods(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedMethodsIsMutable();
        allowedMethods_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @param value The allowedMethods to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedMethods(yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedMethodsIsMutable();
        allowedMethods_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @param values The allowedMethods to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedMethods(
          java.lang.Iterable<? extends yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method> values) {
        ensureAllowedMethodsIsMutable();
        for (yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule.Method value : values) {
          allowedMethods_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @return This builder for chaining.
       */
      public Builder clearAllowedMethods() {
        allowedMethods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @return A list containing the enum numeric values on the wire for allowedMethods.
       */
      public java.util.List<java.lang.Integer>
      getAllowedMethodsValueList() {
        return java.util.Collections.unmodifiableList(allowedMethods_);
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of allowedMethods at the given index.
       */
      public int getAllowedMethodsValue(int index) {
        return allowedMethods_.get(index);
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of allowedMethods at the given index.
       * @return This builder for chaining.
       */
      public Builder setAllowedMethodsValue(
          int index, int value) {
        ensureAllowedMethodsIsMutable();
        allowedMethods_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @param value The enum numeric value on the wire for allowedMethods to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedMethodsValue(int value) {
        ensureAllowedMethodsIsMutable();
        allowedMethods_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP methods allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Method` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified method is checked against
       * the list of the allowed methods. If there is a match, all the allowed methods are listed in the
       * `Access-Control-Allow-Methods` header of the response.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.CorsRule.Method allowed_methods = 2 [(.yandex.cloud.size) = "&gt;0", (.yandex.cloud.unique) = true];</code>
       * @param values The enum numeric values on the wire for allowedMethods to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedMethodsValue(
          java.lang.Iterable<java.lang.Integer> values) {
        ensureAllowedMethodsIsMutable();
        for (int value : values) {
          allowedMethods_.add(value);
        }
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList allowedHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureAllowedHeadersIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          allowedHeaders_ = new com.google.protobuf.LazyStringArrayList(allowedHeaders_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @return A list containing the allowedHeaders.
       */
      public com.google.protobuf.ProtocolStringList
          getAllowedHeadersList() {
        return allowedHeaders_.getUnmodifiableView();
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @return The count of allowedHeaders.
       */
      public int getAllowedHeadersCount() {
        return allowedHeaders_.size();
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @param index The index of the element to return.
       * @return The allowedHeaders at the given index.
       */
      public java.lang.String getAllowedHeaders(int index) {
        return allowedHeaders_.get(index);
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @param index The index of the value to return.
       * @return The bytes of the allowedHeaders at the given index.
       */
      public com.google.protobuf.ByteString
          getAllowedHeadersBytes(int index) {
        return allowedHeaders_.getByteString(index);
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @param index The index to set the value at.
       * @param value The allowedHeaders to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedHeaders(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAllowedHeadersIsMutable();
        allowedHeaders_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @param value The allowedHeaders to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedHeaders(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAllowedHeadersIsMutable();
        allowedHeaders_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @param values The allowedHeaders to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedHeaders(
          java.lang.Iterable<java.lang.String> values) {
        ensureAllowedHeadersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, allowedHeaders_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearAllowedHeaders() {
        allowedHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of HTTP headers allowed by the CORS rule.
       * When a client sends a CORS-preflight `options` request with the `Access-Control-Request-Headers` header (see
       * [S3-compatible API reference](/docs/storage/s3/api-ref/object/options)), the specified headers are checked against
       * the list of the allowed headers. If there is a match, the specified headers that are allowed are listed in the
       * `Access-Control-Allow-Headers` header of the response.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `x-amz-*` value will allow all Amazon S3-compatible headers.
       * </pre>
       *
       * <code>repeated string allowed_headers = 3;</code>
       * @param value The bytes of the allowedHeaders to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedHeadersBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureAllowedHeadersIsMutable();
        allowedHeaders_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList allowedOrigins_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureAllowedOriginsIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          allowedOrigins_ = new com.google.protobuf.LazyStringArrayList(allowedOrigins_);
          bitField0_ |= 0x00000004;
         }
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @return A list containing the allowedOrigins.
       */
      public com.google.protobuf.ProtocolStringList
          getAllowedOriginsList() {
        return allowedOrigins_.getUnmodifiableView();
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @return The count of allowedOrigins.
       */
      public int getAllowedOriginsCount() {
        return allowedOrigins_.size();
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @param index The index of the element to return.
       * @return The allowedOrigins at the given index.
       */
      public java.lang.String getAllowedOrigins(int index) {
        return allowedOrigins_.get(index);
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @param index The index of the value to return.
       * @return The bytes of the allowedOrigins at the given index.
       */
      public com.google.protobuf.ByteString
          getAllowedOriginsBytes(int index) {
        return allowedOrigins_.getByteString(index);
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @param index The index to set the value at.
       * @param value The allowedOrigins to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedOrigins(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAllowedOriginsIsMutable();
        allowedOrigins_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @param value The allowedOrigins to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedOrigins(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureAllowedOriginsIsMutable();
        allowedOrigins_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @param values The allowedOrigins to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedOrigins(
          java.lang.Iterable<java.lang.String> values) {
        ensureAllowedOriginsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, allowedOrigins_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @return This builder for chaining.
       */
      public Builder clearAllowedOrigins() {
        allowedOrigins_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of request origins allowed by the CORS rule.
       * Each string in the list can contain at most one `*` wildcard character that matches 0 or more characters.
       * For example, `http://&#42;.example.com` value will allow requests originating from all subdomains of `example.com`.
       * </pre>
       *
       * <code>repeated string allowed_origins = 4 [(.yandex.cloud.size) = "&gt;0"];</code>
       * @param value The bytes of the allowedOrigins to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedOriginsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureAllowedOriginsIsMutable();
        allowedOrigins_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList exposeHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureExposeHeadersIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          exposeHeaders_ = new com.google.protobuf.LazyStringArrayList(exposeHeaders_);
          bitField0_ |= 0x00000008;
         }
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @return A list containing the exposeHeaders.
       */
      public com.google.protobuf.ProtocolStringList
          getExposeHeadersList() {
        return exposeHeaders_.getUnmodifiableView();
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @return The count of exposeHeaders.
       */
      public int getExposeHeadersCount() {
        return exposeHeaders_.size();
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @param index The index of the element to return.
       * @return The exposeHeaders at the given index.
       */
      public java.lang.String getExposeHeaders(int index) {
        return exposeHeaders_.get(index);
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @param index The index of the value to return.
       * @return The bytes of the exposeHeaders at the given index.
       */
      public com.google.protobuf.ByteString
          getExposeHeadersBytes(int index) {
        return exposeHeaders_.getByteString(index);
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @param index The index to set the value at.
       * @param value The exposeHeaders to set.
       * @return This builder for chaining.
       */
      public Builder setExposeHeaders(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureExposeHeadersIsMutable();
        exposeHeaders_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @param value The exposeHeaders to add.
       * @return This builder for chaining.
       */
      public Builder addExposeHeaders(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureExposeHeadersIsMutable();
        exposeHeaders_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @param values The exposeHeaders to add.
       * @return This builder for chaining.
       */
      public Builder addAllExposeHeaders(
          java.lang.Iterable<java.lang.String> values) {
        ensureExposeHeadersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, exposeHeaders_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearExposeHeaders() {
        exposeHeaders_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * List of headers contained in responses to CORS requests that can be accessed by applications.
       * </pre>
       *
       * <code>repeated string expose_headers = 5;</code>
       * @param value The bytes of the exposeHeaders to add.
       * @return This builder for chaining.
       */
      public Builder addExposeHeadersBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureExposeHeadersIsMutable();
        exposeHeaders_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.Int64Value maxAgeSeconds_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> maxAgeSecondsBuilder_;
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       * @return Whether the maxAgeSeconds field is set.
       */
      public boolean hasMaxAgeSeconds() {
        return maxAgeSecondsBuilder_ != null || maxAgeSeconds_ != null;
      }
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       * @return The maxAgeSeconds.
       */
      public com.google.protobuf.Int64Value getMaxAgeSeconds() {
        if (maxAgeSecondsBuilder_ == null) {
          return maxAgeSeconds_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : maxAgeSeconds_;
        } else {
          return maxAgeSecondsBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       */
      public Builder setMaxAgeSeconds(com.google.protobuf.Int64Value value) {
        if (maxAgeSecondsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxAgeSeconds_ = value;
          onChanged();
        } else {
          maxAgeSecondsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       */
      public Builder setMaxAgeSeconds(
          com.google.protobuf.Int64Value.Builder builderForValue) {
        if (maxAgeSecondsBuilder_ == null) {
          maxAgeSeconds_ = builderForValue.build();
          onChanged();
        } else {
          maxAgeSecondsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       */
      public Builder mergeMaxAgeSeconds(com.google.protobuf.Int64Value value) {
        if (maxAgeSecondsBuilder_ == null) {
          if (maxAgeSeconds_ != null) {
            maxAgeSeconds_ =
              com.google.protobuf.Int64Value.newBuilder(maxAgeSeconds_).mergeFrom(value).buildPartial();
          } else {
            maxAgeSeconds_ = value;
          }
          onChanged();
        } else {
          maxAgeSecondsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       */
      public Builder clearMaxAgeSeconds() {
        if (maxAgeSecondsBuilder_ == null) {
          maxAgeSeconds_ = null;
          onChanged();
        } else {
          maxAgeSeconds_ = null;
          maxAgeSecondsBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       */
      public com.google.protobuf.Int64Value.Builder getMaxAgeSecondsBuilder() {
        
        onChanged();
        return getMaxAgeSecondsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       */
      public com.google.protobuf.Int64ValueOrBuilder getMaxAgeSecondsOrBuilder() {
        if (maxAgeSecondsBuilder_ != null) {
          return maxAgeSecondsBuilder_.getMessageOrBuilder();
        } else {
          return maxAgeSeconds_ == null ?
              com.google.protobuf.Int64Value.getDefaultInstance() : maxAgeSeconds_;
        }
      }
      /**
       * <pre>
       * Time in seconds that a client can cache the response to a CORS-preflight request as identified by the
       * object requested, the HTTP method, and the origin.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value max_age_seconds = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
          getMaxAgeSecondsFieldBuilder() {
        if (maxAgeSecondsBuilder_ == null) {
          maxAgeSecondsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                  getMaxAgeSeconds(),
                  getParentForChildren(),
                  isClean());
          maxAgeSeconds_ = null;
        }
        return maxAgeSecondsBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.CorsRule)
    }

    // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.CorsRule)
    private static final yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule();
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CorsRule>
        PARSER = new com.google.protobuf.AbstractParser<CorsRule>() {
      @java.lang.Override
      public CorsRule parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new CorsRule(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<CorsRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CorsRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.CorsRule getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface WebsiteSettingsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.WebsiteSettings)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Key of the index page object that is returned when a response is made to the root of the website.
     * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
     * If specified, the index page object must be located in the root of the bucket.
     * </pre>
     *
     * <code>string index = 1;</code>
     * @return The index.
     */
    java.lang.String getIndex();
    /**
     * <pre>
     * Key of the index page object that is returned when a response is made to the root of the website.
     * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
     * If specified, the index page object must be located in the root of the bucket.
     * </pre>
     *
     * <code>string index = 1;</code>
     * @return The bytes for index.
     */
    com.google.protobuf.ByteString
        getIndexBytes();

    /**
     * <pre>
     * Key of the error page object that is returned when an error occurs.
     * </pre>
     *
     * <code>string error = 2;</code>
     * @return The error.
     */
    java.lang.String getError();
    /**
     * <pre>
     * Key of the error page object that is returned when an error occurs.
     * </pre>
     *
     * <code>string error = 2;</code>
     * @return The bytes for error.
     */
    com.google.protobuf.ByteString
        getErrorBytes();

    /**
     * <pre>
     * Configuration for redirecting all requests sent to the website.
     * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
     * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
     * @return Whether the redirectAllRequests field is set.
     */
    boolean hasRedirectAllRequests();
    /**
     * <pre>
     * Configuration for redirecting all requests sent to the website.
     * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
     * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
     * @return The redirectAllRequests.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme getRedirectAllRequests();
    /**
     * <pre>
     * Configuration for redirecting all requests sent to the website.
     * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
     * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.SchemeOrBuilder getRedirectAllRequestsOrBuilder();

    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule> 
        getRoutingRulesList();
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule getRoutingRules(int index);
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    int getRoutingRulesCount();
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder> 
        getRoutingRulesOrBuilderList();
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder getRoutingRulesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings}
   */
  public static final class WebsiteSettings extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.WebsiteSettings)
      WebsiteSettingsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use WebsiteSettings.newBuilder() to construct.
    private WebsiteSettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private WebsiteSettings() {
      index_ = "";
      error_ = "";
      routingRules_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new WebsiteSettings();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private WebsiteSettings(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              index_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              error_ = s;
              break;
            }
            case 26: {
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.Builder subBuilder = null;
              if (redirectAllRequests_ != null) {
                subBuilder = redirectAllRequests_.toBuilder();
              }
              redirectAllRequests_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(redirectAllRequests_);
                redirectAllRequests_ = subBuilder.buildPartial();
              }

              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                routingRules_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule>();
                mutable_bitField0_ |= 0x00000001;
              }
              routingRules_.add(
                  input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.parser(), extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          routingRules_ = java.util.Collections.unmodifiableList(routingRules_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Builder.class);
    }

    /**
     * Protobuf enum {@code yandex.cloud.storage.v1.WebsiteSettings.Protocol}
     */
    public enum Protocol
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>PROTOCOL_UNSPECIFIED = 0;</code>
       */
      PROTOCOL_UNSPECIFIED(0),
      /**
       * <pre>
       * `http` scheme.
       * </pre>
       *
       * <code>PROTOCOL_HTTP = 1;</code>
       */
      PROTOCOL_HTTP(1),
      /**
       * <pre>
       * `https` scheme.
       * </pre>
       *
       * <code>PROTOCOL_HTTPS = 2;</code>
       */
      PROTOCOL_HTTPS(2),
      UNRECOGNIZED(-1),
      ;

      /**
       * <code>PROTOCOL_UNSPECIFIED = 0;</code>
       */
      public static final int PROTOCOL_UNSPECIFIED_VALUE = 0;
      /**
       * <pre>
       * `http` scheme.
       * </pre>
       *
       * <code>PROTOCOL_HTTP = 1;</code>
       */
      public static final int PROTOCOL_HTTP_VALUE = 1;
      /**
       * <pre>
       * `https` scheme.
       * </pre>
       *
       * <code>PROTOCOL_HTTPS = 2;</code>
       */
      public static final int PROTOCOL_HTTPS_VALUE = 2;


      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Protocol valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Protocol forNumber(int value) {
        switch (value) {
          case 0: return PROTOCOL_UNSPECIFIED;
          case 1: return PROTOCOL_HTTP;
          case 2: return PROTOCOL_HTTPS;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Protocol>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Protocol> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Protocol>() {
              public Protocol findValueByNumber(int number) {
                return Protocol.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.getDescriptor().getEnumTypes().get(0);
      }

      private static final Protocol[] VALUES = values();

      public static Protocol valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Protocol(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:yandex.cloud.storage.v1.WebsiteSettings.Protocol)
    }

    public interface SchemeOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.WebsiteSettings.Scheme)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Scheme of the redirect URI.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
       * @return The enum numeric value on the wire for protocol.
       */
      int getProtocolValue();
      /**
       * <pre>
       * Scheme of the redirect URI.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
       * @return The protocol.
       */
      yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol getProtocol();

      /**
       * <pre>
       * Hostname of the redirect URI.
       * </pre>
       *
       * <code>string hostname = 2;</code>
       * @return The hostname.
       */
      java.lang.String getHostname();
      /**
       * <pre>
       * Hostname of the redirect URI.
       * </pre>
       *
       * <code>string hostname = 2;</code>
       * @return The bytes for hostname.
       */
      com.google.protobuf.ByteString
          getHostnameBytes();
    }
    /**
     * <pre>
     * A configuration resource for redirecting all requests sent to the website.
     * </pre>
     *
     * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings.Scheme}
     */
    public static final class Scheme extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.WebsiteSettings.Scheme)
        SchemeOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Scheme.newBuilder() to construct.
      private Scheme(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Scheme() {
        protocol_ = 0;
        hostname_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Scheme();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Scheme(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int rawValue = input.readEnum();

                protocol_ = rawValue;
                break;
              }
              case 18: {
                java.lang.String s = input.readStringRequireUtf8();

                hostname_ = s;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Scheme_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Scheme_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.Builder.class);
      }

      public static final int PROTOCOL_FIELD_NUMBER = 1;
      private int protocol_;
      /**
       * <pre>
       * Scheme of the redirect URI.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
       * @return The enum numeric value on the wire for protocol.
       */
      @java.lang.Override public int getProtocolValue() {
        return protocol_;
      }
      /**
       * <pre>
       * Scheme of the redirect URI.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
       * @return The protocol.
       */
      @java.lang.Override public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol getProtocol() {
        @SuppressWarnings("deprecation")
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol result = yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.valueOf(protocol_);
        return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.UNRECOGNIZED : result;
      }

      public static final int HOSTNAME_FIELD_NUMBER = 2;
      private volatile java.lang.Object hostname_;
      /**
       * <pre>
       * Hostname of the redirect URI.
       * </pre>
       *
       * <code>string hostname = 2;</code>
       * @return The hostname.
       */
      @java.lang.Override
      public java.lang.String getHostname() {
        java.lang.Object ref = hostname_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hostname_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Hostname of the redirect URI.
       * </pre>
       *
       * <code>string hostname = 2;</code>
       * @return The bytes for hostname.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getHostnameBytes() {
        java.lang.Object ref = hostname_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          hostname_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (protocol_ != yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.PROTOCOL_UNSPECIFIED.getNumber()) {
          output.writeEnum(1, protocol_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, hostname_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (protocol_ != yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.PROTOCOL_UNSPECIFIED.getNumber()) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(1, protocol_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, hostname_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme other = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme) obj;

        if (protocol_ != other.protocol_) return false;
        if (!getHostname()
            .equals(other.getHostname())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
        hash = (53 * hash) + protocol_;
        hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
        hash = (53 * hash) + getHostname().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * A configuration resource for redirecting all requests sent to the website.
       * </pre>
       *
       * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings.Scheme}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.WebsiteSettings.Scheme)
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.SchemeOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Scheme_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Scheme_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          protocol_ = 0;

          hostname_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Scheme_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme result = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme(this);
          result.protocol_ = protocol_;
          result.hostname_ = hostname_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.getDefaultInstance()) return this;
          if (other.protocol_ != 0) {
            setProtocolValue(other.getProtocolValue());
          }
          if (!other.getHostname().isEmpty()) {
            hostname_ = other.hostname_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private int protocol_ = 0;
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
         * @return The enum numeric value on the wire for protocol.
         */
        @java.lang.Override public int getProtocolValue() {
          return protocol_;
        }
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
         * @param value The enum numeric value on the wire for protocol to set.
         * @return This builder for chaining.
         */
        public Builder setProtocolValue(int value) {
          
          protocol_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
         * @return The protocol.
         */
        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol getProtocol() {
          @SuppressWarnings("deprecation")
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol result = yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.valueOf(protocol_);
          return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.UNRECOGNIZED : result;
        }
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
         * @param value The protocol to set.
         * @return This builder for chaining.
         */
        public Builder setProtocol(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol value) {
          if (value == null) {
            throw new NullPointerException();
          }
          
          protocol_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearProtocol() {
          
          protocol_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object hostname_ = "";
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 2;</code>
         * @return The hostname.
         */
        public java.lang.String getHostname() {
          java.lang.Object ref = hostname_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            hostname_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 2;</code>
         * @return The bytes for hostname.
         */
        public com.google.protobuf.ByteString
            getHostnameBytes() {
          java.lang.Object ref = hostname_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            hostname_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 2;</code>
         * @param value The hostname to set.
         * @return This builder for chaining.
         */
        public Builder setHostname(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          hostname_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearHostname() {
          
          hostname_ = getDefaultInstance().getHostname();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 2;</code>
         * @param value The bytes for hostname to set.
         * @return This builder for chaining.
         */
        public Builder setHostnameBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          hostname_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.WebsiteSettings.Scheme)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.WebsiteSettings.Scheme)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Scheme>
          PARSER = new com.google.protobuf.AbstractParser<Scheme>() {
        @java.lang.Override
        public Scheme parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Scheme(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Scheme> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Scheme> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface ConditionOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.WebsiteSettings.Condition)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * HTTP status code (number only) that must match for the redirect to apply.
       * </pre>
       *
       * <code>string http_error_code_returned_equals = 1;</code>
       * @return The httpErrorCodeReturnedEquals.
       */
      java.lang.String getHttpErrorCodeReturnedEquals();
      /**
       * <pre>
       * HTTP status code (number only) that must match for the redirect to apply.
       * </pre>
       *
       * <code>string http_error_code_returned_equals = 1;</code>
       * @return The bytes for httpErrorCodeReturnedEquals.
       */
      com.google.protobuf.ByteString
          getHttpErrorCodeReturnedEqualsBytes();

      /**
       * <pre>
       * Prefix of the object key from which requests are redirected.
       * </pre>
       *
       * <code>string key_prefix_equals = 2;</code>
       * @return The keyPrefixEquals.
       */
      java.lang.String getKeyPrefixEquals();
      /**
       * <pre>
       * Prefix of the object key from which requests are redirected.
       * </pre>
       *
       * <code>string key_prefix_equals = 2;</code>
       * @return The bytes for keyPrefixEquals.
       */
      com.google.protobuf.ByteString
          getKeyPrefixEqualsBytes();
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings.Condition}
     */
    public static final class Condition extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.WebsiteSettings.Condition)
        ConditionOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Condition.newBuilder() to construct.
      private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Condition() {
        httpErrorCodeReturnedEquals_ = "";
        keyPrefixEquals_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Condition();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Condition(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();

                httpErrorCodeReturnedEquals_ = s;
                break;
              }
              case 18: {
                java.lang.String s = input.readStringRequireUtf8();

                keyPrefixEquals_ = s;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Condition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Condition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.Builder.class);
      }

      public static final int HTTP_ERROR_CODE_RETURNED_EQUALS_FIELD_NUMBER = 1;
      private volatile java.lang.Object httpErrorCodeReturnedEquals_;
      /**
       * <pre>
       * HTTP status code (number only) that must match for the redirect to apply.
       * </pre>
       *
       * <code>string http_error_code_returned_equals = 1;</code>
       * @return The httpErrorCodeReturnedEquals.
       */
      @java.lang.Override
      public java.lang.String getHttpErrorCodeReturnedEquals() {
        java.lang.Object ref = httpErrorCodeReturnedEquals_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          httpErrorCodeReturnedEquals_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * HTTP status code (number only) that must match for the redirect to apply.
       * </pre>
       *
       * <code>string http_error_code_returned_equals = 1;</code>
       * @return The bytes for httpErrorCodeReturnedEquals.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getHttpErrorCodeReturnedEqualsBytes() {
        java.lang.Object ref = httpErrorCodeReturnedEquals_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          httpErrorCodeReturnedEquals_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int KEY_PREFIX_EQUALS_FIELD_NUMBER = 2;
      private volatile java.lang.Object keyPrefixEquals_;
      /**
       * <pre>
       * Prefix of the object key from which requests are redirected.
       * </pre>
       *
       * <code>string key_prefix_equals = 2;</code>
       * @return The keyPrefixEquals.
       */
      @java.lang.Override
      public java.lang.String getKeyPrefixEquals() {
        java.lang.Object ref = keyPrefixEquals_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          keyPrefixEquals_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Prefix of the object key from which requests are redirected.
       * </pre>
       *
       * <code>string key_prefix_equals = 2;</code>
       * @return The bytes for keyPrefixEquals.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getKeyPrefixEqualsBytes() {
        java.lang.Object ref = keyPrefixEquals_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          keyPrefixEquals_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpErrorCodeReturnedEquals_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, httpErrorCodeReturnedEquals_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyPrefixEquals_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, keyPrefixEquals_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpErrorCodeReturnedEquals_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, httpErrorCodeReturnedEquals_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(keyPrefixEquals_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, keyPrefixEquals_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition other = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition) obj;

        if (!getHttpErrorCodeReturnedEquals()
            .equals(other.getHttpErrorCodeReturnedEquals())) return false;
        if (!getKeyPrefixEquals()
            .equals(other.getKeyPrefixEquals())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + HTTP_ERROR_CODE_RETURNED_EQUALS_FIELD_NUMBER;
        hash = (53 * hash) + getHttpErrorCodeReturnedEquals().hashCode();
        hash = (37 * hash) + KEY_PREFIX_EQUALS_FIELD_NUMBER;
        hash = (53 * hash) + getKeyPrefixEquals().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings.Condition}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.WebsiteSettings.Condition)
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.ConditionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Condition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Condition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          httpErrorCodeReturnedEquals_ = "";

          keyPrefixEquals_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Condition_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition result = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition(this);
          result.httpErrorCodeReturnedEquals_ = httpErrorCodeReturnedEquals_;
          result.keyPrefixEquals_ = keyPrefixEquals_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.getDefaultInstance()) return this;
          if (!other.getHttpErrorCodeReturnedEquals().isEmpty()) {
            httpErrorCodeReturnedEquals_ = other.httpErrorCodeReturnedEquals_;
            onChanged();
          }
          if (!other.getKeyPrefixEquals().isEmpty()) {
            keyPrefixEquals_ = other.keyPrefixEquals_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object httpErrorCodeReturnedEquals_ = "";
        /**
         * <pre>
         * HTTP status code (number only) that must match for the redirect to apply.
         * </pre>
         *
         * <code>string http_error_code_returned_equals = 1;</code>
         * @return The httpErrorCodeReturnedEquals.
         */
        public java.lang.String getHttpErrorCodeReturnedEquals() {
          java.lang.Object ref = httpErrorCodeReturnedEquals_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            httpErrorCodeReturnedEquals_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * HTTP status code (number only) that must match for the redirect to apply.
         * </pre>
         *
         * <code>string http_error_code_returned_equals = 1;</code>
         * @return The bytes for httpErrorCodeReturnedEquals.
         */
        public com.google.protobuf.ByteString
            getHttpErrorCodeReturnedEqualsBytes() {
          java.lang.Object ref = httpErrorCodeReturnedEquals_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            httpErrorCodeReturnedEquals_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * HTTP status code (number only) that must match for the redirect to apply.
         * </pre>
         *
         * <code>string http_error_code_returned_equals = 1;</code>
         * @param value The httpErrorCodeReturnedEquals to set.
         * @return This builder for chaining.
         */
        public Builder setHttpErrorCodeReturnedEquals(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          httpErrorCodeReturnedEquals_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * HTTP status code (number only) that must match for the redirect to apply.
         * </pre>
         *
         * <code>string http_error_code_returned_equals = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearHttpErrorCodeReturnedEquals() {
          
          httpErrorCodeReturnedEquals_ = getDefaultInstance().getHttpErrorCodeReturnedEquals();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * HTTP status code (number only) that must match for the redirect to apply.
         * </pre>
         *
         * <code>string http_error_code_returned_equals = 1;</code>
         * @param value The bytes for httpErrorCodeReturnedEquals to set.
         * @return This builder for chaining.
         */
        public Builder setHttpErrorCodeReturnedEqualsBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          httpErrorCodeReturnedEquals_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object keyPrefixEquals_ = "";
        /**
         * <pre>
         * Prefix of the object key from which requests are redirected.
         * </pre>
         *
         * <code>string key_prefix_equals = 2;</code>
         * @return The keyPrefixEquals.
         */
        public java.lang.String getKeyPrefixEquals() {
          java.lang.Object ref = keyPrefixEquals_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            keyPrefixEquals_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Prefix of the object key from which requests are redirected.
         * </pre>
         *
         * <code>string key_prefix_equals = 2;</code>
         * @return The bytes for keyPrefixEquals.
         */
        public com.google.protobuf.ByteString
            getKeyPrefixEqualsBytes() {
          java.lang.Object ref = keyPrefixEquals_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            keyPrefixEquals_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Prefix of the object key from which requests are redirected.
         * </pre>
         *
         * <code>string key_prefix_equals = 2;</code>
         * @param value The keyPrefixEquals to set.
         * @return This builder for chaining.
         */
        public Builder setKeyPrefixEquals(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          keyPrefixEquals_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Prefix of the object key from which requests are redirected.
         * </pre>
         *
         * <code>string key_prefix_equals = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearKeyPrefixEquals() {
          
          keyPrefixEquals_ = getDefaultInstance().getKeyPrefixEquals();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Prefix of the object key from which requests are redirected.
         * </pre>
         *
         * <code>string key_prefix_equals = 2;</code>
         * @param value The bytes for keyPrefixEquals to set.
         * @return This builder for chaining.
         */
        public Builder setKeyPrefixEqualsBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          keyPrefixEquals_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.WebsiteSettings.Condition)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.WebsiteSettings.Condition)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Condition>
          PARSER = new com.google.protobuf.AbstractParser<Condition>() {
        @java.lang.Override
        public Condition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Condition(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Condition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Condition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface RedirectOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.WebsiteSettings.Redirect)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Hostname of the redirect URI.
       * </pre>
       *
       * <code>string hostname = 1;</code>
       * @return The hostname.
       */
      java.lang.String getHostname();
      /**
       * <pre>
       * Hostname of the redirect URI.
       * </pre>
       *
       * <code>string hostname = 1;</code>
       * @return The bytes for hostname.
       */
      com.google.protobuf.ByteString
          getHostnameBytes();

      /**
       * <pre>
       * HTTP status code of the redirect response.
       * Default value: `"301"`.
       * </pre>
       *
       * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
       * @return The httpRedirectCode.
       */
      java.lang.String getHttpRedirectCode();
      /**
       * <pre>
       * HTTP status code of the redirect response.
       * Default value: `"301"`.
       * </pre>
       *
       * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
       * @return The bytes for httpRedirectCode.
       */
      com.google.protobuf.ByteString
          getHttpRedirectCodeBytes();

      /**
       * <pre>
       * Scheme of the redirect URI.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
       * @return The enum numeric value on the wire for protocol.
       */
      int getProtocolValue();
      /**
       * <pre>
       * Scheme of the redirect URI.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
       * @return The protocol.
       */
      yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol getProtocol();

      /**
       * <pre>
       * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
       * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
       * </pre>
       *
       * <code>string replace_key_prefix_with = 4;</code>
       * @return The replaceKeyPrefixWith.
       */
      java.lang.String getReplaceKeyPrefixWith();
      /**
       * <pre>
       * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
       * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
       * </pre>
       *
       * <code>string replace_key_prefix_with = 4;</code>
       * @return The bytes for replaceKeyPrefixWith.
       */
      com.google.protobuf.ByteString
          getReplaceKeyPrefixWithBytes();

      /**
       * <pre>
       * New object key.
       * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
       * </pre>
       *
       * <code>string replace_key_with = 5;</code>
       * @return The replaceKeyWith.
       */
      java.lang.String getReplaceKeyWith();
      /**
       * <pre>
       * New object key.
       * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
       * </pre>
       *
       * <code>string replace_key_with = 5;</code>
       * @return The bytes for replaceKeyWith.
       */
      com.google.protobuf.ByteString
          getReplaceKeyWithBytes();
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings.Redirect}
     */
    public static final class Redirect extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.WebsiteSettings.Redirect)
        RedirectOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Redirect.newBuilder() to construct.
      private Redirect(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Redirect() {
        hostname_ = "";
        httpRedirectCode_ = "";
        protocol_ = 0;
        replaceKeyPrefixWith_ = "";
        replaceKeyWith_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Redirect();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Redirect(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();

                hostname_ = s;
                break;
              }
              case 18: {
                java.lang.String s = input.readStringRequireUtf8();

                httpRedirectCode_ = s;
                break;
              }
              case 24: {
                int rawValue = input.readEnum();

                protocol_ = rawValue;
                break;
              }
              case 34: {
                java.lang.String s = input.readStringRequireUtf8();

                replaceKeyPrefixWith_ = s;
                break;
              }
              case 42: {
                java.lang.String s = input.readStringRequireUtf8();

                replaceKeyWith_ = s;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Redirect_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Redirect_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.Builder.class);
      }

      public static final int HOSTNAME_FIELD_NUMBER = 1;
      private volatile java.lang.Object hostname_;
      /**
       * <pre>
       * Hostname of the redirect URI.
       * </pre>
       *
       * <code>string hostname = 1;</code>
       * @return The hostname.
       */
      @java.lang.Override
      public java.lang.String getHostname() {
        java.lang.Object ref = hostname_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hostname_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Hostname of the redirect URI.
       * </pre>
       *
       * <code>string hostname = 1;</code>
       * @return The bytes for hostname.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getHostnameBytes() {
        java.lang.Object ref = hostname_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          hostname_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int HTTP_REDIRECT_CODE_FIELD_NUMBER = 2;
      private volatile java.lang.Object httpRedirectCode_;
      /**
       * <pre>
       * HTTP status code of the redirect response.
       * Default value: `"301"`.
       * </pre>
       *
       * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
       * @return The httpRedirectCode.
       */
      @java.lang.Override
      public java.lang.String getHttpRedirectCode() {
        java.lang.Object ref = httpRedirectCode_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          httpRedirectCode_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * HTTP status code of the redirect response.
       * Default value: `"301"`.
       * </pre>
       *
       * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
       * @return The bytes for httpRedirectCode.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getHttpRedirectCodeBytes() {
        java.lang.Object ref = httpRedirectCode_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          httpRedirectCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int PROTOCOL_FIELD_NUMBER = 3;
      private int protocol_;
      /**
       * <pre>
       * Scheme of the redirect URI.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
       * @return The enum numeric value on the wire for protocol.
       */
      @java.lang.Override public int getProtocolValue() {
        return protocol_;
      }
      /**
       * <pre>
       * Scheme of the redirect URI.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
       * @return The protocol.
       */
      @java.lang.Override public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol getProtocol() {
        @SuppressWarnings("deprecation")
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol result = yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.valueOf(protocol_);
        return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.UNRECOGNIZED : result;
      }

      public static final int REPLACE_KEY_PREFIX_WITH_FIELD_NUMBER = 4;
      private volatile java.lang.Object replaceKeyPrefixWith_;
      /**
       * <pre>
       * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
       * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
       * </pre>
       *
       * <code>string replace_key_prefix_with = 4;</code>
       * @return The replaceKeyPrefixWith.
       */
      @java.lang.Override
      public java.lang.String getReplaceKeyPrefixWith() {
        java.lang.Object ref = replaceKeyPrefixWith_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          replaceKeyPrefixWith_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
       * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
       * </pre>
       *
       * <code>string replace_key_prefix_with = 4;</code>
       * @return The bytes for replaceKeyPrefixWith.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getReplaceKeyPrefixWithBytes() {
        java.lang.Object ref = replaceKeyPrefixWith_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          replaceKeyPrefixWith_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REPLACE_KEY_WITH_FIELD_NUMBER = 5;
      private volatile java.lang.Object replaceKeyWith_;
      /**
       * <pre>
       * New object key.
       * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
       * </pre>
       *
       * <code>string replace_key_with = 5;</code>
       * @return The replaceKeyWith.
       */
      @java.lang.Override
      public java.lang.String getReplaceKeyWith() {
        java.lang.Object ref = replaceKeyWith_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          replaceKeyWith_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * New object key.
       * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
       * </pre>
       *
       * <code>string replace_key_with = 5;</code>
       * @return The bytes for replaceKeyWith.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getReplaceKeyWithBytes() {
        java.lang.Object ref = replaceKeyWith_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          replaceKeyWith_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hostname_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpRedirectCode_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, httpRedirectCode_);
        }
        if (protocol_ != yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.PROTOCOL_UNSPECIFIED.getNumber()) {
          output.writeEnum(3, protocol_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(replaceKeyPrefixWith_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, replaceKeyPrefixWith_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(replaceKeyWith_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 5, replaceKeyWith_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, hostname_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpRedirectCode_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, httpRedirectCode_);
        }
        if (protocol_ != yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.PROTOCOL_UNSPECIFIED.getNumber()) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(3, protocol_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(replaceKeyPrefixWith_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, replaceKeyPrefixWith_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(replaceKeyWith_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, replaceKeyWith_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect other = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect) obj;

        if (!getHostname()
            .equals(other.getHostname())) return false;
        if (!getHttpRedirectCode()
            .equals(other.getHttpRedirectCode())) return false;
        if (protocol_ != other.protocol_) return false;
        if (!getReplaceKeyPrefixWith()
            .equals(other.getReplaceKeyPrefixWith())) return false;
        if (!getReplaceKeyWith()
            .equals(other.getReplaceKeyWith())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
        hash = (53 * hash) + getHostname().hashCode();
        hash = (37 * hash) + HTTP_REDIRECT_CODE_FIELD_NUMBER;
        hash = (53 * hash) + getHttpRedirectCode().hashCode();
        hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
        hash = (53 * hash) + protocol_;
        hash = (37 * hash) + REPLACE_KEY_PREFIX_WITH_FIELD_NUMBER;
        hash = (53 * hash) + getReplaceKeyPrefixWith().hashCode();
        hash = (37 * hash) + REPLACE_KEY_WITH_FIELD_NUMBER;
        hash = (53 * hash) + getReplaceKeyWith().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings.Redirect}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.WebsiteSettings.Redirect)
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RedirectOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Redirect_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Redirect_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          hostname_ = "";

          httpRedirectCode_ = "";

          protocol_ = 0;

          replaceKeyPrefixWith_ = "";

          replaceKeyWith_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_Redirect_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect result = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect(this);
          result.hostname_ = hostname_;
          result.httpRedirectCode_ = httpRedirectCode_;
          result.protocol_ = protocol_;
          result.replaceKeyPrefixWith_ = replaceKeyPrefixWith_;
          result.replaceKeyWith_ = replaceKeyWith_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.getDefaultInstance()) return this;
          if (!other.getHostname().isEmpty()) {
            hostname_ = other.hostname_;
            onChanged();
          }
          if (!other.getHttpRedirectCode().isEmpty()) {
            httpRedirectCode_ = other.httpRedirectCode_;
            onChanged();
          }
          if (other.protocol_ != 0) {
            setProtocolValue(other.getProtocolValue());
          }
          if (!other.getReplaceKeyPrefixWith().isEmpty()) {
            replaceKeyPrefixWith_ = other.replaceKeyPrefixWith_;
            onChanged();
          }
          if (!other.getReplaceKeyWith().isEmpty()) {
            replaceKeyWith_ = other.replaceKeyWith_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object hostname_ = "";
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 1;</code>
         * @return The hostname.
         */
        public java.lang.String getHostname() {
          java.lang.Object ref = hostname_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            hostname_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 1;</code>
         * @return The bytes for hostname.
         */
        public com.google.protobuf.ByteString
            getHostnameBytes() {
          java.lang.Object ref = hostname_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            hostname_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 1;</code>
         * @param value The hostname to set.
         * @return This builder for chaining.
         */
        public Builder setHostname(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          hostname_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearHostname() {
          
          hostname_ = getDefaultInstance().getHostname();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Hostname of the redirect URI.
         * </pre>
         *
         * <code>string hostname = 1;</code>
         * @param value The bytes for hostname to set.
         * @return This builder for chaining.
         */
        public Builder setHostnameBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          hostname_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object httpRedirectCode_ = "";
        /**
         * <pre>
         * HTTP status code of the redirect response.
         * Default value: `"301"`.
         * </pre>
         *
         * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
         * @return The httpRedirectCode.
         */
        public java.lang.String getHttpRedirectCode() {
          java.lang.Object ref = httpRedirectCode_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            httpRedirectCode_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * HTTP status code of the redirect response.
         * Default value: `"301"`.
         * </pre>
         *
         * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
         * @return The bytes for httpRedirectCode.
         */
        public com.google.protobuf.ByteString
            getHttpRedirectCodeBytes() {
          java.lang.Object ref = httpRedirectCode_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            httpRedirectCode_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * HTTP status code of the redirect response.
         * Default value: `"301"`.
         * </pre>
         *
         * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
         * @param value The httpRedirectCode to set.
         * @return This builder for chaining.
         */
        public Builder setHttpRedirectCode(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          httpRedirectCode_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * HTTP status code of the redirect response.
         * Default value: `"301"`.
         * </pre>
         *
         * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
         * @return This builder for chaining.
         */
        public Builder clearHttpRedirectCode() {
          
          httpRedirectCode_ = getDefaultInstance().getHttpRedirectCode();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * HTTP status code of the redirect response.
         * Default value: `"301"`.
         * </pre>
         *
         * <code>string http_redirect_code = 2 [(.yandex.cloud.pattern) = "3(0[1-9]|[1-9][0-9])"];</code>
         * @param value The bytes for httpRedirectCode to set.
         * @return This builder for chaining.
         */
        public Builder setHttpRedirectCodeBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          httpRedirectCode_ = value;
          onChanged();
          return this;
        }

        private int protocol_ = 0;
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
         * @return The enum numeric value on the wire for protocol.
         */
        @java.lang.Override public int getProtocolValue() {
          return protocol_;
        }
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
         * @param value The enum numeric value on the wire for protocol to set.
         * @return This builder for chaining.
         */
        public Builder setProtocolValue(int value) {
          
          protocol_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
         * @return The protocol.
         */
        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol getProtocol() {
          @SuppressWarnings("deprecation")
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol result = yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.valueOf(protocol_);
          return result == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol.UNRECOGNIZED : result;
        }
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
         * @param value The protocol to set.
         * @return This builder for chaining.
         */
        public Builder setProtocol(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Protocol value) {
          if (value == null) {
            throw new NullPointerException();
          }
          
          protocol_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Scheme of the redirect URI.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Protocol protocol = 3;</code>
         * @return This builder for chaining.
         */
        public Builder clearProtocol() {
          
          protocol_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object replaceKeyPrefixWith_ = "";
        /**
         * <pre>
         * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
         * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_prefix_with = 4;</code>
         * @return The replaceKeyPrefixWith.
         */
        public java.lang.String getReplaceKeyPrefixWith() {
          java.lang.Object ref = replaceKeyPrefixWith_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            replaceKeyPrefixWith_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
         * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_prefix_with = 4;</code>
         * @return The bytes for replaceKeyPrefixWith.
         */
        public com.google.protobuf.ByteString
            getReplaceKeyPrefixWithBytes() {
          java.lang.Object ref = replaceKeyPrefixWith_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            replaceKeyPrefixWith_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
         * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_prefix_with = 4;</code>
         * @param value The replaceKeyPrefixWith to set.
         * @return This builder for chaining.
         */
        public Builder setReplaceKeyPrefixWith(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          replaceKeyPrefixWith_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
         * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_prefix_with = 4;</code>
         * @return This builder for chaining.
         */
        public Builder clearReplaceKeyPrefixWith() {
          
          replaceKeyPrefixWith_ = getDefaultInstance().getReplaceKeyPrefixWith();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Substitution for the prefix of the object key specified in [Condition.key_prefix_equals].
         * At most one of [replace_key_prefix_with] and [replace_key_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_prefix_with = 4;</code>
         * @param value The bytes for replaceKeyPrefixWith to set.
         * @return This builder for chaining.
         */
        public Builder setReplaceKeyPrefixWithBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          replaceKeyPrefixWith_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object replaceKeyWith_ = "";
        /**
         * <pre>
         * New object key.
         * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_with = 5;</code>
         * @return The replaceKeyWith.
         */
        public java.lang.String getReplaceKeyWith() {
          java.lang.Object ref = replaceKeyWith_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            replaceKeyWith_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * New object key.
         * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_with = 5;</code>
         * @return The bytes for replaceKeyWith.
         */
        public com.google.protobuf.ByteString
            getReplaceKeyWithBytes() {
          java.lang.Object ref = replaceKeyWith_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            replaceKeyWith_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * New object key.
         * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_with = 5;</code>
         * @param value The replaceKeyWith to set.
         * @return This builder for chaining.
         */
        public Builder setReplaceKeyWith(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          replaceKeyWith_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * New object key.
         * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_with = 5;</code>
         * @return This builder for chaining.
         */
        public Builder clearReplaceKeyWith() {
          
          replaceKeyWith_ = getDefaultInstance().getReplaceKeyWith();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * New object key.
         * At most one of [replace_key_with] and [replace_key_prefix_with] can be specified.
         * </pre>
         *
         * <code>string replace_key_with = 5;</code>
         * @param value The bytes for replaceKeyWith to set.
         * @return This builder for chaining.
         */
        public Builder setReplaceKeyWithBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          replaceKeyWith_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.WebsiteSettings.Redirect)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.WebsiteSettings.Redirect)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Redirect>
          PARSER = new com.google.protobuf.AbstractParser<Redirect>() {
        @java.lang.Override
        public Redirect parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Redirect(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Redirect> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Redirect> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface RoutingRuleOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.WebsiteSettings.RoutingRule)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Redirect condition.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
       * @return Whether the condition field is set.
       */
      boolean hasCondition();
      /**
       * <pre>
       * Redirect condition.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
       * @return The condition.
       */
      yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition getCondition();
      /**
       * <pre>
       * Redirect condition.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
       */
      yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.ConditionOrBuilder getConditionOrBuilder();

      /**
       * <pre>
       * Redirect instructions.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
       * @return Whether the redirect field is set.
       */
      boolean hasRedirect();
      /**
       * <pre>
       * Redirect instructions.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
       * @return The redirect.
       */
      yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect getRedirect();
      /**
       * <pre>
       * Redirect instructions.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
       */
      yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RedirectOrBuilder getRedirectOrBuilder();
    }
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings.RoutingRule}
     */
    public static final class RoutingRule extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.WebsiteSettings.RoutingRule)
        RoutingRuleOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use RoutingRule.newBuilder() to construct.
      private RoutingRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private RoutingRule() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new RoutingRule();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private RoutingRule(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.Builder subBuilder = null;
                if (condition_ != null) {
                  subBuilder = condition_.toBuilder();
                }
                condition_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(condition_);
                  condition_ = subBuilder.buildPartial();
                }

                break;
              }
              case 18: {
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.Builder subBuilder = null;
                if (redirect_ != null) {
                  subBuilder = redirect_.toBuilder();
                }
                redirect_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(redirect_);
                  redirect_ = subBuilder.buildPartial();
                }

                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_RoutingRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_RoutingRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder.class);
      }

      public static final int CONDITION_FIELD_NUMBER = 1;
      private yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition condition_;
      /**
       * <pre>
       * Redirect condition.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
       * @return Whether the condition field is set.
       */
      @java.lang.Override
      public boolean hasCondition() {
        return condition_ != null;
      }
      /**
       * <pre>
       * Redirect condition.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
       * @return The condition.
       */
      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition getCondition() {
        return condition_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.getDefaultInstance() : condition_;
      }
      /**
       * <pre>
       * Redirect condition.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
       */
      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.ConditionOrBuilder getConditionOrBuilder() {
        return getCondition();
      }

      public static final int REDIRECT_FIELD_NUMBER = 2;
      private yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect redirect_;
      /**
       * <pre>
       * Redirect instructions.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
       * @return Whether the redirect field is set.
       */
      @java.lang.Override
      public boolean hasRedirect() {
        return redirect_ != null;
      }
      /**
       * <pre>
       * Redirect instructions.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
       * @return The redirect.
       */
      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect getRedirect() {
        return redirect_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.getDefaultInstance() : redirect_;
      }
      /**
       * <pre>
       * Redirect instructions.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
       */
      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RedirectOrBuilder getRedirectOrBuilder() {
        return getRedirect();
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (condition_ != null) {
          output.writeMessage(1, getCondition());
        }
        if (redirect_ != null) {
          output.writeMessage(2, getRedirect());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (condition_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getCondition());
        }
        if (redirect_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getRedirect());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule other = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule) obj;

        if (hasCondition() != other.hasCondition()) return false;
        if (hasCondition()) {
          if (!getCondition()
              .equals(other.getCondition())) return false;
        }
        if (hasRedirect() != other.hasRedirect()) return false;
        if (hasRedirect()) {
          if (!getRedirect()
              .equals(other.getRedirect())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasCondition()) {
          hash = (37 * hash) + CONDITION_FIELD_NUMBER;
          hash = (53 * hash) + getCondition().hashCode();
        }
        if (hasRedirect()) {
          hash = (37 * hash) + REDIRECT_FIELD_NUMBER;
          hash = (53 * hash) + getRedirect().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings.RoutingRule}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.WebsiteSettings.RoutingRule)
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_RoutingRule_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_RoutingRule_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (conditionBuilder_ == null) {
            condition_ = null;
          } else {
            condition_ = null;
            conditionBuilder_ = null;
          }
          if (redirectBuilder_ == null) {
            redirect_ = null;
          } else {
            redirect_ = null;
            redirectBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_RoutingRule_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule result = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule(this);
          if (conditionBuilder_ == null) {
            result.condition_ = condition_;
          } else {
            result.condition_ = conditionBuilder_.build();
          }
          if (redirectBuilder_ == null) {
            result.redirect_ = redirect_;
          } else {
            result.redirect_ = redirectBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.getDefaultInstance()) return this;
          if (other.hasCondition()) {
            mergeCondition(other.getCondition());
          }
          if (other.hasRedirect()) {
            mergeRedirect(other.getRedirect());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition condition_;
        private com.google.protobuf.SingleFieldBuilderV3<
            yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.ConditionOrBuilder> conditionBuilder_;
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         * @return Whether the condition field is set.
         */
        public boolean hasCondition() {
          return conditionBuilder_ != null || condition_ != null;
        }
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         * @return The condition.
         */
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition getCondition() {
          if (conditionBuilder_ == null) {
            return condition_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.getDefaultInstance() : condition_;
          } else {
            return conditionBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         */
        public Builder setCondition(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition value) {
          if (conditionBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            condition_ = value;
            onChanged();
          } else {
            conditionBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         */
        public Builder setCondition(
            yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.Builder builderForValue) {
          if (conditionBuilder_ == null) {
            condition_ = builderForValue.build();
            onChanged();
          } else {
            conditionBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         */
        public Builder mergeCondition(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition value) {
          if (conditionBuilder_ == null) {
            if (condition_ != null) {
              condition_ =
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.newBuilder(condition_).mergeFrom(value).buildPartial();
            } else {
              condition_ = value;
            }
            onChanged();
          } else {
            conditionBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         */
        public Builder clearCondition() {
          if (conditionBuilder_ == null) {
            condition_ = null;
            onChanged();
          } else {
            condition_ = null;
            conditionBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         */
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.Builder getConditionBuilder() {
          
          onChanged();
          return getConditionFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         */
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.ConditionOrBuilder getConditionOrBuilder() {
          if (conditionBuilder_ != null) {
            return conditionBuilder_.getMessageOrBuilder();
          } else {
            return condition_ == null ?
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.getDefaultInstance() : condition_;
          }
        }
        /**
         * <pre>
         * Redirect condition.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Condition condition = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.ConditionOrBuilder> 
            getConditionFieldBuilder() {
          if (conditionBuilder_ == null) {
            conditionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Condition.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.ConditionOrBuilder>(
                    getCondition(),
                    getParentForChildren(),
                    isClean());
            condition_ = null;
          }
          return conditionBuilder_;
        }

        private yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect redirect_;
        private com.google.protobuf.SingleFieldBuilderV3<
            yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RedirectOrBuilder> redirectBuilder_;
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         * @return Whether the redirect field is set.
         */
        public boolean hasRedirect() {
          return redirectBuilder_ != null || redirect_ != null;
        }
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         * @return The redirect.
         */
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect getRedirect() {
          if (redirectBuilder_ == null) {
            return redirect_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.getDefaultInstance() : redirect_;
          } else {
            return redirectBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         */
        public Builder setRedirect(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect value) {
          if (redirectBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            redirect_ = value;
            onChanged();
          } else {
            redirectBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         */
        public Builder setRedirect(
            yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.Builder builderForValue) {
          if (redirectBuilder_ == null) {
            redirect_ = builderForValue.build();
            onChanged();
          } else {
            redirectBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         */
        public Builder mergeRedirect(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect value) {
          if (redirectBuilder_ == null) {
            if (redirect_ != null) {
              redirect_ =
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.newBuilder(redirect_).mergeFrom(value).buildPartial();
            } else {
              redirect_ = value;
            }
            onChanged();
          } else {
            redirectBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         */
        public Builder clearRedirect() {
          if (redirectBuilder_ == null) {
            redirect_ = null;
            onChanged();
          } else {
            redirect_ = null;
            redirectBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         */
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.Builder getRedirectBuilder() {
          
          onChanged();
          return getRedirectFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         */
        public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RedirectOrBuilder getRedirectOrBuilder() {
          if (redirectBuilder_ != null) {
            return redirectBuilder_.getMessageOrBuilder();
          } else {
            return redirect_ == null ?
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.getDefaultInstance() : redirect_;
          }
        }
        /**
         * <pre>
         * Redirect instructions.
         * </pre>
         *
         * <code>.yandex.cloud.storage.v1.WebsiteSettings.Redirect redirect = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RedirectOrBuilder> 
            getRedirectFieldBuilder() {
          if (redirectBuilder_ == null) {
            redirectBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Redirect.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RedirectOrBuilder>(
                    getRedirect(),
                    getParentForChildren(),
                    isClean());
            redirect_ = null;
          }
          return redirectBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.WebsiteSettings.RoutingRule)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.WebsiteSettings.RoutingRule)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RoutingRule>
          PARSER = new com.google.protobuf.AbstractParser<RoutingRule>() {
        @java.lang.Override
        public RoutingRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RoutingRule(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<RoutingRule> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RoutingRule> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int INDEX_FIELD_NUMBER = 1;
    private volatile java.lang.Object index_;
    /**
     * <pre>
     * Key of the index page object that is returned when a response is made to the root of the website.
     * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
     * If specified, the index page object must be located in the root of the bucket.
     * </pre>
     *
     * <code>string index = 1;</code>
     * @return The index.
     */
    @java.lang.Override
    public java.lang.String getIndex() {
      java.lang.Object ref = index_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        index_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Key of the index page object that is returned when a response is made to the root of the website.
     * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
     * If specified, the index page object must be located in the root of the bucket.
     * </pre>
     *
     * <code>string index = 1;</code>
     * @return The bytes for index.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getIndexBytes() {
      java.lang.Object ref = index_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        index_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERROR_FIELD_NUMBER = 2;
    private volatile java.lang.Object error_;
    /**
     * <pre>
     * Key of the error page object that is returned when an error occurs.
     * </pre>
     *
     * <code>string error = 2;</code>
     * @return The error.
     */
    @java.lang.Override
    public java.lang.String getError() {
      java.lang.Object ref = error_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        error_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Key of the error page object that is returned when an error occurs.
     * </pre>
     *
     * <code>string error = 2;</code>
     * @return The bytes for error.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getErrorBytes() {
      java.lang.Object ref = error_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        error_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REDIRECT_ALL_REQUESTS_FIELD_NUMBER = 3;
    private yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme redirectAllRequests_;
    /**
     * <pre>
     * Configuration for redirecting all requests sent to the website.
     * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
     * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
     * @return Whether the redirectAllRequests field is set.
     */
    @java.lang.Override
    public boolean hasRedirectAllRequests() {
      return redirectAllRequests_ != null;
    }
    /**
     * <pre>
     * Configuration for redirecting all requests sent to the website.
     * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
     * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
     * @return The redirectAllRequests.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme getRedirectAllRequests() {
      return redirectAllRequests_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.getDefaultInstance() : redirectAllRequests_;
    }
    /**
     * <pre>
     * Configuration for redirecting all requests sent to the website.
     * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
     * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.SchemeOrBuilder getRedirectAllRequestsOrBuilder() {
      return getRedirectAllRequests();
    }

    public static final int ROUTING_RULES_FIELD_NUMBER = 4;
    private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule> routingRules_;
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    @java.lang.Override
    public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule> getRoutingRulesList() {
      return routingRules_;
    }
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    @java.lang.Override
    public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder> 
        getRoutingRulesOrBuilderList() {
      return routingRules_;
    }
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    @java.lang.Override
    public int getRoutingRulesCount() {
      return routingRules_.size();
    }
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule getRoutingRules(int index) {
      return routingRules_.get(index);
    }
    /**
     * <pre>
     * List of redirect rules.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder getRoutingRulesOrBuilder(
        int index) {
      return routingRules_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, index_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(error_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, error_);
      }
      if (redirectAllRequests_ != null) {
        output.writeMessage(3, getRedirectAllRequests());
      }
      for (int i = 0; i < routingRules_.size(); i++) {
        output.writeMessage(4, routingRules_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(index_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, index_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(error_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, error_);
      }
      if (redirectAllRequests_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getRedirectAllRequests());
      }
      for (int i = 0; i < routingRules_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, routingRules_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings)) {
        return super.equals(obj);
      }
      yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings other = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings) obj;

      if (!getIndex()
          .equals(other.getIndex())) return false;
      if (!getError()
          .equals(other.getError())) return false;
      if (hasRedirectAllRequests() != other.hasRedirectAllRequests()) return false;
      if (hasRedirectAllRequests()) {
        if (!getRedirectAllRequests()
            .equals(other.getRedirectAllRequests())) return false;
      }
      if (!getRoutingRulesList()
          .equals(other.getRoutingRulesList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + getIndex().hashCode();
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
      if (hasRedirectAllRequests()) {
        hash = (37 * hash) + REDIRECT_ALL_REQUESTS_FIELD_NUMBER;
        hash = (53 * hash) + getRedirectAllRequests().hashCode();
      }
      if (getRoutingRulesCount() > 0) {
        hash = (37 * hash) + ROUTING_RULES_FIELD_NUMBER;
        hash = (53 * hash) + getRoutingRulesList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.WebsiteSettings}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.WebsiteSettings)
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettingsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.class, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Builder.class);
      }

      // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getRoutingRulesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        index_ = "";

        error_ = "";

        if (redirectAllRequestsBuilder_ == null) {
          redirectAllRequests_ = null;
        } else {
          redirectAllRequests_ = null;
          redirectAllRequestsBuilder_ = null;
        }
        if (routingRulesBuilder_ == null) {
          routingRules_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          routingRulesBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_WebsiteSettings_descriptor;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings getDefaultInstanceForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.getDefaultInstance();
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings build() {
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings buildPartial() {
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings result = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings(this);
        int from_bitField0_ = bitField0_;
        result.index_ = index_;
        result.error_ = error_;
        if (redirectAllRequestsBuilder_ == null) {
          result.redirectAllRequests_ = redirectAllRequests_;
        } else {
          result.redirectAllRequests_ = redirectAllRequestsBuilder_.build();
        }
        if (routingRulesBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            routingRules_ = java.util.Collections.unmodifiableList(routingRules_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.routingRules_ = routingRules_;
        } else {
          result.routingRules_ = routingRulesBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings) {
          return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings other) {
        if (other == yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.getDefaultInstance()) return this;
        if (!other.getIndex().isEmpty()) {
          index_ = other.index_;
          onChanged();
        }
        if (!other.getError().isEmpty()) {
          error_ = other.error_;
          onChanged();
        }
        if (other.hasRedirectAllRequests()) {
          mergeRedirectAllRequests(other.getRedirectAllRequests());
        }
        if (routingRulesBuilder_ == null) {
          if (!other.routingRules_.isEmpty()) {
            if (routingRules_.isEmpty()) {
              routingRules_ = other.routingRules_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureRoutingRulesIsMutable();
              routingRules_.addAll(other.routingRules_);
            }
            onChanged();
          }
        } else {
          if (!other.routingRules_.isEmpty()) {
            if (routingRulesBuilder_.isEmpty()) {
              routingRulesBuilder_.dispose();
              routingRulesBuilder_ = null;
              routingRules_ = other.routingRules_;
              bitField0_ = (bitField0_ & ~0x00000001);
              routingRulesBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getRoutingRulesFieldBuilder() : null;
            } else {
              routingRulesBuilder_.addAllMessages(other.routingRules_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object index_ = "";
      /**
       * <pre>
       * Key of the index page object that is returned when a response is made to the root of the website.
       * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
       * If specified, the index page object must be located in the root of the bucket.
       * </pre>
       *
       * <code>string index = 1;</code>
       * @return The index.
       */
      public java.lang.String getIndex() {
        java.lang.Object ref = index_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          index_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Key of the index page object that is returned when a response is made to the root of the website.
       * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
       * If specified, the index page object must be located in the root of the bucket.
       * </pre>
       *
       * <code>string index = 1;</code>
       * @return The bytes for index.
       */
      public com.google.protobuf.ByteString
          getIndexBytes() {
        java.lang.Object ref = index_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          index_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Key of the index page object that is returned when a response is made to the root of the website.
       * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
       * If specified, the index page object must be located in the root of the bucket.
       * </pre>
       *
       * <code>string index = 1;</code>
       * @param value The index to set.
       * @return This builder for chaining.
       */
      public Builder setIndex(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        index_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Key of the index page object that is returned when a response is made to the root of the website.
       * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
       * If specified, the index page object must be located in the root of the bucket.
       * </pre>
       *
       * <code>string index = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearIndex() {
        
        index_ = getDefaultInstance().getIndex();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Key of the index page object that is returned when a response is made to the root of the website.
       * Either [index] or [redirect_all_requests] must be specified in order for the bucket to host a static website.
       * If specified, the index page object must be located in the root of the bucket.
       * </pre>
       *
       * <code>string index = 1;</code>
       * @param value The bytes for index to set.
       * @return This builder for chaining.
       */
      public Builder setIndexBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        index_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object error_ = "";
      /**
       * <pre>
       * Key of the error page object that is returned when an error occurs.
       * </pre>
       *
       * <code>string error = 2;</code>
       * @return The error.
       */
      public java.lang.String getError() {
        java.lang.Object ref = error_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          error_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Key of the error page object that is returned when an error occurs.
       * </pre>
       *
       * <code>string error = 2;</code>
       * @return The bytes for error.
       */
      public com.google.protobuf.ByteString
          getErrorBytes() {
        java.lang.Object ref = error_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          error_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Key of the error page object that is returned when an error occurs.
       * </pre>
       *
       * <code>string error = 2;</code>
       * @param value The error to set.
       * @return This builder for chaining.
       */
      public Builder setError(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        error_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Key of the error page object that is returned when an error occurs.
       * </pre>
       *
       * <code>string error = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearError() {
        
        error_ = getDefaultInstance().getError();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Key of the error page object that is returned when an error occurs.
       * </pre>
       *
       * <code>string error = 2;</code>
       * @param value The bytes for error to set.
       * @return This builder for chaining.
       */
      public Builder setErrorBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        error_ = value;
        onChanged();
        return this;
      }

      private yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme redirectAllRequests_;
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.SchemeOrBuilder> redirectAllRequestsBuilder_;
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       * @return Whether the redirectAllRequests field is set.
       */
      public boolean hasRedirectAllRequests() {
        return redirectAllRequestsBuilder_ != null || redirectAllRequests_ != null;
      }
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       * @return The redirectAllRequests.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme getRedirectAllRequests() {
        if (redirectAllRequestsBuilder_ == null) {
          return redirectAllRequests_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.getDefaultInstance() : redirectAllRequests_;
        } else {
          return redirectAllRequestsBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       */
      public Builder setRedirectAllRequests(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme value) {
        if (redirectAllRequestsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          redirectAllRequests_ = value;
          onChanged();
        } else {
          redirectAllRequestsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       */
      public Builder setRedirectAllRequests(
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.Builder builderForValue) {
        if (redirectAllRequestsBuilder_ == null) {
          redirectAllRequests_ = builderForValue.build();
          onChanged();
        } else {
          redirectAllRequestsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       */
      public Builder mergeRedirectAllRequests(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme value) {
        if (redirectAllRequestsBuilder_ == null) {
          if (redirectAllRequests_ != null) {
            redirectAllRequests_ =
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.newBuilder(redirectAllRequests_).mergeFrom(value).buildPartial();
          } else {
            redirectAllRequests_ = value;
          }
          onChanged();
        } else {
          redirectAllRequestsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       */
      public Builder clearRedirectAllRequests() {
        if (redirectAllRequestsBuilder_ == null) {
          redirectAllRequests_ = null;
          onChanged();
        } else {
          redirectAllRequests_ = null;
          redirectAllRequestsBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.Builder getRedirectAllRequestsBuilder() {
        
        onChanged();
        return getRedirectAllRequestsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.SchemeOrBuilder getRedirectAllRequestsOrBuilder() {
        if (redirectAllRequestsBuilder_ != null) {
          return redirectAllRequestsBuilder_.getMessageOrBuilder();
        } else {
          return redirectAllRequests_ == null ?
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.getDefaultInstance() : redirectAllRequests_;
        }
      }
      /**
       * <pre>
       * Configuration for redirecting all requests sent to the website.
       * Either [redirect_all_requests] or [index] must be specified in order for the bucket to host a static website.
       * If [redirect_all_requests] is specified, it must be the only field in [Bucket.website_settings].
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.WebsiteSettings.Scheme redirect_all_requests = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.SchemeOrBuilder> 
          getRedirectAllRequestsFieldBuilder() {
        if (redirectAllRequestsBuilder_ == null) {
          redirectAllRequestsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.Scheme.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.SchemeOrBuilder>(
                  getRedirectAllRequests(),
                  getParentForChildren(),
                  isClean());
          redirectAllRequests_ = null;
        }
        return redirectAllRequestsBuilder_;
      }

      private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule> routingRules_ =
        java.util.Collections.emptyList();
      private void ensureRoutingRulesIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          routingRules_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule>(routingRules_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder> routingRulesBuilder_;

      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule> getRoutingRulesList() {
        if (routingRulesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(routingRules_);
        } else {
          return routingRulesBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public int getRoutingRulesCount() {
        if (routingRulesBuilder_ == null) {
          return routingRules_.size();
        } else {
          return routingRulesBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule getRoutingRules(int index) {
        if (routingRulesBuilder_ == null) {
          return routingRules_.get(index);
        } else {
          return routingRulesBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder setRoutingRules(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule value) {
        if (routingRulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRoutingRulesIsMutable();
          routingRules_.set(index, value);
          onChanged();
        } else {
          routingRulesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder setRoutingRules(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder builderForValue) {
        if (routingRulesBuilder_ == null) {
          ensureRoutingRulesIsMutable();
          routingRules_.set(index, builderForValue.build());
          onChanged();
        } else {
          routingRulesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder addRoutingRules(yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule value) {
        if (routingRulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRoutingRulesIsMutable();
          routingRules_.add(value);
          onChanged();
        } else {
          routingRulesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder addRoutingRules(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule value) {
        if (routingRulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRoutingRulesIsMutable();
          routingRules_.add(index, value);
          onChanged();
        } else {
          routingRulesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder addRoutingRules(
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder builderForValue) {
        if (routingRulesBuilder_ == null) {
          ensureRoutingRulesIsMutable();
          routingRules_.add(builderForValue.build());
          onChanged();
        } else {
          routingRulesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder addRoutingRules(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder builderForValue) {
        if (routingRulesBuilder_ == null) {
          ensureRoutingRulesIsMutable();
          routingRules_.add(index, builderForValue.build());
          onChanged();
        } else {
          routingRulesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder addAllRoutingRules(
          java.lang.Iterable<? extends yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule> values) {
        if (routingRulesBuilder_ == null) {
          ensureRoutingRulesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, routingRules_);
          onChanged();
        } else {
          routingRulesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder clearRoutingRules() {
        if (routingRulesBuilder_ == null) {
          routingRules_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          routingRulesBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public Builder removeRoutingRules(int index) {
        if (routingRulesBuilder_ == null) {
          ensureRoutingRulesIsMutable();
          routingRules_.remove(index);
          onChanged();
        } else {
          routingRulesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder getRoutingRulesBuilder(
          int index) {
        return getRoutingRulesFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder getRoutingRulesOrBuilder(
          int index) {
        if (routingRulesBuilder_ == null) {
          return routingRules_.get(index);  } else {
          return routingRulesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder> 
           getRoutingRulesOrBuilderList() {
        if (routingRulesBuilder_ != null) {
          return routingRulesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(routingRules_);
        }
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder addRoutingRulesBuilder() {
        return getRoutingRulesFieldBuilder().addBuilder(
            yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.getDefaultInstance());
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder addRoutingRulesBuilder(
          int index) {
        return getRoutingRulesFieldBuilder().addBuilder(
            index, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.getDefaultInstance());
      }
      /**
       * <pre>
       * List of redirect rules.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.WebsiteSettings.RoutingRule routing_rules = 4;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder> 
           getRoutingRulesBuilderList() {
        return getRoutingRulesFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder> 
          getRoutingRulesFieldBuilder() {
        if (routingRulesBuilder_ == null) {
          routingRulesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRule.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings.RoutingRuleOrBuilder>(
                  routingRules_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          routingRules_ = null;
        }
        return routingRulesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.WebsiteSettings)
    }

    // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.WebsiteSettings)
    private static final yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings();
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebsiteSettings>
        PARSER = new com.google.protobuf.AbstractParser<WebsiteSettings>() {
      @java.lang.Override
      public WebsiteSettings parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new WebsiteSettings(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<WebsiteSettings> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebsiteSettings> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.WebsiteSettings getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface LifecycleRuleOrBuilder extends
      // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.LifecycleRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID of the rule. Provided by the client or generated at creation time.
     * </pre>
     *
     * <code>.google.protobuf.StringValue id = 1;</code>
     * @return Whether the id field is set.
     */
    boolean hasId();
    /**
     * <pre>
     * ID of the rule. Provided by the client or generated at creation time.
     * </pre>
     *
     * <code>.google.protobuf.StringValue id = 1;</code>
     * @return The id.
     */
    com.google.protobuf.StringValue getId();
    /**
     * <pre>
     * ID of the rule. Provided by the client or generated at creation time.
     * </pre>
     *
     * <code>.google.protobuf.StringValue id = 1;</code>
     */
    com.google.protobuf.StringValueOrBuilder getIdOrBuilder();

    /**
     * <pre>
     * Indicates whether the rule is in effect.
     * </pre>
     *
     * <code>bool enabled = 2;</code>
     * @return The enabled.
     */
    boolean getEnabled();

    /**
     * <pre>
     * Filter that identifies the objects to which the rule applies.
     * If not specified, the rule applies to all objects in the bucket.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
     * @return Whether the filter field is set.
     */
    boolean hasFilter();
    /**
     * <pre>
     * Filter that identifies the objects to which the rule applies.
     * If not specified, the rule applies to all objects in the bucket.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
     * @return The filter.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter getFilter();
    /**
     * <pre>
     * Filter that identifies the objects to which the rule applies.
     * If not specified, the rule applies to all objects in the bucket.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilterOrBuilder getFilterOrBuilder();

    /**
     * <pre>
     * Expiration rule.
     * The expiration of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
     * recovered.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
     * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
     * the current version of the object.
     * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
     * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
     * delete marker becomes the current version of the object.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
     * @return Whether the expiration field is set.
     */
    boolean hasExpiration();
    /**
     * <pre>
     * Expiration rule.
     * The expiration of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
     * recovered.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
     * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
     * the current version of the object.
     * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
     * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
     * delete marker becomes the current version of the object.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
     * @return The expiration.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration getExpiration();
    /**
     * <pre>
     * Expiration rule.
     * The expiration of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
     * recovered.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
     * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
     * the current version of the object.
     * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
     * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
     * delete marker becomes the current version of the object.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.ExpirationOrBuilder getExpirationOrBuilder();

    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition> 
        getTransitionsList();
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition getTransitions(int index);
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    int getTransitionsCount();
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.TransitionOrBuilder> 
        getTransitionsOrBuilderList();
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.TransitionOrBuilder getTransitionsOrBuilder(
        int index);

    /**
     * <pre>
     * Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.AfterDays abort_incomplete_multipart_upload = 6;</code>
     * @return Whether the abortIncompleteMultipartUpload field is set.
     */
    boolean hasAbortIncompleteMultipartUpload();
    /**
     * <pre>
     * Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.AfterDays abort_incomplete_multipart_upload = 6;</code>
     * @return The abortIncompleteMultipartUpload.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays getAbortIncompleteMultipartUpload();
    /**
     * <pre>
     * Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.AfterDays abort_incomplete_multipart_upload = 6;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDaysOrBuilder getAbortIncompleteMultipartUploadOrBuilder();

    /**
     * <pre>
     * Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
     * `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At expiration, the non-current version of the object is deleted and cannot be recovered.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration noncurrent_expiration = 7;</code>
     * @return Whether the noncurrentExpiration field is set.
     */
    boolean hasNoncurrentExpiration();
    /**
     * <pre>
     * Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
     * `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At expiration, the non-current version of the object is deleted and cannot be recovered.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration noncurrent_expiration = 7;</code>
     * @return The noncurrentExpiration.
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration getNoncurrentExpiration();
    /**
     * <pre>
     * Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
     * `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At expiration, the non-current version of the object is deleted and cannot be recovered.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration noncurrent_expiration = 7;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpirationOrBuilder getNoncurrentExpirationOrBuilder();

    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition> 
        getNoncurrentTransitionsList();
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition getNoncurrentTransitions(int index);
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    int getNoncurrentTransitionsCount();
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransitionOrBuilder> 
        getNoncurrentTransitionsOrBuilderList();
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransitionOrBuilder getNoncurrentTransitionsOrBuilder(
        int index);
  }
  /**
   * <pre>
   * An object lifecycle rule resource for the bucket.
   * For details about the concept, see [documentation](/docs/storage/concepts/lifecycles).
   * </pre>
   *
   * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule}
   */
  public static final class LifecycleRule extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.LifecycleRule)
      LifecycleRuleOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use LifecycleRule.newBuilder() to construct.
    private LifecycleRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private LifecycleRule() {
      transitions_ = java.util.Collections.emptyList();
      noncurrentTransitions_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new LifecycleRule();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private LifecycleRule(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.StringValue.Builder subBuilder = null;
              if (id_ != null) {
                subBuilder = id_.toBuilder();
              }
              id_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(id_);
                id_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {

              enabled_ = input.readBool();
              break;
            }
            case 26: {
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.Builder subBuilder = null;
              if (filter_ != null) {
                subBuilder = filter_.toBuilder();
              }
              filter_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(filter_);
                filter_ = subBuilder.buildPartial();
              }

              break;
            }
            case 34: {
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.Builder subBuilder = null;
              if (expiration_ != null) {
                subBuilder = expiration_.toBuilder();
              }
              expiration_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(expiration_);
                expiration_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                transitions_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition>();
                mutable_bitField0_ |= 0x00000001;
              }
              transitions_.add(
                  input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.parser(), extensionRegistry));
              break;
            }
            case 50: {
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.Builder subBuilder = null;
              if (abortIncompleteMultipartUpload_ != null) {
                subBuilder = abortIncompleteMultipartUpload_.toBuilder();
              }
              abortIncompleteMultipartUpload_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(abortIncompleteMultipartUpload_);
                abortIncompleteMultipartUpload_ = subBuilder.buildPartial();
              }

              break;
            }
            case 58: {
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.Builder subBuilder = null;
              if (noncurrentExpiration_ != null) {
                subBuilder = noncurrentExpiration_.toBuilder();
              }
              noncurrentExpiration_ = input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(noncurrentExpiration_);
                noncurrentExpiration_ = subBuilder.buildPartial();
              }

              break;
            }
            case 66: {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                noncurrentTransitions_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition>();
                mutable_bitField0_ |= 0x00000002;
              }
              noncurrentTransitions_.add(
                  input.readMessage(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition.parser(), extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          transitions_ = java.util.Collections.unmodifiableList(transitions_);
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          noncurrentTransitions_ = java.util.Collections.unmodifiableList(noncurrentTransitions_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder.class);
    }

    public interface AfterDaysOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.LifecycleRule.AfterDays)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
       * aborted.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
       * @return Whether the daysAfterExpiration field is set.
       */
      boolean hasDaysAfterExpiration();
      /**
       * <pre>
       * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
       * aborted.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
       * @return The daysAfterExpiration.
       */
      com.google.protobuf.Int64Value getDaysAfterExpiration();
      /**
       * <pre>
       * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
       * aborted.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
       */
      com.google.protobuf.Int64ValueOrBuilder getDaysAfterExpirationOrBuilder();
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.AfterDays}
     */
    public static final class AfterDays extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.LifecycleRule.AfterDays)
        AfterDaysOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use AfterDays.newBuilder() to construct.
      private AfterDays(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private AfterDays() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new AfterDays();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private AfterDays(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.Int64Value.Builder subBuilder = null;
                if (daysAfterExpiration_ != null) {
                  subBuilder = daysAfterExpiration_.toBuilder();
                }
                daysAfterExpiration_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(daysAfterExpiration_);
                  daysAfterExpiration_ = subBuilder.buildPartial();
                }

                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_AfterDays_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_AfterDays_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.Builder.class);
      }

      public static final int DAYS_AFTER_EXPIRATION_FIELD_NUMBER = 1;
      private com.google.protobuf.Int64Value daysAfterExpiration_;
      /**
       * <pre>
       * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
       * aborted.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
       * @return Whether the daysAfterExpiration field is set.
       */
      @java.lang.Override
      public boolean hasDaysAfterExpiration() {
        return daysAfterExpiration_ != null;
      }
      /**
       * <pre>
       * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
       * aborted.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
       * @return The daysAfterExpiration.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getDaysAfterExpiration() {
        return daysAfterExpiration_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : daysAfterExpiration_;
      }
      /**
       * <pre>
       * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
       * aborted.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getDaysAfterExpirationOrBuilder() {
        return getDaysAfterExpiration();
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (daysAfterExpiration_ != null) {
          output.writeMessage(1, getDaysAfterExpiration());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (daysAfterExpiration_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getDaysAfterExpiration());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays other = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays) obj;

        if (hasDaysAfterExpiration() != other.hasDaysAfterExpiration()) return false;
        if (hasDaysAfterExpiration()) {
          if (!getDaysAfterExpiration()
              .equals(other.getDaysAfterExpiration())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDaysAfterExpiration()) {
          hash = (37 * hash) + DAYS_AFTER_EXPIRATION_FIELD_NUMBER;
          hash = (53 * hash) + getDaysAfterExpiration().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.AfterDays}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.LifecycleRule.AfterDays)
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDaysOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_AfterDays_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_AfterDays_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (daysAfterExpirationBuilder_ == null) {
            daysAfterExpiration_ = null;
          } else {
            daysAfterExpiration_ = null;
            daysAfterExpirationBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_AfterDays_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays result = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays(this);
          if (daysAfterExpirationBuilder_ == null) {
            result.daysAfterExpiration_ = daysAfterExpiration_;
          } else {
            result.daysAfterExpiration_ = daysAfterExpirationBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.getDefaultInstance()) return this;
          if (other.hasDaysAfterExpiration()) {
            mergeDaysAfterExpiration(other.getDaysAfterExpiration());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private com.google.protobuf.Int64Value daysAfterExpiration_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> daysAfterExpirationBuilder_;
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         * @return Whether the daysAfterExpiration field is set.
         */
        public boolean hasDaysAfterExpiration() {
          return daysAfterExpirationBuilder_ != null || daysAfterExpiration_ != null;
        }
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         * @return The daysAfterExpiration.
         */
        public com.google.protobuf.Int64Value getDaysAfterExpiration() {
          if (daysAfterExpirationBuilder_ == null) {
            return daysAfterExpiration_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : daysAfterExpiration_;
          } else {
            return daysAfterExpirationBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         */
        public Builder setDaysAfterExpiration(com.google.protobuf.Int64Value value) {
          if (daysAfterExpirationBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            daysAfterExpiration_ = value;
            onChanged();
          } else {
            daysAfterExpirationBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         */
        public Builder setDaysAfterExpiration(
            com.google.protobuf.Int64Value.Builder builderForValue) {
          if (daysAfterExpirationBuilder_ == null) {
            daysAfterExpiration_ = builderForValue.build();
            onChanged();
          } else {
            daysAfterExpirationBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         */
        public Builder mergeDaysAfterExpiration(com.google.protobuf.Int64Value value) {
          if (daysAfterExpirationBuilder_ == null) {
            if (daysAfterExpiration_ != null) {
              daysAfterExpiration_ =
                com.google.protobuf.Int64Value.newBuilder(daysAfterExpiration_).mergeFrom(value).buildPartial();
            } else {
              daysAfterExpiration_ = value;
            }
            onChanged();
          } else {
            daysAfterExpirationBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         */
        public Builder clearDaysAfterExpiration() {
          if (daysAfterExpirationBuilder_ == null) {
            daysAfterExpiration_ = null;
            onChanged();
          } else {
            daysAfterExpiration_ = null;
            daysAfterExpirationBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         */
        public com.google.protobuf.Int64Value.Builder getDaysAfterExpirationBuilder() {
          
          onChanged();
          return getDaysAfterExpirationFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getDaysAfterExpirationOrBuilder() {
          if (daysAfterExpirationBuilder_ != null) {
            return daysAfterExpirationBuilder_.getMessageOrBuilder();
          } else {
            return daysAfterExpiration_ == null ?
                com.google.protobuf.Int64Value.getDefaultInstance() : daysAfterExpiration_;
          }
        }
        /**
         * <pre>
         * Time period, in number of days from the start of the multipart upload, after which the incomplete upload is
         * aborted.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days_after_expiration = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
            getDaysAfterExpirationFieldBuilder() {
          if (daysAfterExpirationBuilder_ == null) {
            daysAfterExpirationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                    getDaysAfterExpiration(),
                    getParentForChildren(),
                    isClean());
            daysAfterExpiration_ = null;
          }
          return daysAfterExpirationBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.LifecycleRule.AfterDays)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.LifecycleRule.AfterDays)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AfterDays>
          PARSER = new com.google.protobuf.AbstractParser<AfterDays>() {
        @java.lang.Override
        public AfterDays parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AfterDays(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<AfterDays> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AfterDays> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface NoncurrentExpirationOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version expires.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       * @return Whether the noncurrentDays field is set.
       */
      boolean hasNoncurrentDays();
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version expires.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       * @return The noncurrentDays.
       */
      com.google.protobuf.Int64Value getNoncurrentDays();
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version expires.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       */
      com.google.protobuf.Int64ValueOrBuilder getNoncurrentDaysOrBuilder();
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration}
     */
    public static final class NoncurrentExpiration extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration)
        NoncurrentExpirationOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use NoncurrentExpiration.newBuilder() to construct.
      private NoncurrentExpiration(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private NoncurrentExpiration() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new NoncurrentExpiration();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private NoncurrentExpiration(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.Int64Value.Builder subBuilder = null;
                if (noncurrentDays_ != null) {
                  subBuilder = noncurrentDays_.toBuilder();
                }
                noncurrentDays_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(noncurrentDays_);
                  noncurrentDays_ = subBuilder.buildPartial();
                }

                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentExpiration_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentExpiration_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.Builder.class);
      }

      public static final int NONCURRENT_DAYS_FIELD_NUMBER = 1;
      private com.google.protobuf.Int64Value noncurrentDays_;
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version expires.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       * @return Whether the noncurrentDays field is set.
       */
      @java.lang.Override
      public boolean hasNoncurrentDays() {
        return noncurrentDays_ != null;
      }
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version expires.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       * @return The noncurrentDays.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getNoncurrentDays() {
        return noncurrentDays_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : noncurrentDays_;
      }
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version expires.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getNoncurrentDaysOrBuilder() {
        return getNoncurrentDays();
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (noncurrentDays_ != null) {
          output.writeMessage(1, getNoncurrentDays());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (noncurrentDays_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getNoncurrentDays());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration other = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration) obj;

        if (hasNoncurrentDays() != other.hasNoncurrentDays()) return false;
        if (hasNoncurrentDays()) {
          if (!getNoncurrentDays()
              .equals(other.getNoncurrentDays())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasNoncurrentDays()) {
          hash = (37 * hash) + NONCURRENT_DAYS_FIELD_NUMBER;
          hash = (53 * hash) + getNoncurrentDays().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration)
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpirationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentExpiration_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentExpiration_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (noncurrentDaysBuilder_ == null) {
            noncurrentDays_ = null;
          } else {
            noncurrentDays_ = null;
            noncurrentDaysBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentExpiration_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration result = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration(this);
          if (noncurrentDaysBuilder_ == null) {
            result.noncurrentDays_ = noncurrentDays_;
          } else {
            result.noncurrentDays_ = noncurrentDaysBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.getDefaultInstance()) return this;
          if (other.hasNoncurrentDays()) {
            mergeNoncurrentDays(other.getNoncurrentDays());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private com.google.protobuf.Int64Value noncurrentDays_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> noncurrentDaysBuilder_;
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         * @return Whether the noncurrentDays field is set.
         */
        public boolean hasNoncurrentDays() {
          return noncurrentDaysBuilder_ != null || noncurrentDays_ != null;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         * @return The noncurrentDays.
         */
        public com.google.protobuf.Int64Value getNoncurrentDays() {
          if (noncurrentDaysBuilder_ == null) {
            return noncurrentDays_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : noncurrentDays_;
          } else {
            return noncurrentDaysBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public Builder setNoncurrentDays(com.google.protobuf.Int64Value value) {
          if (noncurrentDaysBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            noncurrentDays_ = value;
            onChanged();
          } else {
            noncurrentDaysBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public Builder setNoncurrentDays(
            com.google.protobuf.Int64Value.Builder builderForValue) {
          if (noncurrentDaysBuilder_ == null) {
            noncurrentDays_ = builderForValue.build();
            onChanged();
          } else {
            noncurrentDaysBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public Builder mergeNoncurrentDays(com.google.protobuf.Int64Value value) {
          if (noncurrentDaysBuilder_ == null) {
            if (noncurrentDays_ != null) {
              noncurrentDays_ =
                com.google.protobuf.Int64Value.newBuilder(noncurrentDays_).mergeFrom(value).buildPartial();
            } else {
              noncurrentDays_ = value;
            }
            onChanged();
          } else {
            noncurrentDaysBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public Builder clearNoncurrentDays() {
          if (noncurrentDaysBuilder_ == null) {
            noncurrentDays_ = null;
            onChanged();
          } else {
            noncurrentDays_ = null;
            noncurrentDaysBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public com.google.protobuf.Int64Value.Builder getNoncurrentDaysBuilder() {
          
          onChanged();
          return getNoncurrentDaysFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getNoncurrentDaysOrBuilder() {
          if (noncurrentDaysBuilder_ != null) {
            return noncurrentDaysBuilder_.getMessageOrBuilder();
          } else {
            return noncurrentDays_ == null ?
                com.google.protobuf.Int64Value.getDefaultInstance() : noncurrentDays_;
          }
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version expires.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
            getNoncurrentDaysFieldBuilder() {
          if (noncurrentDaysBuilder_ == null) {
            noncurrentDaysBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                    getNoncurrentDays(),
                    getParentForChildren(),
                    isClean());
            noncurrentDays_ = null;
          }
          return noncurrentDaysBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<NoncurrentExpiration>
          PARSER = new com.google.protobuf.AbstractParser<NoncurrentExpiration>() {
        @java.lang.Override
        public NoncurrentExpiration parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new NoncurrentExpiration(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<NoncurrentExpiration> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<NoncurrentExpiration> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface NoncurrentTransitionOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version is transitioned.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       * @return Whether the noncurrentDays field is set.
       */
      boolean hasNoncurrentDays();
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version is transitioned.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       * @return The noncurrentDays.
       */
      com.google.protobuf.Int64Value getNoncurrentDays();
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version is transitioned.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       */
      com.google.protobuf.Int64ValueOrBuilder getNoncurrentDaysOrBuilder();

      /**
       * <pre>
       * Storage class to which a non-current version of an object is transitioned from standard storage.
       * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
       * to standard storage and transitions to or from ice storage are not allowed.
       * </pre>
       *
       * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
       * @return The storageClass.
       */
      java.lang.String getStorageClass();
      /**
       * <pre>
       * Storage class to which a non-current version of an object is transitioned from standard storage.
       * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
       * to standard storage and transitions to or from ice storage are not allowed.
       * </pre>
       *
       * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
       * @return The bytes for storageClass.
       */
      com.google.protobuf.ByteString
          getStorageClassBytes();
    }
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition}
     */
    public static final class NoncurrentTransition extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition)
        NoncurrentTransitionOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use NoncurrentTransition.newBuilder() to construct.
      private NoncurrentTransition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private NoncurrentTransition() {
        storageClass_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new NoncurrentTransition();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private NoncurrentTransition(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.Int64Value.Builder subBuilder = null;
                if (noncurrentDays_ != null) {
                  subBuilder = noncurrentDays_.toBuilder();
                }
                noncurrentDays_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(noncurrentDays_);
                  noncurrentDays_ = subBuilder.buildPartial();
                }

                break;
              }
              case 18: {
                java.lang.String s = input.readStringRequireUtf8();

                storageClass_ = s;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentTransition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentTransition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition.Builder.class);
      }

      public static final int NONCURRENT_DAYS_FIELD_NUMBER = 1;
      private com.google.protobuf.Int64Value noncurrentDays_;
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version is transitioned.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       * @return Whether the noncurrentDays field is set.
       */
      @java.lang.Override
      public boolean hasNoncurrentDays() {
        return noncurrentDays_ != null;
      }
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version is transitioned.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       * @return The noncurrentDays.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getNoncurrentDays() {
        return noncurrentDays_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : noncurrentDays_;
      }
      /**
       * <pre>
       * Time period, in number of days since the version of an object was classified as non-current, after which the
       * version is transitioned.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getNoncurrentDaysOrBuilder() {
        return getNoncurrentDays();
      }

      public static final int STORAGE_CLASS_FIELD_NUMBER = 2;
      private volatile java.lang.Object storageClass_;
      /**
       * <pre>
       * Storage class to which a non-current version of an object is transitioned from standard storage.
       * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
       * to standard storage and transitions to or from ice storage are not allowed.
       * </pre>
       *
       * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
       * @return The storageClass.
       */
      @java.lang.Override
      public java.lang.String getStorageClass() {
        java.lang.Object ref = storageClass_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          storageClass_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Storage class to which a non-current version of an object is transitioned from standard storage.
       * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
       * to standard storage and transitions to or from ice storage are not allowed.
       * </pre>
       *
       * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
       * @return The bytes for storageClass.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getStorageClassBytes() {
        java.lang.Object ref = storageClass_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          storageClass_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (noncurrentDays_ != null) {
          output.writeMessage(1, getNoncurrentDays());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, storageClass_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (noncurrentDays_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getNoncurrentDays());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, storageClass_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition other = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition) obj;

        if (hasNoncurrentDays() != other.hasNoncurrentDays()) return false;
        if (hasNoncurrentDays()) {
          if (!getNoncurrentDays()
              .equals(other.getNoncurrentDays())) return false;
        }
        if (!getStorageClass()
            .equals(other.getStorageClass())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasNoncurrentDays()) {
          hash = (37 * hash) + NONCURRENT_DAYS_FIELD_NUMBER;
          hash = (53 * hash) + getNoncurrentDays().hashCode();
        }
        hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
        hash = (53 * hash) + getStorageClass().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * List of transition rules for non-current versions of objects in a bucket with versioning enabled
       * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
       * At transition, the non-current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition)
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransitionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentTransition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentTransition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (noncurrentDaysBuilder_ == null) {
            noncurrentDays_ = null;
          } else {
            noncurrentDays_ = null;
            noncurrentDaysBuilder_ = null;
          }
          storageClass_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_NoncurrentTransition_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition result = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition(this);
          if (noncurrentDaysBuilder_ == null) {
            result.noncurrentDays_ = noncurrentDays_;
          } else {
            result.noncurrentDays_ = noncurrentDaysBuilder_.build();
          }
          result.storageClass_ = storageClass_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition.getDefaultInstance()) return this;
          if (other.hasNoncurrentDays()) {
            mergeNoncurrentDays(other.getNoncurrentDays());
          }
          if (!other.getStorageClass().isEmpty()) {
            storageClass_ = other.storageClass_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private com.google.protobuf.Int64Value noncurrentDays_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> noncurrentDaysBuilder_;
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         * @return Whether the noncurrentDays field is set.
         */
        public boolean hasNoncurrentDays() {
          return noncurrentDaysBuilder_ != null || noncurrentDays_ != null;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         * @return The noncurrentDays.
         */
        public com.google.protobuf.Int64Value getNoncurrentDays() {
          if (noncurrentDaysBuilder_ == null) {
            return noncurrentDays_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : noncurrentDays_;
          } else {
            return noncurrentDaysBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public Builder setNoncurrentDays(com.google.protobuf.Int64Value value) {
          if (noncurrentDaysBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            noncurrentDays_ = value;
            onChanged();
          } else {
            noncurrentDaysBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public Builder setNoncurrentDays(
            com.google.protobuf.Int64Value.Builder builderForValue) {
          if (noncurrentDaysBuilder_ == null) {
            noncurrentDays_ = builderForValue.build();
            onChanged();
          } else {
            noncurrentDaysBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public Builder mergeNoncurrentDays(com.google.protobuf.Int64Value value) {
          if (noncurrentDaysBuilder_ == null) {
            if (noncurrentDays_ != null) {
              noncurrentDays_ =
                com.google.protobuf.Int64Value.newBuilder(noncurrentDays_).mergeFrom(value).buildPartial();
            } else {
              noncurrentDays_ = value;
            }
            onChanged();
          } else {
            noncurrentDaysBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public Builder clearNoncurrentDays() {
          if (noncurrentDaysBuilder_ == null) {
            noncurrentDays_ = null;
            onChanged();
          } else {
            noncurrentDays_ = null;
            noncurrentDaysBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public com.google.protobuf.Int64Value.Builder getNoncurrentDaysBuilder() {
          
          onChanged();
          return getNoncurrentDaysFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getNoncurrentDaysOrBuilder() {
          if (noncurrentDaysBuilder_ != null) {
            return noncurrentDaysBuilder_.getMessageOrBuilder();
          } else {
            return noncurrentDays_ == null ?
                com.google.protobuf.Int64Value.getDefaultInstance() : noncurrentDays_;
          }
        }
        /**
         * <pre>
         * Time period, in number of days since the version of an object was classified as non-current, after which the
         * version is transitioned.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value noncurrent_days = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
            getNoncurrentDaysFieldBuilder() {
          if (noncurrentDaysBuilder_ == null) {
            noncurrentDaysBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                    getNoncurrentDays(),
                    getParentForChildren(),
                    isClean());
            noncurrentDays_ = null;
          }
          return noncurrentDaysBuilder_;
        }

        private java.lang.Object storageClass_ = "";
        /**
         * <pre>
         * Storage class to which a non-current version of an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
         * @return The storageClass.
         */
        public java.lang.String getStorageClass() {
          java.lang.Object ref = storageClass_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            storageClass_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Storage class to which a non-current version of an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
         * @return The bytes for storageClass.
         */
        public com.google.protobuf.ByteString
            getStorageClassBytes() {
          java.lang.Object ref = storageClass_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            storageClass_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Storage class to which a non-current version of an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
         * @param value The storageClass to set.
         * @return This builder for chaining.
         */
        public Builder setStorageClass(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          storageClass_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Storage class to which a non-current version of an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
         * @return This builder for chaining.
         */
        public Builder clearStorageClass() {
          
          storageClass_ = getDefaultInstance().getStorageClass();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Storage class to which a non-current version of an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 2 [(.yandex.cloud.required) = true];</code>
         * @param value The bytes for storageClass to set.
         * @return This builder for chaining.
         */
        public Builder setStorageClassBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          storageClass_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<NoncurrentTransition>
          PARSER = new com.google.protobuf.AbstractParser<NoncurrentTransition>() {
        @java.lang.Override
        public NoncurrentTransition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new NoncurrentTransition(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<NoncurrentTransition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<NoncurrentTransition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface TransitionOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.LifecycleRule.Transition)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Specific date of object transition.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
       * transitioned immediately.
       * At most one of [date] and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       * @return Whether the date field is set.
       */
      boolean hasDate();
      /**
       * <pre>
       * Specific date of object transition.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
       * transitioned immediately.
       * At most one of [date] and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       * @return The date.
       */
      com.google.protobuf.Timestamp getDate();
      /**
       * <pre>
       * Specific date of object transition.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
       * transitioned immediately.
       * At most one of [date] and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       */
      com.google.protobuf.TimestampOrBuilder getDateOrBuilder();

      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object is
       * transitioned.
       * At most one of [days] and [date] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       * @return Whether the days field is set.
       */
      boolean hasDays();
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object is
       * transitioned.
       * At most one of [days] and [date] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       * @return The days.
       */
      com.google.protobuf.Int64Value getDays();
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object is
       * transitioned.
       * At most one of [days] and [date] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       */
      com.google.protobuf.Int64ValueOrBuilder getDaysOrBuilder();

      /**
       * <pre>
       * Storage class to which an object is transitioned from standard storage.
       * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
       * to standard storage and transitions to or from ice storage are not allowed.
       * </pre>
       *
       * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
       * @return The storageClass.
       */
      java.lang.String getStorageClass();
      /**
       * <pre>
       * Storage class to which an object is transitioned from standard storage.
       * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
       * to standard storage and transitions to or from ice storage are not allowed.
       * </pre>
       *
       * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
       * @return The bytes for storageClass.
       */
      com.google.protobuf.ByteString
          getStorageClassBytes();
    }
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.Transition}
     */
    public static final class Transition extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.LifecycleRule.Transition)
        TransitionOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Transition.newBuilder() to construct.
      private Transition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Transition() {
        storageClass_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Transition();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Transition(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (date_ != null) {
                  subBuilder = date_.toBuilder();
                }
                date_ = input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(date_);
                  date_ = subBuilder.buildPartial();
                }

                break;
              }
              case 18: {
                com.google.protobuf.Int64Value.Builder subBuilder = null;
                if (days_ != null) {
                  subBuilder = days_.toBuilder();
                }
                days_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(days_);
                  days_ = subBuilder.buildPartial();
                }

                break;
              }
              case 34: {
                java.lang.String s = input.readStringRequireUtf8();

                storageClass_ = s;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Transition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Transition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.Builder.class);
      }

      public static final int DATE_FIELD_NUMBER = 1;
      private com.google.protobuf.Timestamp date_;
      /**
       * <pre>
       * Specific date of object transition.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
       * transitioned immediately.
       * At most one of [date] and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       * @return Whether the date field is set.
       */
      @java.lang.Override
      public boolean hasDate() {
        return date_ != null;
      }
      /**
       * <pre>
       * Specific date of object transition.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
       * transitioned immediately.
       * At most one of [date] and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       * @return The date.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getDate() {
        return date_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : date_;
      }
      /**
       * <pre>
       * Specific date of object transition.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
       * transitioned immediately.
       * At most one of [date] and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getDateOrBuilder() {
        return getDate();
      }

      public static final int DAYS_FIELD_NUMBER = 2;
      private com.google.protobuf.Int64Value days_;
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object is
       * transitioned.
       * At most one of [days] and [date] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       * @return Whether the days field is set.
       */
      @java.lang.Override
      public boolean hasDays() {
        return days_ != null;
      }
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object is
       * transitioned.
       * At most one of [days] and [date] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       * @return The days.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getDays() {
        return days_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : days_;
      }
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object is
       * transitioned.
       * At most one of [days] and [date] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getDaysOrBuilder() {
        return getDays();
      }

      public static final int STORAGE_CLASS_FIELD_NUMBER = 4;
      private volatile java.lang.Object storageClass_;
      /**
       * <pre>
       * Storage class to which an object is transitioned from standard storage.
       * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
       * to standard storage and transitions to or from ice storage are not allowed.
       * </pre>
       *
       * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
       * @return The storageClass.
       */
      @java.lang.Override
      public java.lang.String getStorageClass() {
        java.lang.Object ref = storageClass_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          storageClass_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Storage class to which an object is transitioned from standard storage.
       * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
       * to standard storage and transitions to or from ice storage are not allowed.
       * </pre>
       *
       * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
       * @return The bytes for storageClass.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getStorageClassBytes() {
        java.lang.Object ref = storageClass_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          storageClass_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (date_ != null) {
          output.writeMessage(1, getDate());
        }
        if (days_ != null) {
          output.writeMessage(2, getDays());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, storageClass_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (date_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getDate());
        }
        if (days_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getDays());
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(storageClass_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, storageClass_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition other = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition) obj;

        if (hasDate() != other.hasDate()) return false;
        if (hasDate()) {
          if (!getDate()
              .equals(other.getDate())) return false;
        }
        if (hasDays() != other.hasDays()) return false;
        if (hasDays()) {
          if (!getDays()
              .equals(other.getDays())) return false;
        }
        if (!getStorageClass()
            .equals(other.getStorageClass())) return false;
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDate()) {
          hash = (37 * hash) + DATE_FIELD_NUMBER;
          hash = (53 * hash) + getDate().hashCode();
        }
        if (hasDays()) {
          hash = (37 * hash) + DAYS_FIELD_NUMBER;
          hash = (53 * hash) + getDays().hashCode();
        }
        hash = (37 * hash) + STORAGE_CLASS_FIELD_NUMBER;
        hash = (53 * hash) + getStorageClass().hashCode();
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.Transition}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.LifecycleRule.Transition)
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.TransitionOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Transition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Transition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (dateBuilder_ == null) {
            date_ = null;
          } else {
            date_ = null;
            dateBuilder_ = null;
          }
          if (daysBuilder_ == null) {
            days_ = null;
          } else {
            days_ = null;
            daysBuilder_ = null;
          }
          storageClass_ = "";

          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Transition_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition result = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition(this);
          if (dateBuilder_ == null) {
            result.date_ = date_;
          } else {
            result.date_ = dateBuilder_.build();
          }
          if (daysBuilder_ == null) {
            result.days_ = days_;
          } else {
            result.days_ = daysBuilder_.build();
          }
          result.storageClass_ = storageClass_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.getDefaultInstance()) return this;
          if (other.hasDate()) {
            mergeDate(other.getDate());
          }
          if (other.hasDays()) {
            mergeDays(other.getDays());
          }
          if (!other.getStorageClass().isEmpty()) {
            storageClass_ = other.storageClass_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private com.google.protobuf.Timestamp date_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> dateBuilder_;
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         * @return Whether the date field is set.
         */
        public boolean hasDate() {
          return dateBuilder_ != null || date_ != null;
        }
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         * @return The date.
         */
        public com.google.protobuf.Timestamp getDate() {
          if (dateBuilder_ == null) {
            return date_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : date_;
          } else {
            return dateBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public Builder setDate(com.google.protobuf.Timestamp value) {
          if (dateBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            date_ = value;
            onChanged();
          } else {
            dateBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public Builder setDate(
            com.google.protobuf.Timestamp.Builder builderForValue) {
          if (dateBuilder_ == null) {
            date_ = builderForValue.build();
            onChanged();
          } else {
            dateBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public Builder mergeDate(com.google.protobuf.Timestamp value) {
          if (dateBuilder_ == null) {
            if (date_ != null) {
              date_ =
                com.google.protobuf.Timestamp.newBuilder(date_).mergeFrom(value).buildPartial();
            } else {
              date_ = value;
            }
            onChanged();
          } else {
            dateBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public Builder clearDate() {
          if (dateBuilder_ == null) {
            date_ = null;
            onChanged();
          } else {
            date_ = null;
            dateBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public com.google.protobuf.Timestamp.Builder getDateBuilder() {
          
          onChanged();
          return getDateFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getDateOrBuilder() {
          if (dateBuilder_ != null) {
            return dateBuilder_.getMessageOrBuilder();
          } else {
            return date_ == null ?
                com.google.protobuf.Timestamp.getDefaultInstance() : date_;
          }
        }
        /**
         * <pre>
         * Specific date of object transition.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket are
         * transitioned immediately.
         * At most one of [date] and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> 
            getDateFieldBuilder() {
          if (dateBuilder_ == null) {
            dateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                    getDate(),
                    getParentForChildren(),
                    isClean());
            date_ = null;
          }
          return dateBuilder_;
        }

        private com.google.protobuf.Int64Value days_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> daysBuilder_;
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         * @return Whether the days field is set.
         */
        public boolean hasDays() {
          return daysBuilder_ != null || days_ != null;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         * @return The days.
         */
        public com.google.protobuf.Int64Value getDays() {
          if (daysBuilder_ == null) {
            return days_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : days_;
          } else {
            return daysBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public Builder setDays(com.google.protobuf.Int64Value value) {
          if (daysBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            days_ = value;
            onChanged();
          } else {
            daysBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public Builder setDays(
            com.google.protobuf.Int64Value.Builder builderForValue) {
          if (daysBuilder_ == null) {
            days_ = builderForValue.build();
            onChanged();
          } else {
            daysBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public Builder mergeDays(com.google.protobuf.Int64Value value) {
          if (daysBuilder_ == null) {
            if (days_ != null) {
              days_ =
                com.google.protobuf.Int64Value.newBuilder(days_).mergeFrom(value).buildPartial();
            } else {
              days_ = value;
            }
            onChanged();
          } else {
            daysBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public Builder clearDays() {
          if (daysBuilder_ == null) {
            days_ = null;
            onChanged();
          } else {
            days_ = null;
            daysBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public com.google.protobuf.Int64Value.Builder getDaysBuilder() {
          
          onChanged();
          return getDaysFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getDaysOrBuilder() {
          if (daysBuilder_ != null) {
            return daysBuilder_.getMessageOrBuilder();
          } else {
            return days_ == null ?
                com.google.protobuf.Int64Value.getDefaultInstance() : days_;
          }
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object is
         * transitioned.
         * At most one of [days] and [date] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
            getDaysFieldBuilder() {
          if (daysBuilder_ == null) {
            daysBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                    getDays(),
                    getParentForChildren(),
                    isClean());
            days_ = null;
          }
          return daysBuilder_;
        }

        private java.lang.Object storageClass_ = "";
        /**
         * <pre>
         * Storage class to which an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
         * @return The storageClass.
         */
        public java.lang.String getStorageClass() {
          java.lang.Object ref = storageClass_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            storageClass_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Storage class to which an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
         * @return The bytes for storageClass.
         */
        public com.google.protobuf.ByteString
            getStorageClassBytes() {
          java.lang.Object ref = storageClass_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            storageClass_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Storage class to which an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
         * @param value The storageClass to set.
         * @return This builder for chaining.
         */
        public Builder setStorageClass(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          storageClass_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Storage class to which an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
         * @return This builder for chaining.
         */
        public Builder clearStorageClass() {
          
          storageClass_ = getDefaultInstance().getStorageClass();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Storage class to which an object is transitioned from standard storage.
         * The only supported class is cold storage (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms). Transitions from cold
         * to standard storage and transitions to or from ice storage are not allowed.
         * </pre>
         *
         * <code>string storage_class = 4 [(.yandex.cloud.required) = true];</code>
         * @param value The bytes for storageClass to set.
         * @return This builder for chaining.
         */
        public Builder setStorageClassBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          storageClass_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.LifecycleRule.Transition)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.LifecycleRule.Transition)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Transition>
          PARSER = new com.google.protobuf.AbstractParser<Transition>() {
        @java.lang.Override
        public Transition parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Transition(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Transition> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Transition> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface ExpirationOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.LifecycleRule.Expiration)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Specific date of object expiration.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
       * immediately.
       * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       * @return Whether the date field is set.
       */
      boolean hasDate();
      /**
       * <pre>
       * Specific date of object expiration.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
       * immediately.
       * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       * @return The date.
       */
      com.google.protobuf.Timestamp getDate();
      /**
       * <pre>
       * Specific date of object expiration.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
       * immediately.
       * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       */
      com.google.protobuf.TimestampOrBuilder getDateOrBuilder();

      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object expires.
       * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       * @return Whether the days field is set.
       */
      boolean hasDays();
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object expires.
       * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       * @return The days.
       */
      com.google.protobuf.Int64Value getDays();
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object expires.
       * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       */
      com.google.protobuf.Int64ValueOrBuilder getDaysOrBuilder();

      /**
       * <pre>
       * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
       * delete marker) is removed at the object's expiration.
       * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
       * @return Whether the expiredObjectDeleteMarker field is set.
       */
      boolean hasExpiredObjectDeleteMarker();
      /**
       * <pre>
       * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
       * delete marker) is removed at the object's expiration.
       * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
       * @return The expiredObjectDeleteMarker.
       */
      com.google.protobuf.BoolValue getExpiredObjectDeleteMarker();
      /**
       * <pre>
       * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
       * delete marker) is removed at the object's expiration.
       * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
       */
      com.google.protobuf.BoolValueOrBuilder getExpiredObjectDeleteMarkerOrBuilder();
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.Expiration}
     */
    public static final class Expiration extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.LifecycleRule.Expiration)
        ExpirationOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Expiration.newBuilder() to construct.
      private Expiration(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Expiration() {
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new Expiration();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Expiration(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.Timestamp.Builder subBuilder = null;
                if (date_ != null) {
                  subBuilder = date_.toBuilder();
                }
                date_ = input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(date_);
                  date_ = subBuilder.buildPartial();
                }

                break;
              }
              case 18: {
                com.google.protobuf.Int64Value.Builder subBuilder = null;
                if (days_ != null) {
                  subBuilder = days_.toBuilder();
                }
                days_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(days_);
                  days_ = subBuilder.buildPartial();
                }

                break;
              }
              case 26: {
                com.google.protobuf.BoolValue.Builder subBuilder = null;
                if (expiredObjectDeleteMarker_ != null) {
                  subBuilder = expiredObjectDeleteMarker_.toBuilder();
                }
                expiredObjectDeleteMarker_ = input.readMessage(com.google.protobuf.BoolValue.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(expiredObjectDeleteMarker_);
                  expiredObjectDeleteMarker_ = subBuilder.buildPartial();
                }

                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Expiration_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Expiration_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.Builder.class);
      }

      public static final int DATE_FIELD_NUMBER = 1;
      private com.google.protobuf.Timestamp date_;
      /**
       * <pre>
       * Specific date of object expiration.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
       * immediately.
       * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       * @return Whether the date field is set.
       */
      @java.lang.Override
      public boolean hasDate() {
        return date_ != null;
      }
      /**
       * <pre>
       * Specific date of object expiration.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
       * immediately.
       * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       * @return The date.
       */
      @java.lang.Override
      public com.google.protobuf.Timestamp getDate() {
        return date_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : date_;
      }
      /**
       * <pre>
       * Specific date of object expiration.
       * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
       * immediately.
       * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp date = 1;</code>
       */
      @java.lang.Override
      public com.google.protobuf.TimestampOrBuilder getDateOrBuilder() {
        return getDate();
      }

      public static final int DAYS_FIELD_NUMBER = 2;
      private com.google.protobuf.Int64Value days_;
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object expires.
       * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       * @return Whether the days field is set.
       */
      @java.lang.Override
      public boolean hasDays() {
        return days_ != null;
      }
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object expires.
       * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       * @return The days.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getDays() {
        return days_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : days_;
      }
      /**
       * <pre>
       * Time period, in number of days from the creation or modification of the object, after which an object expires.
       * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value days = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getDaysOrBuilder() {
        return getDays();
      }

      public static final int EXPIRED_OBJECT_DELETE_MARKER_FIELD_NUMBER = 3;
      private com.google.protobuf.BoolValue expiredObjectDeleteMarker_;
      /**
       * <pre>
       * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
       * delete marker) is removed at the object's expiration.
       * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
       * @return Whether the expiredObjectDeleteMarker field is set.
       */
      @java.lang.Override
      public boolean hasExpiredObjectDeleteMarker() {
        return expiredObjectDeleteMarker_ != null;
      }
      /**
       * <pre>
       * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
       * delete marker) is removed at the object's expiration.
       * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
       * @return The expiredObjectDeleteMarker.
       */
      @java.lang.Override
      public com.google.protobuf.BoolValue getExpiredObjectDeleteMarker() {
        return expiredObjectDeleteMarker_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : expiredObjectDeleteMarker_;
      }
      /**
       * <pre>
       * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
       * delete marker) is removed at the object's expiration.
       * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
       * </pre>
       *
       * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
       */
      @java.lang.Override
      public com.google.protobuf.BoolValueOrBuilder getExpiredObjectDeleteMarkerOrBuilder() {
        return getExpiredObjectDeleteMarker();
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (date_ != null) {
          output.writeMessage(1, getDate());
        }
        if (days_ != null) {
          output.writeMessage(2, getDays());
        }
        if (expiredObjectDeleteMarker_ != null) {
          output.writeMessage(3, getExpiredObjectDeleteMarker());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (date_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(1, getDate());
        }
        if (days_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getDays());
        }
        if (expiredObjectDeleteMarker_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(3, getExpiredObjectDeleteMarker());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration other = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration) obj;

        if (hasDate() != other.hasDate()) return false;
        if (hasDate()) {
          if (!getDate()
              .equals(other.getDate())) return false;
        }
        if (hasDays() != other.hasDays()) return false;
        if (hasDays()) {
          if (!getDays()
              .equals(other.getDays())) return false;
        }
        if (hasExpiredObjectDeleteMarker() != other.hasExpiredObjectDeleteMarker()) return false;
        if (hasExpiredObjectDeleteMarker()) {
          if (!getExpiredObjectDeleteMarker()
              .equals(other.getExpiredObjectDeleteMarker())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDate()) {
          hash = (37 * hash) + DATE_FIELD_NUMBER;
          hash = (53 * hash) + getDate().hashCode();
        }
        if (hasDays()) {
          hash = (37 * hash) + DAYS_FIELD_NUMBER;
          hash = (53 * hash) + getDays().hashCode();
        }
        if (hasExpiredObjectDeleteMarker()) {
          hash = (37 * hash) + EXPIRED_OBJECT_DELETE_MARKER_FIELD_NUMBER;
          hash = (53 * hash) + getExpiredObjectDeleteMarker().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.Expiration}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.LifecycleRule.Expiration)
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.ExpirationOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Expiration_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Expiration_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (dateBuilder_ == null) {
            date_ = null;
          } else {
            date_ = null;
            dateBuilder_ = null;
          }
          if (daysBuilder_ == null) {
            days_ = null;
          } else {
            days_ = null;
            daysBuilder_ = null;
          }
          if (expiredObjectDeleteMarkerBuilder_ == null) {
            expiredObjectDeleteMarker_ = null;
          } else {
            expiredObjectDeleteMarker_ = null;
            expiredObjectDeleteMarkerBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_Expiration_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration result = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration(this);
          if (dateBuilder_ == null) {
            result.date_ = date_;
          } else {
            result.date_ = dateBuilder_.build();
          }
          if (daysBuilder_ == null) {
            result.days_ = days_;
          } else {
            result.days_ = daysBuilder_.build();
          }
          if (expiredObjectDeleteMarkerBuilder_ == null) {
            result.expiredObjectDeleteMarker_ = expiredObjectDeleteMarker_;
          } else {
            result.expiredObjectDeleteMarker_ = expiredObjectDeleteMarkerBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.getDefaultInstance()) return this;
          if (other.hasDate()) {
            mergeDate(other.getDate());
          }
          if (other.hasDays()) {
            mergeDays(other.getDays());
          }
          if (other.hasExpiredObjectDeleteMarker()) {
            mergeExpiredObjectDeleteMarker(other.getExpiredObjectDeleteMarker());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private com.google.protobuf.Timestamp date_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> dateBuilder_;
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         * @return Whether the date field is set.
         */
        public boolean hasDate() {
          return dateBuilder_ != null || date_ != null;
        }
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         * @return The date.
         */
        public com.google.protobuf.Timestamp getDate() {
          if (dateBuilder_ == null) {
            return date_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : date_;
          } else {
            return dateBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public Builder setDate(com.google.protobuf.Timestamp value) {
          if (dateBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            date_ = value;
            onChanged();
          } else {
            dateBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public Builder setDate(
            com.google.protobuf.Timestamp.Builder builderForValue) {
          if (dateBuilder_ == null) {
            date_ = builderForValue.build();
            onChanged();
          } else {
            dateBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public Builder mergeDate(com.google.protobuf.Timestamp value) {
          if (dateBuilder_ == null) {
            if (date_ != null) {
              date_ =
                com.google.protobuf.Timestamp.newBuilder(date_).mergeFrom(value).buildPartial();
            } else {
              date_ = value;
            }
            onChanged();
          } else {
            dateBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public Builder clearDate() {
          if (dateBuilder_ == null) {
            date_ = null;
            onChanged();
          } else {
            date_ = null;
            dateBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public com.google.protobuf.Timestamp.Builder getDateBuilder() {
          
          onChanged();
          return getDateFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        public com.google.protobuf.TimestampOrBuilder getDateOrBuilder() {
          if (dateBuilder_ != null) {
            return dateBuilder_.getMessageOrBuilder();
          } else {
            return date_ == null ?
                com.google.protobuf.Timestamp.getDefaultInstance() : date_;
          }
        }
        /**
         * <pre>
         * Specific date of object expiration.
         * The rule continues to apply even after the date has passed, i.e. any new objects created in the bucket expire
         * immediately.
         * Exactly one of [date], [days], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Timestamp date = 1;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder> 
            getDateFieldBuilder() {
          if (dateBuilder_ == null) {
            dateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp, com.google.protobuf.Timestamp.Builder, com.google.protobuf.TimestampOrBuilder>(
                    getDate(),
                    getParentForChildren(),
                    isClean());
            date_ = null;
          }
          return dateBuilder_;
        }

        private com.google.protobuf.Int64Value days_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> daysBuilder_;
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         * @return Whether the days field is set.
         */
        public boolean hasDays() {
          return daysBuilder_ != null || days_ != null;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         * @return The days.
         */
        public com.google.protobuf.Int64Value getDays() {
          if (daysBuilder_ == null) {
            return days_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : days_;
          } else {
            return daysBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public Builder setDays(com.google.protobuf.Int64Value value) {
          if (daysBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            days_ = value;
            onChanged();
          } else {
            daysBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public Builder setDays(
            com.google.protobuf.Int64Value.Builder builderForValue) {
          if (daysBuilder_ == null) {
            days_ = builderForValue.build();
            onChanged();
          } else {
            daysBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public Builder mergeDays(com.google.protobuf.Int64Value value) {
          if (daysBuilder_ == null) {
            if (days_ != null) {
              days_ =
                com.google.protobuf.Int64Value.newBuilder(days_).mergeFrom(value).buildPartial();
            } else {
              days_ = value;
            }
            onChanged();
          } else {
            daysBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public Builder clearDays() {
          if (daysBuilder_ == null) {
            days_ = null;
            onChanged();
          } else {
            days_ = null;
            daysBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public com.google.protobuf.Int64Value.Builder getDaysBuilder() {
          
          onChanged();
          return getDaysFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getDaysOrBuilder() {
          if (daysBuilder_ != null) {
            return daysBuilder_.getMessageOrBuilder();
          } else {
            return days_ == null ?
                com.google.protobuf.Int64Value.getDefaultInstance() : days_;
          }
        }
        /**
         * <pre>
         * Time period, in number of days from the creation or modification of the object, after which an object expires.
         * Exactly one of [days], [date], and [expired_object_delete_marker] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value days = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
            getDaysFieldBuilder() {
          if (daysBuilder_ == null) {
            daysBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                    getDays(),
                    getParentForChildren(),
                    isClean());
            days_ = null;
          }
          return daysBuilder_;
        }

        private com.google.protobuf.BoolValue expiredObjectDeleteMarker_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder> expiredObjectDeleteMarkerBuilder_;
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         * @return Whether the expiredObjectDeleteMarker field is set.
         */
        public boolean hasExpiredObjectDeleteMarker() {
          return expiredObjectDeleteMarkerBuilder_ != null || expiredObjectDeleteMarker_ != null;
        }
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         * @return The expiredObjectDeleteMarker.
         */
        public com.google.protobuf.BoolValue getExpiredObjectDeleteMarker() {
          if (expiredObjectDeleteMarkerBuilder_ == null) {
            return expiredObjectDeleteMarker_ == null ? com.google.protobuf.BoolValue.getDefaultInstance() : expiredObjectDeleteMarker_;
          } else {
            return expiredObjectDeleteMarkerBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         */
        public Builder setExpiredObjectDeleteMarker(com.google.protobuf.BoolValue value) {
          if (expiredObjectDeleteMarkerBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            expiredObjectDeleteMarker_ = value;
            onChanged();
          } else {
            expiredObjectDeleteMarkerBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         */
        public Builder setExpiredObjectDeleteMarker(
            com.google.protobuf.BoolValue.Builder builderForValue) {
          if (expiredObjectDeleteMarkerBuilder_ == null) {
            expiredObjectDeleteMarker_ = builderForValue.build();
            onChanged();
          } else {
            expiredObjectDeleteMarkerBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         */
        public Builder mergeExpiredObjectDeleteMarker(com.google.protobuf.BoolValue value) {
          if (expiredObjectDeleteMarkerBuilder_ == null) {
            if (expiredObjectDeleteMarker_ != null) {
              expiredObjectDeleteMarker_ =
                com.google.protobuf.BoolValue.newBuilder(expiredObjectDeleteMarker_).mergeFrom(value).buildPartial();
            } else {
              expiredObjectDeleteMarker_ = value;
            }
            onChanged();
          } else {
            expiredObjectDeleteMarkerBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         */
        public Builder clearExpiredObjectDeleteMarker() {
          if (expiredObjectDeleteMarkerBuilder_ == null) {
            expiredObjectDeleteMarker_ = null;
            onChanged();
          } else {
            expiredObjectDeleteMarker_ = null;
            expiredObjectDeleteMarkerBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         */
        public com.google.protobuf.BoolValue.Builder getExpiredObjectDeleteMarkerBuilder() {
          
          onChanged();
          return getExpiredObjectDeleteMarkerFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         */
        public com.google.protobuf.BoolValueOrBuilder getExpiredObjectDeleteMarkerOrBuilder() {
          if (expiredObjectDeleteMarkerBuilder_ != null) {
            return expiredObjectDeleteMarkerBuilder_.getMessageOrBuilder();
          } else {
            return expiredObjectDeleteMarker_ == null ?
                com.google.protobuf.BoolValue.getDefaultInstance() : expiredObjectDeleteMarker_;
          }
        }
        /**
         * <pre>
         * Indicates whether a delete marker of an object with no non-current versions (referred to as an expired object
         * delete marker) is removed at the object's expiration.
         * Exactly one of [expired_object_delete_marker], [date], and [days] fields can be specified.
         * </pre>
         *
         * <code>.google.protobuf.BoolValue expired_object_delete_marker = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder> 
            getExpiredObjectDeleteMarkerFieldBuilder() {
          if (expiredObjectDeleteMarkerBuilder_ == null) {
            expiredObjectDeleteMarkerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.BoolValue, com.google.protobuf.BoolValue.Builder, com.google.protobuf.BoolValueOrBuilder>(
                    getExpiredObjectDeleteMarker(),
                    getParentForChildren(),
                    isClean());
            expiredObjectDeleteMarker_ = null;
          }
          return expiredObjectDeleteMarkerBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.LifecycleRule.Expiration)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.LifecycleRule.Expiration)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Expiration>
          PARSER = new com.google.protobuf.AbstractParser<Expiration>() {
        @java.lang.Override
        public Expiration parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Expiration(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Expiration> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Expiration> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface RuleFilterOrBuilder extends
        // @@protoc_insertion_point(interface_extends:yandex.cloud.storage.v1.LifecycleRule.RuleFilter)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Key prefix that the object must have in order for the rule to apply.
       * </pre>
       *
       * <code>string prefix = 1;</code>
       * @return The prefix.
       */
      java.lang.String getPrefix();
      /**
       * <pre>
       * Key prefix that the object must have in order for the rule to apply.
       * </pre>
       *
       * <code>string prefix = 1;</code>
       * @return The bytes for prefix.
       */
      com.google.protobuf.ByteString
          getPrefixBytes();

      /**
       * <pre>
       * Size that the object must be greater.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
       * @return Whether the objectSizeGreaterThan field is set.
       */
      boolean hasObjectSizeGreaterThan();
      /**
       * <pre>
       * Size that the object must be greater.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
       * @return The objectSizeGreaterThan.
       */
      com.google.protobuf.Int64Value getObjectSizeGreaterThan();
      /**
       * <pre>
       * Size that the object must be greater.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
       */
      com.google.protobuf.Int64ValueOrBuilder getObjectSizeGreaterThanOrBuilder();

      /**
       * <pre>
       * Size that the object must be less t.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
       * @return Whether the objectSizeLessThan field is set.
       */
      boolean hasObjectSizeLessThan();
      /**
       * <pre>
       * Size that the object must be less t.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
       * @return The objectSizeLessThan.
       */
      com.google.protobuf.Int64Value getObjectSizeLessThan();
      /**
       * <pre>
       * Size that the object must be less t.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
       */
      com.google.protobuf.Int64ValueOrBuilder getObjectSizeLessThanOrBuilder();
    }
    /**
     * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.RuleFilter}
     */
    public static final class RuleFilter extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:yandex.cloud.storage.v1.LifecycleRule.RuleFilter)
        RuleFilterOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use RuleFilter.newBuilder() to construct.
      private RuleFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private RuleFilter() {
        prefix_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          UnusedPrivateParameter unused) {
        return new RuleFilter();
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private RuleFilter(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                java.lang.String s = input.readStringRequireUtf8();

                prefix_ = s;
                break;
              }
              case 18: {
                com.google.protobuf.Int64Value.Builder subBuilder = null;
                if (objectSizeGreaterThan_ != null) {
                  subBuilder = objectSizeGreaterThan_.toBuilder();
                }
                objectSizeGreaterThan_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(objectSizeGreaterThan_);
                  objectSizeGreaterThan_ = subBuilder.buildPartial();
                }

                break;
              }
              case 26: {
                com.google.protobuf.Int64Value.Builder subBuilder = null;
                if (objectSizeLessThan_ != null) {
                  subBuilder = objectSizeLessThan_.toBuilder();
                }
                objectSizeLessThan_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(objectSizeLessThan_);
                  objectSizeLessThan_ = subBuilder.buildPartial();
                }

                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_RuleFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_RuleFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.Builder.class);
      }

      public static final int PREFIX_FIELD_NUMBER = 1;
      private volatile java.lang.Object prefix_;
      /**
       * <pre>
       * Key prefix that the object must have in order for the rule to apply.
       * </pre>
       *
       * <code>string prefix = 1;</code>
       * @return The prefix.
       */
      @java.lang.Override
      public java.lang.String getPrefix() {
        java.lang.Object ref = prefix_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          prefix_ = s;
          return s;
        }
      }
      /**
       * <pre>
       * Key prefix that the object must have in order for the rule to apply.
       * </pre>
       *
       * <code>string prefix = 1;</code>
       * @return The bytes for prefix.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getPrefixBytes() {
        java.lang.Object ref = prefix_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          prefix_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int OBJECT_SIZE_GREATER_THAN_FIELD_NUMBER = 2;
      private com.google.protobuf.Int64Value objectSizeGreaterThan_;
      /**
       * <pre>
       * Size that the object must be greater.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
       * @return Whether the objectSizeGreaterThan field is set.
       */
      @java.lang.Override
      public boolean hasObjectSizeGreaterThan() {
        return objectSizeGreaterThan_ != null;
      }
      /**
       * <pre>
       * Size that the object must be greater.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
       * @return The objectSizeGreaterThan.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getObjectSizeGreaterThan() {
        return objectSizeGreaterThan_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : objectSizeGreaterThan_;
      }
      /**
       * <pre>
       * Size that the object must be greater.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getObjectSizeGreaterThanOrBuilder() {
        return getObjectSizeGreaterThan();
      }

      public static final int OBJECT_SIZE_LESS_THAN_FIELD_NUMBER = 3;
      private com.google.protobuf.Int64Value objectSizeLessThan_;
      /**
       * <pre>
       * Size that the object must be less t.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
       * @return Whether the objectSizeLessThan field is set.
       */
      @java.lang.Override
      public boolean hasObjectSizeLessThan() {
        return objectSizeLessThan_ != null;
      }
      /**
       * <pre>
       * Size that the object must be less t.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
       * @return The objectSizeLessThan.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getObjectSizeLessThan() {
        return objectSizeLessThan_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : objectSizeLessThan_;
      }
      /**
       * <pre>
       * Size that the object must be less t.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getObjectSizeLessThanOrBuilder() {
        return getObjectSizeLessThan();
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(prefix_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, prefix_);
        }
        if (objectSizeGreaterThan_ != null) {
          output.writeMessage(2, getObjectSizeGreaterThan());
        }
        if (objectSizeLessThan_ != null) {
          output.writeMessage(3, getObjectSizeLessThan());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(prefix_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, prefix_);
        }
        if (objectSizeGreaterThan_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getObjectSizeGreaterThan());
        }
        if (objectSizeLessThan_ != null) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(3, getObjectSizeLessThan());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter)) {
          return super.equals(obj);
        }
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter other = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter) obj;

        if (!getPrefix()
            .equals(other.getPrefix())) return false;
        if (hasObjectSizeGreaterThan() != other.hasObjectSizeGreaterThan()) return false;
        if (hasObjectSizeGreaterThan()) {
          if (!getObjectSizeGreaterThan()
              .equals(other.getObjectSizeGreaterThan())) return false;
        }
        if (hasObjectSizeLessThan() != other.hasObjectSizeLessThan()) return false;
        if (hasObjectSizeLessThan()) {
          if (!getObjectSizeLessThan()
              .equals(other.getObjectSizeLessThan())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + PREFIX_FIELD_NUMBER;
        hash = (53 * hash) + getPrefix().hashCode();
        if (hasObjectSizeGreaterThan()) {
          hash = (37 * hash) + OBJECT_SIZE_GREATER_THAN_FIELD_NUMBER;
          hash = (53 * hash) + getObjectSizeGreaterThan().hashCode();
        }
        if (hasObjectSizeLessThan()) {
          hash = (37 * hash) + OBJECT_SIZE_LESS_THAN_FIELD_NUMBER;
          hash = (53 * hash) + getObjectSizeLessThan().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule.RuleFilter}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.LifecycleRule.RuleFilter)
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilterOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_RuleFilter_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_RuleFilter_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.Builder.class);
        }

        // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          prefix_ = "";

          if (objectSizeGreaterThanBuilder_ == null) {
            objectSizeGreaterThan_ = null;
          } else {
            objectSizeGreaterThan_ = null;
            objectSizeGreaterThanBuilder_ = null;
          }
          if (objectSizeLessThanBuilder_ == null) {
            objectSizeLessThan_ = null;
          } else {
            objectSizeLessThan_ = null;
            objectSizeLessThanBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_RuleFilter_descriptor;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter getDefaultInstanceForType() {
          return yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.getDefaultInstance();
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter build() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter buildPartial() {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter result = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter(this);
          result.prefix_ = prefix_;
          if (objectSizeGreaterThanBuilder_ == null) {
            result.objectSizeGreaterThan_ = objectSizeGreaterThan_;
          } else {
            result.objectSizeGreaterThan_ = objectSizeGreaterThanBuilder_.build();
          }
          if (objectSizeLessThanBuilder_ == null) {
            result.objectSizeLessThan_ = objectSizeLessThan_;
          } else {
            result.objectSizeLessThan_ = objectSizeLessThanBuilder_.build();
          }
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter) {
            return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter other) {
          if (other == yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.getDefaultInstance()) return this;
          if (!other.getPrefix().isEmpty()) {
            prefix_ = other.prefix_;
            onChanged();
          }
          if (other.hasObjectSizeGreaterThan()) {
            mergeObjectSizeGreaterThan(other.getObjectSizeGreaterThan());
          }
          if (other.hasObjectSizeLessThan()) {
            mergeObjectSizeLessThan(other.getObjectSizeLessThan());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }

        private java.lang.Object prefix_ = "";
        /**
         * <pre>
         * Key prefix that the object must have in order for the rule to apply.
         * </pre>
         *
         * <code>string prefix = 1;</code>
         * @return The prefix.
         */
        public java.lang.String getPrefix() {
          java.lang.Object ref = prefix_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            prefix_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Key prefix that the object must have in order for the rule to apply.
         * </pre>
         *
         * <code>string prefix = 1;</code>
         * @return The bytes for prefix.
         */
        public com.google.protobuf.ByteString
            getPrefixBytes() {
          java.lang.Object ref = prefix_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            prefix_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Key prefix that the object must have in order for the rule to apply.
         * </pre>
         *
         * <code>string prefix = 1;</code>
         * @param value The prefix to set.
         * @return This builder for chaining.
         */
        public Builder setPrefix(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  
          prefix_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Key prefix that the object must have in order for the rule to apply.
         * </pre>
         *
         * <code>string prefix = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearPrefix() {
          
          prefix_ = getDefaultInstance().getPrefix();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Key prefix that the object must have in order for the rule to apply.
         * </pre>
         *
         * <code>string prefix = 1;</code>
         * @param value The bytes for prefix to set.
         * @return This builder for chaining.
         */
        public Builder setPrefixBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
          
          prefix_ = value;
          onChanged();
          return this;
        }

        private com.google.protobuf.Int64Value objectSizeGreaterThan_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> objectSizeGreaterThanBuilder_;
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         * @return Whether the objectSizeGreaterThan field is set.
         */
        public boolean hasObjectSizeGreaterThan() {
          return objectSizeGreaterThanBuilder_ != null || objectSizeGreaterThan_ != null;
        }
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         * @return The objectSizeGreaterThan.
         */
        public com.google.protobuf.Int64Value getObjectSizeGreaterThan() {
          if (objectSizeGreaterThanBuilder_ == null) {
            return objectSizeGreaterThan_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : objectSizeGreaterThan_;
          } else {
            return objectSizeGreaterThanBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         */
        public Builder setObjectSizeGreaterThan(com.google.protobuf.Int64Value value) {
          if (objectSizeGreaterThanBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            objectSizeGreaterThan_ = value;
            onChanged();
          } else {
            objectSizeGreaterThanBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         */
        public Builder setObjectSizeGreaterThan(
            com.google.protobuf.Int64Value.Builder builderForValue) {
          if (objectSizeGreaterThanBuilder_ == null) {
            objectSizeGreaterThan_ = builderForValue.build();
            onChanged();
          } else {
            objectSizeGreaterThanBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         */
        public Builder mergeObjectSizeGreaterThan(com.google.protobuf.Int64Value value) {
          if (objectSizeGreaterThanBuilder_ == null) {
            if (objectSizeGreaterThan_ != null) {
              objectSizeGreaterThan_ =
                com.google.protobuf.Int64Value.newBuilder(objectSizeGreaterThan_).mergeFrom(value).buildPartial();
            } else {
              objectSizeGreaterThan_ = value;
            }
            onChanged();
          } else {
            objectSizeGreaterThanBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         */
        public Builder clearObjectSizeGreaterThan() {
          if (objectSizeGreaterThanBuilder_ == null) {
            objectSizeGreaterThan_ = null;
            onChanged();
          } else {
            objectSizeGreaterThan_ = null;
            objectSizeGreaterThanBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         */
        public com.google.protobuf.Int64Value.Builder getObjectSizeGreaterThanBuilder() {
          
          onChanged();
          return getObjectSizeGreaterThanFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getObjectSizeGreaterThanOrBuilder() {
          if (objectSizeGreaterThanBuilder_ != null) {
            return objectSizeGreaterThanBuilder_.getMessageOrBuilder();
          } else {
            return objectSizeGreaterThan_ == null ?
                com.google.protobuf.Int64Value.getDefaultInstance() : objectSizeGreaterThan_;
          }
        }
        /**
         * <pre>
         * Size that the object must be greater.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_greater_than = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
            getObjectSizeGreaterThanFieldBuilder() {
          if (objectSizeGreaterThanBuilder_ == null) {
            objectSizeGreaterThanBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                    getObjectSizeGreaterThan(),
                    getParentForChildren(),
                    isClean());
            objectSizeGreaterThan_ = null;
          }
          return objectSizeGreaterThanBuilder_;
        }

        private com.google.protobuf.Int64Value objectSizeLessThan_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> objectSizeLessThanBuilder_;
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         * @return Whether the objectSizeLessThan field is set.
         */
        public boolean hasObjectSizeLessThan() {
          return objectSizeLessThanBuilder_ != null || objectSizeLessThan_ != null;
        }
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         * @return The objectSizeLessThan.
         */
        public com.google.protobuf.Int64Value getObjectSizeLessThan() {
          if (objectSizeLessThanBuilder_ == null) {
            return objectSizeLessThan_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : objectSizeLessThan_;
          } else {
            return objectSizeLessThanBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         */
        public Builder setObjectSizeLessThan(com.google.protobuf.Int64Value value) {
          if (objectSizeLessThanBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            objectSizeLessThan_ = value;
            onChanged();
          } else {
            objectSizeLessThanBuilder_.setMessage(value);
          }

          return this;
        }
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         */
        public Builder setObjectSizeLessThan(
            com.google.protobuf.Int64Value.Builder builderForValue) {
          if (objectSizeLessThanBuilder_ == null) {
            objectSizeLessThan_ = builderForValue.build();
            onChanged();
          } else {
            objectSizeLessThanBuilder_.setMessage(builderForValue.build());
          }

          return this;
        }
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         */
        public Builder mergeObjectSizeLessThan(com.google.protobuf.Int64Value value) {
          if (objectSizeLessThanBuilder_ == null) {
            if (objectSizeLessThan_ != null) {
              objectSizeLessThan_ =
                com.google.protobuf.Int64Value.newBuilder(objectSizeLessThan_).mergeFrom(value).buildPartial();
            } else {
              objectSizeLessThan_ = value;
            }
            onChanged();
          } else {
            objectSizeLessThanBuilder_.mergeFrom(value);
          }

          return this;
        }
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         */
        public Builder clearObjectSizeLessThan() {
          if (objectSizeLessThanBuilder_ == null) {
            objectSizeLessThan_ = null;
            onChanged();
          } else {
            objectSizeLessThan_ = null;
            objectSizeLessThanBuilder_ = null;
          }

          return this;
        }
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         */
        public com.google.protobuf.Int64Value.Builder getObjectSizeLessThanBuilder() {
          
          onChanged();
          return getObjectSizeLessThanFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getObjectSizeLessThanOrBuilder() {
          if (objectSizeLessThanBuilder_ != null) {
            return objectSizeLessThanBuilder_.getMessageOrBuilder();
          } else {
            return objectSizeLessThan_ == null ?
                com.google.protobuf.Int64Value.getDefaultInstance() : objectSizeLessThan_;
          }
        }
        /**
         * <pre>
         * Size that the object must be less t.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value object_size_less_than = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
            getObjectSizeLessThanFieldBuilder() {
          if (objectSizeLessThanBuilder_ == null) {
            objectSizeLessThanBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                    getObjectSizeLessThan(),
                    getParentForChildren(),
                    isClean());
            objectSizeLessThan_ = null;
          }
          return objectSizeLessThanBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:yandex.cloud.storage.v1.LifecycleRule.RuleFilter)
      }

      // @@protoc_insertion_point(class_scope:yandex.cloud.storage.v1.LifecycleRule.RuleFilter)
      private static final yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter();
      }

      public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<RuleFilter>
          PARSER = new com.google.protobuf.AbstractParser<RuleFilter>() {
        @java.lang.Override
        public RuleFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RuleFilter(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<RuleFilter> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<RuleFilter> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int ID_FIELD_NUMBER = 1;
    private com.google.protobuf.StringValue id_;
    /**
     * <pre>
     * ID of the rule. Provided by the client or generated at creation time.
     * </pre>
     *
     * <code>.google.protobuf.StringValue id = 1;</code>
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return id_ != null;
    }
    /**
     * <pre>
     * ID of the rule. Provided by the client or generated at creation time.
     * </pre>
     *
     * <code>.google.protobuf.StringValue id = 1;</code>
     * @return The id.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getId() {
      return id_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : id_;
    }
    /**
     * <pre>
     * ID of the rule. Provided by the client or generated at creation time.
     * </pre>
     *
     * <code>.google.protobuf.StringValue id = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getIdOrBuilder() {
      return getId();
    }

    public static final int ENABLED_FIELD_NUMBER = 2;
    private boolean enabled_;
    /**
     * <pre>
     * Indicates whether the rule is in effect.
     * </pre>
     *
     * <code>bool enabled = 2;</code>
     * @return The enabled.
     */
    @java.lang.Override
    public boolean getEnabled() {
      return enabled_;
    }

    public static final int FILTER_FIELD_NUMBER = 3;
    private yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter filter_;
    /**
     * <pre>
     * Filter that identifies the objects to which the rule applies.
     * If not specified, the rule applies to all objects in the bucket.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
     * @return Whether the filter field is set.
     */
    @java.lang.Override
    public boolean hasFilter() {
      return filter_ != null;
    }
    /**
     * <pre>
     * Filter that identifies the objects to which the rule applies.
     * If not specified, the rule applies to all objects in the bucket.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
     * @return The filter.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter getFilter() {
      return filter_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.getDefaultInstance() : filter_;
    }
    /**
     * <pre>
     * Filter that identifies the objects to which the rule applies.
     * If not specified, the rule applies to all objects in the bucket.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilterOrBuilder getFilterOrBuilder() {
      return getFilter();
    }

    public static final int EXPIRATION_FIELD_NUMBER = 4;
    private yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration expiration_;
    /**
     * <pre>
     * Expiration rule.
     * The expiration of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
     * recovered.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
     * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
     * the current version of the object.
     * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
     * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
     * delete marker becomes the current version of the object.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
     * @return Whether the expiration field is set.
     */
    @java.lang.Override
    public boolean hasExpiration() {
      return expiration_ != null;
    }
    /**
     * <pre>
     * Expiration rule.
     * The expiration of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
     * recovered.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
     * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
     * the current version of the object.
     * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
     * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
     * delete marker becomes the current version of the object.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
     * @return The expiration.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration getExpiration() {
      return expiration_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.getDefaultInstance() : expiration_;
    }
    /**
     * <pre>
     * Expiration rule.
     * The expiration of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
     * recovered.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
     * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
     * the current version of the object.
     * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
     * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
     * delete marker becomes the current version of the object.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.ExpirationOrBuilder getExpirationOrBuilder() {
      return getExpiration();
    }

    public static final int TRANSITIONS_FIELD_NUMBER = 5;
    private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition> transitions_;
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    @java.lang.Override
    public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition> getTransitionsList() {
      return transitions_;
    }
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    @java.lang.Override
    public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.TransitionOrBuilder> 
        getTransitionsOrBuilderList() {
      return transitions_;
    }
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    @java.lang.Override
    public int getTransitionsCount() {
      return transitions_.size();
    }
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition getTransitions(int index) {
      return transitions_.get(index);
    }
    /**
     * <pre>
     * List of transition rules.
     * The transition of an object is described as follows.
     * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
     * specified storage class.
     * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
     * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.TransitionOrBuilder getTransitionsOrBuilder(
        int index) {
      return transitions_.get(index);
    }

    public static final int ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD_NUMBER = 6;
    private yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays abortIncompleteMultipartUpload_;
    /**
     * <pre>
     * Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.AfterDays abort_incomplete_multipart_upload = 6;</code>
     * @return Whether the abortIncompleteMultipartUpload field is set.
     */
    @java.lang.Override
    public boolean hasAbortIncompleteMultipartUpload() {
      return abortIncompleteMultipartUpload_ != null;
    }
    /**
     * <pre>
     * Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.AfterDays abort_incomplete_multipart_upload = 6;</code>
     * @return The abortIncompleteMultipartUpload.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays getAbortIncompleteMultipartUpload() {
      return abortIncompleteMultipartUpload_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDays.getDefaultInstance() : abortIncompleteMultipartUpload_;
    }
    /**
     * <pre>
     * Configuration for aborting incomplete [multipart uploads](/docs/storage/concepts/multipart).
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.AfterDays abort_incomplete_multipart_upload = 6;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.AfterDaysOrBuilder getAbortIncompleteMultipartUploadOrBuilder() {
      return getAbortIncompleteMultipartUpload();
    }

    public static final int NONCURRENT_EXPIRATION_FIELD_NUMBER = 7;
    private yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration noncurrentExpiration_;
    /**
     * <pre>
     * Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
     * `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At expiration, the non-current version of the object is deleted and cannot be recovered.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration noncurrent_expiration = 7;</code>
     * @return Whether the noncurrentExpiration field is set.
     */
    @java.lang.Override
    public boolean hasNoncurrentExpiration() {
      return noncurrentExpiration_ != null;
    }
    /**
     * <pre>
     * Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
     * `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At expiration, the non-current version of the object is deleted and cannot be recovered.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration noncurrent_expiration = 7;</code>
     * @return The noncurrentExpiration.
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration getNoncurrentExpiration() {
      return noncurrentExpiration_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpiration.getDefaultInstance() : noncurrentExpiration_;
    }
    /**
     * <pre>
     * Expiration rule for non-current versions of objects in a bucket with versioning enabled ([Bucket.versioning] is
     * `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At expiration, the non-current version of the object is deleted and cannot be recovered.
     * </pre>
     *
     * <code>.yandex.cloud.storage.v1.LifecycleRule.NoncurrentExpiration noncurrent_expiration = 7;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentExpirationOrBuilder getNoncurrentExpirationOrBuilder() {
      return getNoncurrentExpiration();
    }

    public static final int NONCURRENT_TRANSITIONS_FIELD_NUMBER = 8;
    private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition> noncurrentTransitions_;
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    @java.lang.Override
    public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition> getNoncurrentTransitionsList() {
      return noncurrentTransitions_;
    }
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    @java.lang.Override
    public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransitionOrBuilder> 
        getNoncurrentTransitionsOrBuilderList() {
      return noncurrentTransitions_;
    }
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    @java.lang.Override
    public int getNoncurrentTransitionsCount() {
      return noncurrentTransitions_.size();
    }
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransition getNoncurrentTransitions(int index) {
      return noncurrentTransitions_.get(index);
    }
    /**
     * <pre>
     * List of transition rules for non-current versions of objects in a bucket with versioning enabled
     * ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended (`VERSIONING_SUSPENDED`).
     * At transition, the non-current version of the object is transitioned to the specified storage class.
     * </pre>
     *
     * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.NoncurrentTransition noncurrent_transitions = 8;</code>
     */
    @java.lang.Override
    public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.NoncurrentTransitionOrBuilder getNoncurrentTransitionsOrBuilder(
        int index) {
      return noncurrentTransitions_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (id_ != null) {
        output.writeMessage(1, getId());
      }
      if (enabled_ != false) {
        output.writeBool(2, enabled_);
      }
      if (filter_ != null) {
        output.writeMessage(3, getFilter());
      }
      if (expiration_ != null) {
        output.writeMessage(4, getExpiration());
      }
      for (int i = 0; i < transitions_.size(); i++) {
        output.writeMessage(5, transitions_.get(i));
      }
      if (abortIncompleteMultipartUpload_ != null) {
        output.writeMessage(6, getAbortIncompleteMultipartUpload());
      }
      if (noncurrentExpiration_ != null) {
        output.writeMessage(7, getNoncurrentExpiration());
      }
      for (int i = 0; i < noncurrentTransitions_.size(); i++) {
        output.writeMessage(8, noncurrentTransitions_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (id_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getId());
      }
      if (enabled_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, enabled_);
      }
      if (filter_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getFilter());
      }
      if (expiration_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getExpiration());
      }
      for (int i = 0; i < transitions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, transitions_.get(i));
      }
      if (abortIncompleteMultipartUpload_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getAbortIncompleteMultipartUpload());
      }
      if (noncurrentExpiration_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, getNoncurrentExpiration());
      }
      for (int i = 0; i < noncurrentTransitions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, noncurrentTransitions_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule)) {
        return super.equals(obj);
      }
      yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule other = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule) obj;

      if (hasId() != other.hasId()) return false;
      if (hasId()) {
        if (!getId()
            .equals(other.getId())) return false;
      }
      if (getEnabled()
          != other.getEnabled()) return false;
      if (hasFilter() != other.hasFilter()) return false;
      if (hasFilter()) {
        if (!getFilter()
            .equals(other.getFilter())) return false;
      }
      if (hasExpiration() != other.hasExpiration()) return false;
      if (hasExpiration()) {
        if (!getExpiration()
            .equals(other.getExpiration())) return false;
      }
      if (!getTransitionsList()
          .equals(other.getTransitionsList())) return false;
      if (hasAbortIncompleteMultipartUpload() != other.hasAbortIncompleteMultipartUpload()) return false;
      if (hasAbortIncompleteMultipartUpload()) {
        if (!getAbortIncompleteMultipartUpload()
            .equals(other.getAbortIncompleteMultipartUpload())) return false;
      }
      if (hasNoncurrentExpiration() != other.hasNoncurrentExpiration()) return false;
      if (hasNoncurrentExpiration()) {
        if (!getNoncurrentExpiration()
            .equals(other.getNoncurrentExpiration())) return false;
      }
      if (!getNoncurrentTransitionsList()
          .equals(other.getNoncurrentTransitionsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasId()) {
        hash = (37 * hash) + ID_FIELD_NUMBER;
        hash = (53 * hash) + getId().hashCode();
      }
      hash = (37 * hash) + ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getEnabled());
      if (hasFilter()) {
        hash = (37 * hash) + FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFilter().hashCode();
      }
      if (hasExpiration()) {
        hash = (37 * hash) + EXPIRATION_FIELD_NUMBER;
        hash = (53 * hash) + getExpiration().hashCode();
      }
      if (getTransitionsCount() > 0) {
        hash = (37 * hash) + TRANSITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getTransitionsList().hashCode();
      }
      if (hasAbortIncompleteMultipartUpload()) {
        hash = (37 * hash) + ABORT_INCOMPLETE_MULTIPART_UPLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getAbortIncompleteMultipartUpload().hashCode();
      }
      if (hasNoncurrentExpiration()) {
        hash = (37 * hash) + NONCURRENT_EXPIRATION_FIELD_NUMBER;
        hash = (53 * hash) + getNoncurrentExpiration().hashCode();
      }
      if (getNoncurrentTransitionsCount() > 0) {
        hash = (37 * hash) + NONCURRENT_TRANSITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getNoncurrentTransitionsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * An object lifecycle rule resource for the bucket.
     * For details about the concept, see [documentation](/docs/storage/concepts/lifecycles).
     * </pre>
     *
     * Protobuf type {@code yandex.cloud.storage.v1.LifecycleRule}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:yandex.cloud.storage.v1.LifecycleRule)
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.class, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Builder.class);
      }

      // Construct using yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getTransitionsFieldBuilder();
          getNoncurrentTransitionsFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (idBuilder_ == null) {
          id_ = null;
        } else {
          id_ = null;
          idBuilder_ = null;
        }
        enabled_ = false;

        if (filterBuilder_ == null) {
          filter_ = null;
        } else {
          filter_ = null;
          filterBuilder_ = null;
        }
        if (expirationBuilder_ == null) {
          expiration_ = null;
        } else {
          expiration_ = null;
          expirationBuilder_ = null;
        }
        if (transitionsBuilder_ == null) {
          transitions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          transitionsBuilder_.clear();
        }
        if (abortIncompleteMultipartUploadBuilder_ == null) {
          abortIncompleteMultipartUpload_ = null;
        } else {
          abortIncompleteMultipartUpload_ = null;
          abortIncompleteMultipartUploadBuilder_ = null;
        }
        if (noncurrentExpirationBuilder_ == null) {
          noncurrentExpiration_ = null;
        } else {
          noncurrentExpiration_ = null;
          noncurrentExpirationBuilder_ = null;
        }
        if (noncurrentTransitionsBuilder_ == null) {
          noncurrentTransitions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          noncurrentTransitionsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.internal_static_yandex_cloud_storage_v1_LifecycleRule_descriptor;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule getDefaultInstanceForType() {
        return yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.getDefaultInstance();
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule build() {
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule buildPartial() {
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule result = new yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule(this);
        int from_bitField0_ = bitField0_;
        if (idBuilder_ == null) {
          result.id_ = id_;
        } else {
          result.id_ = idBuilder_.build();
        }
        result.enabled_ = enabled_;
        if (filterBuilder_ == null) {
          result.filter_ = filter_;
        } else {
          result.filter_ = filterBuilder_.build();
        }
        if (expirationBuilder_ == null) {
          result.expiration_ = expiration_;
        } else {
          result.expiration_ = expirationBuilder_.build();
        }
        if (transitionsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            transitions_ = java.util.Collections.unmodifiableList(transitions_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.transitions_ = transitions_;
        } else {
          result.transitions_ = transitionsBuilder_.build();
        }
        if (abortIncompleteMultipartUploadBuilder_ == null) {
          result.abortIncompleteMultipartUpload_ = abortIncompleteMultipartUpload_;
        } else {
          result.abortIncompleteMultipartUpload_ = abortIncompleteMultipartUploadBuilder_.build();
        }
        if (noncurrentExpirationBuilder_ == null) {
          result.noncurrentExpiration_ = noncurrentExpiration_;
        } else {
          result.noncurrentExpiration_ = noncurrentExpirationBuilder_.build();
        }
        if (noncurrentTransitionsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            noncurrentTransitions_ = java.util.Collections.unmodifiableList(noncurrentTransitions_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.noncurrentTransitions_ = noncurrentTransitions_;
        } else {
          result.noncurrentTransitions_ = noncurrentTransitionsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule) {
          return mergeFrom((yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule other) {
        if (other == yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.getDefaultInstance()) return this;
        if (other.hasId()) {
          mergeId(other.getId());
        }
        if (other.getEnabled() != false) {
          setEnabled(other.getEnabled());
        }
        if (other.hasFilter()) {
          mergeFilter(other.getFilter());
        }
        if (other.hasExpiration()) {
          mergeExpiration(other.getExpiration());
        }
        if (transitionsBuilder_ == null) {
          if (!other.transitions_.isEmpty()) {
            if (transitions_.isEmpty()) {
              transitions_ = other.transitions_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureTransitionsIsMutable();
              transitions_.addAll(other.transitions_);
            }
            onChanged();
          }
        } else {
          if (!other.transitions_.isEmpty()) {
            if (transitionsBuilder_.isEmpty()) {
              transitionsBuilder_.dispose();
              transitionsBuilder_ = null;
              transitions_ = other.transitions_;
              bitField0_ = (bitField0_ & ~0x00000001);
              transitionsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getTransitionsFieldBuilder() : null;
            } else {
              transitionsBuilder_.addAllMessages(other.transitions_);
            }
          }
        }
        if (other.hasAbortIncompleteMultipartUpload()) {
          mergeAbortIncompleteMultipartUpload(other.getAbortIncompleteMultipartUpload());
        }
        if (other.hasNoncurrentExpiration()) {
          mergeNoncurrentExpiration(other.getNoncurrentExpiration());
        }
        if (noncurrentTransitionsBuilder_ == null) {
          if (!other.noncurrentTransitions_.isEmpty()) {
            if (noncurrentTransitions_.isEmpty()) {
              noncurrentTransitions_ = other.noncurrentTransitions_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureNoncurrentTransitionsIsMutable();
              noncurrentTransitions_.addAll(other.noncurrentTransitions_);
            }
            onChanged();
          }
        } else {
          if (!other.noncurrentTransitions_.isEmpty()) {
            if (noncurrentTransitionsBuilder_.isEmpty()) {
              noncurrentTransitionsBuilder_.dispose();
              noncurrentTransitionsBuilder_ = null;
              noncurrentTransitions_ = other.noncurrentTransitions_;
              bitField0_ = (bitField0_ & ~0x00000002);
              noncurrentTransitionsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getNoncurrentTransitionsFieldBuilder() : null;
            } else {
              noncurrentTransitionsBuilder_.addAllMessages(other.noncurrentTransitions_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.StringValue id_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> idBuilder_;
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       * @return Whether the id field is set.
       */
      public boolean hasId() {
        return idBuilder_ != null || id_ != null;
      }
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       * @return The id.
       */
      public com.google.protobuf.StringValue getId() {
        if (idBuilder_ == null) {
          return id_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : id_;
        } else {
          return idBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       */
      public Builder setId(com.google.protobuf.StringValue value) {
        if (idBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          id_ = value;
          onChanged();
        } else {
          idBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       */
      public Builder setId(
          com.google.protobuf.StringValue.Builder builderForValue) {
        if (idBuilder_ == null) {
          id_ = builderForValue.build();
          onChanged();
        } else {
          idBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       */
      public Builder mergeId(com.google.protobuf.StringValue value) {
        if (idBuilder_ == null) {
          if (id_ != null) {
            id_ =
              com.google.protobuf.StringValue.newBuilder(id_).mergeFrom(value).buildPartial();
          } else {
            id_ = value;
          }
          onChanged();
        } else {
          idBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       */
      public Builder clearId() {
        if (idBuilder_ == null) {
          id_ = null;
          onChanged();
        } else {
          id_ = null;
          idBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       */
      public com.google.protobuf.StringValue.Builder getIdBuilder() {
        
        onChanged();
        return getIdFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       */
      public com.google.protobuf.StringValueOrBuilder getIdOrBuilder() {
        if (idBuilder_ != null) {
          return idBuilder_.getMessageOrBuilder();
        } else {
          return id_ == null ?
              com.google.protobuf.StringValue.getDefaultInstance() : id_;
        }
      }
      /**
       * <pre>
       * ID of the rule. Provided by the client or generated at creation time.
       * </pre>
       *
       * <code>.google.protobuf.StringValue id = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
          getIdFieldBuilder() {
        if (idBuilder_ == null) {
          idBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                  getId(),
                  getParentForChildren(),
                  isClean());
          id_ = null;
        }
        return idBuilder_;
      }

      private boolean enabled_ ;
      /**
       * <pre>
       * Indicates whether the rule is in effect.
       * </pre>
       *
       * <code>bool enabled = 2;</code>
       * @return The enabled.
       */
      @java.lang.Override
      public boolean getEnabled() {
        return enabled_;
      }
      /**
       * <pre>
       * Indicates whether the rule is in effect.
       * </pre>
       *
       * <code>bool enabled = 2;</code>
       * @param value The enabled to set.
       * @return This builder for chaining.
       */
      public Builder setEnabled(boolean value) {
        
        enabled_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Indicates whether the rule is in effect.
       * </pre>
       *
       * <code>bool enabled = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearEnabled() {
        
        enabled_ = false;
        onChanged();
        return this;
      }

      private yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter filter_;
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilterOrBuilder> filterBuilder_;
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       * @return Whether the filter field is set.
       */
      public boolean hasFilter() {
        return filterBuilder_ != null || filter_ != null;
      }
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       * @return The filter.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter getFilter() {
        if (filterBuilder_ == null) {
          return filter_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.getDefaultInstance() : filter_;
        } else {
          return filterBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       */
      public Builder setFilter(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter value) {
        if (filterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          filter_ = value;
          onChanged();
        } else {
          filterBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       */
      public Builder setFilter(
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.Builder builderForValue) {
        if (filterBuilder_ == null) {
          filter_ = builderForValue.build();
          onChanged();
        } else {
          filterBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       */
      public Builder mergeFilter(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter value) {
        if (filterBuilder_ == null) {
          if (filter_ != null) {
            filter_ =
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.newBuilder(filter_).mergeFrom(value).buildPartial();
          } else {
            filter_ = value;
          }
          onChanged();
        } else {
          filterBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       */
      public Builder clearFilter() {
        if (filterBuilder_ == null) {
          filter_ = null;
          onChanged();
        } else {
          filter_ = null;
          filterBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.Builder getFilterBuilder() {
        
        onChanged();
        return getFilterFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilterOrBuilder getFilterOrBuilder() {
        if (filterBuilder_ != null) {
          return filterBuilder_.getMessageOrBuilder();
        } else {
          return filter_ == null ?
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.getDefaultInstance() : filter_;
        }
      }
      /**
       * <pre>
       * Filter that identifies the objects to which the rule applies.
       * If not specified, the rule applies to all objects in the bucket.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.RuleFilter filter = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilterOrBuilder> 
          getFilterFieldBuilder() {
        if (filterBuilder_ == null) {
          filterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilter.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.RuleFilterOrBuilder>(
                  getFilter(),
                  getParentForChildren(),
                  isClean());
          filter_ = null;
        }
        return filterBuilder_;
      }

      private yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration expiration_;
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.ExpirationOrBuilder> expirationBuilder_;
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       * @return Whether the expiration field is set.
       */
      public boolean hasExpiration() {
        return expirationBuilder_ != null || expiration_ != null;
      }
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       * @return The expiration.
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration getExpiration() {
        if (expirationBuilder_ == null) {
          return expiration_ == null ? yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.getDefaultInstance() : expiration_;
        } else {
          return expirationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       */
      public Builder setExpiration(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration value) {
        if (expirationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          expiration_ = value;
          onChanged();
        } else {
          expirationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       */
      public Builder setExpiration(
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.Builder builderForValue) {
        if (expirationBuilder_ == null) {
          expiration_ = builderForValue.build();
          onChanged();
        } else {
          expirationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       */
      public Builder mergeExpiration(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration value) {
        if (expirationBuilder_ == null) {
          if (expiration_ != null) {
            expiration_ =
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.newBuilder(expiration_).mergeFrom(value).buildPartial();
          } else {
            expiration_ = value;
          }
          onChanged();
        } else {
          expirationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       */
      public Builder clearExpiration() {
        if (expirationBuilder_ == null) {
          expiration_ = null;
          onChanged();
        } else {
          expiration_ = null;
          expirationBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.Builder getExpirationBuilder() {
        
        onChanged();
        return getExpirationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.ExpirationOrBuilder getExpirationOrBuilder() {
        if (expirationBuilder_ != null) {
          return expirationBuilder_.getMessageOrBuilder();
        } else {
          return expiration_ == null ?
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.getDefaultInstance() : expiration_;
        }
      }
      /**
       * <pre>
       * Expiration rule.
       * The expiration of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is deleted and cannot be
       * recovered.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`), the current version of the
       * object (if it exists and is not a delete marker) is retained as a non-current version, and a delete marker becomes
       * the current version of the object.
       * For the bucket with versioning suspended ([Bucket.versioning] is `VERSIONING_SUSPENDED`), the current version of
       * the object is retained as a non-current version if it is not a delete marker, or is removed otherwise, and a
       * delete marker becomes the current version of the object.
       * </pre>
       *
       * <code>.yandex.cloud.storage.v1.LifecycleRule.Expiration expiration = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.ExpirationOrBuilder> 
          getExpirationFieldBuilder() {
        if (expirationBuilder_ == null) {
          expirationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Expiration.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.ExpirationOrBuilder>(
                  getExpiration(),
                  getParentForChildren(),
                  isClean());
          expiration_ = null;
        }
        return expirationBuilder_;
      }

      private java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition> transitions_ =
        java.util.Collections.emptyList();
      private void ensureTransitionsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          transitions_ = new java.util.ArrayList<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition>(transitions_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.Builder, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.TransitionOrBuilder> transitionsBuilder_;

      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public java.util.List<yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition> getTransitionsList() {
        if (transitionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(transitions_);
        } else {
          return transitionsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public int getTransitionsCount() {
        if (transitionsBuilder_ == null) {
          return transitions_.size();
        } else {
          return transitionsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition getTransitions(int index) {
        if (transitionsBuilder_ == null) {
          return transitions_.get(index);
        } else {
          return transitionsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder setTransitions(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition value) {
        if (transitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransitionsIsMutable();
          transitions_.set(index, value);
          onChanged();
        } else {
          transitionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder setTransitions(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.Builder builderForValue) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          transitions_.set(index, builderForValue.build());
          onChanged();
        } else {
          transitionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder addTransitions(yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition value) {
        if (transitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransitionsIsMutable();
          transitions_.add(value);
          onChanged();
        } else {
          transitionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder addTransitions(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition value) {
        if (transitionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTransitionsIsMutable();
          transitions_.add(index, value);
          onChanged();
        } else {
          transitionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder addTransitions(
          yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.Builder builderForValue) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          transitions_.add(builderForValue.build());
          onChanged();
        } else {
          transitionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder addTransitions(
          int index, yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.Builder builderForValue) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          transitions_.add(index, builderForValue.build());
          onChanged();
        } else {
          transitionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder addAllTransitions(
          java.lang.Iterable<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition> values) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, transitions_);
          onChanged();
        } else {
          transitionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder clearTransitions() {
        if (transitionsBuilder_ == null) {
          transitions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          transitionsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public Builder removeTransitions(int index) {
        if (transitionsBuilder_ == null) {
          ensureTransitionsIsMutable();
          transitions_.remove(index);
          onChanged();
        } else {
          transitionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.Transition.Builder getTransitionsBuilder(
          int index) {
        return getTransitionsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.TransitionOrBuilder getTransitionsOrBuilder(
          int index) {
        if (transitionsBuilder_ == null) {
          return transitions_.get(index);  } else {
          return transitionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
       * For the unversioned bucket ([Bucket.versioning] is `VERSIONING_DISABLED`), the object is transitioned to the
       * specified storage class.
       * For the bucket with versioning enabled ([Bucket.versioning] is `VERSIONING_ENABLED`) or suspended
       * (`VERSIONING_SUSPENDED`), the current version of the object is transitioned to the specified storage class.
       * </pre>
       *
       * <code>repeated .yandex.cloud.storage.v1.LifecycleRule.Transition transitions = 5;</code>
       */
      public java.util.List<? extends yandex.cloud.api.storage.v1.BucketOuterClass.LifecycleRule.TransitionOrBuilder> 
           getTransitionsOrBuilderList() {
        if (transitionsBuilder_ != null) {
          return transitionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(transitions_);
        }
      }
      /**
       * <pre>
       * List of transition rules.
       * The transition of an object is described as follows.
   