/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.test.junit4;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.test.integration.YdbHelper;
import tech.ydb.test.integration.YdbHelperFactory;
import tech.ydb.test.integration.utils.ProxyYdbHelper;

public class YdbHelperRule
extends ProxyYdbHelper
implements TestRule {
    private static final Logger logger = LoggerFactory.getLogger(YdbHelperRule.class);
    private final AtomicReference<YdbHelper> proxy = new AtomicReference();

    public Statement apply(final Statement base, final Description description) {
        final YdbHelperFactory factory = YdbHelperFactory.getInstance();
        return new Statement(){

            public void evaluate() throws Throwable {
                if (!factory.isEnabled()) {
                    logger.info("Test {} skipped because ydb helper is not available", (Object)description.getDisplayName());
                    Assume.assumeFalse((String)"YDB Helper is not available", (boolean)true);
                    return;
                }
                String path = description.getDisplayName();
                logger.debug("create ydb helper for test {}", (Object)path);
                try (YdbHelper helper = factory.createHelper();){
                    YdbHelperRule.this.proxy.set(helper);
                    base.evaluate();
                    YdbHelperRule.this.proxy.set(null);
                }
            }
        };
    }

    protected YdbHelper origin() {
        return this.proxy.get();
    }
}

