/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination;

import java.util.concurrent.CompletableFuture;
import javax.annotation.WillNotClose;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.coordination.description.NodeConfig;
import tech.ydb.coordination.impl.CoordinationServiceImpl;
import tech.ydb.coordination.settings.CoordinationNodeSettings;
import tech.ydb.coordination.settings.CoordinationSessionSettings;
import tech.ydb.coordination.settings.DescribeCoordinationNodeSettings;
import tech.ydb.coordination.settings.DropCoordinationNodeSettings;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcTransport;

public interface CoordinationClient {
    public static CoordinationClient newClient(@WillNotClose GrpcTransport transport) {
        return CoordinationServiceImpl.newClient(transport);
    }

    public String getDatabase();

    public CoordinationSession createSession(String var1, CoordinationSessionSettings var2);

    public CompletableFuture<Status> createNode(String var1, CoordinationNodeSettings var2);

    public CompletableFuture<Status> alterNode(String var1, CoordinationNodeSettings var2);

    public CompletableFuture<Status> dropNode(String var1, DropCoordinationNodeSettings var2);

    public CompletableFuture<Result<NodeConfig>> describeNode(String var1, DescribeCoordinationNodeSettings var2);

    default public CoordinationSession createSession(String path) {
        return this.createSession(path, CoordinationSessionSettings.newBuilder().build());
    }

    default public CompletableFuture<Status> createNode(String path) {
        return this.createNode(path, CoordinationNodeSettings.newBuilder().build());
    }

    default public CompletableFuture<Status> dropNode(String path) {
        return this.dropNode(path, DropCoordinationNodeSettings.newBuilder().build());
    }

    default public CompletableFuture<Result<NodeConfig>> describeNode(String path) {
        return this.describeNode(path, DescribeCoordinationNodeSettings.newBuilder().build());
    }
}

