/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import tech.ydb.coordination.SemaphoreLease;
import tech.ydb.coordination.description.SemaphoreDescription;
import tech.ydb.coordination.description.SemaphoreWatcher;
import tech.ydb.coordination.settings.DescribeSemaphoreMode;
import tech.ydb.coordination.settings.WatchSemaphoreMode;
import tech.ydb.core.Result;
import tech.ydb.core.Status;

public interface CoordinationSession
extends AutoCloseable {
    public CompletableFuture<Status> connect();

    public CompletableFuture<Status> stop();

    public long getId();

    public State getState();

    public void addStateListener(Consumer<State> var1);

    public void removeStateListener(Consumer<State> var1);

    @Override
    default public void close() {
        this.stop().join();
    }

    public CompletableFuture<Status> createSemaphore(String var1, long var2, byte[] var4);

    public CompletableFuture<Status> updateSemaphore(String var1, byte[] var2);

    public CompletableFuture<Status> deleteSemaphore(String var1, boolean var2);

    public CompletableFuture<Result<SemaphoreLease>> acquireSemaphore(String var1, long var2, byte[] var4, Duration var5);

    public CompletableFuture<Result<SemaphoreLease>> acquireEphemeralSemaphore(String var1, boolean var2, byte[] var3, Duration var4);

    public CompletableFuture<Result<SemaphoreDescription>> describeSemaphore(String var1, DescribeSemaphoreMode var2);

    public CompletableFuture<Result<SemaphoreWatcher>> watchSemaphore(String var1, DescribeSemaphoreMode var2, WatchSemaphoreMode var3);

    default public CompletableFuture<Status> createSemaphore(String name, long limit) {
        return this.createSemaphore(name, limit, null);
    }

    default public CompletableFuture<Status> deleteSemaphore(String name) {
        return this.deleteSemaphore(name, false);
    }

    default public CompletableFuture<Result<SemaphoreLease>> acquireSemaphore(String name, long count, Duration timeout) {
        return this.acquireSemaphore(name, count, null, timeout);
    }

    default public CompletableFuture<Result<SemaphoreLease>> acquireEphemeralSemaphore(String name, boolean exclusive, Duration timeout) {
        return this.acquireEphemeralSemaphore(name, exclusive, null, timeout);
    }

    public static enum State {
        INITIAL(false, false),
        CONNECTING(false, false),
        CONNECTED(true, true),
        RECONNECTING(false, true),
        RECONNECTED(true, true),
        CLOSED(false, false),
        LOST(false, false);

        private final boolean isConnected;
        private final boolean isActive;

        private State(boolean isConnected, boolean isActive) {
            this.isConnected = isConnected;
            this.isActive = isActive;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public boolean isActive() {
            return this.isActive;
        }
    }
}

