/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.impl;

import java.time.Clock;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import tech.ydb.coordination.CoordinationClient;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.coordination.description.NodeConfig;
import tech.ydb.coordination.impl.Rpc;
import tech.ydb.coordination.impl.SessionImpl;
import tech.ydb.coordination.settings.CoordinationNodeSettings;
import tech.ydb.coordination.settings.CoordinationSessionSettings;
import tech.ydb.coordination.settings.DescribeCoordinationNodeSettings;
import tech.ydb.coordination.settings.DropCoordinationNodeSettings;
import tech.ydb.core.Result;
import tech.ydb.core.Status;
import tech.ydb.core.grpc.GrpcRequestSettings;
import tech.ydb.core.operation.Operation;
import tech.ydb.core.settings.BaseRequestSettings;
import tech.ydb.core.settings.OperationSettings;
import tech.ydb.proto.coordination.AlterNodeRequest;
import tech.ydb.proto.coordination.CreateNodeRequest;
import tech.ydb.proto.coordination.DescribeNodeRequest;
import tech.ydb.proto.coordination.DropNodeRequest;

class ClientImpl
implements CoordinationClient {
    private final Rpc rpc;

    ClientImpl(Rpc rpc) {
        this.rpc = rpc;
    }

    private String validatePath(String path) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Coordination node path cannot be empty");
        }
        return path.startsWith("/") ? path : this.rpc.getDatabase() + "/" + path;
    }

    private static String getTraceIdOrGenerateNew(String traceId) {
        return traceId == null ? UUID.randomUUID().toString() : traceId;
    }

    private GrpcRequestSettings makeGrpcRequestSettings(BaseRequestSettings settings, String traceId) {
        return GrpcRequestSettings.newBuilder().withDeadline(settings.getRequestTimeout()).withTraceId(traceId).build();
    }

    @Override
    public CoordinationSession createSession(String path, CoordinationSessionSettings settings) {
        return new SessionImpl(this.rpc, Clock.systemUTC(), this.validatePath(path), settings);
    }

    @Override
    public CompletableFuture<Status> createNode(String path, CoordinationNodeSettings settings) {
        CreateNodeRequest request = CreateNodeRequest.newBuilder().setPath(this.validatePath(path)).setOperationParams(Operation.buildParams((OperationSettings)settings)).setConfig(settings.getConfig().toProto()).build();
        String traceId = ClientImpl.getTraceIdOrGenerateNew(settings.getTraceId());
        GrpcRequestSettings grpcSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings, traceId);
        return this.rpc.createNode(request, grpcSettings);
    }

    @Override
    public CompletableFuture<Status> alterNode(String path, CoordinationNodeSettings settings) {
        AlterNodeRequest request = AlterNodeRequest.newBuilder().setPath(this.validatePath(path)).setOperationParams(Operation.buildParams((OperationSettings)settings)).setConfig(settings.getConfig().toProto()).build();
        String traceId = ClientImpl.getTraceIdOrGenerateNew(settings.getTraceId());
        GrpcRequestSettings grpcSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings, traceId);
        return this.rpc.alterNode(request, grpcSettings);
    }

    @Override
    public CompletableFuture<Status> dropNode(String path, DropCoordinationNodeSettings settings) {
        DropNodeRequest request = DropNodeRequest.newBuilder().setPath(this.validatePath(path)).setOperationParams(Operation.buildParams((OperationSettings)settings)).build();
        String traceId = ClientImpl.getTraceIdOrGenerateNew(settings.getTraceId());
        GrpcRequestSettings grpcSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings, traceId);
        return this.rpc.dropNode(request, grpcSettings);
    }

    @Override
    public CompletableFuture<Result<NodeConfig>> describeNode(String path, DescribeCoordinationNodeSettings settings) {
        DescribeNodeRequest request = DescribeNodeRequest.newBuilder().setPath(this.validatePath(path)).setOperationParams(Operation.buildParams((OperationSettings)settings)).build();
        String traceId = ClientImpl.getTraceIdOrGenerateNew(settings.getTraceId());
        GrpcRequestSettings grpcSettings = this.makeGrpcRequestSettings((BaseRequestSettings)settings, traceId);
        return this.rpc.describeNode(request, grpcSettings);
    }

    @Override
    public String getDatabase() {
        return this.rpc.getDatabase();
    }
}

