/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.coordination.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import tech.ydb.coordination.CoordinationSession;
import tech.ydb.coordination.impl.Stream;
import tech.ydb.coordination.impl.StreamMsg;
import tech.ydb.core.Issue;
import tech.ydb.core.Status;
import tech.ydb.core.StatusCode;

class SessionState {
    private final CoordinationSession.State state;
    private final Stream stream;
    private final long sessionID;
    private final AtomicLong reqIdx;

    private SessionState(CoordinationSession.State state) {
        this(state, null, -1L, new AtomicLong(0L));
    }

    private SessionState(CoordinationSession.State state, Stream stream) {
        this(state, stream, -1L, new AtomicLong(0L));
    }

    private SessionState(CoordinationSession.State state, Stream stream, long sessionID, AtomicLong reqIdx) {
        this.state = state;
        this.stream = stream;
        this.sessionID = sessionID;
        this.reqIdx = reqIdx;
    }

    public long getSessionId() {
        return this.sessionID;
    }

    public boolean hasStream(Stream stream) {
        return this.stream == stream;
    }

    public CoordinationSession.State getState() {
        return this.state;
    }

    public void sendMessage(StreamMsg<?> msg) {
        if (this.stream != null) {
            this.stream.sendMsg(this.reqIdx.incrementAndGet(), msg);
        } else {
            Issue issue = Issue.of((String)("Session has invalid state " + (Object)((Object)this.state)), (Issue.Severity)Issue.Severity.ERROR);
            msg.handleError(Status.of((StatusCode)StatusCode.CLIENT_INTERNAL_ERROR, (Issue[])new Issue[]{issue}));
        }
    }

    public CompletableFuture<Status> stop() {
        if (this.stream != null) {
            return this.stream.stop();
        }
        return CompletableFuture.completedFuture(Status.SUCCESS);
    }

    public void cancel() {
        if (this.stream != null) {
            this.stream.cancelStream();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Session{state=").append((Object)this.getState()).append(", id=").append(this.sessionID);
        if (this.stream != null) {
            sb.append(", stream=").append(this.stream.hashCode());
        }
        return sb.append("}").toString();
    }

    static SessionState unstarted() {
        return new SessionState(CoordinationSession.State.INITIAL);
    }

    static SessionState lost() {
        return new SessionState(CoordinationSession.State.LOST);
    }

    static SessionState closed() {
        return new SessionState(CoordinationSession.State.CLOSED);
    }

    static SessionState connecting(Stream stream) {
        return new SessionState(CoordinationSession.State.CONNECTING, stream);
    }

    static SessionState reconnecting(Stream stream) {
        return new SessionState(CoordinationSession.State.RECONNECTING, stream);
    }

    static SessionState connected(SessionState prev, long sessionID) {
        return new SessionState(CoordinationSession.State.CONNECTED, prev.stream, sessionID, prev.reqIdx);
    }

    static SessionState reconnected(SessionState prev) {
        return new SessionState(CoordinationSession.State.RECONNECTED, prev.stream, prev.sessionID, prev.reqIdx);
    }

    static SessionState disconnected(SessionState prev, Stream stream) {
        return new SessionState(CoordinationSession.State.RECONNECTING, stream, prev.sessionID, prev.reqIdx);
    }
}

