/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.export.settings;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import tech.ydb.core.settings.OperationSettings;
import tech.ydb.proto.export.YdbExport;

public class ExportToS3Settings
extends OperationSettings {
    private final Schema schema;
    private final Integer numberOfRetries;
    private final StorageClass storageClass;
    private final String compression;
    private final String region;
    private final String description;
    private final List<Item> itemList;

    private ExportToS3Settings(Builder builder) {
        super((OperationSettings.OperationBuilder)builder);
        this.schema = builder.schema;
        this.numberOfRetries = builder.numberOfRetries;
        this.storageClass = builder.storageClass;
        this.compression = builder.compression;
        this.region = builder.region;
        this.description = builder.description;
        this.itemList = builder.itemList;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public String getCompression() {
        return this.compression;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Item> getItemList() {
        return this.itemList;
    }

    public static Builder newBuilder() {
        return (Builder)new Builder().withAsyncMode(true);
    }

    public static class Item {
        private final String sourcePath;
        private final String destinationPrefix;

        private Item(String sourcePath, String destinationPrefix) {
            this.sourcePath = sourcePath;
            this.destinationPrefix = destinationPrefix;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getDestinationPrefix() {
            return this.destinationPrefix;
        }
    }

    public static enum StorageClass {
        STANDARD,
        REDUCED_REDUNDANCY,
        STANDARD_IA,
        ONEZONE_IA,
        INTELLIGENT_TIERING,
        GLACIER,
        DEEP_ARCHIVE,
        OUTPOSTS;


        public YdbExport.ExportToS3Settings.StorageClass toProto() {
            switch (this) {
                case STANDARD: {
                    return YdbExport.ExportToS3Settings.StorageClass.STANDARD;
                }
                case REDUCED_REDUNDANCY: {
                    return YdbExport.ExportToS3Settings.StorageClass.REDUCED_REDUNDANCY;
                }
                case STANDARD_IA: {
                    return YdbExport.ExportToS3Settings.StorageClass.STANDARD_IA;
                }
                case ONEZONE_IA: {
                    return YdbExport.ExportToS3Settings.StorageClass.ONEZONE_IA;
                }
                case INTELLIGENT_TIERING: {
                    return YdbExport.ExportToS3Settings.StorageClass.INTELLIGENT_TIERING;
                }
                case GLACIER: {
                    return YdbExport.ExportToS3Settings.StorageClass.GLACIER;
                }
                case DEEP_ARCHIVE: {
                    return YdbExport.ExportToS3Settings.StorageClass.DEEP_ARCHIVE;
                }
                case OUTPOSTS: {
                    return YdbExport.ExportToS3Settings.StorageClass.OUTPOSTS;
                }
            }
            throw new RuntimeException("Unsupported storage class!");
        }
    }

    public static enum Schema {
        HTTP,
        HTTPS;


        public YdbExport.ExportToS3Settings.Scheme toProto() {
            switch (this) {
                case HTTP: {
                    return YdbExport.ExportToS3Settings.Scheme.HTTP;
                }
                case HTTPS: {
                    return YdbExport.ExportToS3Settings.Scheme.HTTPS;
                }
            }
            throw new RuntimeException("Unsupported schema!");
        }
    }

    public static class Builder
    extends OperationSettings.OperationBuilder<Builder> {
        private Schema schema = null;
        private Integer numberOfRetries = null;
        private StorageClass storageClass = null;
        private String compression = null;
        private String region = null;
        private String description = null;
        private final List<Item> itemList = new ArrayList<Item>();

        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public Builder setNumberOfRetries(Integer numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
            return this;
        }

        public Builder setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public Builder setCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setDescription(String description) {
            Preconditions.checkArgument((description != null && description.length() <= 128 ? 1 : 0) != 0, (Object)"From proto (length).le = 128");
            this.description = description;
            return this;
        }

        public Builder addItem(String sourcePath, String destinationPrefix) {
            Preconditions.checkArgument((sourcePath != null && destinationPrefix != null ? 1 : 0) != 0, (Object)"Item params aren't null!");
            this.itemList.add(new Item(sourcePath, destinationPrefix));
            return this;
        }

        public ExportToS3Settings build() {
            Preconditions.checkArgument((!this.itemList.isEmpty() ? 1 : 0) != 0, (Object)"Item list must be not empty!");
            return new ExportToS3Settings(this);
        }
    }
}

