/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.export.settings;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import tech.ydb.core.settings.OperationSettings;

public class ExportToYtSettings
extends OperationSettings {
    private final Integer port;
    private final List<Item> itemList;
    private final String description;
    private final Integer numberOfRetries;
    private final Boolean useTypeV3;

    public ExportToYtSettings(Builder b) {
        super((OperationSettings.OperationBuilder)b);
        this.port = b.port;
        this.itemList = b.itemList;
        this.description = b.description;
        this.numberOfRetries = b.numberOfRetries;
        this.useTypeV3 = b.useTypeV3;
    }

    public Integer getPort() {
        return this.port;
    }

    public List<Item> getItemList() {
        return this.itemList;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public Boolean getUseTypeV3() {
        return this.useTypeV3;
    }

    public static Builder newBuilder() {
        return (Builder)new Builder().withAsyncMode(true);
    }

    public static class Item {
        private final String sourcePath;
        private final String destinationPath;

        private Item(String sourcePath, String destinationPrefix) {
            this.sourcePath = sourcePath;
            this.destinationPath = destinationPrefix;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getDestinationPath() {
            return this.destinationPath;
        }
    }

    public static class Builder
    extends OperationSettings.OperationBuilder<Builder> {
        private Integer port = null;
        private final List<Item> itemList = new ArrayList<Item>();
        private String description = null;
        private Integer numberOfRetries = null;
        private Boolean useTypeV3 = null;

        public Builder setPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder addItem(String sourcePath, String destinationPath) {
            Preconditions.checkArgument((sourcePath != null && destinationPath != null ? 1 : 0) != 0, (Object)"Item params aren't null!");
            this.itemList.add(new Item(sourcePath, destinationPath));
            return this;
        }

        public Builder setDescription(String description) {
            Preconditions.checkArgument((description != null && description.length() <= 128 ? 1 : 0) != 0, (Object)"From proto (length).le = 128");
            this.description = description;
            return this;
        }

        public Builder setNumberOfRetries(Integer numberOfRetries) {
            this.numberOfRetries = numberOfRetries;
            return this;
        }

        public Builder setUseTypeV3(Boolean useTypeV3) {
            this.useTypeV3 = useTypeV3;
            return this;
        }

        public ExportToYtSettings build() {
            Preconditions.checkArgument((!this.itemList.isEmpty() ? 1 : 0) != 0, (Object)"Item list must be not empty!");
            return new ExportToYtSettings(this);
        }
    }
}

