/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.core.StatusCode;
import tech.ydb.core.UnexpectedResultException;
import tech.ydb.core.utils.FutureTools;
import tech.ydb.table.SessionRetryContext;

public interface SessionRetryHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(SessionRetryHandler.class);
    public static final SessionRetryHandler DEFAULT = new SessionRetryHandler(){};

    default public void onSuccess(SessionRetryContext context, int retryNumber, long millis) {
        LOGGER.debug("RetryCtx[{}] OK, finished after {} retries, {} ms total", new Object[]{context.hashCode(), retryNumber, millis});
    }

    default public void onCancel(SessionRetryContext context, int retryNumber, long millis) {
        LOGGER.debug("RetryCtx[{}] cancelled, {} retries, {} ms", new Object[]{context.hashCode(), retryNumber, millis});
    }

    default public void onRetry(SessionRetryContext context, StatusCode code, int retryNumber, long next, long millis) {
        LOGGER.debug("RetryCtx[{}] RETRYABLE CODE[{}], scheduling next retry #{} in {} ms, {} ms total", new Object[]{context.hashCode(), code, retryNumber, next, millis});
    }

    default public void onRetry(SessionRetryContext context, Throwable issue, int retryNumber, long next, long millis) {
        LOGGER.debug("RetryCtx[{}] RETRYABLE ERROR[{}], scheduling next retry #{} in {} ms, {} ms total", new Object[]{context.hashCode(), this.errorMsg(issue), retryNumber, next, millis});
    }

    default public void onLimit(SessionRetryContext context, StatusCode code, int retryLimit, long millis) {
        LOGGER.debug("RetryCtx[{}] RETRYABLE CODE[{}], finished by retries limit ({}), {} ms total", new Object[]{context.hashCode(), code, retryLimit, millis});
    }

    default public void onError(SessionRetryContext context, StatusCode code, int retryNumber, long millis) {
        LOGGER.debug("RetryCtx[{}] NON-RETRYABLE CODE[{}], finished after {} retries, {} ms total", new Object[]{context.hashCode(), code, retryNumber, millis});
    }

    default public void onError(SessionRetryContext context, Throwable issue, int retryNumber, long millis) {
        LOGGER.debug("RetryCtx[{}] NON-RETRYABLE ERROR[{}], finished after {} retries, {} ms total", new Object[]{context.hashCode(), this.errorMsg(issue), retryNumber, millis});
    }

    default public String errorMsg(Throwable t) {
        if (!LOGGER.isDebugEnabled()) {
            return "unknown";
        }
        Throwable cause = FutureTools.unwrapCompletionException((Throwable)t);
        if (cause instanceof UnexpectedResultException) {
            StatusCode statusCode = ((UnexpectedResultException)cause).getStatus().getCode();
            return statusCode.name();
        }
        return t.getMessage();
    }
}

