/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.description;

import java.util.Objects;
import tech.ydb.table.settings.Changefeed;

public class ChangefeedDescription {
    private final String name;
    private final Changefeed.Mode mode;
    private final Changefeed.Format format;
    private final State state;
    private final boolean virtualTimestamps;

    public ChangefeedDescription(String name, Changefeed.Mode mode, Changefeed.Format format, State state, boolean virtualTimestamps) {
        this.name = name;
        this.mode = mode;
        this.format = format;
        this.state = state;
        this.virtualTimestamps = virtualTimestamps;
    }

    public String getName() {
        return this.name;
    }

    public Changefeed.Mode getMode() {
        return this.mode;
    }

    public Changefeed.Format getFormat() {
        return this.format;
    }

    public State getState() {
        return this.state;
    }

    public boolean hasVirtualTimestamps() {
        return this.virtualTimestamps;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.mode, this.format, this.state, this.virtualTimestamps});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangefeedDescription cd = (ChangefeedDescription)o;
        return Objects.equals(this.name, cd.name) && this.mode == cd.mode && this.format == cd.format && this.state == cd.state && this.virtualTimestamps == cd.virtualTimestamps;
    }

    public String toString() {
        return "Changefeed['" + this.name + "']{state=" + (Object)((Object)this.state) + ", format=" + (Object)((Object)this.format) + ", mode=" + (Object)((Object)this.mode) + ", virtual timestamps=" + this.virtualTimestamps + "}";
    }

    public static enum State {
        ENABLED,
        DISABLED,
        INITIAL_SCAN;

    }
}

