/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.impl.pool;

import java.util.concurrent.TimeUnit;

public final class SessionPoolOptions {
    public static final SessionPoolOptions DEFAULT = new SessionPoolOptions(10, 50, TimeUnit.MINUTES.toMillis(5L), TimeUnit.MINUTES.toMillis(1L));
    private final int minSize;
    private final int maxSize;
    private final long keepAliveTimeMillis;
    private final long maxIdleTimeMillis;

    SessionPoolOptions(int minSize, int maxSize, long keepAliveTimeMillis, long maxIdleTimeMillis) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.keepAliveTimeMillis = keepAliveTimeMillis;
        this.maxIdleTimeMillis = maxIdleTimeMillis;
    }

    int getMinSize() {
        return this.minSize;
    }

    int getMaxSize() {
        return this.maxSize;
    }

    long getKeepAliveTimeMillis() {
        return this.keepAliveTimeMillis;
    }

    long getMaxIdleTimeMillis() {
        return this.maxIdleTimeMillis;
    }

    public SessionPoolOptions withSize(int minSize, int maxSize) {
        return new SessionPoolOptions(minSize, maxSize, this.keepAliveTimeMillis, this.maxIdleTimeMillis);
    }

    public SessionPoolOptions withKeepAliveTimeMillis(long timeMillis) {
        return new SessionPoolOptions(this.minSize, this.maxSize, timeMillis, this.maxIdleTimeMillis);
    }

    public SessionPoolOptions withMaxIdleTimeMillis(long timeMillis) {
        return new SessionPoolOptions(this.minSize, this.maxSize, this.keepAliveTimeMillis, timeMillis);
    }
}

