/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.query;

import tech.ydb.proto.common.CommonProtos;
import tech.ydb.proto.table.YdbTable;
import tech.ydb.table.result.ResultSetReader;
import tech.ydb.table.result.impl.ProtoValueReaders;

public class ReadTablePart {
    private final ResultSetReader resultSetReader;
    private final VirtualTimestamp timestamp;

    public ReadTablePart(YdbTable.ReadTableResult result, CommonProtos.VirtualTimestamp snapshot) {
        this.resultSetReader = ProtoValueReaders.forResultSet(result.getResultSet());
        this.timestamp = new VirtualTimestamp(snapshot.getPlanStep(), snapshot.getTxId());
    }

    public ResultSetReader getResultSetReader() {
        return this.resultSetReader;
    }

    public VirtualTimestamp getVirtualTimestamp() {
        return this.timestamp;
    }

    public static final class VirtualTimestamp {
        private final long planStep;
        private final long txId;

        public VirtualTimestamp(long planStep, long txId) {
            this.planStep = planStep;
            this.txId = txId;
        }

        public long getPlanStep() {
            return this.planStep;
        }

        public long getTxId() {
            return this.txId;
        }
    }
}

