/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.settings;

import java.time.Duration;
import java.util.Objects;
import tech.ydb.proto.table.YdbTable;
import tech.ydb.table.description.ChangefeedDescription;
import tech.ydb.table.impl.BaseSession;

public class Changefeed {
    private final String name;
    private final Mode mode;
    private final Format format;
    private final boolean virtualTimestamps;
    private final Duration retentionPeriod;
    private final boolean initialScan;

    private Changefeed(Builder builder) {
        this.name = builder.name;
        this.mode = builder.mode;
        this.format = builder.format;
        this.virtualTimestamps = builder.virtualTimestamps;
        this.retentionPeriod = builder.retentionPeriod;
        this.initialScan = builder.initialScan;
    }

    public String getName() {
        return this.name;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Format getFormat() {
        return this.format;
    }

    public boolean hasVirtualTimestamps() {
        return this.virtualTimestamps;
    }

    public boolean hasInitialScan() {
        return this.initialScan;
    }

    public Duration getRetentionPeriod() {
        return this.retentionPeriod;
    }

    @Deprecated
    public YdbTable.Changefeed toProto() {
        return BaseSession.buildChangefeed(this);
    }

    public static Builder fromDescription(ChangefeedDescription description) {
        return new Builder(description);
    }

    public static Builder newBuilder(String changefeedName) {
        return new Builder(changefeedName);
    }

    public static class Builder {
        private final String name;
        private Mode mode = Mode.KEYS_ONLY;
        private Format format = Format.JSON;
        private boolean virtualTimestamps = false;
        private Duration retentionPeriod = null;
        private boolean initialScan = false;

        private Builder(ChangefeedDescription description) {
            this.name = description.getName();
            this.mode = description.getMode();
            this.format = description.getFormat();
            this.virtualTimestamps = description.hasVirtualTimestamps();
        }

        private Builder(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public Builder withMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder withFormat(Format format) {
            this.format = format;
            return this;
        }

        public Builder withVirtualTimestamps(boolean value) {
            this.virtualTimestamps = value;
            return this;
        }

        public Builder withInitialScan(boolean value) {
            this.initialScan = value;
            return this;
        }

        public Builder withRetentionPeriod(Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public Changefeed build() {
            return new Changefeed(this);
        }
    }

    public static enum Format {
        JSON,
        DYNAMODB_STREAMS_JSON,
        DEBEZIUM_JSON;


        @Deprecated
        public YdbTable.ChangefeedFormat.Format toProto() {
            return BaseSession.buildChangefeedFormat(this);
        }
    }

    public static enum Mode {
        KEYS_ONLY,
        UPDATES,
        NEW_IMAGE,
        OLD_IMAGE,
        NEW_AND_OLD_IMAGES;


        @Deprecated
        public YdbTable.ChangefeedMode.Mode toPb() {
            return BaseSession.buildChangefeedMode(this);
        }
    }
}

