/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.settings;

import java.util.ArrayList;
import java.util.List;
import tech.ydb.table.settings.RequestSettings;

public class RenameTablesSettings
extends RequestSettings<RenameTablesSettings> {
    private final List<Item> items = new ArrayList<Item>();

    public List<Item> getItems() {
        return this.items;
    }

    public RenameTablesSettings addTable(String sourcePath, String destinationPath, boolean replaceDestination) {
        this.items.add(new Item(sourcePath, destinationPath, replaceDestination));
        return this;
    }

    public RenameTablesSettings addTable(String sourcePath, String destinationPath) {
        this.items.add(new Item(sourcePath, destinationPath));
        return this;
    }

    public static class Item {
        private final String sourcePath;
        private final String destinationPath;
        private final boolean replaceDestination;

        public Item(String sourcePath, String destinationPath, boolean replaceDestination) {
            this.sourcePath = sourcePath;
            this.destinationPath = destinationPath;
            this.replaceDestination = replaceDestination;
        }

        public Item(String sourcePath, String destinationPath) {
            this.sourcePath = sourcePath;
            this.destinationPath = destinationPath;
            this.replaceDestination = false;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getDestinationPath() {
            return this.destinationPath;
        }

        public boolean isReplaceDestination() {
            return this.replaceDestination;
        }
    }
}

