/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.settings;

import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import tech.ydb.core.settings.OperationSettings;

public class RequestSettings<Self extends RequestSettings<?>> {
    private String traceId;
    private Duration operationTimeout;
    private Duration cancelAfter;
    private Duration timeout = null;
    private Boolean reportCostInfo;

    public String getTraceId() {
        return this.traceId;
    }

    public String getTraceIdOrGenerateNew() {
        return this.traceId == null ? UUID.randomUUID().toString() : this.traceId;
    }

    public Self setTraceId(String traceId) {
        this.traceId = traceId;
        return this.self();
    }

    @Deprecated
    public Optional<Duration> getTimeout() {
        return Optional.ofNullable(this.timeout);
    }

    public Duration getTimeoutDuration() {
        return this.timeout;
    }

    public Self setTimeout(Duration duration) {
        this.timeout = duration;
        return this.self();
    }

    public Self setTimeout(long duration, TimeUnit unit) {
        this.timeout = Duration.ofNanos(unit.toNanos(duration));
        return this.self();
    }

    private Self self() {
        return (Self)this;
    }

    public Optional<Duration> getOperationTimeout() {
        return Optional.ofNullable(this.operationTimeout);
    }

    public Self setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this.self();
    }

    public Optional<Duration> getCancelAfter() {
        return Optional.ofNullable(this.cancelAfter);
    }

    public Self setCancelAfter(Duration cancelAfter) {
        this.cancelAfter = cancelAfter;
        return this.self();
    }

    public Optional<Boolean> getReportCostInfo() {
        return Optional.ofNullable(this.reportCostInfo);
    }

    public Self setReportCostInfo(Boolean reportCostInfo) {
        this.reportCostInfo = reportCostInfo;
        return this.self();
    }

    public OperationSettings toOperationSettings() {
        return ((OperationSettings.OperationBuilder)new OperationSettings.OperationBuilder().withRequestTimeout(this.timeout)).withOperationTimeout(this.operationTimeout).withCancelTimeout(this.cancelAfter).withReportCostInfo(this.reportCostInfo).build();
    }
}

