/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.values;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.values.DecimalValue;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.proto.ProtoType;

public class DecimalType
implements Type {
    public static final int MAX_PRECISION = 35;
    private static final InfValues[] INF_VALUES = new InfValues[35];
    private static final DecimalType YDB_DEFAULT;
    private final int precision;
    private final int scale;
    private final InfValues inf;
    private final DecimalValue infValue;
    private final DecimalValue negInfValue;
    private final DecimalValue nanValue;

    private DecimalType(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
        this.inf = INF_VALUES[precision - 1];
        this.infValue = new DecimalValue(this, 5421010862427522L, 3136633892082024448L);
        this.negInfValue = new DecimalValue(this, -5421010862427523L, -3136633892082024448L);
        this.nanValue = new DecimalValue(this, 5421010862427522L, 3136633892082024449L);
    }

    public static DecimalType getDefault() {
        return YDB_DEFAULT;
    }

    public static DecimalType of(int precision) {
        return DecimalType.of(precision, 0);
    }

    public static DecimalType of(int precision, int scale) {
        Preconditions.checkArgument((precision >= 1 && precision <= 35 ? 1 : 0) != 0, (String)"precision (%s) is out of range [1, %s]", (int)precision, (int)35);
        Preconditions.checkArgument((scale >= 0 && scale <= precision ? 1 : 0) != 0, (String)"scale (%s) is out of range [0, %s]", (int)scale, (int)precision);
        return new DecimalType(precision, scale);
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.DECIMAL;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public DecimalValue getInf() {
        return this.infValue;
    }

    public DecimalValue getNegInf() {
        return this.negInfValue;
    }

    public DecimalValue getNaN() {
        return this.nanValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        return this.precision == that.precision && this.scale == that.scale;
    }

    @Override
    public int hashCode() {
        return 35 * this.precision + this.scale;
    }

    @Override
    public String toString() {
        return "Decimal(" + this.precision + ", " + this.scale + ')';
    }

    @Override
    public ValueProtos.Type toPb() {
        return ProtoType.getDecimal(this.precision, this.scale);
    }

    public DecimalValue newValue(long high, long low) {
        return DecimalValue.fromBits(this, high, low);
    }

    public DecimalValue newValue(long value) {
        return DecimalValue.fromLong(this, value);
    }

    public DecimalValue newValueUnsigned(long value) {
        return DecimalValue.fromUnsignedLong(this, value);
    }

    public DecimalValue newValueUnscaled(long value) {
        return DecimalValue.fromUnscaledLong(this, value);
    }

    public DecimalValue newValue(BigDecimal value) {
        return DecimalValue.fromBigDecimal(this, value);
    }

    public DecimalValue newValue(BigInteger value) {
        return DecimalValue.fromBigInteger(this, value);
    }

    public DecimalValue newValueUnscaled(BigInteger value) {
        return DecimalValue.fromUnscaledBigInteger(this, value);
    }

    public DecimalValue newValue(String value) {
        return DecimalValue.fromString(this, value);
    }

    boolean isInf(long high, long low) {
        return high > this.inf.posHigh || high == this.inf.posHigh && Long.compareUnsigned(low, this.inf.posLow) >= 0;
    }

    boolean isNegInf(long high, long low) {
        return high < this.inf.negHigh || high == this.inf.negHigh && Long.compareUnsigned(low, this.inf.negLow) <= 0;
    }

    static {
        long mask32 = 0xFFFFFFFFL;
        long infHigh = 0L;
        long infLow = 1L;
        for (int precision = 1; precision <= 35; ++precision) {
            long ll = 10L * (infLow & mask32);
            long lh = 10L * (infLow >>> 32) + (ll >>> 32);
            long hl = 10L * (infHigh & mask32) + (lh >>> 32);
            long hh = 10L * (infHigh >>> 32) + (hl >>> 32);
            infLow = (lh << 32) + (ll & mask32);
            infHigh = (hh << 32) + (hl & mask32);
            DecimalType.INF_VALUES[precision - 1] = new InfValues(infHigh, infLow);
        }
        YDB_DEFAULT = DecimalType.of(22, 9);
    }

    private static class InfValues {
        private final long posHigh;
        private final long posLow;
        private final long negHigh;
        private final long negLow;

        InfValues(long infHigh, long infLow) {
            this.posHigh = infHigh;
            this.posLow = infLow;
            this.negHigh = -1L - infHigh;
            this.negLow = -1L - infLow + 1L;
        }
    }
}

