/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.table.values;

import java.util.Objects;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.values.Type;
import tech.ydb.table.values.proto.ProtoType;

public class PgType
implements Type {
    private final int oid;
    private final int typlen;
    private final int typmod;

    private PgType(int oid, int typlen, int typmod) {
        this.oid = oid;
        this.typlen = typlen;
        this.typmod = typmod;
    }

    public static PgType of(int oid) {
        return new PgType(oid, 0, 0);
    }

    public static PgType of(int oid, int typlen, int typmod) {
        return new PgType(oid, typlen, typmod);
    }

    public int getOid() {
        return this.oid;
    }

    @Override
    public Type.Kind getKind() {
        return Type.Kind.PG_TYPE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PgType that = (PgType)o;
        return this.oid == that.oid && this.typlen == that.typlen && this.typmod == that.typmod;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.oid, this.typlen, this.typmod);
    }

    @Override
    public String toString() {
        return "PgType[" + this.oid + "]";
    }

    @Override
    public ValueProtos.Type toPb() {
        return ProtoType.getPgType(this.oid, this.typlen, this.typmod);
    }
}

