/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.aspect.tx;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import tech.ydb.yoj.aspect.tx.YojTransactional;
import tech.ydb.yoj.repository.db.Tx;
import tech.ydb.yoj.repository.db.TxManager;
import tech.ydb.yoj.repository.db.exception.RetryableException;

@Aspect
public class YojTransactionAspect {
    private final TxManager tx;

    public YojTransactionAspect(TxManager tx) {
        this.tx = tx;
    }

    @Around(value="@within(transactional) && !@annotation(YojTransactional)")
    public Object doInClassTransaction(ProceedingJoinPoint pjp, YojTransactional transactional) throws Throwable {
        return this.doInTransaction(pjp, transactional);
    }

    @Around(value="@annotation(transactional)")
    public Object doInMethodTransaction(ProceedingJoinPoint pjp, YojTransactional transactional) throws Throwable {
        return this.doInTransaction(pjp, transactional);
    }

    private Object doInTransaction(ProceedingJoinPoint pjp, YojTransactional transactional) throws Throwable {
        try {
            String name = transactional.name().isBlank() ? YojTransactionAspect.getSimpleMethod(pjp.getSignature()) : transactional.name();
            TxManager localTx = this.tx.withName(name);
            if (Tx.Current.exists()) {
                if (transactional.propagation() == YojTransactional.Propagation.NEVER) {
                    throw new IllegalStateException("Transaction already exists (tried to start transaction '" + name + "')");
                }
                if (transactional.propagation() == YojTransactional.Propagation.REQUIRED) {
                    return pjp.proceed();
                }
                if (transactional.propagation() == YojTransactional.Propagation.REQUIRES_NEW) {
                    localTx = localTx.separate();
                }
            }
            if (transactional.maxRetries() != -1) {
                localTx = localTx.withMaxRetries(transactional.maxRetries());
            }
            this.validateIsolationLevel(name, transactional);
            if (transactional.readOnly()) {
                return localTx.readOnly().noFirstLevelCache().withStatementIsolationLevel(transactional.isolation()).run(() -> this.safeCall(pjp));
            }
            localTx = switch (transactional.writeMode()) {
                default -> throw new IncompatibleClassChangeError();
                case YojTransactional.WriteMode.UNSPECIFIED -> localTx;
                case YojTransactional.WriteMode.DELAYED -> localTx.delayedWrites();
                case YojTransactional.WriteMode.IMMEDIATE -> localTx.immediateWrites();
            };
            return localTx.tx(() -> this.safeCall(pjp));
        }
        catch (CallException | CallRetryableException e) {
            throw ((Throwable)e).getCause();
        }
    }

    private void validateIsolationLevel(String name, YojTransactional transactional) {
        if (transactional.isolation().isReadWrite() && transactional.readOnly()) {
            throw new IllegalStateException("Unsupported isolation level for read-only transaction '" + name + "': " + String.valueOf(transactional.isolation()));
        }
    }

    private static String getSimpleMethod(Signature signature) {
        return signature.getDeclaringType().getSimpleName() + "." + signature.getName();
    }

    Object safeCall(ProceedingJoinPoint pjp) {
        try {
            return pjp.proceed();
        }
        catch (RetryableException e) {
            throw new CallRetryableException(e);
        }
        catch (Throwable e) {
            throw new CallException(e);
        }
    }

    static class CallRetryableException
    extends RetryableException {
        CallRetryableException(RetryableException e) {
            super(e.getMessage(), e.getCause());
        }
    }

    static class CallException
    extends RuntimeException {
        CallException(Throwable e) {
            super(e);
        }
    }
}

