/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.generator;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import tech.ydb.yoj.generator.FieldGeneratorAnnotationProcessor;
import tech.ydb.yoj.generator.TargetClassStructure;
import tech.ydb.yoj.generator.Utils;

class StringConstantsRenderer {
    public static final String INTEGRAL_FIELD_SUFFIX = "_OBJ";

    StringConstantsRenderer() {
    }

    public static String render(TargetClassStructure targetClass, @Nullable String packageName) {
        String ident = Strings.repeat((String)" ", (int)(targetClass.nestLevel() * 4));
        StringBuilder result = new StringBuilder();
        if (packageName != null) {
            result.append("package %s;\n\nimport javax.annotation.processing.Generated;\n\n@Generated(\"%s\")\npublic final class %s {\n".formatted(packageName, FieldGeneratorAnnotationProcessor.class.getName(), targetClass.className()));
        } else {
            result.append(ident).append("public static final class %s {\n".formatted(targetClass.className()));
        }
        result.append(ident).append("    private %s(){}\n\n".formatted(targetClass.className()));
        targetClass.simpleFieldNames().stream().map(name -> StringConstantsRenderer.renderField(targetClass.fieldPrefix(), name)).map(s -> ident + "    " + s + "\n").forEach(result::append);
        for (TargetClassStructure nestedClass : targetClass.nestedClasses()) {
            String renderedField = StringConstantsRenderer.renderField(targetClass.fieldPrefix(), nestedClass.originatingField(), INTEGRAL_FIELD_SUFFIX);
            result.append("%s    %s\n".formatted(ident, renderedField));
            result.append(StringConstantsRenderer.render(nestedClass, null));
        }
        result.append(ident).append("}\n");
        return result.toString();
    }

    private static String renderField(String fieldPrefix, String simpleFieldName) {
        return StringConstantsRenderer.renderField(fieldPrefix, simpleFieldName, "");
    }

    private static String renderField(String fieldPrefix, String simpleFieldName, String namePostfix) {
        return "public static final String %s%s = \"%s\";".formatted(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, simpleFieldName), namePostfix, Utils.concatFieldNameChain(fieldPrefix, simpleFieldName));
    }
}

