/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.generator;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import tech.ydb.yoj.generator.FieldInfo;
import tech.ydb.yoj.generator.SourceClassStructure;
import tech.ydb.yoj.generator.Utils;

record TargetClassStructure(String className, List<String> simpleFieldNames, List<TargetClassStructure> nestedClasses, String fieldPrefix, @Nullable String originatingField, int nestLevel) {
    public static TargetClassStructure build(SourceClassStructure sourceClassStructure, String targetClassName) {
        return new Builder(sourceClassStructure).build(sourceClassStructure, targetClassName, "", null, 0);
    }

    private static class Builder {
        private final Map<String, SourceClassStructure> allAvailableNestedClasses = new HashMap<String, SourceClassStructure>();

        public Builder(SourceClassStructure root) {
            Builder.calcAllAvailableNestedClasses(root, this.allAvailableNestedClasses);
        }

        public TargetClassStructure build(SourceClassStructure sourceClassStructure, String className, String fieldPrefix, @Nullable String originatingField, int nestLevel) {
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<TargetClassStructure> nestedClasses = new ArrayList<TargetClassStructure>();
            for (FieldInfo field : sourceClassStructure.fields()) {
                int amountOfFieldsInside = this.calcAmountOfFieldsInside(field);
                if (this.isSimpleField(field)) {
                    fields.add(field.name());
                    continue;
                }
                if (Builder.isIdField(field) && amountOfFieldsInside == 1) {
                    fields.add(field.name());
                    continue;
                }
                if (amountOfFieldsInside <= 0) continue;
                nestedClasses.add(this.build(this.getComplexFieldClass(field), CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, field.name()), Utils.concatFieldNameChain(fieldPrefix, field.name()), field.name(), nestLevel + 1));
            }
            return new TargetClassStructure(className, fields, nestedClasses, fieldPrefix, originatingField, nestLevel);
        }

        public boolean isSimpleField(FieldInfo field) {
            return !this.allAvailableNestedClasses.containsKey(field.type());
        }

        @Nonnull
        public SourceClassStructure getComplexFieldClass(FieldInfo field) {
            SourceClassStructure structure = this.allAvailableNestedClasses.get(field.type());
            if (structure == null) {
                throw new IllegalArgumentException("Field %s of type %s is not considered to be complex!".formatted(field.name(), field.type()));
            }
            return structure;
        }

        public int calcAmountOfFieldsInside(FieldInfo field) {
            if (this.isSimpleField(field)) {
                return 1;
            }
            int fieldsInside = 0;
            for (FieldInfo innerField : this.getComplexFieldClass(field).fields()) {
                fieldsInside += this.calcAmountOfFieldsInside(innerField);
            }
            return fieldsInside;
        }

        private static boolean isIdField(FieldInfo field) {
            return field.name().equals("id");
        }

        private static void calcAllAvailableNestedClasses(SourceClassStructure root, Map<String, SourceClassStructure> result) {
            result.putAll(root.nestedClasses());
            root.nestedClasses().values().forEach(nested -> Builder.calcAllAvailableNestedClasses(nested, result));
        }
    }
}

