/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.generator;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import tech.ydb.yoj.generator.FieldInfo;

record SourceClassStructure(String className, List<FieldInfo> fields, Map<String, SourceClassStructure> nestedClasses, int nestLevel) {
    public static SourceClassStructure analyse(Element root, Types typeUtils) {
        return SourceClassStructure.analyse(root, 0, typeUtils);
    }

    private static SourceClassStructure analyse(Element classElement, int nestLevel, Types typeUtils) {
        String className = ((TypeElement)classElement).getQualifiedName().toString();
        List<FieldInfo> fields = FieldInfo.extractAllFields(classElement, typeUtils);
        Map<String, SourceClassStructure> nestedClasses = SourceClassStructure.analyseNestedClasses(classElement, nestLevel, typeUtils);
        return new SourceClassStructure(className, fields, nestedClasses, nestLevel);
    }

    private static Map<String, SourceClassStructure> analyseNestedClasses(Element root, int nestLevel, Types typeUtils) {
        return root.getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.CLASS || e.getKind() == ElementKind.RECORD).map(e -> SourceClassStructure.analyse(e, nestLevel + 1, typeUtils)).collect(Collectors.toMap(SourceClassStructure::className, Function.identity()));
    }
}

