/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.common.JsonConverter;
import tech.ydb.yoj.repository.db.exception.ConversionException;

public final class JacksonJsonConverter
implements JsonConverter {
    private static final JsonConverter instance = new JacksonJsonConverter(JacksonJsonConverter.createDefaultObjectMapper());
    private final ObjectMapper mapper;

    public JacksonJsonConverter(UnaryOperator<ObjectMapper> mapperBuilder) {
        this((ObjectMapper)mapperBuilder.apply(JacksonJsonConverter.createDefaultObjectMapper()));
    }

    public static JsonConverter getDefault() {
        return instance;
    }

    public String toJson(@NonNull Type type, @Nullable Object o) throws ConversionException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            return this.mapper.writerFor(this.mapper.getTypeFactory().constructType(type)).writeValueAsString(o);
        }
        catch (IOException e) {
            throw new ConversionException("Could not serialize an object of type `" + type + "` to JSON", (Throwable)e);
        }
    }

    public <T> T fromJson(@NonNull Type type, @NonNull String content) throws ConversionException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        try {
            return (T)this.mapper.readerFor(this.mapper.getTypeFactory().constructType(type)).readValue(content);
        }
        catch (IOException e) {
            throw new ConversionException("Could not deserialize an object of type `" + type + "` from JSON", (Throwable)e);
        }
    }

    public <T> T fromObject(@NonNull Type type, @Nullable Object content) throws ConversionException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        try {
            JavaType jacksonType = this.mapper.getTypeFactory().constructType(type);
            return (T)(content != null ? this.mapper.convertValue(content, jacksonType) : (jacksonType.isCollectionLikeType() ? List.of() : Map.of()));
        }
        catch (Exception e) {
            throw new ConversionException("Could not convert an object to type `" + type + "`", (Throwable)e);
        }
    }

    public String toString() {
        return "JacksonJsonConverter";
    }

    public static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setTimeZone(TimeZone.getDefault());
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new SimpleModule().addAbstractTypeMapping(Set.class, LinkedHashSet.class).addAbstractTypeMapping(Map.class, LinkedHashMap.class).addAbstractTypeMapping(List.class, ArrayList.class));
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.WRITE_DATE_KEYS_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }

    @ConstructorProperties(value={"mapper"})
    @Generated
    public JacksonJsonConverter(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

