/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Maps;
import org.eclipse.collections.impl.tuple.Tuples;
import tech.ydb.yoj.databind.ByteArray;
import tech.ydb.yoj.databind.CustomValueTypes;
import tech.ydb.yoj.databind.FieldValueType;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.common.CommonConverters;
import tech.ydb.yoj.repository.db.exception.ConversionException;

final class Columns {
    public static final Columns EMPTY = new Columns((ImmutableMap<String, Object>)Maps.immutable.empty());
    private final ImmutableMap<String, Object> map;

    public static <T extends Entity<T>> Columns fromEntity(EntitySchema<T> schema, T entity) {
        Map cells = schema.flatten(entity);
        ArrayList<Pair> newValues = new ArrayList<Pair>();
        for (Schema.JavaField field : schema.flattenFields()) {
            String column = field.getName();
            Object value = Columns.serialize(field, cells.get(column));
            newValues.add(Tuples.pair((Object)column, (Object)value));
        }
        return new Columns((ImmutableMap<String, Object>)Maps.immutable.empty().newWithAllKeyValues(newValues));
    }

    public <T> T toSchema(Schema<T> schema) {
        try {
            return this.toSchemaUnchecked(schema);
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (Exception e) {
            String message = String.format("Could not convert %s: %s", schema.getTypeName(), e.getMessage());
            throw new ConversionException(message, (Throwable)e);
        }
    }

    private <T> T toSchemaUnchecked(Schema<T> schema) {
        LinkedHashMap<String, Object> cells = new LinkedHashMap<String, Object>();
        for (Schema.JavaField field : schema.flattenFields()) {
            String column = field.getName();
            Object value = Columns.deserialize(field, this.map.get((Object)column));
            cells.put(column, value);
        }
        return (T)schema.newInstance(Collections.unmodifiableMap(cells));
    }

    private static Object serialize(Schema.JavaField field, Object value) {
        if (value == null) {
            return null;
        }
        Type type = field.getType();
        Type serializedType = field.getCustomValueTypeInfo() != null ? field.getCustomValueTypeInfo().getColumnClass() : type;
        String qualifier = field.getDbTypeQualifier();
        try {
            Preconditions.checkState((boolean)field.isSimple(), (String)"Trying to serialize a non-simple field: %s", (Object)field);
            value = CustomValueTypes.preconvert((Schema.JavaField)field, (Object)value);
            return switch (field.getValueType()) {
                case FieldValueType.STRING, FieldValueType.BOOLEAN, FieldValueType.INTEGER, FieldValueType.REAL -> value;
                case FieldValueType.UUID -> CommonConverters.serializeUuidValue((Object)value);
                case FieldValueType.ENUM -> {
                    if ("toString".equals(qualifier)) {
                        yield CommonConverters.serializeEnumToStringValue((Type)serializedType, (Object)value);
                    }
                    yield CommonConverters.serializeEnumValue((Type)serializedType, (Object)value);
                }
                case FieldValueType.OBJECT -> CommonConverters.serializeOpaqueObjectValue((Type)serializedType, (Object)value);
                case FieldValueType.BINARY -> (byte[])((byte[])value).clone();
                case FieldValueType.BYTE_ARRAY -> ((ByteArray)value).copy().getArray();
                case FieldValueType.INTERVAL, FieldValueType.TIMESTAMP -> value;
                default -> throw new IllegalStateException("Don't know how to serialize field: " + String.valueOf(field));
            };
        }
        catch (Exception e) {
            throw new ConversionException("Could not serialize value of type <" + String.valueOf(type) + ">", (Throwable)e);
        }
    }

    private static Object deserialize(Schema.JavaField field, Object value) {
        if (value == null) {
            return null;
        }
        Type type = field.getType();
        Type serializedType = field.getCustomValueTypeInfo() != null ? field.getCustomValueTypeInfo().getColumnClass() : type;
        String qualifier = field.getDbTypeQualifier();
        try {
            Preconditions.checkState((boolean)field.isSimple(), (String)"Trying to deserialize a non-simple field: %s", (Object)field);
            Object deserialized = switch (field.getValueType()) {
                case FieldValueType.STRING, FieldValueType.BOOLEAN, FieldValueType.INTEGER, FieldValueType.REAL -> value;
                case FieldValueType.UUID -> CommonConverters.deserializeUuidValue((Object)value);
                case FieldValueType.ENUM -> {
                    if ("toString".equals(qualifier)) {
                        yield CommonConverters.deserializeEnumToStringValue((Type)serializedType, (Object)value);
                    }
                    yield CommonConverters.deserializeEnumValue((Type)serializedType, (Object)value);
                }
                case FieldValueType.OBJECT -> CommonConverters.deserializeOpaqueObjectValue((Type)serializedType, (Object)value);
                case FieldValueType.BINARY -> (byte[])((byte[])value).clone();
                case FieldValueType.BYTE_ARRAY -> ByteArray.copy((byte[])((byte[])value));
                case FieldValueType.INTERVAL, FieldValueType.TIMESTAMP -> value;
                default -> throw new IllegalStateException("Don't know how to deserialize field: " + String.valueOf(field));
            };
            return CustomValueTypes.postconvert((Schema.JavaField)field, (Object)deserialized);
        }
        catch (Exception e) {
            throw new ConversionException("Could not deserialize value of type <" + String.valueOf(type) + ">", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Columns columns = (Columns)o;
        return this.map.equals(columns.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    @ConstructorProperties(value={"map"})
    @Generated
    private Columns(ImmutableMap<String, Object> map) {
        this.map = map;
    }
}

