/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.Repository;
import tech.ydb.yoj.repository.db.RepositoryTransaction;
import tech.ydb.yoj.repository.db.SchemaOperations;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.db.TxOptions;
import tech.ydb.yoj.repository.db.exception.DropTableException;
import tech.ydb.yoj.repository.test.inmemory.InMemoryRepositoryTransaction;
import tech.ydb.yoj.repository.test.inmemory.InMemoryStorage;

public class InMemoryRepository
implements Repository {
    private final Map<String, InMemoryStorage> snapshots = new ConcurrentHashMap<String, InMemoryStorage>();
    private volatile InMemoryStorage storage = new InMemoryStorage();

    public void dropDb() {
        this.storage.dropDb();
    }

    public String makeSnapshot() {
        String snapshotId = UUID.randomUUID().toString();
        this.snapshots.put(snapshotId, this.storage.createSnapshot());
        return snapshotId;
    }

    public void loadSnapshot(String id) {
        this.storage = this.snapshots.get(id).createSnapshot();
    }

    public Set<TableDescriptor<?>> tables() {
        return Set.copyOf(this.storage.tables());
    }

    public RepositoryTransaction startTransaction(TxOptions options) {
        return new InMemoryRepositoryTransaction(options, this);
    }

    public <T extends Entity<T>> SchemaOperations<T> schema(final TableDescriptor<T> tableDescriptor) {
        return new SchemaOperations<T>(){

            public void create() {
                InMemoryRepository.this.storage.createTable(tableDescriptor);
            }

            public void drop() {
                if (!InMemoryRepository.this.storage.dropTable(tableDescriptor)) {
                    throw new DropTableException(String.format("Can't drop table %s: table doesn't exist", tableDescriptor.toDebugString()));
                }
            }

            public boolean exists() {
                return InMemoryRepository.this.storage.containsTable(tableDescriptor);
            }
        };
    }

    @Generated
    InMemoryStorage getStorage() {
        return this.storage;
    }
}

