/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import tech.ydb.yoj.repository.BaseDb;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.RepositoryTransaction;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.db.TxOptions;
import tech.ydb.yoj.repository.db.cache.TransactionLocal;
import tech.ydb.yoj.repository.db.exception.IllegalTransactionIsolationLevelException;
import tech.ydb.yoj.repository.db.exception.IllegalTransactionScanException;
import tech.ydb.yoj.repository.db.exception.OptimisticLockException;
import tech.ydb.yoj.repository.test.inmemory.InMemoryRepository;
import tech.ydb.yoj.repository.test.inmemory.InMemoryStorage;
import tech.ydb.yoj.repository.test.inmemory.InMemoryTable;
import tech.ydb.yoj.repository.test.inmemory.InMemoryTxLockWatcher;
import tech.ydb.yoj.repository.test.inmemory.ReadOnlyTxDataShard;
import tech.ydb.yoj.repository.test.inmemory.WriteTxDataShard;

public class InMemoryRepositoryTransaction
implements BaseDb,
RepositoryTransaction {
    private static final AtomicLong txIdGenerator = new AtomicLong();
    private final long txId = txIdGenerator.incrementAndGet();
    private final Stopwatch txStopwatch = Stopwatch.createStarted();
    private final List<Runnable> pendingWrites = new ArrayList<Runnable>();
    private final TransactionLocal transactionLocal;
    private final TxOptions options;
    private final InMemoryTxLockWatcher watcher;
    private final InMemoryStorage storage;
    private boolean hasWrites = false;
    private Long version = null;
    private String closeAction = null;
    private boolean isBadSession = false;

    public InMemoryRepositoryTransaction(TxOptions options, InMemoryRepository repository) {
        this.storage = repository.getStorage();
        this.options = options;
        this.transactionLocal = new TransactionLocal(options);
        this.watcher = new InMemoryTxLockWatcher();
    }

    private long getVersion() {
        if (this.version == null) {
            this.version = this.storage.getCurrentVersion();
        }
        return this.version;
    }

    public <T extends Entity<T>> Table<T> table(Class<T> c) {
        return new InMemoryTable<T>(this.getMemory(c));
    }

    public <T extends Entity<T>> Table<T> table(TableDescriptor<T> tableDescriptor) {
        return new InMemoryTable<T>(this, tableDescriptor);
    }

    @Deprecated
    public final <T extends Entity<T>> InMemoryTable.DbMemory<T> getMemory(Class<T> c) {
        return new InMemoryTable.DbMemory<T>(c, this);
    }

    public void commit() {
        if (this.isBadSession) {
            throw new IllegalStateException("Transaction was invalidated. Commit isn't possible");
        }
        this.endTransaction("commit()", this::commitImpl);
    }

    private void commitImpl() {
        try {
            this.transactionLocal.projectionCache().applyProjectionChanges((RepositoryTransaction)this);
            for (Runnable pendingWrite : this.pendingWrites) {
                pendingWrite.run();
            }
            this.storage.commit(this.txId, this.getVersion(), this.watcher);
        }
        catch (Exception e) {
            this.storage.rollback(this.txId);
            throw e;
        }
    }

    public void rollback() {
        this.endTransaction("rollback()", this::rollbackImpl);
    }

    private void rollbackImpl() {
        this.storage.rollback(this.txId);
    }

    private void endTransaction(String action, Runnable runnable) {
        try {
            if (this.isFinalActionNeeded(action)) {
                this.logTransaction(action, runnable);
            }
            this.closeAction = action;
        }
        catch (Throwable throwable) {
            this.closeAction = action;
            this.transactionLocal.log().info("[[%s]] TOTAL (since tx start)", new Object[]{this.txStopwatch});
            throw throwable;
        }
        this.transactionLocal.log().info("[[%s]] TOTAL (since tx start)", new Object[]{this.txStopwatch});
    }

    private boolean isFinalActionNeeded(String action) {
        if (this.options.isScan()) {
            this.transactionLocal.log().info("No-op %s: scan tx", new Object[]{action});
            return false;
        }
        if (this.options.isReadOnly()) {
            this.transactionLocal.log().info("No-op %s: read-only tx @%s", new Object[]{action, this.options.getIsolationLevel()});
            return false;
        }
        return true;
    }

    final <T extends Entity<T>> void doInWriteTransaction(String log, TableDescriptor<T> tableDescriptor, Consumer<WriteTxDataShard<T>> consumer) {
        if (this.options.isScan()) {
            throw new IllegalTransactionScanException("Mutable operations");
        }
        if (this.options.isReadOnly()) {
            throw new IllegalTransactionIsolationLevelException("Mutable operations", this.options.getIsolationLevel());
        }
        Runnable query = () -> this.logTransaction(log, () -> {
            WriteTxDataShard shard = this.storage.getWriteTxDataShard(tableDescriptor, this.txId, this.getVersion());
            consumer.accept(shard);
            this.hasWrites = true;
        });
        if (this.options.isImmediateWrites()) {
            query.run();
            this.transactionLocal.projectionCache().applyProjectionChanges((RepositoryTransaction)this);
        } else {
            this.pendingWrites.add(query);
        }
    }

    final <T extends Entity<T>, R> R doInTransaction(String action, TableDescriptor<T> tableDescriptor, Function<ReadOnlyTxDataShard<T>, R> func) {
        return (R)this.logTransaction(action, () -> {
            InMemoryTxLockWatcher findWatcher = this.hasWrites ? this.watcher : InMemoryTxLockWatcher.NO_LOCKS;
            ReadOnlyTxDataShard shard = this.storage.getReadOnlyTxDataShard(tableDescriptor, this.txId, this.getVersion(), findWatcher);
            try {
                return func.apply(shard);
            }
            catch (OptimisticLockException e) {
                this.isBadSession = true;
                throw e;
            }
        });
    }

    private void logTransaction(String action, Runnable runnable) {
        this.logTransaction(action, () -> {
            runnable.run();
            return null;
        });
    }

    private <R> R logTransaction(String action, Supplier<R> supplier) {
        if (this.closeAction != null) {
            throw new IllegalStateException("Transaction already closed by " + this.closeAction);
        }
        Stopwatch sw = Stopwatch.createStarted();
        try {
            R result = supplier.get();
            this.transactionLocal.log().debug("[ %s ] %s -> %s", new Object[]{sw, action, this.printResult(result)});
            return result;
        }
        catch (Throwable t) {
            this.transactionLocal.log().debug("[ %s ] %s => %s", new Object[]{sw, action, t});
            throw t;
        }
    }

    private String printResult(Object result) {
        if (result instanceof Iterable) {
            long size = Iterables.size((Iterable)((Iterable)result));
            return size == 1L ? String.valueOf(Iterables.getOnlyElement((Iterable)((Iterable)result))) : "[" + size + "]";
        }
        return String.valueOf(result);
    }

    @Generated
    public TransactionLocal getTransactionLocal() {
        return this.transactionLocal;
    }

    @Generated
    public TxOptions getOptions() {
        return this.options;
    }

    @Generated
    public InMemoryTxLockWatcher getWatcher() {
        return this.watcher;
    }
}

