/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.test.inmemory.InMemoryDataShard;
import tech.ydb.yoj.repository.test.inmemory.InMemoryRepositoryException;
import tech.ydb.yoj.repository.test.inmemory.InMemoryTxLockWatcher;
import tech.ydb.yoj.repository.test.inmemory.ReadOnlyTxDataShard;
import tech.ydb.yoj.repository.test.inmemory.TxDataShardImpl;
import tech.ydb.yoj.repository.test.inmemory.WriteTxDataShard;

final class InMemoryStorage {
    private final Map<TableDescriptor<?>, InMemoryDataShard<?>> shards;
    private final Map<Long, Set<TableDescriptor<?>>> uncommited = new HashMap();
    private long currentVersion;

    public InMemoryStorage() {
        this(0L, new HashMap());
    }

    private InMemoryStorage(long version, Map<TableDescriptor<?>, InMemoryDataShard<?>> shards) {
        this.shards = shards;
        this.currentVersion = version;
    }

    public synchronized long getCurrentVersion() {
        return this.currentVersion;
    }

    public synchronized InMemoryStorage createSnapshot() {
        HashMap snapshotDb = new HashMap();
        for (Map.Entry<TableDescriptor<?>, InMemoryDataShard<?>> entry : this.shards.entrySet()) {
            snapshotDb.put(entry.getKey(), entry.getValue().createSnapshot());
        }
        return new InMemoryStorage(this.currentVersion, snapshotDb);
    }

    public synchronized void commit(long txId, long version, InMemoryTxLockWatcher watcher) {
        if (!this.uncommited.containsKey(txId)) {
            return;
        }
        for (InMemoryDataShard<?> shard : this.shards.values()) {
            shard.checkLocks(version, watcher);
        }
        ++this.currentVersion;
        Set<TableDescriptor<?>> uncommitedTables = this.uncommited.remove(txId);
        for (TableDescriptor<?> tableDescriptor : uncommitedTables) {
            this.shards.get(tableDescriptor).commit(txId, this.currentVersion);
        }
    }

    public synchronized void rollback(long txId) {
        Set<TableDescriptor<?>> uncommitedTables = this.uncommited.remove(txId);
        if (uncommitedTables == null) {
            return;
        }
        for (TableDescriptor<?> tableDescriptor : uncommitedTables) {
            this.shards.get(tableDescriptor).rollback(txId);
        }
    }

    public synchronized <T extends Entity<T>> WriteTxDataShard<T> getWriteTxDataShard(TableDescriptor<T> tableDescriptor, long txId, long version) {
        this.uncommited.computeIfAbsent(txId, __ -> new HashSet()).add(tableDescriptor);
        return this.getTxDataShard(tableDescriptor, txId, version, InMemoryTxLockWatcher.NO_LOCKS);
    }

    public synchronized <T extends Entity<T>> ReadOnlyTxDataShard<T> getReadOnlyTxDataShard(TableDescriptor<T> tableDescriptor, long txId, long version, InMemoryTxLockWatcher watcher) {
        return this.getTxDataShard(tableDescriptor, txId, version, watcher);
    }

    private <T extends Entity<T>> TxDataShardImpl<T> getTxDataShard(TableDescriptor<T> tableDescriptor, long txId, long version, InMemoryTxLockWatcher watcher) {
        InMemoryDataShard<?> shard = this.shards.get(tableDescriptor);
        if (shard == null) {
            throw new InMemoryRepositoryException("Table is not created: " + tableDescriptor.toDebugString());
        }
        return new TxDataShardImpl(shard, txId, version, watcher);
    }

    public synchronized void dropDb() {
        this.shards.clear();
    }

    public synchronized Set<TableDescriptor<?>> tables() {
        return this.shards.keySet();
    }

    public synchronized boolean containsTable(TableDescriptor<?> tableDescriptor) {
        return this.shards.containsKey(tableDescriptor);
    }

    public synchronized <T extends Entity<T>> void createTable(TableDescriptor<T> tableDescriptor) {
        if (this.containsTable(tableDescriptor)) {
            return;
        }
        this.shards.put(tableDescriptor, new InMemoryDataShard<T>(tableDescriptor));
    }

    public synchronized boolean dropTable(TableDescriptor<?> tableDescriptor) {
        if (!this.containsTable(tableDescriptor)) {
            return false;
        }
        this.shards.remove(tableDescriptor);
        return true;
    }
}

