/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import tech.ydb.yoj.databind.expression.FilterExpression;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.databind.schema.ObjectSchema;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityExpressions;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Range;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.TableDescriptor;
import tech.ydb.yoj.repository.db.ViewSchema;
import tech.ydb.yoj.repository.db.cache.FirstLevelCache;
import tech.ydb.yoj.repository.db.exception.IllegalTransactionIsolationLevelException;
import tech.ydb.yoj.repository.db.list.InMemoryQueries;
import tech.ydb.yoj.repository.db.readtable.ReadTableParams;
import tech.ydb.yoj.repository.db.statement.Changeset;
import tech.ydb.yoj.repository.test.inmemory.Columns;
import tech.ydb.yoj.repository.test.inmemory.InMemoryRepositoryTransaction;
import tech.ydb.yoj.repository.test.inmemory.ReadOnlyTxDataShard;
import tech.ydb.yoj.repository.test.inmemory.WriteTxDataShard;

public class InMemoryTable<T extends Entity<T>>
implements Table<T> {
    private final EntitySchema<T> schema;
    private final TableDescriptor<T> tableDescriptor;
    private final InMemoryRepositoryTransaction transaction;

    @Deprecated
    public InMemoryTable(DbMemory<T> memory) {
        this(memory.transaction(), memory.type());
    }

    public InMemoryTable(InMemoryRepositoryTransaction transaction, Class<T> type) {
        this(transaction, TableDescriptor.from((EntitySchema)EntitySchema.of(type)));
    }

    public InMemoryTable(InMemoryRepositoryTransaction transaction, TableDescriptor<T> tableDescriptor) {
        this.schema = EntitySchema.of((Class)tableDescriptor.entityType());
        this.tableDescriptor = tableDescriptor;
        this.transaction = transaction;
    }

    public List<T> findAll() {
        this.transaction.getWatcher().markTableRead(this.tableDescriptor);
        return this.findAll0();
    }

    public <V extends Table.View> List<V> findAll(Class<V> viewType) {
        return this.findAll().stream().map(entity -> InMemoryTable.toView(viewType, this.schema, entity)).collect(Collectors.toList());
    }

    public long countAll() {
        return this.findAll().size();
    }

    public long count(String indexName, FilterExpression<T> filter) {
        return this.find(indexName, filter, null, null, null).size();
    }

    @Deprecated
    public void update(Entity.Id<T> id, Changeset changeset) {
        T found = this.find(id);
        if (found == null) {
            return;
        }
        HashMap cells = new HashMap(this.schema.flatten(found));
        changeset.toMap().forEach((k, v) -> cells.putAll(this.schema.flattenOneField(k, v)));
        Entity newInstance = (Entity)this.schema.newInstance(cells);
        this.save(newInstance);
    }

    public List<T> find(@Nullable String indexName, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset) {
        return InMemoryQueries.find(() -> this.findAll().stream(), filter, orderBy, (Integer)limit, (Long)offset);
    }

    public <V extends Table.View> List<V> find(Class<V> viewType, @Nullable String indexName, @Nullable FilterExpression<T> finalFilter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset, boolean distinct) {
        Stream<Table.View> stream = this.find(indexName, finalFilter, orderBy, limit, offset).stream().map(entity -> InMemoryTable.toView(viewType, this.schema, entity));
        if (distinct) {
            stream = stream.distinct();
        }
        return stream.collect(Collectors.toList());
    }

    public <ID extends Entity.Id<T>> List<ID> findIds(@Nullable String indexName, @Nullable FilterExpression<T> finalFilter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset) {
        return this.find(indexName, finalFilter, orderBy, limit, offset).stream().map(entity -> entity.getId()).collect(Collectors.toList());
    }

    public <ID extends Entity.Id<T>> Stream<T> readTable(ReadTableParams<ID> params) {
        return this.readTableStream(params).map(Entity::postLoad);
    }

    public <ID extends Entity.Id<T>> Stream<ID> readTableIds(ReadTableParams<ID> params) {
        return this.readTableStream(params).map(e -> {
            Entity.Id id = e.getId();
            return id;
        });
    }

    public <V extends Table.ViewId<T>, ID extends Entity.Id<T>> Stream<V> readTable(Class<V> viewClass, ReadTableParams<ID> params) {
        return this.readTableStream(params).map(e -> (Table.ViewId)InMemoryTable.toView(viewClass, this.schema, e));
    }

    public Class<T> getType() {
        return this.tableDescriptor.entityType();
    }

    public TableDescriptor<T> getTableDescriptor() {
        return this.tableDescriptor;
    }

    public T find(Entity.Id<T> id) {
        if (id.isPartial()) {
            throw new IllegalArgumentException("Cannot use partial id in find method");
        }
        return (T)this.transaction.getTransactionLocal().firstLevelCache(this.tableDescriptor).get(id, __ -> {
            this.markKeyRead(id);
            Entity entity = this.transaction.doInTransaction("find(" + String.valueOf(id) + ")", this.tableDescriptor, shard -> shard.find(id));
            return this.postLoad(entity);
        });
    }

    public <V extends Table.View> V find(Class<V> viewType, Entity.Id<T> id) {
        if (id.isPartial()) {
            throw new IllegalArgumentException("Cannot use partial id in find method");
        }
        FirstLevelCache cache = this.transaction.getTransactionLocal().firstLevelCache(this.tableDescriptor);
        if (cache.containsKey(id)) {
            return (V)((Table.View)cache.peek(id).map(entity -> InMemoryTable.toView(viewType, this.schema, entity)).orElse(null));
        }
        this.markKeyRead(id);
        return (V)this.transaction.doInTransaction("find(" + String.valueOf(id) + ")", this.tableDescriptor, shard -> shard.find(id, viewType));
    }

    public <ID extends Entity.Id<T>> List<T> find(Range<ID> range) {
        this.transaction.getWatcher().markRangeRead(this.tableDescriptor, range);
        return this.findAll0().stream().filter(e -> range.contains(e.getId())).sorted(EntityIdSchema.SORT_ENTITY_BY_ID).collect(Collectors.toList());
    }

    public <ID extends Entity.Id<T>> List<ID> findIds(Range<ID> range) {
        return this.find(range).stream().map(e -> e.getId()).collect(Collectors.toList());
    }

    public <V extends Table.View, ID extends Entity.Id<T>> List<V> find(Class<V> viewType, Range<ID> range) {
        return this.find(range).stream().map(entity -> InMemoryTable.toView(viewType, this.schema, entity)).collect(Collectors.toList());
    }

    public <V extends Table.View, ID extends Entity.Id<T>> List<V> find(Class<V> viewType, Set<ID> ids) {
        return this.find(viewType, ids, null, EntityExpressions.defaultOrder(this.getType()), null);
    }

    public <V extends Table.View, ID extends Entity.Id<T>> List<V> find(Class<V> viewType, Set<ID> ids, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (ids.isEmpty()) {
            return List.of();
        }
        return this.find(ids, filter, orderBy, limit).stream().map(entity -> InMemoryTable.toView(viewType, this.schema, entity)).collect(Collectors.toList());
    }

    public <ID extends Entity.Id<T>> List<T> find(Set<ID> ids, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        List<T> found = this.findUncached(ids, filter, orderBy, limit);
        return this.postLoad(found);
    }

    public <ID extends Entity.Id<T>> List<T> findUncached(Set<ID> ids, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (ids.isEmpty()) {
            return List.of();
        }
        EntityIdSchema idSchema = this.schema.getIdSchema();
        Set idsSet = ids.stream().map(arg_0 -> ((EntityIdSchema)idSchema).flatten(arg_0)).collect(Collectors.toUnmodifiableSet());
        Set idFieldsSet = idsSet.stream().map(Map::keySet).collect(Collectors.toUnmodifiableSet());
        Preconditions.checkArgument((idFieldsSet.size() > 0 ? 1 : 0) != 0, (Object)"ids must have at least one non-null field");
        Preconditions.checkArgument((idFieldsSet.size() == 1 ? 1 : 0) != 0, (Object)"ids must have nulls in the same fields");
        Set idFields = (Set)Iterables.getOnlyElement(idFieldsSet);
        ids.forEach(this::markKeyRead);
        Stream<Entity> result = this.getAllEntries().stream().filter(e -> idsSet.contains(idSchema.flatten((Object)e.getId()).entrySet().stream().filter(entry -> idFields.contains(entry.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue))));
        if (filter != null) {
            result = result.filter(InMemoryQueries.toPredicate(filter));
        }
        if (orderBy != null) {
            result = result.sorted(InMemoryQueries.toComparator(orderBy));
        }
        if (limit != null) {
            result = result.limit(limit.intValue());
        }
        return result.toList();
    }

    public <V extends Table.View, KEY> List<V> find(Class<V> viewType, String indexName, Set<KEY> keys, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (keys.isEmpty()) {
            return List.of();
        }
        return this.find(indexName, keys, filter, orderBy, limit).stream().map(entity -> InMemoryTable.toView(viewType, this.schema, entity)).toList();
    }

    public <KEY> List<T> find(String indexName, Set<KEY> keys, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit) {
        if (keys.isEmpty()) {
            return List.of();
        }
        Class<?> keyType = Iterables.getFirst(keys, null).getClass();
        ObjectSchema keySchema = ObjectSchema.of(keyType);
        Set keysSet = keys.stream().map(arg_0 -> ((Schema)keySchema).flatten(arg_0)).collect(Collectors.toUnmodifiableSet());
        Set keyFieldsSet = keysSet.stream().map(Map::keySet).collect(Collectors.toUnmodifiableSet());
        Preconditions.checkArgument((keyFieldsSet.size() != 0 ? 1 : 0) != 0, (Object)"keys should have at least one non-null field");
        Preconditions.checkArgument((keyFieldsSet.size() == 1 ? 1 : 0) != 0, (Object)"keys should have nulls in the same fields");
        Set keyFields = (Set)Iterables.getOnlyElement(keyFieldsSet);
        Schema.Index globalIndex = this.schema.getGlobalIndexes().stream().filter(i -> i.getIndexName().equals(indexName)).findAny().orElseThrow(() -> new IllegalArgumentException("Table `%s` doesn't have index `%s`".formatted(this.tableDescriptor.toDebugString(), indexName)));
        Set indexKeys = Set.copyOf(globalIndex.getFieldNames());
        Sets.SetView missingInIndexKeys = Sets.difference((Set)keyFields, indexKeys);
        Preconditions.checkArgument((boolean)missingInIndexKeys.isEmpty(), (Object)"Index `%s` of table `%s` doesn't contain key(s): [%s]".formatted(indexName, this.tableDescriptor.toDebugString(), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)missingInIndexKeys)));
        Preconditions.checkArgument((boolean)this.isPrefixedFields(globalIndex.getFieldNames(), keyFields), (Object)"FindIn(keys) is allowed only by the prefix of the index key fields, index key: %s, query uses the fields: %s".formatted(globalIndex.getFieldNames(), keyFields));
        for (Map id : keysSet) {
            this.transaction.getWatcher().markRangeRead(this.tableDescriptor, id);
        }
        Stream<Entity> result = this.getAllEntries().stream().filter(e -> keysSet.contains(this.schema.flatten(e).entrySet().stream().filter(field -> keyFields.contains(field.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue))));
        if (filter != null) {
            result = result.filter(InMemoryQueries.toPredicate(filter));
        }
        if (orderBy != null) {
            result = result.sorted(InMemoryQueries.toComparator(orderBy));
        }
        if (limit != null) {
            result = result.limit(limit.intValue());
        }
        return this.postLoad(result.toList());
    }

    private boolean isPrefixedFields(List<String> keyFields, Set<String> fields) {
        for (String keyField : keyFields.subList(0, fields.size())) {
            if (fields.contains(keyField)) continue;
            return false;
        }
        return true;
    }

    private <ID extends Entity.Id<T>> void markKeyRead(ID id) {
        EntityIdSchema idSchema = this.schema.getIdSchema();
        if (idSchema.flattenFieldNames().size() != idSchema.flatten(id).size()) {
            this.transaction.getWatcher().markRangeRead(this.tableDescriptor, Range.create(id, id));
        } else {
            this.transaction.getWatcher().markRowRead(this.tableDescriptor, id);
        }
    }

    public <ID extends Entity.Id<T>> List<ID> findIds(Set<ID> ids) {
        return this.find(ids).stream().map(e -> e.getId()).sorted((Comparator<Entity.Id>)this.schema.getIdSchema()).toList();
    }

    public T insert(T tt) {
        Entity t = tt.preSave();
        this.transaction.getWatcher().markRowRead(this.tableDescriptor, t.getId());
        this.transaction.doInWriteTransaction("insert(" + String.valueOf(t) + ")", this.tableDescriptor, shard -> shard.insert(t));
        this.transaction.getTransactionLocal().firstLevelCache(this.tableDescriptor).put(t);
        this.transaction.getTransactionLocal().projectionCache().save(t);
        return (T)t;
    }

    public T save(T tt) {
        Entity t = tt.preSave();
        this.transaction.doInWriteTransaction("save(" + String.valueOf(t) + ")", this.tableDescriptor, shard -> shard.save(t));
        this.transaction.getTransactionLocal().firstLevelCache(this.tableDescriptor).put(t);
        this.transaction.getTransactionLocal().projectionCache().save(t);
        return (T)t;
    }

    public void delete(Entity.Id<T> id) {
        this.transaction.doInWriteTransaction("delete(" + String.valueOf(id) + ")", this.tableDescriptor, shard -> shard.delete(id));
        this.transaction.getTransactionLocal().firstLevelCache(this.tableDescriptor).putEmpty(id);
        this.transaction.getTransactionLocal().projectionCache().delete(id);
    }

    public void deleteAll() {
        this.transaction.doInWriteTransaction("deleteAll(" + this.tableDescriptor.toDebugString() + ")", this.tableDescriptor, WriteTxDataShard::deleteAll);
    }

    private List<T> getAllEntries() {
        return this.transaction.doInTransaction("findAll(" + this.tableDescriptor.toDebugString() + ")", this.tableDescriptor, ReadOnlyTxDataShard::findAll);
    }

    private List<T> findAll0() {
        List<T> all = this.getAllEntries();
        return this.postLoad(all);
    }

    public Stream<T> streamAll(int batchSize) {
        return this.streamPartial(null, batchSize);
    }

    public <ID extends Entity.Id<T>> Stream<T> streamPartial(ID partial, int batchSize) {
        Preconditions.checkArgument((1 <= batchSize && batchSize <= 5000 ? 1 : 0) != 0, (String)"batchSize must be in range [1, 5000], got %s", (int)batchSize);
        Range range = partial == null ? null : Range.create(partial);
        this.markRangeRead(range);
        return this.streamPartial0(range);
    }

    private <ID extends Entity.Id<T>> Stream<T> streamPartial0(@Nullable Range<ID> range) {
        return (range == null ? this.findAll() : this.find(range)).stream();
    }

    public <V extends Table.ViewId<T>> Stream<V> streamAll(Class<V> viewType, int batchSize) {
        return this.streamPartial(viewType, null, batchSize);
    }

    public <ID extends Entity.Id<T>, V extends Table.ViewId<T>> Stream<V> streamPartial(Class<V> viewType, ID partial, int batchSize) {
        return this.streamPartial(partial, batchSize).map(e -> (Table.ViewId)InMemoryTable.toView(viewType, this.schema, e));
    }

    public <ID extends Entity.Id<T>> Stream<ID> streamAllIds(int batchSize) {
        return this.streamPartialIds(null, batchSize);
    }

    public <ID extends Entity.Id<T>> Stream<ID> streamPartialIds(ID partial, int batchSize) {
        Preconditions.checkArgument((1 <= batchSize && batchSize <= 10000 ? 1 : 0) != 0, (String)"batchSize must be in range [1, 10000], got %s", (int)batchSize);
        Range range = partial == null ? null : Range.create(partial);
        this.markRangeRead(range);
        return this.streamPartial0(range).map(e -> e.getId());
    }

    private <ID extends Entity.Id<T>> void markRangeRead(Range<ID> range) {
        if (range == null) {
            this.transaction.getWatcher().markTableRead(this.tableDescriptor);
        } else {
            this.transaction.getWatcher().markRangeRead(this.tableDescriptor, range);
        }
    }

    private <ID extends Entity.Id<T>> Stream<T> readTableStream(ReadTableParams<ID> params) {
        if (!this.transaction.getOptions().getIsolationLevel().isReadOnly()) {
            throw new IllegalTransactionIsolationLevelException("readTable", this.transaction.getOptions().getIsolationLevel());
        }
        if (!(params.isOrdered() || params.getFromKey() == null && params.getToKey() == null)) {
            throw new IllegalArgumentException("using fromKey or toKey with unordered readTable does not make sense");
        }
        Stream<Entity> stream = this.findAll0().stream().filter(e -> this.readTableFilter(e, params));
        if (params.isOrdered()) {
            stream = stream.sorted(EntityIdSchema.SORT_ENTITY_BY_ID);
        }
        if (params.getRowLimit() > 0) {
            stream = stream.limit(params.getRowLimit());
        }
        return stream;
    }

    private <ID extends Entity.Id<T>> boolean readTableFilter(T e, ReadTableParams<ID> params) {
        Entity.Id to;
        Entity.Id id = e.getId();
        Entity.Id from = (Entity.Id)params.getFromKey();
        if (from != null) {
            int compare = EntityIdSchema.ofEntity((Class)id.getType()).compare(id, from);
            if (params.isFromInclusive() ? compare < 0 : compare <= 0) {
                return false;
            }
        }
        if ((to = (Entity.Id)params.getToKey()) != null) {
            int compare = EntityIdSchema.ofEntity((Class)id.getType()).compare(id, to);
            return params.isToInclusive() ? compare <= 0 : compare < 0;
        }
        return true;
    }

    public FirstLevelCache<T> getFirstLevelCache() {
        return this.transaction.getTransactionLocal().firstLevelCache(this.tableDescriptor);
    }

    @Nullable
    public T postLoad(T entity) {
        if (entity == null) {
            return null;
        }
        Entity t = entity.postLoad();
        this.transaction.getTransactionLocal().firstLevelCache(this.tableDescriptor).put(t);
        this.transaction.getTransactionLocal().projectionCache().load(t);
        return (T)t;
    }

    private static <V extends Table.View, T extends Entity<T>> V toView(Class<V> viewType, EntitySchema<T> schema, T entity) {
        if (entity == null) {
            return null;
        }
        ViewSchema viewSchema = ViewSchema.of(viewType);
        return (V)((Table.View)Columns.fromEntity(schema, entity).toSchema(viewSchema));
    }

    @Deprecated
    public record DbMemory<T extends Entity<T>>(Class<T> type, InMemoryRepositoryTransaction transaction) {
    }
}

