/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Range;
import tech.ydb.yoj.repository.db.TableDescriptor;

public final class InMemoryTxLockWatcher {
    public static final InMemoryTxLockWatcher NO_LOCKS = new InMemoryTxLockWatcher(Map.of(), Map.of());
    private final Map<TableDescriptor<?>, Set<Entity.Id<?>>> readRows;
    private final Map<TableDescriptor<?>, List<Range<?>>> readRanges;

    public InMemoryTxLockWatcher() {
        this(new HashMap(), new HashMap());
    }

    public <T extends Entity<T>> void markRowRead(TableDescriptor<T> tableDescriptor, Entity.Id<T> id) {
        this.readRows.computeIfAbsent(tableDescriptor, __ -> new HashSet()).add(id);
    }

    public <T extends Entity<T>, ID extends Entity.Id<T>> void markRangeRead(TableDescriptor<T> tableDescriptor, Range<ID> range) {
        this.readRanges.computeIfAbsent(tableDescriptor, __ -> new ArrayList()).add(range);
    }

    public <T extends Entity<T>, ID extends Entity.Id<T>> void markRangeRead(TableDescriptor<T> tableDescriptor, Map<String, Object> map) {
        Range range = Range.create((EntityIdSchema)EntitySchema.of((Class)tableDescriptor.entityType()).getIdSchema(), map);
        this.markRangeRead(tableDescriptor, range);
    }

    public <T extends Entity<T>, ID extends Entity.Id<T>> void markTableRead(TableDescriptor<T> tableDescriptor) {
        Range range = Range.create((EntityIdSchema)EntitySchema.of((Class)tableDescriptor.entityType()).getIdSchema(), Map.of());
        this.markRangeRead(tableDescriptor, range);
    }

    public <T extends Entity<T>> Set<Entity.Id<T>> getReadRows(TableDescriptor<T> tableDescriptor) {
        Set<Entity.Id<T>> lockedRows = this.readRows.getOrDefault(tableDescriptor, Set.of());
        return lockedRows;
    }

    public <T extends Entity<T>> List<Range<Entity.Id<T>>> getReadRanges(TableDescriptor<T> tableDescriptor) {
        List<Range<Entity.Id<T>>> lockedRanges = this.readRanges.getOrDefault(tableDescriptor, List.of());
        return lockedRanges;
    }

    @ConstructorProperties(value={"readRows", "readRanges"})
    @Generated
    private InMemoryTxLockWatcher(Map<TableDescriptor<?>, Set<Entity.Id<?>>> readRows, Map<TableDescriptor<?>, List<Range<?>>> readRanges) {
        this.readRows = readRows;
        this.readRanges = readRanges;
    }
}

