/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.test.inmemory;

import java.beans.ConstructorProperties;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.test.inmemory.InMemoryDataShard;
import tech.ydb.yoj.repository.test.inmemory.InMemoryTxLockWatcher;
import tech.ydb.yoj.repository.test.inmemory.ReadOnlyTxDataShard;
import tech.ydb.yoj.repository.test.inmemory.WriteTxDataShard;

final class TxDataShardImpl<T extends Entity<T>>
implements ReadOnlyTxDataShard<T>,
WriteTxDataShard<T> {
    private final InMemoryDataShard<T> shard;
    private final long txId;
    private final long version;
    private final InMemoryTxLockWatcher watcher;

    @Override
    @Nullable
    public T find(Entity.Id<T> id) {
        return this.shard.find(this.txId, this.version, id, this.watcher);
    }

    @Override
    @Nullable
    public <V extends Table.View> V find(Entity.Id<T> id, Class<V> viewType) {
        return this.shard.find(this.txId, this.version, id, viewType, this.watcher);
    }

    @Override
    public List<T> findAll() {
        return this.shard.findAll(this.txId, this.version, this.watcher);
    }

    @Override
    public void insert(T entity) {
        this.shard.insert(this.txId, this.version, entity);
    }

    @Override
    public void save(T entity) {
        this.shard.save(this.txId, this.version, entity);
    }

    @Override
    public void delete(Entity.Id<T> id) {
        this.shard.delete(this.txId, id);
    }

    @Override
    public void deleteAll() {
        this.shard.deleteAll(this.txId);
    }

    @ConstructorProperties(value={"shard", "txId", "version", "watcher"})
    @Generated
    public TxDataShardImpl(InMemoryDataShard<T> shard, long txId, long version, InMemoryTxLockWatcher watcher) {
        this.shard = shard;
        this.txId = txId;
        this.version = version;
        this.watcher = watcher;
    }
}

